/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import org.adempiere.controller.form.BOMDropController;
import org.adempiere.controller.form.BOMDropForm;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VRadioButton;
import org.compiere.model.MLookup;
import org.compiere.swing.CEditor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CollapsiblePanel;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VBOMDrop
extends CPanel
implements FormPanel,
BOMDropForm,
ActionListener {
    private static final long serialVersionUID = -6952031736723743235L;
    private BOMDropController controller;
    private int windowNo = 0;
    private FormFrame formFrame;
    private int lineCount = 0;
    private static CLogger log = CLogger.getCLogger(VBOMDrop.class);
    private HashMap<CollapsiblePanel, ButtonGroup> buttonGroups = new HashMap();
    private static final int WINDOW_WIDTH = 600;
    private static final int SEARCH_WIDTH = 120;
    private static final int QTY_WIDTH = 60;
    private static final int UOM_WIDTH = 60;
    private static final int NAME_WIDTH = 120;
    private static final int CHECK_WIDTH = 15;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CPanel selectionPanel = new CPanel(new GridBagLayout());
    private HashMap<String, Object> groupboxes = new HashMap();
    private CScrollPane scroll;
    private CPanel header = new CPanel();

    VBOMDrop() {
        this.controller = new BOMDropController(this);
    }

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.windowNo = WindowNo;
        this.formFrame = frame;
        if (!this.controller.init(frame.getProcessInfo(), this.windowNo)) {
            this.dispose();
        }
        this.selectionPanel.setBorder(new TitledBorder(Msg.translate(Env.getCtx(), "BOMDropForm_SelectBOM")));
        this.confirmPanel.addActionListener(this);
        String title = Msg.getMsg(Env.getCtx(), "BOMDropForm_SelectProducts");
        this.scroll = new CScrollPane(this);
        this.scroll.setColumnHeaderView(this.header);
        this.scroll.setBorder(new TitledBorder(title));
        this.formFrame.getContentPane().setLayout(new BorderLayout());
        this.formFrame.getContentPane().add((Component)this.selectionPanel, "North");
        this.formFrame.getContentPane().add((Component)this.scroll, "Center");
        this.formFrame.getContentPane().add((Component)this.confirmPanel, "South");
        this.sizeIt();
        this.setLayout(new GridBagLayout());
        this.scroll.setVisible(false);
    }

    @Override
    public void sizeIt() {
        this.formFrame.getWindow().setPreferredSize(null);
        Dimension size = new Dimension(this.formFrame.getPreferredSize());
        size.width = 600;
        this.formFrame.getWindow().setPreferredSize(size);
        this.formFrame.pack();
        Rectangle myBounds = this.formFrame.getWindow().getBounds();
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle screenBounds = gd.getDefaultConfiguration().getBounds();
            if (!screenBounds.intersects(myBounds) || screenBounds.contains(myBounds)) continue;
            AEnv.positionCenterScreen(this.formFrame.getWindow());
            break;
        }
    }

    @Override
    public void dispose() {
        if (this.formFrame != null) {
            this.formFrame.dispose();
        }
        this.formFrame = null;
        this.removeAll();
        if (this.buttonGroups != null) {
            this.buttonGroups.clear();
        }
        this.buttonGroups = null;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size.width > 600) {
            size.width = 570;
        }
        return size;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.config(e.getActionCommand());
        if (e.getActionCommand().equals("Ok")) {
            this.controller.confirmOK();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.controller.confirmCancel();
        }
    }

    @Override
    public CEditor createSelectionEditor(int displayType, MLookup lookup, String columnName, String name, String description, int row, int col) {
        if (DisplayType.isLookup(displayType) || displayType == 13) {
            VLookup editor = new VLookup(lookup.getColumnName(), false, false, true, lookup);
            Dimension size = new Dimension(editor.getMinimumSize());
            size.width = 120;
            editor.setPreferredSize(size);
            CLabel label = new CLabel(name);
            label.setLabelFor(editor);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = col;
            c.gridy = row;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.ipadx = 5;
            c.insets = new Insets(2, 5, 2, 5);
            c.fill = 2;
            c.anchor = 23;
            this.selectionPanel.add((Component)label, c);
            c.gridx = col + 1;
            this.selectionPanel.add((Component)editor, c);
            return editor;
        }
        if (DisplayType.isNumeric(displayType)) {
            VNumber editor = new VNumber(columnName, true, false, true, displayType, columnName);
            Dimension size = new Dimension(editor.getMinimumSize());
            size.width = 60;
            editor.setPreferredSize(new Dimension(size));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = col;
            c.gridy = row;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.ipadx = 5;
            c.insets = new Insets(2, 5, 2, 5);
            c.fill = 2;
            c.anchor = 24;
            CLabel label = new CLabel(columnName);
            label.setLabelFor(editor);
            this.selectionPanel.add((Component)label, c);
            c.gridx = col + 1;
            this.selectionPanel.add((Component)editor, c);
            return editor;
        }
        if (20 == displayType) {
            VCheckBox editor = new VCheckBox(columnName, false, false, true, name, description, false);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = col;
            c.gridy = row;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.ipadx = 5;
            c.insets = new Insets(2, 5, 2, 5);
            c.fill = 2;
            c.anchor = 23;
            this.selectionPanel.add((Component)editor, c);
            return editor;
        }
        throw new IllegalArgumentException("Unhandled display type " + displayType);
    }

    @Override
    public void enableConfirmOK(boolean enable) {
        this.confirmPanel.getOKButton().setEnabled(enable);
    }

    @Override
    public void showDialog(String message, String result) {
        ADialog.info(this.windowNo, this, message, result);
    }

    @Override
    public void clearBOMList() {
        this.removeAll();
        this.revalidate();
        this.repaint();
        this.lineCount = 0;
        this.buttonGroups.clear();
        this.groupboxes.clear();
        this.scroll.setVisible(false);
    }

    @Override
    public Object createFeature(String featureKey, String caption) {
        log.fine("Groupbox=" + featureKey);
        CollapsiblePanel optionGroup = new CollapsiblePanel(caption);
        this.groupboxes.put(featureKey, optionGroup);
        optionGroup.setCollapsed(true);
        optionGroup.getCollapsiblePane().getContentPane().setLayout(new GridBagLayout());
        optionGroup.setToolTipText("BOMDropForm_ClickToOpen");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = this.lineCount++;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 23;
        this.add((Component)optionGroup, c);
        return optionGroup;
    }

    @Override
    public void updateFeatureCaption(Object feature, String caption) {
        if (feature == null || !(feature instanceof CollapsiblePanel)) {
            throw new IllegalArgumentException("Feature type not an instance of CollapsiblePanel " + feature);
        }
        CollapsiblePanel optionGroup = (CollapsiblePanel)feature;
        optionGroup.setTitle(caption);
    }

    @Override
    public CEditor addCheck(Object feature, String itemType, String name) {
        GridBagConstraints checkConstraint = new GridBagConstraints();
        checkConstraint.gridx = 0;
        checkConstraint.gridwidth = 1;
        checkConstraint.gridheight = 1;
        checkConstraint.weightx = 0.0;
        checkConstraint.weighty = 0.0;
        checkConstraint.ipadx = 5;
        checkConstraint.ipady = 5;
        checkConstraint.fill = 0;
        checkConstraint.anchor = 10;
        GridBagConstraints labelConstraint = new GridBagConstraints();
        labelConstraint.gridx = 1;
        labelConstraint.gridwidth = 1;
        labelConstraint.gridheight = 1;
        labelConstraint.weightx = 0.3;
        labelConstraint.weighty = 0.0;
        labelConstraint.fill = 2;
        labelConstraint.anchor = 10;
        CLabel label = new CLabel(name);
        label.setHorizontalAlignment(2);
        Dimension size = new Dimension(label.getMinimumSize());
        size.width = 120;
        label.setPreferredSize(size);
        if ("CHECK".equals(itemType)) {
            VCheckBox cb;
            if (feature != null && feature instanceof CollapsiblePanel) {
                cb = new VCheckBox(name, false, false, true, name, "", true);
                cb.addVetoableChangeListener(this.controller);
                cb.setEnabled(true);
                cb.setSelected(false);
                size = new Dimension(cb.getMinimumSize());
                size.width = 15;
                cb.setPreferredSize(size);
                checkConstraint.gridy = -1;
                labelConstraint.gridy = -1;
                CollapsiblePanel optionGroup = (CollapsiblePanel)feature;
                optionGroup.getCollapsiblePane().getContentPane().add((Component)cb, checkConstraint);
                optionGroup.getCollapsiblePane().getContentPane().add((Component)label, labelConstraint);
            } else {
                cb = new VCheckBox(name, false, true, false, name, "", true);
                cb.addVetoableChangeListener(this.controller);
                cb.setSelected(true);
                size = new Dimension(cb.getMinimumSize());
                size.width = 15;
                cb.setPreferredSize(size);
                checkConstraint.gridy = this.lineCount;
                labelConstraint.gridy = this.lineCount;
                this.add((Component)cb, checkConstraint);
                this.add((Component)label, labelConstraint);
            }
            return cb;
        }
        if ("RADIO".equals(itemType)) {
            if (feature == null || !(feature instanceof CollapsiblePanel)) {
                throw new IllegalArgumentException("Can't have radiobutton type without a group!");
            }
            VRadioButton rb = new VRadioButton(name, false, false, true, name, "", true);
            rb.addVetoableChangeListener(this.controller);
            size = new Dimension(rb.getMinimumSize());
            size.width = 15;
            rb.setPreferredSize(size);
            CollapsiblePanel optionGroup = (CollapsiblePanel)feature;
            ButtonGroup buttonGroup = this.buttonGroups.get(optionGroup);
            if (buttonGroup == null) {
                buttonGroup = new ButtonGroup();
                this.buttonGroups.put(optionGroup, buttonGroup);
                buttonGroup.add(rb);
                rb.setValue(true);
            }
            buttonGroup.add(rb);
            checkConstraint.gridy = -1;
            labelConstraint.gridy = -1;
            optionGroup.getCollapsiblePane().getContentPane().add((Component)rb, checkConstraint);
            optionGroup.getCollapsiblePane().getContentPane().add((Component)label, labelConstraint);
            return rb;
        }
        log.severe("Unhandled Item type: " + itemType);
        return null;
    }

    @Override
    public CEditor addQty(Object feature, BigDecimal qty) {
        VNumber qtyEditor = new VNumber("Qty", true, false, true, 29, Msg.translate(Env.getCtx(), "Qty"));
        Dimension size = new Dimension(qtyEditor.getMinimumSize());
        size.width = 60;
        qtyEditor.setPreferredSize(size);
        qtyEditor.setValue(qty);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.ipadx = 5;
        c.insets = new Insets(2, 5, 2, 5);
        c.fill = 2;
        c.anchor = 23;
        if (feature != null && feature instanceof CollapsiblePanel) {
            c.gridy = -1;
            CollapsiblePanel optionGroup = (CollapsiblePanel)feature;
            optionGroup.getCollapsiblePane().getContentPane().add((Component)qtyEditor, c);
        } else {
            c.gridy = this.lineCount;
            this.add((Component)qtyEditor, c);
        }
        return qtyEditor;
    }

    @Override
    public CEditor addUOM(Object feature, MLookup uomLookup, int c_uom_id) {
        VLookup uomEditor = new VLookup(uomLookup.getColumnName(), true, false, true, uomLookup);
        Dimension size = new Dimension(uomEditor.getMinimumSize());
        size.width = 60;
        uomEditor.setPreferredSize(size);
        uomEditor.setValue(c_uom_id);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.insets = new Insets(2, 5, 2, 10);
        c.fill = 2;
        c.anchor = 23;
        if (feature != null && feature instanceof CollapsiblePanel) {
            c.gridy = -1;
            CollapsiblePanel optionGroup = (CollapsiblePanel)feature;
            optionGroup.getCollapsiblePane().getContentPane().add((Component)uomEditor, c);
        } else {
            c.gridy = this.lineCount++;
            this.add((Component)uomEditor, c);
        }
        return uomEditor;
    }

    @Override
    public void enableBOMList() {
        JSeparator dummy = new JSeparator(0);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = this.lineCount;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 19;
        this.add((Component)dummy, c);
        this.scroll.setVisible(true);
    }

    @Override
    public void setBOMListHeaders(String checkName, String productName, String qtyName, String uomName) {
        this.header.removeAll();
        this.header.setLayout(new GridBagLayout());
        CLabel selectLabel = new CLabel(checkName, 2);
        CLabel nameLabel = new CLabel(productName, 2);
        CLabel qtyLabel = new CLabel(qtyName, 0);
        CLabel uomLabel = new CLabel(uomName, 0);
        Dimension size = new Dimension(15, 22);
        selectLabel.setPreferredSize(size);
        size = new Dimension(120, 22);
        nameLabel.setPreferredSize(size);
        size = new Dimension(60, 22);
        qtyLabel.setPreferredSize(size);
        size = new Dimension(60, 22);
        uomLabel.setPreferredSize(size);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipadx = 5;
        c.insets = new Insets(2, 5, 2, 5);
        c.fill = 2;
        c.anchor = 20;
        this.header.add((Component)selectLabel, c);
        c.gridx = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.3;
        this.header.add((Component)nameLabel, c);
        c.gridx = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.ipadx = 5;
        c.insets = new Insets(2, 5, 2, 5);
        this.header.add((Component)qtyLabel, c);
        c.gridx = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.ipadx = 5;
        c.insets = new Insets(2, 5, 2, 5);
        this.header.add((Component)uomLabel, c);
        JSeparator dummy = new JSeparator(0);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 10;
        this.header.add((Component)dummy, c);
        this.scroll.setVisible(true);
    }
}

