/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.adempiere.util.DeleteEntitiesModel;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.DeleteEntityControler;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VDeleteEntity
extends DeleteEntityControler
implements FormPanel,
ActionListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VDeleteEntity.class);
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel mainPanel = new CPanel();
    private CPanel centerPanel = new CPanel();
    private GridBagLayout centerLayout = new GridBagLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private JScrollPane treePane;
    private CheckboxTree tree;
    private CLabel clientLabel;
    private CComboBox clientPick;
    private CComboBox tablePick;
    private CLabel tableLabel;
    private CCheckBox dryRun;
    private CButton refreshButton;
    private DefaultMutableTreeNode rootNode;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("VMerge.init - WinNo=" + this.m_WindowNo);
        try {
            this.preInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    private void createNodes(DefaultMutableTreeNode root) {
        DeleteEntitiesModel currentNode = (DeleteEntitiesModel)root.getUserObject();
        this.loadChilds(currentNode, root);
        Enumeration<TreeNode> kids = root.children();
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)kids.nextElement();
            if (root.isNodeAncestor(node)) {
                log.log(Level.WARNING, "Loop detected, escaping.");
                break;
            }
            if (!((DeleteEntitiesModel)node.getUserObject()).isMandatoryLink()) continue;
            this.createNodes(node);
        }
    }

    private void loadValues() {
        Object o = this.clientPick.getValue();
        if (o != null) {
            this.setClientId(((KeyNamePair)o).getKey());
        }
        if ((o = this.tablePick.getValue()) != null) {
            this.setTableId(((KeyNamePair)o).getKey());
        }
        this.setDryRun(this.dryRun.isSelected());
    }

    private void loadView() {
        this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
        this.confirmPanel.getOKButton().setEnabled(false);
        DeleteEntitiesModel data = new DeleteEntitiesModel(this.getClientId(), this.getTableId());
        this.rootNode = new DefaultMutableTreeNode(data);
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.setRoot(this.rootNode);
        this.createNodes(this.rootNode);
        this.tree.expandRow(0);
        this.confirmPanel.getOKButton().setEnabled(true);
        this.mainPanel.setCursor(Cursor.getDefaultCursor());
    }

    private void preInit() {
        this.refreshButton = ConfirmPanel.createRefreshButton(false);
        this.refreshButton.addActionListener(this);
        this.dryRun = new CCheckBox(Msg.getMsg(Env.getCtx(), "DryRun"), true);
        this.clientLabel = new CLabel(Msg.getElement(Env.getCtx(), "AD_Client_ID"));
        this.clientPick = new CComboBox(this.getClients());
        this.clientPick.setSelectedItem(null);
        this.clientPick.setMandatory(true);
        this.clientPick.setBackground(false);
        this.tableLabel = new CLabel(Msg.getElement(Env.getCtx(), "AD_Table_ID"));
        this.tablePick = new CComboBox(this.getTables());
        this.tablePick.setSelectedItem(null);
        this.tablePick.setMandatory(true);
        this.tablePick.setBackground(false);
        this.rootNode = new DefaultMutableTreeNode(null);
        this.tree = new CheckboxTree(this.rootNode);
        this.treePane = new JScrollPane(this.tree);
        JViewport viewPort = this.treePane.getViewport();
        viewPort.add(this.tree);
    }

    void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.mainLayout.setHgap(5);
        this.mainLayout.setVgap(5);
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
        this.centerPanel.setLayout(this.centerLayout);
        this.mainPanel.add((Component)this.centerPanel, "North");
        this.centerPanel.add((Component)this.clientLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.clientPick, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.tableLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.tablePick, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.dryRun, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.refreshButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.treePane, "Center");
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.log(Level.FINE, "from: " + e.getSource() + " action: " + e.getActionCommand());
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        if (e.getActionCommand().equals("Ok")) {
            this.loadValues();
            if (this.getClientId() <= 0 || this.getTableId() <= 0) {
                ADialog.error(this.m_WindowNo, this.mainPanel, "Error", Msg.getMsg(Env.getCtx(), "SelectClient"));
            } else {
                Enumeration<TreeNode> nodes = this.rootNode.breadthFirstEnumeration();
                while (nodes.hasMoreElements()) {
                    this.addToStackForDelete((DeleteEntitiesModel)((DefaultMutableTreeNode)nodes.nextElement()).getUserObject());
                }
                int deleted = 0;
                try {
                    deleted = this.deleteSelectedNodes();
                }
                catch (Exception ex) {
                    ADialog.error(this.m_WindowNo, this.mainPanel, "DeleteError", ex.getLocalizedMessage());
                    return;
                }
                ADialog.info(this.m_WindowNo, this.mainPanel, "DeleteSuccess", Msg.getMsg(Env.getCtx(), "RecordsDeleted") + " #" + deleted);
                this.loadView();
            }
        } else if (e.getActionCommand().equals("Refresh")) {
            this.loadValues();
            if (this.getClientId() <= 0) {
                ADialog.error(this.m_WindowNo, this.mainPanel, "Error", Msg.getMsg(Env.getCtx(), "SelectClient"));
                return;
            }
            this.loadView();
        }
    }

    @Override
    public void addToNode(DeleteEntitiesModel data, Object rootNode) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(data.getTableName());
        node.setUserObject(data);
        ((DefaultMutableTreeNode)rootNode).add(node);
    }
}

