/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPayment;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class InfoPayment
extends Info {
    private static final long serialVersionUID = -2917241055484901704L;
    private boolean m_isSOTrx = false;
    private int fieldID = 0;
    private CLabel lDocumentNo = new CLabel(Msg.translate(Env.getCtx(), "DocumentNo"));
    private CTextField fDocumentNo = new CTextField(10);
    private CLabel lBankAccount_ID = new CLabel(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
    private VLookup fBankAccount_ID;
    private CLabel lBPartner_ID = new CLabel(Msg.translate(Env.getCtx(), "BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lDateFrom = new CLabel(Msg.translate(Env.getCtx(), "DateTrx"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel lDateTo = new CLabel("-  ");
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private CLabel lAmtFrom = new CLabel(Msg.translate(Env.getCtx(), "PayAmt"));
    private VNumber fAmtFrom = new VNumber("AmtFrom", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtFrom"));
    private CLabel lAmtTo = new CLabel("-  ");
    private VNumber fAmtTo = new VNumber("AmtTo", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtTo"));
    private VCheckBox fcheckReceipt = new VCheckBox("IsReceipt", false, false, true, Msg.translate(Env.getCtx(), "OnlyReceipt"), "", false);
    private VCheckBox fcheckPayment = new VCheckBox("IsReceipt", false, false, true, Msg.translate(Env.getCtx(), "OnlyPayment"), "", false);
    private static String s_From = " C_Payment_v p";
    private static String s_Order = " p.DateTrx desc, p.DocumentNo";
    private static final Info_Column[] s_Layout = new Info_Column[]{new Info_Column(" ", "p.C_Payment_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BankAccount_ID"), "(SELECT b.Name || ' ' || ba.AccountNo FROM C_Bank b, C_BankAccount ba WHERE b.C_Bank_ID=ba.C_Bank_ID AND ba.C_BankAccount_ID=p.C_BankAccount_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=p.C_BPartner_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "DateTrx"), "p.DateTrx", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "DocumentNo"), "p.DocumentNo", String.class), new Info_Column(Msg.translate(Env.getCtx(), "IsReceipt"), "p.IsReceipt", Boolean.class), new Info_Column(Msg.translate(Env.getCtx(), "C_Currency_ID"), "(SELECT ISO_Code FROM C_Currency c WHERE c.C_Currency_ID=p.C_Currency_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "PayAmt"), "p.PayAmt", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "ConvertedAmount"), "currencyBase(p.PayAmt,p.C_Currency_ID,p.DateTrx, p.AD_Client_ID,p.AD_Org_ID)", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "DiscountAmt"), "p.DiscountAmt", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "WriteOffAmt"), "p.WriteOffAmt", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "IsAllocated"), "p.IsAllocated", Boolean.class), new Info_Column(Msg.translate(Env.getCtx(), "DocStatus"), "docstatus", String.class)};

    @Deprecated
    protected InfoPayment(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        this(frame, modal, WindowNo, 0, value, multiSelection, true, whereClause);
    }

    protected InfoPayment(Frame frame, boolean modal, int WindowNo, int record_id, String value, boolean multiSelection, boolean saveResults, String whereClause) {
        super(frame, modal, WindowNo, "p", "C_Payment_ID", multiSelection, saveResults, whereClause);
        this.log.info("InfoPayment");
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoPayment"));
        StringBuffer where = new StringBuffer("p.IsActive='Y'");
        if (whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(whereClause, "C_Payment.", "p."));
        }
        this.setWhereClause(where.toString());
        this.setTableLayout(s_Layout);
        this.setFromClause(s_From);
        this.setOrderClause(s_Order);
        this.setShowTotals(true);
        this.statInit();
        this.initInfo(record_id, value);
        this.m_heldLastFocus = this.fDocumentNo;
        if (this.autoQuery() || record_id != 0 || value != null && value.length() > 0 && value != "%") {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.lDocumentNo.setLabelFor(this.fDocumentNo);
        this.fDocumentNo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDocumentNo.addActionListener(this);
        this.fcheckReceipt.setSelected(true);
        this.fcheckReceipt.setActionCommand("OnlyReceipt");
        this.fcheckReceipt.addActionListener(this);
        this.fcheckPayment.setSelected(false);
        this.fcheckPayment.setActionCommand("OnlyPayment");
        this.fcheckPayment.addActionListener(this);
        this.fBankAccount_ID = new VLookup("C_BankAccount_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("C_Payment", "C_BankAccount_ID"), 19));
        this.lBankAccount_ID.setLabelFor(this.fBankAccount_ID);
        this.fBankAccount_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fBankAccount_ID.addActionListener(this);
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("C_Payment", "C_BPartner_ID"), 30));
        this.lBPartner_ID.setLabelFor(this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fBPartner_ID.addActionListener(this);
        this.lDateFrom.setLabelFor(this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.fDateFrom.addActionListener(this);
        this.lDateTo.setLabelFor(this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.fDateTo.addActionListener(this);
        this.lAmtFrom.setLabelFor(this.fAmtFrom);
        this.fAmtFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtFrom.setToolTipText(Msg.translate(Env.getCtx(), "AmtFrom"));
        this.fAmtFrom.setBorder(this.fDateFrom.getBorder());
        this.fAmtFrom.addActionListener(this);
        this.lAmtTo.setLabelFor(this.fAmtTo);
        this.fAmtTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtTo.setToolTipText(Msg.translate(Env.getCtx(), "AmtTo"));
        this.fAmtTo.setBorder(this.fDateFrom.getBorder());
        this.fAmtTo.addActionListener(this);
        CPanel amtPanel = new CPanel();
        CPanel datePanel = new CPanel();
        amtPanel.setLayout(new ALayout(0, 0, true));
        amtPanel.add((Component)this.fAmtFrom, new ALayoutConstraint(0, 0));
        amtPanel.add((Component)this.lAmtTo, null);
        amtPanel.add((Component)this.fAmtTo, null);
        datePanel.setLayout(new ALayout(0, 0, true));
        datePanel.add((Component)this.fDateFrom, new ALayoutConstraint(0, 0));
        datePanel.add((Component)this.lDateTo, null);
        datePanel.add((Component)this.fDateTo, null);
        this.p_criteriaGrid.add((Component)this.lDocumentNo, new ALayoutConstraint(0, 0));
        this.p_criteriaGrid.add((Component)this.fDocumentNo, null);
        this.p_criteriaGrid.add((Component)this.lBPartner_ID, null);
        this.p_criteriaGrid.add((Component)this.fBPartner_ID, null);
        this.p_criteriaGrid.add((Component)this.fcheckReceipt, new ALayoutConstraint(0, 5));
        this.p_criteriaGrid.add((Component)this.lBankAccount_ID, new ALayoutConstraint(1, 0));
        this.p_criteriaGrid.add(this.fBankAccount_ID);
        this.p_criteriaGrid.add((Component)this.lDateFrom, null);
        this.p_criteriaGrid.add((Component)datePanel, null);
        this.p_criteriaGrid.add((Component)this.fcheckPayment, new ALayoutConstraint(1, 5));
        this.p_criteriaGrid.add((Component)this.lAmtFrom, new ALayoutConstraint(2, 2));
        this.p_criteriaGrid.add((Component)amtPanel, null);
    }

    @Override
    protected void initInfo(int record_id, String value) {
        if (record_id != 0 && value != null && value.length() > 0) {
            this.log.severe("Received both a record_id and a value: " + record_id + " - " + value);
        }
        if (record_id != 0) {
            this.fieldID = record_id;
            String trxName = Trx.createTrxName();
            MPayment p2 = new MPayment(Env.getCtx(), record_id, trxName);
            this.fcheckReceipt.setSelected(p2.isReceipt());
            this.fcheckPayment.setSelected(!p2.isReceipt());
            p2 = null;
            Trx.get(trxName, false).close();
        } else {
            String id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_BPartner_ID", true);
            if (id != null && id.length() != 0 && new Integer(id) > 0) {
                this.fBPartner_ID.setValue(new Integer(id));
            }
            if (value != null && value.length() > 0) {
                this.fDocumentNo.setValue(value);
            } else {
                id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_Payment_ID", true);
                if (id != null && id.length() != 0 && new Integer(id) > 0) {
                    this.fieldID = new Integer(id);
                    String trxName = Trx.createTrxName();
                    MPayment p3 = new MPayment(Env.getCtx(), record_id, trxName);
                    this.fcheckReceipt.setSelected(p3.isReceipt());
                    this.fcheckPayment.setSelected(!p3.isReceipt());
                    p3 = null;
                    Trx.get(trxName, false).close();
                }
                if ((id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_BankAccount_ID", true)) != null && id.length() != 0 && new Integer(id) > 0) {
                    this.fBankAccount_ID.setValue(new Integer(id));
                }
            }
        }
    }

    @Override
    protected String getSQLWhere() {
        Comparable<Date> to;
        Comparable<Date> from;
        StringBuffer sql = new StringBuffer();
        if (this.isResetRecordID()) {
            this.fieldID = 0;
        }
        if (this.fieldID != 0) {
            sql.append(" AND p.C_Payment_ID = ?");
        }
        if (InfoPayment.isValidSQLText(this.fDocumentNo)) {
            sql.append(" AND UPPER(p.DocumentNo) LIKE ?");
        }
        if (this.fBPartner_ID.getValue() != null) {
            sql.append(" AND p.C_BPartner_ID=?");
        }
        if (this.fBankAccount_ID.getValue() != null) {
            sql.append(" AND p.C_BankAccount_ID=?");
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(p.DateTrx, 'DD') <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(p.DateTrx, 'DD') >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(p.DateTrx, 'DD') BETWEEN ? AND ?");
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND p.PayAmt <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND p.PayAmt >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND p.PayAmt BETWEEN ? AND ?");
            }
        }
        if (this.fcheckReceipt.isSelected() && this.fcheckPayment.isSelected()) {
            this.log.severe("Both Only Receipt and Only Payment selected at the same time.");
        }
        if (this.fcheckReceipt.isSelected()) {
            sql.append(" AND ");
            sql.append("p.IsReceipt='Y'");
        }
        if (this.fcheckPayment.isSelected()) {
            sql.append(" AND ");
            sql.append("p.IsReceipt='N'");
        }
        this.log.fine(sql.toString());
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        Comparable<Date> to;
        Comparable<Date> from;
        Integer id;
        int index = 1;
        if (this.fieldID != 0) {
            pstmt.setInt(index++, this.fieldID);
        }
        if (InfoPayment.isValidSQLText(this.fDocumentNo)) {
            pstmt.setString(index++, InfoPayment.getSQLText(this.fDocumentNo));
        }
        if (this.fBPartner_ID.getValue() != null) {
            id = (Integer)this.fBPartner_ID.getValue();
            pstmt.setInt(index++, id);
            this.log.fine("BPartner=" + id);
        }
        if (this.fBankAccount_ID.getValue() != null) {
            id = (Integer)this.fBankAccount_ID.getValue();
            pstmt.setInt(index++, id);
            this.log.fine("BankAccount=" + id);
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            this.log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
                pstmt.setTimestamp(index++, (Timestamp)to);
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            this.log.fine("Amt From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "OnlyReceipt" && this.fcheckReceipt.isSelected()) {
            this.fcheckPayment.setSelected(false);
        }
        if (e.getActionCommand() == "OnlyPayment" && this.fcheckPayment.isSelected()) {
            this.fcheckReceipt.setSelected(false);
        }
        super.actionPerformed(e);
    }

    @Override
    protected void zoom(int record_ID) {
        this.log.info("InfoPayment.zoom");
        Integer C_Payment_ID = record_ID;
        if (C_Payment_ID == null) {
            return;
        }
        MQuery query = new MQuery("C_Payment");
        query.addRestriction("C_Payment_ID", "=", C_Payment_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("C_Payment", this.m_isSOTrx && this.fcheckReceipt.isSelected() || !this.m_isSOTrx && !this.fcheckReceipt.isSelected());
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    protected boolean hasOutstandingChanges() {
        return this.fDocumentNo.hasChanged() || this.fBankAccount_ID.hasChanged() || this.fcheckPayment.hasChanged() || this.fcheckReceipt.hasChanged() || this.fBPartner_ID.hasChanged() || this.fAmtFrom.hasChanged() || this.fAmtTo.hasChanged() || this.fDateFrom.hasChanged() || this.fDateTo.hasChanged();
    }

    @Override
    protected void setFieldOldValues() {
        this.fAmtFrom.set_oldValue();
        this.fAmtTo.set_oldValue();
        this.fDocumentNo.set_oldValue();
        this.fBankAccount_ID.set_oldValue();
        this.fcheckPayment.set_oldValue();
        this.fcheckReceipt.set_oldValue();
        this.fBPartner_ID.set_oldValue();
        this.fDateFrom.set_oldValue();
        this.fDateTo.set_oldValue();
    }

    @Override
    protected void clearParameters() {
        Object nullObject = null;
        this.fDocumentNo.setValue("");
        this.fAmtFrom.setValue(nullObject);
        this.fAmtTo.setValue(nullObject);
        this.fBPartner_ID.setValue(null);
        this.fBankAccount_ID.setValue(null);
        this.fDateFrom.setValue(nullObject);
        this.fDateTo.setValue(nullObject);
        this.fcheckReceipt.setSelected(true);
        this.fcheckPayment.setSelected(false);
    }
}

