/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.apps.search.InvoiceHistory;
import org.compiere.apps.search.PAttributeInstance;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VPAttribute;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MProduct;
import org.compiere.model.MQuery;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextArea;
import org.compiere.swing.CTextField;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class InfoProduct
extends Info
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 2076229793041196087L;
    private static Info_Column[] s_Layout = null;
    private static int INDEX_PATTRIBUTE = 0;
    private int fieldID = 0;
    private CLabel labelValue = new CLabel();
    private CTextField fieldValue = new CTextField(10);
    private CLabel labelName = new CLabel();
    private CTextField fieldName = new CTextField(10);
    private CLabel labelUPC = new CLabel();
    private CTextField fieldUPC = new CTextField(10);
    private CLabel labelSKU = new CLabel();
    private CTextField fieldSKU = new CTextField(10);
    private CLabel labelPriceList = new CLabel();
    private VLookup fPriceList_ID;
    private CLabel labelWarehouse = new CLabel();
    private VLookup fWarehouse_ID;
    private CLabel labelVendor = new CLabel();
    private VLookup fVendor_ID;
    private VCheckBox checkOnlyStock = new VCheckBox();
    private VCheckBox checkShowDetail = new VCheckBox();
    private CLabel labelProductCategory = new CLabel();
    private VLookup fProductCategory_ID;
    private CLabel labelAS = new CLabel();
    private VLookup fAS_ID;
    private CLabel labelASI = new CLabel();
    private VPAttribute fASI_ID;
    private VCheckBox checkAND = new VCheckBox();
    private CTextArea fieldDescription = new CTextArea();
    private CTextArea fieldPAttributes = new CTextArea();
    private CPanel tablePanel = new CPanel();
    private MiniTable warehouseTbl = new MiniTable();
    private String m_sqlWarehouse;
    private MiniTable substituteTbl = new MiniTable();
    private String m_sqlSubstitute;
    private MiniTable relatedTbl = new MiniTable();
    private String m_sqlRelated;
    private MiniTable vendorTbl = new MiniTable();
    private String m_sqlVendor;
    private CTabbedPane jTab = new CTabbedPane();
    private Info_Column[] m_layoutATP = null;
    private MiniTable m_tableAtp = null;
    private DefaultTableModel m_modelAtp = null;
    private int m_M_Product_ID = 0;
    private int m_M_Warehouse_ID = 0;
    private int m_M_PriceList_ID = 0;
    private CButton m_PAttributeButton = null;
    private int m_M_AttributeSetInstance_ID = -1;
    private int m_M_Locator_ID = 0;

    @Deprecated
    public InfoProduct(Frame frame, boolean modal, int WindowNo, int M_Warehouse_ID, int M_PriceList_ID, String value, boolean multiSelection, String whereClause) {
        this(frame, modal, WindowNo, M_Warehouse_ID, M_PriceList_ID, 0, value, multiSelection, true, whereClause);
    }

    public InfoProduct(Frame frame, boolean modal, int WindowNo, int M_Warehouse_ID, int M_PriceList_ID, int record_id, String value, boolean multiSelection, boolean saveResults, String whereClause) {
        super(frame, modal, WindowNo, "p", "M_Product_ID", multiSelection, saveResults, whereClause);
        this.log.info(value + ", Wh=" + M_Warehouse_ID + ", PL=" + M_PriceList_ID + ", WHERE=" + whereClause);
        this.setTitle(Util.cleanAmp(Msg.getMsg(Env.getCtx(), "InfoProduct")));
        this.m_M_Warehouse_ID = M_Warehouse_ID;
        this.m_M_PriceList_ID = M_PriceList_ID;
        StringBuffer where = new StringBuffer();
        where.append("p.IsActive='Y'");
        if (whereClause != null && whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(whereClause, "M_Product.", "p."));
        }
        this.setWhereClause(where.toString());
        this.statInit();
        this.initInfo(record_id, value, M_Warehouse_ID, M_PriceList_ID);
        this.m_heldLastFocus = this.fieldValue;
        if (this.autoQuery() || record_id != 0 || value != null && value.length() > 0 && value != "%") {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.labelValue.setText(Msg.getMsg(Env.getCtx(), "Value"));
        this.fieldValue.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldValue.addActionListener(this);
        this.labelName.setText(Msg.getMsg(Env.getCtx(), "Name"));
        this.fieldName.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldName.addActionListener(this);
        this.labelUPC.setText(Msg.translate(Env.getCtx(), "UPC"));
        this.fieldUPC.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldUPC.addActionListener(this);
        this.labelSKU.setText(Msg.translate(Env.getCtx(), "SKU"));
        this.fieldSKU.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldSKU.addActionListener(this);
        this.labelWarehouse.setText(Msg.getMsg(Env.getCtx(), "Warehouse"));
        this.fWarehouse_ID = new VLookup("M_Warehouse_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("M_Warehouse", "M_Warehouse_ID"), 19));
        this.fWarehouse_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fWarehouse_ID.addActionListener(this);
        this.checkOnlyStock.setText(Msg.getMsg(Env.getCtx(), "OnlyStock"));
        this.checkOnlyStock.setName("OnlyStock");
        this.checkOnlyStock.setToolTipText(Msg.getMsg(Env.getCtx(), "OnlyStockTip"));
        this.checkOnlyStock.setSelected(false);
        this.checkOnlyStock.addActionListener(this);
        this.checkShowDetail.setText(Msg.getMsg(Env.getCtx(), "ShowDetail"));
        this.checkShowDetail.setName("ShowDetail");
        this.checkShowDetail.setToolTipText(Msg.getMsg(Env.getCtx(), "ShowAttributeDetails"));
        this.checkShowDetail.setSelected(false);
        this.checkShowDetail.setEnabled(false);
        this.checkShowDetail.addActionListener(this);
        this.checkAND.setText(Msg.getMsg(Env.getCtx(), "SearchAND"));
        this.checkAND.setName("SearchAND");
        this.checkAND.setToolTipText(Msg.getMsg(Env.getCtx(), "SearchANDInfo"));
        this.checkAND.setSelected(true);
        this.checkAND.addActionListener(this);
        this.labelPriceList.setText(Msg.getMsg(Env.getCtx(), "PriceListVersion"));
        this.fPriceList_ID = new VLookup("M_PriceList_Version_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("M_PriceList_Version", "M_PriceList_Version_ID"), 19));
        this.fPriceList_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fPriceList_ID.addActionListener(this);
        this.labelProductCategory.setText(Msg.translate(Env.getCtx(), "M_Product_Category_ID"));
        this.fProductCategory_ID = new VLookup("M_Product_Category_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("M_Product_Category", "M_Product_Category_ID"), 19));
        this.fProductCategory_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fProductCategory_ID.addActionListener(this);
        this.labelAS.setText(Msg.translate(Env.getCtx(), "M_AttributeSet_ID"));
        this.fAS_ID = new VLookup("M_AttributeSet_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("M_AttributeSet", "M_AttributeSet_ID"), 19));
        this.fAS_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fAS_ID.addActionListener(this);
        this.labelASI.setText(Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"));
        MPAttributeLookup mpaLookup = new MPAttributeLookup(Env.getCtx(), this.p_WindowNo);
        this.fASI_ID = new VPAttribute(null, false, false, true, this.p_WindowNo, mpaLookup, true);
        this.fASI_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fASI_ID.addActionListener(this);
        this.labelVendor.setText(Msg.translate(Env.getCtx(), "Vendor"));
        this.fVendor_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("M_Product_PO", "C_BPartner_ID"), 30));
        this.fVendor_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fVendor_ID.addActionListener(this);
        this.fVendor_ID.setIsSOTrx(true, false);
        this.p_criteriaGrid.add((Component)this.labelValue, new ALayoutConstraint(0, 0));
        this.p_criteriaGrid.add((Component)this.fieldValue, null);
        this.p_criteriaGrid.add((Component)this.labelWarehouse, null);
        this.p_criteriaGrid.add((Component)this.fWarehouse_ID, null);
        this.p_criteriaGrid.add((Component)this.checkOnlyStock, new ALayoutConstraint(0, 5));
        this.p_criteriaGrid.add((Component)this.labelName, new ALayoutConstraint(1, 0));
        this.p_criteriaGrid.add((Component)this.fieldName, null);
        this.p_criteriaGrid.add((Component)this.labelPriceList, null);
        this.p_criteriaGrid.add((Component)this.fPriceList_ID, null);
        this.p_criteriaGrid.add((Component)this.labelAS, null);
        this.p_criteriaGrid.add((Component)this.fAS_ID, null);
        this.p_criteriaGrid.add((Component)this.labelUPC, new ALayoutConstraint(2, 0));
        this.p_criteriaGrid.add((Component)this.fieldUPC, null);
        this.p_criteriaGrid.add((Component)this.labelProductCategory, null);
        this.p_criteriaGrid.add((Component)this.fProductCategory_ID, null);
        this.p_criteriaGrid.add((Component)this.labelASI, null);
        this.p_criteriaGrid.add((Component)this.fASI_ID, null);
        this.p_criteriaGrid.add((Component)this.labelSKU, new ALayoutConstraint(3, 0));
        this.p_criteriaGrid.add((Component)this.fieldSKU, null);
        this.p_criteriaGrid.add((Component)this.labelVendor, null);
        this.p_criteriaGrid.add((Component)this.fVendor_ID, null);
        this.p_criteriaGrid.add((Component)this.checkAND, new ALayoutConstraint(3, 5));
        this.m_PAttributeButton = ConfirmPanel.createPAttributeButton(false);
        this.confirmPanel.addButton(this.m_PAttributeButton);
        this.m_PAttributeButton.addActionListener(this);
        this.m_PAttributeButton.setEnabled(false);
        this.fieldDescription.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldDescription.setEditable(false);
        this.fieldDescription.setPreferredSize(new Dimension(this.INFO_WIDTH - 100, 100));
        this.fieldPAttributes.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldPAttributes.setEditable(false);
        this.fieldPAttributes.setPreferredSize(new Dimension(this.INFO_WIDTH - 100, 100));
        ColumnInfo[] s_layoutWarehouse = new ColumnInfo[]{new ColumnInfo(" ", "M_Warehouse_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "WarehouseName"), "WarehouseName", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyAvailable"), "sum(QtyAvailable)", Double.class, true, true, null), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOnHand"), "sum(QtyOnHand)", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyReserved"), "sum(QtyReserved)", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOrdered"), "sum(QtyOrdered)", Double.class)};
        String s_sqlFrom = " M_PRODUCT_STOCK_V ";
        String s_sqlWhere = "(QtyOnHand <> 0 OR QtyAvailable <> 0 OR QtyReserved <> 0 OR QtyOrdered <> 0) AND M_Product_ID = ?";
        this.m_sqlWarehouse = this.warehouseTbl.prepareTable(s_layoutWarehouse, s_sqlFrom, s_sqlWhere, false, "M_PRODUCT_STOCK_V");
        this.m_sqlWarehouse = this.m_sqlWarehouse + " Group By M_Warehouse_ID, WarehouseName ";
        this.m_sqlWarehouse = this.m_sqlWarehouse + " Order By sum(QtyOnHand) DESC, WarehouseName ";
        this.warehouseTbl.setRowSelectionAllowed(true);
        this.warehouseTbl.setMultiSelection(false);
        this.warehouseTbl.addMouseListener(this);
        this.warehouseTbl.setShowTotals(true);
        this.warehouseTbl.autoSize();
        ColumnInfo[] s_layoutSubstitute = new ColumnInfo[]{new ColumnInfo(Msg.translate(Env.getCtx(), "Warehouse"), "orgname", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Description"), "description", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Value"), "value", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyAvailable"), "QtyAvailable", Double.class, true, true, null), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOnHand"), "QtyOnHand", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyReserved"), "QtyReserved", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "PriceStd"), "PriceStd", Double.class)};
        s_sqlFrom = "M_PRODUCT_SUBSTITUTERELATED_V";
        s_sqlWhere = "M_Product_ID = ? AND M_PriceList_Version_ID = ? and RowType = 'S'";
        this.m_sqlSubstitute = this.substituteTbl.prepareTable(s_layoutSubstitute, s_sqlFrom, s_sqlWhere, false, "M_PRODUCT_SUBSTITUTERELATED_V");
        this.substituteTbl.setRowSelectionAllowed(false);
        this.substituteTbl.setMultiSelection(false);
        this.substituteTbl.addMouseListener(this);
        this.substituteTbl.setShowTotals(false);
        this.substituteTbl.autoSize();
        ColumnInfo[] s_layoutRelated = new ColumnInfo[]{new ColumnInfo(Msg.translate(Env.getCtx(), "Warehouse"), "orgname", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Description"), "description", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Value"), "value", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyAvailable"), "QtyAvailable", Double.class, true, true, null), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOnHand"), "QtyOnHand", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyReserved"), "QtyReserved", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "PriceStd"), "PriceStd", Double.class)};
        s_sqlFrom = "M_PRODUCT_SUBSTITUTERELATED_V";
        s_sqlWhere = "M_Product_ID = ? AND M_PriceList_Version_ID = ? and RowType = 'R'";
        this.m_sqlRelated = this.relatedTbl.prepareTable(s_layoutRelated, s_sqlFrom, s_sqlWhere, false, "M_PRODUCT_SUBSTITUTERELATED_V");
        this.relatedTbl.setRowSelectionAllowed(false);
        this.relatedTbl.setMultiSelection(false);
        this.relatedTbl.addMouseListener(this);
        this.relatedTbl.setShowTotals(false);
        this.relatedTbl.autoSize();
        this.initAtpTab();
        this.m_tableAtp.setRowSelectionAllowed(false);
        this.m_tableAtp.setMultiSelection(false);
        ColumnInfo[] s_layoutVendor = new ColumnInfo[]{new ColumnInfo(Msg.translate(Env.getCtx(), "Vendor"), "(SELECT bp.Name FROM C_BPartner bp WHERE bp.C_BPartner_ID = M_PRODUCT_PO.C_BPartner_ID)", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "IsCurrentVendor"), "IsCurrentVendor", Boolean.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_UOM_ID"), "(SELECT Name FROM C_UOM WHERE C_UOM_ID = M_PRODUCT_PO.C_UOM_ID)", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_Currency_ID"), "(SELECT iso_code FROM C_Currency WHERE C_Currency_ID = M_PRODUCT_PO.C_Currency_ID)", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "PriceList"), "PriceList", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "PricePO"), "PricePO", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "VendorProductNo"), "VendorProductNo", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Order_Min"), "Order_Min", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "DeliveryTime_Promised"), "DeliveryTime_Promised", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "DeliveryTime_Actual"), "DeliveryTime_Actual", Double.class)};
        s_sqlFrom = "M_PRODUCT_PO";
        s_sqlWhere = "M_Product_ID = ?";
        this.m_sqlVendor = this.vendorTbl.prepareTable(s_layoutVendor, s_sqlFrom, s_sqlWhere, false, "M_PRODUCT_PO");
        this.vendorTbl.setRowSelectionAllowed(false);
        this.vendorTbl.setMultiSelection(false);
        this.vendorTbl.addMouseListener(this);
        this.vendorTbl.setShowTotals(false);
        this.vendorTbl.autoSize();
        this.jTab.addTab(Msg.translate(Env.getCtx(), "Warehouse"), new JScrollPane(this.warehouseTbl));
        this.jTab.setPreferredSize(new Dimension(this.INFO_WIDTH, this.SCREEN_HEIGHT > 600 ? 250 : 105));
        this.jTab.addTab(Msg.translate(Env.getCtx(), "Description"), new JScrollPane(this.fieldDescription));
        this.jTab.addTab(Msg.translate(Env.getCtx(), "ProductAttribute"), new JScrollPane(this.fieldPAttributes));
        this.jTab.addTab(Msg.translate(Env.getCtx(), "Substitute_ID"), new JScrollPane(this.substituteTbl));
        this.jTab.addTab(Msg.translate(Env.getCtx(), "RelatedProduct_ID"), new JScrollPane(this.relatedTbl));
        this.jTab.addTab(Msg.getMsg(Env.getCtx(), "ATP"), new JScrollPane(this.m_tableAtp));
        this.jTab.addTab(Msg.translate(Env.getCtx(), "Vendor"), new JScrollPane(this.vendorTbl));
        this.jTab.addChangeListener(this);
        this.tablePanel.setPreferredSize(new Dimension(this.INFO_WIDTH, this.SCREEN_HEIGHT > 600 ? 255 : 110));
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)this.jTab, "Center");
        this.p_detailTaskPane.setTitle(Msg.translate(Env.getCtx(), "WarehouseStock"));
        this.p_detailTaskPane.add((Component)this.checkShowDetail, (Object)"North");
        this.p_detailTaskPane.add((Component)this.tablePanel, (Object)"Center");
        this.p_detailTaskPane.setVisible(true);
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String sql;
                int M_PriceList_Version_ID = 0;
                if (InfoProduct.this.fPriceList_ID.getValue() != null) {
                    M_PriceList_Version_ID = (Integer)InfoProduct.this.fPriceList_ID.getValue();
                }
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                String eol = System.getProperty("line.separator");
                int leadRowKey = InfoProduct.this.p_table.getLeadRowKey();
                if (InfoProduct.this.jTab.getSelectedIndex() == 0 || InfoProduct.this.m_M_Product_ID != leadRowKey) {
                    InfoProduct.this.m_M_Product_ID = leadRowKey;
                    MProduct mp = MProduct.get(Env.getCtx(), InfoProduct.this.m_M_Product_ID);
                    InfoProduct.this.m_M_AttributeSetInstance_ID = mp.getM_AttributeSetInstance_ID();
                    sql = InfoProduct.this.m_sqlWarehouse;
                    InfoProduct.this.log.finest(sql);
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, InfoProduct.this.m_M_Product_ID);
                        rs = pstmt.executeQuery();
                        InfoProduct.this.warehouseTbl.loadTable(rs);
                        rs.close();
                    }
                    catch (Exception e) {
                        try {
                            InfoProduct.this.log.log(Level.WARNING, sql, e);
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            throw throwable;
                        }
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                if (InfoProduct.this.jTab.getSelectedIndex() == 1) {
                    InfoProduct.this.fieldDescription.setText("");
                    if (InfoProduct.this.m_M_Product_ID != 0) {
                        MProduct p2 = MProduct.get(Env.getCtx(), InfoProduct.this.m_M_Product_ID);
                        if (p2.getDescription() != null && p2.getDescription().length() > 0) {
                            InfoProduct.this.fieldDescription.setText(p2.getDescription());
                        }
                        if (p2.getDocumentNote() != null && p2.getDocumentNote().length() > 0) {
                            if (InfoProduct.this.fieldDescription.getText().length() > 0) {
                                InfoProduct.this.fieldDescription.setText(InfoProduct.this.fieldDescription.getText() + eol + eol + p2.getDocumentNote());
                            } else {
                                InfoProduct.this.fieldDescription.setText(InfoProduct.this.fieldDescription.getText() + p2.getDocumentNote());
                            }
                        }
                    } else {
                        InfoProduct.this.fieldDescription.setText("");
                    }
                }
                if (InfoProduct.this.jTab.getSelectedIndex() == 2) {
                    InfoProduct.this.fieldPAttributes.setText("");
                    StringBuffer paText = new StringBuffer();
                    if (InfoProduct.this.m_M_Product_ID != 0) {
                        Boolean labeled;
                        MProduct p3 = MProduct.get(Env.getCtx(), InfoProduct.this.m_M_Product_ID);
                        if (p3.getM_AttributeSet_ID() == 0 || p3.getM_AttributeSetInstance_ID() == 0) {
                            return;
                        }
                        int M_AttributeSet_ID = p3.getM_AttributeSetInstance_ID();
                        sql = "SELECT asi.Lot, asi.SerNo, asi.GuaranteeDate, COALESCE(a.SerNoCharSOverwrite, '#'::CHAR(1)), COALESCE(a.SerNoCharEOverwrite, ''::CHAR(1)), COALESCE(a.LotCharSOverwrite, '\u00ab'::CHAR(1)), COALESCE(a.LotCharEOverwrite, '\u00bb'::CHAR(1)) FROM M_AttributeSetInstance asi INNER JOIN M_AttributeSet a ON (asi.M_AttributeSet_ID=a.M_AttributeSet_ID) WHERE asi.M_AttributeSetInstance_ID=?";
                        InfoProduct.this.log.finest(sql);
                        try {
                            pstmt = DB.prepareStatement(sql, null);
                            pstmt.setInt(1, M_AttributeSet_ID);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                if (rs.getString(1) != null && rs.getString(1).length() > 0) {
                                    paText.append(Msg.translate(Env.getCtx(), "Lot")).append(": ").append(rs.getString(6)).append(rs.getString(1)).append(rs.getString(7)).append(eol);
                                }
                                if (rs.getString(2) != null && rs.getString(2).length() > 0) {
                                    paText.append(Msg.translate(Env.getCtx(), "SerialNumber")).append(": ").append(rs.getString(4)).append(rs.getString(2)).append(rs.getString(5)).append(eol);
                                }
                                if (rs.getDate(3) == null) continue;
                                paText.append(Msg.translate(Env.getCtx(), "GuaranteeDate")).append(": ").append(rs.getDate(3)).append(eol);
                            }
                        }
                        catch (Exception e) {
                            InfoProduct.this.log.log(Level.WARNING, sql, e);
                        }
                        finally {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                        }
                        sql = "SELECT ai.Value, a.Name FROM M_AttributeInstance ai INNER JOIN M_Attribute a ON (ai.M_Attribute_ID=a.M_Attribute_ID AND a.IsInstanceAttribute='Y') WHERE ai.M_AttributeSetInstance_ID=?";
                        InfoProduct.this.log.finest(sql);
                        try {
                            pstmt = DB.prepareStatement(sql, null);
                            pstmt.setInt(1, M_AttributeSet_ID);
                            rs = pstmt.executeQuery();
                            labeled = false;
                            while (rs.next()) {
                                if (!labeled.booleanValue()) {
                                    paText.append("***  ").append(Msg.translate(Env.getCtx(), "InstanceAttribute")).append("  ***").append(eol);
                                    labeled = true;
                                }
                                paText.append("  ").append(rs.getString(2)).append(": ").append(rs.getString(1)).append(eol);
                            }
                            rs.close();
                        }
                        catch (Exception e) {
                            InfoProduct.this.log.log(Level.WARNING, sql, e);
                        }
                        finally {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                        }
                        sql = "SELECT ai.Value, a.Name FROM M_AttributeInstance ai INNER JOIN M_Attribute a ON (ai.M_Attribute_ID=a.M_Attribute_ID AND a.IsInstanceAttribute='N') WHERE ai.M_AttributeSetInstance_ID=?";
                        InfoProduct.this.log.finest(sql);
                        try {
                            pstmt = DB.prepareStatement(sql, null);
                            pstmt.setInt(1, M_AttributeSet_ID);
                            rs = pstmt.executeQuery();
                            labeled = false;
                            while (rs.next()) {
                                if (!labeled.booleanValue()) {
                                    paText.append("***  ").append(Msg.translate(Env.getCtx(), "ProductAttribute")).append("  ***").append(eol);
                                    labeled = true;
                                }
                                paText.append("  ").append(rs.getString(2)).append(": ").append(rs.getString(1)).append(eol);
                            }
                            rs.close();
                        }
                        catch (Exception e) {
                            InfoProduct.this.log.log(Level.WARNING, sql, e);
                        }
                        finally {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                        }
                        if (paText.length() > 0) {
                            InfoProduct.this.fieldPAttributes.setText(paText.toString());
                        }
                    }
                }
                if (InfoProduct.this.jTab.getSelectedIndex() == 3) {
                    sql = InfoProduct.this.m_sqlSubstitute;
                    InfoProduct.this.log.finest(sql);
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, InfoProduct.this.m_M_Product_ID);
                        pstmt.setInt(2, M_PriceList_Version_ID);
                        rs = pstmt.executeQuery();
                        InfoProduct.this.substituteTbl.loadTable(rs);
                        rs.close();
                    }
                    catch (Exception e) {
                        try {
                            InfoProduct.this.log.log(Level.WARNING, sql, e);
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            throw throwable;
                        }
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                if (InfoProduct.this.jTab.getSelectedIndex() == 4) {
                    sql = InfoProduct.this.m_sqlRelated;
                    InfoProduct.this.log.finest(sql);
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, InfoProduct.this.m_M_Product_ID);
                        pstmt.setInt(2, M_PriceList_Version_ID);
                        rs = pstmt.executeQuery();
                        InfoProduct.this.relatedTbl.loadTable(rs);
                        rs.close();
                    }
                    catch (Exception e) {
                        InfoProduct.this.log.log(Level.WARNING, sql, e);
                    }
                    finally {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                    }
                }
                if (InfoProduct.this.jTab.getSelectedIndex() == 5) {
                    InfoProduct.this.refreshAtpTab();
                }
                if (InfoProduct.this.jTab.getSelectedIndex() == 6) {
                    sql = InfoProduct.this.m_sqlVendor;
                    InfoProduct.this.log.finest(sql);
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, InfoProduct.this.m_M_Product_ID);
                        rs = pstmt.executeQuery();
                        InfoProduct.this.vendorTbl.loadTable(rs);
                        rs.close();
                    }
                    catch (Exception e) {
                        InfoProduct.this.log.log(Level.WARNING, sql, e);
                    }
                    finally {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                    }
                }
            }
        });
    }

    @Override
    protected void initInfo() {
        this.clearParameters();
        this.initInfo(0, "", this.m_M_Warehouse_ID, this.m_M_PriceList_ID);
    }

    private void initInfo(int record_id, String value, int M_Warehouse_ID, int M_PriceList_ID) {
        if (record_id != 0 && value != null && value.length() > 0) {
            this.log.severe("Received both a record_id and a value: " + record_id + " - " + value);
        }
        if (record_id != 0) {
            this.fieldID = record_id;
            this.fWarehouse_ID.setValue((int)new Integer(M_Warehouse_ID));
            this.fPriceList_ID.setValue(this.findPLV(M_PriceList_ID));
        } else {
            this.fieldID = 0;
            if (value != null && value.length() > 0) {
                if (value.startsWith("@") && value.endsWith("@")) {
                    this.fieldName.setText(value.substring(1, value.length() - 1));
                } else {
                    this.fieldValue.setText(value);
                    this.fieldName.setText(value);
                    this.fieldUPC.setText(value);
                    this.fieldSKU.setText(value);
                }
                this.fWarehouse_ID.setValue(0);
                this.fPriceList_ID.setValue(0);
                this.checkAND.setSelected(false);
            } else {
                String id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "M_Product_ID", true);
                if (id != null && id.length() != 0 && new Integer(id) > 0) {
                    this.fieldID = new Integer(id);
                }
                if ((id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "M_PriceList_Version_ID", true)) != null && id.length() != 0 && new Integer(id) > 0) {
                    this.fPriceList_ID.setValue((int)new Integer(id));
                } else {
                    this.fPriceList_ID.setValue(this.findPLV(M_PriceList_ID));
                }
                if (M_Warehouse_ID == 0) {
                    id = Env.getContext(Env.getCtx(), "#M_Warehouse_ID");
                    if (id != null && id.length() != 0 && new Integer(id) > 0) {
                        this.fWarehouse_ID.setValue((int)new Integer(id));
                    } else {
                        id = Env.getContext(Env.getCtx(), this.p_WindowNo, "M_Warehouse_ID");
                        if (id != null && id.length() != 0 && new Integer(id) > 0) {
                            this.fWarehouse_ID.setValue((int)new Integer(id));
                        }
                    }
                } else {
                    this.fWarehouse_ID.setValue((int)new Integer(M_Warehouse_ID));
                }
                id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_BPartner_ID", false);
                boolean isSOTrx = "Y".equals(Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "IsSOTrx", false));
                if (id != null && id.length() != 0 && new Integer(id) > 0 && !isSOTrx) {
                    this.fVendor_ID.setValue((int)new Integer(id));
                }
            }
        }
        if (!this.isValidVObject(this.fWarehouse_ID)) {
            this.checkOnlyStock.setSelected(false);
            this.checkOnlyStock.setEnabled(false);
        } else {
            this.checkOnlyStock.setEnabled(true);
        }
        this.prepareTable(this.getTableLayout(), this.getFromClause(), this.getWhereClause(), this.getOrderClause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findPLV(int M_PriceList_ID) {
        Timestamp priceDate = null;
        String dateStr = Env.getContext(Env.getCtx(), this.p_WindowNo, "DateOrdered");
        if (dateStr != null && dateStr.length() > 0) {
            priceDate = Env.getContextAsDate(Env.getCtx(), this.p_WindowNo, "DateOrdered");
        } else {
            dateStr = Env.getContext(Env.getCtx(), this.p_WindowNo, "DateInvoiced");
            if (dateStr != null && dateStr.length() > 0) {
                priceDate = Env.getContextAsDate(Env.getCtx(), this.p_WindowNo, "DateInvoiced");
            }
        }
        if (priceDate == null) {
            priceDate = new Timestamp(System.currentTimeMillis());
        }
        this.log.config("M_PriceList_ID=" + M_PriceList_ID + " - " + priceDate);
        int retValue = 0;
        String sql = "SELECT plv.M_PriceList_Version_ID, plv.ValidFrom FROM M_PriceList pl, M_PriceList_Version plv WHERE pl.M_PriceList_ID=plv.M_PriceList_ID AND plv.IsActive='Y' AND pl.M_PriceList_ID=? ORDER BY plv.ValidFrom DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_PriceList_ID);
            rs = pstmt.executeQuery();
            while (rs.next() && retValue == 0) {
                Timestamp plDate = rs.getTimestamp(2);
                if (priceDate.before(plDate)) continue;
                retValue = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    @Override
    protected String getFromClause() {
        String s_productFrom = "M_Product p";
        if (this.isValidVObject(this.fPriceList_ID)) {
            s_productFrom = s_productFrom + " LEFT OUTER JOIN (SELECT mpp.M_Product_ID, mpp.M_PriceList_Version_id, mpp.IsActive, mpp.PriceList, mpp.PriceStd, mpp.PriceLimit FROM M_ProductPrice mpp, M_PriceList_Version mplv  WHERE mplv.M_PriceList_Version_ID = mpp.M_PriceList_Version_ID AND mplv.IsActive = 'Y') pr ON (p.M_Product_ID=pr.M_Product_ID AND pr.IsActive='Y')";
        }
        s_productFrom = s_productFrom + " LEFT OUTER JOIN M_AttributeSet pa ON (p.M_AttributeSet_ID=pa.M_AttributeSet_ID) LEFT OUTER JOIN M_Product_PO ppo ON (p.M_Product_ID=ppo.M_Product_ID and ppo.IsCurrentVendor='Y' and ppo.IsActive='Y') LEFT OUTER JOIN M_Product_Category pc ON (p.M_Product_Category_ID=pc.M_Product_Category_ID) LEFT OUTER JOIN C_BPartner bp ON (ppo.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN C_UOM u ON (p.C_UOM_ID=u.C_UOM_ID)";
        return s_productFrom;
    }

    @Override
    protected String getSQLWhere() {
        String asiWhere;
        ArrayList<String> list = new ArrayList<String>();
        if (this.isResetRecordID()) {
            this.fieldID = 0;
        }
        if (this.fieldID != 0) {
            list.add("p.M_Product_ID = ?");
        }
        if (this.fWarehouse_ID.getValue() != null && (Integer)this.fWarehouse_ID.getValue() != 0) {
            list.add("p.IsSummary='N'");
        }
        if (this.checkOnlyStock.isSelected()) {
            list.add("p.isStocked = ?");
        }
        if (this.fPriceList_ID.getValue() != null) {
            list.add("pr.M_PriceList_Version_ID=?");
        }
        if (this.fProductCategory_ID.getValue() != null) {
            list.add("(p.M_Product_Category_ID=? OR p.M_Product_Category_ID IN (SELECT PPC.M_Product_Category_ID FROM M_Product_Category ppc WHERE  ppc.M_Product_Category_Parent_ID = ?))");
        }
        if (this.fAS_ID.getValue() != null) {
            list.add("p.M_AttributeSet_ID=?");
        }
        if (this.fASI_ID.getAttributeWhere() != null && (asiWhere = this.fASI_ID.getAttributeWhere()).length() > 0) {
            if (asiWhere.startsWith(" AND ")) {
                asiWhere = asiWhere.substring(5);
            }
            list.add(asiWhere);
        }
        if (InfoProduct.isValidSQLText(this.fieldValue)) {
            list.add("UPPER(p.Value) LIKE ?");
        }
        if (InfoProduct.isValidSQLText(this.fieldName)) {
            list.add("UPPER(p.Name) LIKE ?");
        }
        if (InfoProduct.isValidSQLText(this.fieldUPC)) {
            list.add("UPPER(p.UPC) LIKE ?");
        }
        if (InfoProduct.isValidSQLText(this.fieldSKU)) {
            list.add("UPPER(p.SKU) LIKE ?");
        }
        if (this.fVendor_ID.getValue() != null) {
            list.add("ppo.C_BPartner_ID=?");
        }
        StringBuffer sql = new StringBuffer();
        int size = list.size();
        if (size == 1) {
            sql.append(" AND ").append((String)list.get(0));
        } else if (size > 1) {
            boolean AND = this.checkAND.isSelected();
            sql.append(" AND ");
            if (!AND) {
                sql.append("(");
            }
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sql.append(AND ? " AND " : " OR ");
                }
                sql.append((String)list.get(i));
            }
            if (!AND) {
                sql.append(")");
            }
        }
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        int index = 1;
        Integer id = this.fWarehouse_ID.getValue() != null ? (Integer)this.fWarehouse_ID.getValue() : Integer.valueOf(0);
        if (!forCount) {
            for (int i = 0; i < this.p_layout.length; ++i) {
                if (this.p_layout[i].getColSQL().indexOf(63) == -1) continue;
                pstmt.setInt(index++, id);
            }
        }
        this.log.fine("M_Warehouse_ID=" + id + " (" + (index - 1) + "*)");
        if (this.fieldID != 0) {
            pstmt.setInt(index++, this.fieldID);
            this.log.fine("Record ID: " + this.fieldID);
        }
        if (this.checkOnlyStock.isSelected()) {
            pstmt.setString(index++, "Y");
            this.log.fine("Only Stocked: Y");
        }
        if (this.fPriceList_ID.getValue() != null) {
            id = (Integer)this.fPriceList_ID.getValue();
            pstmt.setInt(index++, id);
            this.log.fine("M_PriceList_Version_ID=" + id);
        }
        if (this.fProductCategory_ID.getValue() != null) {
            id = (Integer)this.fProductCategory_ID.getValue();
            pstmt.setInt(index++, id);
            pstmt.setInt(index++, id);
            this.log.fine("M_Product_Category_ID=" + id);
        }
        if (this.fAS_ID.getValue() != null) {
            id = (Integer)this.fAS_ID.getValue();
            pstmt.setInt(index++, id);
            this.log.fine("M_AttributeSet_ID=" + id);
        }
        if (this.fASI_ID.getAttributeWhere() != null) {
            // empty if block
        }
        if (InfoProduct.isValidSQLText(this.fieldValue)) {
            pstmt.setString(index++, InfoProduct.getSQLText(this.fieldValue));
        }
        if (InfoProduct.isValidSQLText(this.fieldName)) {
            pstmt.setString(index++, InfoProduct.getSQLText(this.fieldName));
        }
        if (InfoProduct.isValidSQLText(this.fieldUPC)) {
            pstmt.setString(index++, InfoProduct.getSQLText(this.fieldUPC));
        }
        if (InfoProduct.isValidSQLText(this.fieldSKU)) {
            pstmt.setString(index++, InfoProduct.getSQLText(this.fieldSKU));
        }
        if (this.fVendor_ID.getValue() != null) {
            id = (Integer)this.fVendor_ID.getValue();
            pstmt.setInt(index++, id);
            this.log.fine("fVendor_ID=" + id);
        }
    }

    @Override
    protected void recordSelected(int key) {
        if (this.m_M_Product_ID != key) {
            this.refresh();
        }
        this.p_detailTaskPane.setCollapsed(false);
    }

    @Override
    protected void noRecordSelected() {
        this.m_M_Product_ID = 0;
        this.p_detailTaskPane.setCollapsed(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.p_loadedOK) {
            return;
        }
        String cmd = e.getActionCommand();
        Object source = null;
        if (e.getSource() != null) {
            VCheckBox cb;
            source = e.getSource();
            if (cmd.equals("PAttribute")) {
                PAttributeInstance pai;
                if (this.p_table.isMultiSelection()) {
                    int row = this.p_table.getSelectionModel().getLeadSelectionIndex();
                    this.p_table.setRowChecked(row, true);
                }
                MProduct mp = MProduct.get(Env.getCtx(), this.m_M_Product_ID);
                String title = "";
                int wh_id = 0;
                if (this.isValidVObject(this.fWarehouse_ID)) {
                    title = this.fWarehouse_ID.getDisplay() + " - " + mp.getName();
                    wh_id = (Integer)this.fWarehouse_ID.getValue();
                }
                int bp_id = 0;
                String s_bp_id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_BPartner_ID", false);
                if (s_bp_id != null && s_bp_id.length() != 0 && new Integer(s_bp_id) > 0) {
                    bp_id = new Integer(s_bp_id);
                }
                if (!(pai = new PAttributeInstance(this, title, wh_id, 0, this.p_table.getLeadRowKey(), bp_id)).wasCancelled()) {
                    this.m_M_AttributeSetInstance_ID = pai.getM_AttributeSetInstance_ID();
                    this.m_M_Locator_ID = pai.getM_Locator_ID();
                    if (this.m_M_AttributeSetInstance_ID > 0) {
                        this.fASI_ID.setValue(this.m_M_AttributeSetInstance_ID);
                    } else {
                        this.fASI_ID.setValue(0);
                    }
                }
                if (this.p_saveResults && this.m_M_AttributeSetInstance_ID != -1 && !pai.wasCancelled()) {
                    this.dispose(this.p_saveResults);
                    return;
                }
                return;
            }
            if (source instanceof VComboBox) {
                if (((VComboBox)source).getParent() instanceof VLookup) {
                    source = ((VComboBox)source).getParent();
                    VLookup vl = (VLookup)source;
                    this.m_heldLastFocus = vl;
                    if (cmd.equals("comboBoxEdited")) {
                        if (!vl.hasChanged() && !this.hasOutstandingChanges()) {
                            vl.requestFocus();
                            return;
                        }
                        this.p_triggerRefresh = true;
                        if (vl == this.fWarehouse_ID) {
                            if (!this.isValidVObject(this.fWarehouse_ID)) {
                                this.checkOnlyStock.setSelected(false);
                                this.checkOnlyStock.setEnabled(false);
                            } else {
                                this.checkOnlyStock.setEnabled(true);
                            }
                        }
                    }
                }
            } else if (source instanceof CTextField) {
                CTextField tf = (CTextField)source;
                if (tf.getParent() instanceof VPAttribute) {
                    source = tf.getParent();
                    VPAttribute vpa = (VPAttribute)source;
                    this.m_heldLastFocus = this.fieldValue;
                    if (vpa.hasChanged()) {
                        this.p_triggerRefresh = true;
                    }
                }
            } else if (e.getSource() instanceof VCheckBox && (cb = (VCheckBox)e.getSource()).getName().equals("ShowDetail")) {
                this.refreshAtpTab();
                return;
            }
        }
        super.actionPerformed(e);
    }

    @Override
    protected boolean columnIsDynamic(Object o) {
        return o.equals(this.fPriceList_ID) || o.equals(this.fProductCategory_ID) || o.equals(this.fWarehouse_ID);
    }

    @Override
    protected void enableButtons() {
        if (this.m_PAttributeButton != null) {
            if (this.p_table == null) {
                return;
            }
            int row = this.p_table.getSelectionModel().getLeadSelectionIndex();
            int rows = this.p_table.getRowCount();
            if (this.p_table.getShowTotals()) {
                --rows;
            }
            if (row < 0 || row > rows) {
                super.enableButtons();
                return;
            }
            boolean enabled = false;
            try {
                Object value = this.p_table.getValueAt(row, INDEX_PATTRIBUTE);
                enabled = Boolean.TRUE.equals(value);
            }
            catch (Exception e) {
                enabled = false;
            }
            if (enabled && this.p_table.isMultiSelection()) {
                IDColumn record;
                Object data;
                int checkedRows = this.p_table.getSelectedKeys().size();
                int selectedRows = this.p_table.getSelectedRowCount();
                this.log.fine("Checked Rows: " + checkedRows + " SelectedRows: " + selectedRows);
                if (checkedRows > 1 || selectedRows > 1) {
                    enabled = false;
                } else if (checkedRows == 1 && (data = this.p_table.getValueAt(row, this.p_table.getKeyColumnIndex())) instanceof IDColumn && !(record = (IDColumn)data).isSelected()) {
                    enabled = false;
                    this.log.fine("Lead selection is not checked!");
                }
            }
            this.m_PAttributeButton.setEnabled(enabled);
        }
        super.enableButtons();
    }

    @Override
    protected void showHistory(int record_id) {
        this.log.info("");
        int M_Product_ID = record_id;
        if (M_Product_ID <= 0) {
            return;
        }
        int M_Warehouse_ID = 0;
        if (this.fWarehouse_ID.getValue() != null) {
            M_Warehouse_ID = (Integer)this.fWarehouse_ID.getValue();
        }
        int M_AttributeSetInstance_ID = this.m_M_AttributeSetInstance_ID;
        if (this.m_M_AttributeSetInstance_ID < 0) {
            M_AttributeSetInstance_ID = 0;
        }
        InvoiceHistory ih = new InvoiceHistory(this, 0, M_Product_ID, M_Warehouse_ID, M_AttributeSetInstance_ID);
        ih.setVisible(true);
        ih = null;
    }

    @Override
    protected boolean hasHistory() {
        return true;
    }

    @Override
    protected void zoom(int record_id) {
        this.log.info("");
        Integer M_Product_ID = record_id;
        if (M_Product_ID == null) {
            return;
        }
        MQuery query = new MQuery("M_Product");
        query.addRestriction("M_Product_ID", "=", M_Product_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("M_Product", true);
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    protected void customize() {
        this.log.info("");
    }

    @Override
    protected boolean hasCustomize() {
        return false;
    }

    @Override
    protected void saveSelectionDetail() {
        Integer ID = this.getSelectedRowKey();
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_Product_ID", ID == null ? "0" : ID.toString());
        if (this.isValidVObject(this.fPriceList_ID)) {
            Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_PriceList_Version_ID", ((Integer)this.fPriceList_ID.getValue()).toString());
        }
        if (this.isValidVObject(this.fWarehouse_ID)) {
            Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_Warehouse_ID", ((Integer)this.fWarehouse_ID.getValue()).toString());
        }
        if (this.m_M_AttributeSetInstance_ID == -1 || this.isMultipleResults()) {
            Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_AttributeSetInstance_ID", "0");
            Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_Locator_ID", "0");
        } else {
            Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_AttributeSetInstance_ID", String.valueOf(this.m_M_AttributeSetInstance_ID));
            Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_Locator_ID", String.valueOf(this.m_M_Locator_ID));
        }
    }

    @Override
    protected Info_Column[] getTableLayout() {
        ArrayList<Info_Column> list = new ArrayList<Info_Column>();
        list.add(new Info_Column(" ", "p.M_Product_ID", IDColumn.class, false));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "Discontinued").substring(0, 1), "p.Discontinued", Boolean.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "M_Product_Category_ID"), "pc.Name", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "Value"), "p.Value", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "Name"), "p.Name", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "UPC"), "p.UPC", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "SKU"), "p.SKU", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "C_UOM_ID"), "u.name", String.class));
        if (this.isValidVObject(this.fPriceList_ID)) {
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "PriceList"), "bomPriceList(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceList", BigDecimal.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "PriceStd"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceStd", BigDecimal.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "PriceLimit"), "bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceLimit", BigDecimal.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "Margin"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID)-bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS Margin", BigDecimal.class));
        }
        if (this.isValidVObject(this.fWarehouse_ID)) {
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "IsStocked"), "p.isStocked", Boolean.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyAvailable"), "case when p.IsBOM='N' and (p.ProductType!='I' OR p.IsStocked='N') then to_number(get_Sysconfig('QTY_TO_SHOW_FOR_SERVICES', '99999', p.ad_client_id, 0), '99999999999') else bomQtyAvailable(p.M_Product_ID,?,0) end AS QtyAvailable", Double.class, true, true, null));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyOnHand"), "case when p.IsBOM='N' and (p.ProductType!='I' OR p.IsStocked='N') then to_number(get_Sysconfig('QTY_TO_SHOW_FOR_SERVICES', '99999', p.ad_client_id, 0), '99999999999') else bomQtyOnHand(p.M_Product_ID,?,0) end AS QtyOnHand", Double.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyReserved"), "bomQtyReserved(p.M_Product_ID,?,0) AS QtyReserved", Double.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyOrdered"), "bomQtyOrdered(p.M_Product_ID,?,0) AS QtyOrdered", Double.class));
            if (this.isUnconfirmed()) {
                list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyUnconfirmed"), "(SELECT SUM(c.TargetQty) FROM M_InOutLineConfirm c INNER JOIN M_InOutLine il ON (c.M_InOutLine_ID=il.M_InOutLine_ID) INNER JOIN M_InOut i ON (il.M_InOut_ID=i.M_InOut_ID) WHERE c.Processed='N' AND i.M_Warehouse_ID=? AND il.M_Product_ID=p.M_Product_ID) AS QtyUnconfirmed", Double.class));
                list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyUnconfirmedMove"), "(SELECT SUM(c.TargetQty) FROM M_MovementLineConfirm c INNER JOIN M_MovementLine ml ON (c.M_MovementLine_ID=ml.M_MovementLine_ID) INNER JOIN M_Locator l ON (ml.M_LocatorTo_ID=l.M_Locator_ID) WHERE c.Processed='N' AND l.M_Warehouse_ID=? AND ml.M_Product_ID=p.M_Product_ID) AS QtyUnconfirmedMove", Double.class));
            }
        }
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "Vendor"), "bp.Name", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "IsInstanceAttribute"), "pa.IsInstanceAttribute", Boolean.class));
        s_Layout = new Info_Column[list.size()];
        list.toArray(s_Layout);
        INDEX_PATTRIBUTE = s_Layout.length - 1;
        return s_Layout;
    }

    @Override
    protected String getOrderClause() {
        String orderClause = "";
        if (!this.isValidVObject(this.fProductCategory_ID)) {
            orderClause = orderClause + ", pc.Name";
        }
        orderClause = orderClause + ", Value";
        if (this.isValidVObject(this.fWarehouse_ID)) {
            orderClause = orderClause + ", QtyAvailable DESC";
        }
        if (this.isValidVObject(this.fPriceList_ID)) {
            orderClause = orderClause + ", Margin DESC";
        }
        if (orderClause.startsWith(", ")) {
            orderClause = orderClause.substring(2);
        }
        return orderClause;
    }

    private boolean isUnconfirmed() {
        int no = DB.getSQLValue(null, "SELECT COUNT(*) FROM M_InOutLineConfirm WHERE AD_Client_ID=?", Env.getAD_Client_ID(Env.getCtx()));
        if (no > 0) {
            return true;
        }
        no = DB.getSQLValue(null, "SELECT COUNT(*) FROM M_MovementLineConfirm WHERE AD_Client_ID=?", Env.getAD_Client_ID(Env.getCtx()));
        return no > 0;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof CTabbedPane) {
            CTabbedPane tab = (CTabbedPane)e.getSource();
            if (tab.getSelectedIndex() == 5) {
                this.checkShowDetail.setEnabled(true);
            } else {
                this.checkShowDetail.setEnabled(false);
            }
            this.log.fine("Calling refresh(): " + e.toString());
            this.refresh();
        }
    }

    private void initAtpTab() {
        this.m_tableAtp = new MiniTable();
        this.m_tableAtp.setRowSelectionAllowed(true);
        this.m_tableAtp.setMultiSelection(false);
        this.m_tableAtp.addMouseListener(this);
        this.m_tableAtp.setShowTotals(false);
        ArrayList<Info_Column> list = new ArrayList<Info_Column>();
        list.add(new Info_Column(" ", "M_Product_ID", IDColumn.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "M_Warehouse_ID"), "Warehouse", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "M_Locator_ID"), "Locator", String.class));
        list.add(new Info_Column(Msg.getMsg(Env.getCtx(), "Date", true), "Date", Timestamp.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyAvailable"), "QtyAvailable", Double.class, true, true, null));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyOnHand"), "QtyOnHand", Double.class));
        list.add(new Info_Column(Msg.getMsg(Env.getCtx(), "ExpectedChange", true), "DeltaQty", Double.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "BP_Name", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyOrdered"), "QtyOrdered", Double.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyReserved"), "QtyReserved", Double.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"), "PASI", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "DocumentNo"), "DocumentNo", String.class));
        this.m_layoutATP = new Info_Column[list.size()];
        list.toArray(this.m_layoutATP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAtpTab() {
        boolean showDetail = this.checkShowDetail.isSelected();
        Vector data = new Vector();
        int M_Warehouse_ID = 0;
        if (this.warehouseTbl.getRowCount() > 0) {
            Object wh_data;
            int selectedRow = this.warehouseTbl.getSelectedRow();
            if (selectedRow < 0) {
                selectedRow = 0;
            }
            if ((wh_data = this.warehouseTbl.getValueAt(selectedRow, this.warehouseTbl.getKeyColumnIndex())) != null && wh_data instanceof IDColumn) {
                IDColumn dataColumn = (IDColumn)wh_data;
                M_Warehouse_ID = dataColumn.getRecord_ID();
            }
        } else {
            M_Warehouse_ID = this.m_M_Warehouse_ID;
        }
        if (M_Warehouse_ID == 0) {
            this.clearAtpTab();
            return;
        }
        String sql = !showDetail ? "(SELECT s.M_Product_ID, w.Name as warehouse, l.value as locator, 0 as ID, null as Date, sum(s.QtyOnHand) as AvailQty, null as DeltaQty, sum(s.QtyOrdered) as QtyOrdered, sum(s.QtyReserved) as QtyReserved, null as sumPASI, 0 as ASI, null as BP_Name, null as DocumentNo, 10 as SeqNo" : "(SELECT s.M_Product_ID, w.Name as warehouse, l.value as locator, s.M_AttributeSetInstance_ID as ID, now() as Date, s.QtyOnHand as AvailQty, null as DeltaQty, s.QtyOrdered as QtyOrdered, s.QtyReserved as QtyReserved, CASE WHEN s.PASI  = '' THEN '{' || COALESCE(s.M_AttributeSetInstance_ID,0) || '}' ELSE s.PASI END as sumPASI, COALESCE(M_AttributeSetInstance_ID,0) as ASI, null as BP_Name, null as DocumentNo,  10 as SeqNo";
        sql = sql + " FROM (SELECT M_Product_ID, M_Locator_ID, QtyOnHand, QtyReserved, QtyOrdered, COALESCE(productAttribute(M_AttributeSetInstance_ID)::varchar, '') as PASI, COALESCE(M_AttributeSetInstance_ID,0) as M_AttributeSetInstance_ID FROM M_Storage) s  INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) INNER JOIN M_Warehouse w ON (l.M_Warehouse_ID=w.M_Warehouse_ID) AND s.M_Product_ID=" + this.m_M_Product_ID;
        if (M_Warehouse_ID != 0) {
            sql = sql + " AND l.M_Warehouse_ID=" + M_Warehouse_ID;
        }
        if (!showDetail) {
            sql = sql + " GROUP BY s.M_Product_ID, w.Name, l.value, s.M_Locator_ID, sumPASI, ASI, BP_Name, DocumentNo, SeqNo ";
        }
        sql = sql + " UNION ALL ";
        sql = sql + "SELECT ol.M_Product_ID, w.Name as warehouse, null as locator, ol.M_AttributeSetInstance_ID as ID, o.DatePromised as date, null as AvailQty, CASE WHEN dt.DocBaseType = 'POO' THEN ol.QtyOrdered ELSE -ol.QtyReserved END as DeltaQty, CASE WHEN dt.DocBaseType = 'POO' THEN ol.QtyOrdered ELSE null END as QtyOrdered, CASE WHEN dt.DocBaseType = 'POO' THEN 0 ELSE 0 END as QtyReserved, productAttribute(ol.M_AttributeSetInstance_ID) as sumPASI, ol.M_AttributeSetInstance_ID as ASI, bp.Name as BP_Name, dt.PrintName || ' ' || o.DocumentNo As DocumentNo, 20 as SeqNo FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ol.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN C_BPartner bp  ON (o.C_BPartner_ID=bp.C_BPartner_ID) WHERE ol.QtyReserved<>0 AND o.DocStatus in ('IP','CO') AND ol.M_Product_ID=" + this.m_M_Product_ID;
        if (M_Warehouse_ID != 0) {
            sql = sql + " AND w.M_Warehouse_ID=" + M_Warehouse_ID;
        }
        sql = sql + " UNION ALL ";
        sql = sql + "SELECT ol.M_Product_ID, wf.Name as warehouse, lf.value as locator, ol.M_AttributeSetInstance_ID as ID, ol.DatePromised as date, null as AvailQty, -ol.QtyOrdered+ol.QtyInTransit+ol.QtyDelivered as DeltaQty, null as QtyOrdered, null  as QtyReserved, productAttribute(ol.M_AttributeSetInstance_ID) as sumPASI, ol.M_AttributeSetInstance_ID as ASI, bp.Name as BP_Name, dt.PrintName || ' ' || o.DocumentNo As DocumentNo, 20 as SeqNo FROM DD_Order o INNER JOIN DD_OrderLine ol ON (o.DD_Order_ID=ol.DD_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Locator l ON (l.M_Locator_ID = ol.M_LocatorTo_ID) INNER JOIN M_Locator lf on (lf.M_Locator_ID = ol.M_Locator_ID) INNER JOIN M_Warehouse w ON (l.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN M_Warehouse wf ON (lf.M_Warehouse_ID=wf.M_Warehouse_ID) INNER JOIN C_BPartner bp  ON (o.C_BPartner_ID = bp.C_BPartner_ID) WHERE ol.QtyReserved<>0 AND o.DocStatus in ('IP','CO') AND o.IsDelivered = 'N' AND ol.M_Product_ID=" + this.m_M_Product_ID;
        if (M_Warehouse_ID != 0) {
            sql = sql + " AND wf.M_Warehouse_ID=" + M_Warehouse_ID;
        }
        sql = sql + " UNION ALL ";
        sql = sql + "SELECT ol.M_Product_ID, w.Name as warehouse, l.value as locator, ol.M_AttributeSetInstance_ID as ID, ol.DatePromised as date, null as AvailQty, ol.QtyOrdered-ol.QtyDelivered as DeltaQty, null as QtyOrdered, null  as QtyReserved, productAttribute(ol.M_AttributeSetInstance_ID) as sumPASI, ol.M_AttributeSetInstance_ID as ASI, bp.Name as BP_Name, dt.PrintName || ' ' || o.DocumentNo As DocumentNo, 20 as SeqNo FROM DD_Order o INNER JOIN DD_OrderLine ol ON (o.DD_Order_ID=ol.DD_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Locator l ON (l.M_Locator_ID = ol.M_LocatorTo_ID) INNER JOIN M_Locator lf on (lf.M_Locator_ID = ol.M_Locator_ID) INNER JOIN M_Warehouse w ON (l.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN M_Warehouse wf ON (lf.M_Warehouse_ID=wf.M_Warehouse_ID) INNER JOIN C_BPartner bp  ON (wf.AD_Org_ID=bp.AD_OrgBP_ID) WHERE ol.QtyOrdered - ol.Qtydelivered > 0 AND o.DocStatus in ('IP','CO') AND o.IsDelivered='N' AND ol.M_Product_ID=" + this.m_M_Product_ID;
        if (M_Warehouse_ID != 0) {
            sql = sql + " AND w.M_Warehouse_ID=" + M_Warehouse_ID;
        }
        sql = sql + " ORDER BY M_Product_ID, SeqNo, ID, date, locator)";
        double qty = 0.0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            boolean index = true;
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(10);
                line.add(rs.getInt(1));
                line.add(rs.getString(2));
                line.add(rs.getString(3));
                line.add(rs.getTimestamp(5));
                double deltaQty = rs.getDouble(7);
                line.add(new Double(qty += rs.getDouble(6) + deltaQty) - rs.getDouble(9));
                line.add(new Double(rs.getDouble(6)));
                line.add(new Double(rs.getDouble(7)));
                line.add(rs.getString(12));
                line.add(new Double(rs.getDouble(8)));
                line.add(new Double(rs.getDouble(9)));
                line.add(rs.getString(10));
                line.add(rs.getString(13));
                data.add(line);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        Vector<String> columnNames = new Vector<String>();
        for (int i = 0; i < this.m_layoutATP.length; ++i) {
            columnNames.add(this.m_layoutATP[i].getColHeader());
        }
        this.m_modelAtp = new DefaultTableModel();
        this.m_modelAtp.setDataVector(data, columnNames);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoProduct.this.m_tableAtp.setModel(InfoProduct.this.m_modelAtp);
                for (int i = 0; i < InfoProduct.this.m_layoutATP.length; ++i) {
                    InfoProduct.this.m_tableAtp.setColumnClass(i, InfoProduct.this.m_layoutATP[i].getColClass(), InfoProduct.this.m_layoutATP[i].isReadOnly(), InfoProduct.this.m_layoutATP[i].getColHeader());
                    if (!InfoProduct.this.m_layoutATP[i].isColorColumn()) continue;
                    InfoProduct.this.m_tableAtp.setColorColumn(i);
                }
                InfoProduct.this.m_tableAtp.autoSize();
            }
        });
    }

    private void clearAtpTab() {
        this.m_modelAtp = new DefaultTableModel();
        this.m_tableAtp.setRowCount(0);
        this.m_tableAtp.setModel(this.m_modelAtp);
    }

    public int getM_AttributeSet_ID() {
        int M_AttributeSet_ID = 0;
        if (this.fAS_ID.getValue() != null) {
            M_AttributeSet_ID = (Integer)this.fAS_ID.getValue();
        }
        return M_AttributeSet_ID;
    }

    @Override
    protected boolean hasOutstandingChanges() {
        return this.fieldValue.hasChanged() || this.fieldName.hasChanged() || this.fieldUPC.hasChanged() || this.fieldSKU.hasChanged() || this.fPriceList_ID.hasChanged() || this.fWarehouse_ID.hasChanged() || this.fVendor_ID.hasChanged() || this.fProductCategory_ID.hasChanged() || this.fAS_ID.hasChanged() || this.fASI_ID.hasChanged() || this.checkOnlyStock.hasChanged() || this.checkAND.hasChanged();
    }

    @Override
    protected void setFieldOldValues() {
        this.fieldValue.set_oldValue();
        this.fieldName.set_oldValue();
        this.fieldUPC.set_oldValue();
        this.fieldSKU.set_oldValue();
        this.fPriceList_ID.set_oldValue();
        this.fWarehouse_ID.set_oldValue();
        this.fVendor_ID.set_oldValue();
        this.fProductCategory_ID.set_oldValue();
        this.fAS_ID.set_oldValue();
        this.fASI_ID.set_oldValue();
        this.checkOnlyStock.set_oldValue();
        this.checkAND.set_oldValue();
    }

    @Override
    protected void clearParameters() {
        this.fieldValue.setText("");
        this.fieldName.setText("");
        this.fieldUPC.setText("");
        this.fieldSKU.setText("");
        this.fWarehouse_ID.setValue(null);
        this.fPriceList_ID.setValue(null);
        this.fProductCategory_ID.setValue(null);
        this.fVendor_ID.setValue(null);
        this.fAS_ID.setValue(null);
        this.fASI_ID.setValue(null);
        this.checkOnlyStock.setValue(false);
        this.checkAND.setSelected(true);
    }
}

