/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class PAttributeInstance
extends CDialog
implements ListSelectionListener {
    private static final long serialVersionUID = -3743466565716139916L;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private JScrollPane centerScrollPane = new JScrollPane();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CCheckBox showAll = new CCheckBox(Msg.getMsg(Env.getCtx(), "ShowAll"));
    private MiniTable m_table = new MiniTable();
    private int m_M_Warehouse_ID;
    private int m_M_Locator_ID;
    private int m_M_Product_ID;
    private int m_M_AttributeSetInstance_ID = -1;
    private String m_M_AttributeSetInstanceName = null;
    private String m_sql;
    private boolean m_wasCancelled;
    private static CLogger log = CLogger.getCLogger(PAttributeInstance.class);
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Dimension screensize = this.toolkit.getScreenSize();
    protected final int SCREEN_WIDTH;
    protected final int SCREEN_HEIGHT;
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "asi.M_AttributeSetInstance_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Description"), "asi.Description", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Lot"), "asi.Lot", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "SerNo"), "asi.SerNo", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "GuaranteeDate"), "asi.GuaranteeDate", Timestamp.class), new ColumnInfo(Msg.translate(Env.getCtx(), "M_Locator_ID"), "l.Value", KeyNamePair.class, "s.M_Locator_ID"), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOnHand"), "s.QtyOnHand", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyReserved"), "s.QtyReserved", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOrdered"), "s.QtyOrdered", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "GoodForDays"), "(daysbetween(asi.GuaranteeDate, SYSDATE))-p.GuaranteeDaysMin", Integer.class, true, true, null), new ColumnInfo(Msg.translate(Env.getCtx(), "ShelfLifeDays"), "daysbetween(asi.GuaranteeDate, SYSDATE)", Integer.class), new ColumnInfo(Msg.translate(Env.getCtx(), "ShelfLifeRemainingPct"), "CASE WHEN p.GuaranteeDays > 0 THEN TRUNC(((daysbetween(asi.GuaranteeDate, SYSDATE))/p.GuaranteeDays)*100) ELSE 0 END", Integer.class)};
    private static String s_sqlFrom = "M_AttributeSetInstance asi INNER JOIN M_AttributeSet st ON (st.M_AttributeSet_ID=asi.M_AttributeSet_ID ) LEFT OUTER JOIN M_Storage s ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) LEFT OUTER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) LEFT OUTER JOIN M_Product p ON (s.M_Product_ID=p.M_Product_ID) ";
    private static String s_sqlWhereWithoutWarehouse = " p.M_Product_ID=?";
    private static String s_sqlWhereSameWarehouse = " AND (? in (0, l.M_Warehouse_ID))";
    private static String s_sqlNonZero = " AND (s.QtyOnHand<>0 OR s.QtyReserved<>0 OR s.QtyOrdered<>0)";
    private static String s_sqlMinLife = "";
    private Action doDispose;

    public PAttributeInstance(JFrame parent, String title, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        super(parent, Msg.getMsg(Env.getCtx(), "PAttributeInstance") + ": " + title, true);
        this.SCREEN_WIDTH = this.screensize.width > 1500 ? 1500 : this.screensize.width - 100;
        this.SCREEN_HEIGHT = this.screensize.height > 600 ? 250 : 105;
        this.doDispose = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PAttributeInstance.this.dispose();
            }
        };
        this.init(M_Warehouse_ID, M_Locator_ID, M_Product_ID, C_BPartner_ID);
        AEnv.showCenterWindow(parent, this);
    }

    public PAttributeInstance(JDialog parent, String title, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        super(parent, Msg.getMsg(Env.getCtx(), "PAttributeInstance") + ": " + title, true);
        this.SCREEN_WIDTH = this.screensize.width > 1500 ? 1500 : this.screensize.width - 100;
        this.SCREEN_HEIGHT = this.screensize.height > 600 ? 250 : 105;
        this.doDispose = new /* invalid duplicate definition of identical inner class */;
        this.init(M_Warehouse_ID, M_Locator_ID, M_Product_ID, C_BPartner_ID);
        AEnv.showCenterWindow(parent, this);
    }

    private void init(int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        log.info("M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID);
        this.m_M_Warehouse_ID = M_Warehouse_ID;
        this.m_M_Locator_ID = M_Locator_ID;
        this.m_M_Product_ID = M_Product_ID;
        try {
            this.jbInit();
            this.dynInit(C_BPartner_ID);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.northPanel.setLayout(new ALayout());
        this.northPanel.add((Component)this.showAll, new ALayoutConstraint(0, 0));
        this.showAll.addActionListener(this);
        this.getContentPane().add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.centerScrollPane, "Center");
        this.centerScrollPane.getViewport().add((Component)this.m_table, null);
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.mainPanel.setPreferredSize(new Dimension(this.SCREEN_WIDTH, this.SCREEN_HEIGHT));
        this.confirmPanel.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dynInit(int C_BPartner_ID) {
        log.config("C_BPartner_ID=" + C_BPartner_ID);
        if (C_BPartner_ID != 0) {
            int ShelfLifeMinPct = 0;
            int ShelfLifeMinDays = 0;
            String sql = "SELECT bp.ShelfLifeMinPct, bpp.ShelfLifeMinPct, bpp.ShelfLifeMinDays FROM C_BPartner bp  LEFT OUTER JOIN C_BPartner_Product bpp ON (bp.C_BPartner_ID=bpp.C_BPartner_ID AND bpp.M_Product_ID=?) WHERE bp.C_BPartner_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.m_M_Product_ID);
                pstmt.setInt(2, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    ShelfLifeMinPct = rs.getInt(1);
                    int pct = rs.getInt(2);
                    if (pct > 0) {
                        ShelfLifeMinDays = pct;
                    }
                    ShelfLifeMinDays = rs.getInt(3);
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (ShelfLifeMinPct > 0) {
                s_sqlMinLife = " AND COALESCE(TRUNC(((daysbetween(asi.GuaranteeDate, SYSDATE))/p.GuaranteeDays)*100),0)>=" + ShelfLifeMinPct;
                log.config("PAttributeInstance.dynInit - ShelfLifeMinPct=" + ShelfLifeMinPct);
            }
            if (ShelfLifeMinDays > 0) {
                s_sqlMinLife = s_sqlMinLife + " AND COALESCE((daysbetween(asi.GuaranteeDate, SYSDATE)),0)>=" + ShelfLifeMinDays;
                log.config("PAttributeInstance.dynInit - ShelfLifeMinDays=" + ShelfLifeMinDays);
            }
        }
        this.m_sql = this.m_table.prepareTable(s_layout, s_sqlFrom, s_sqlWhereWithoutWarehouse, false, "asi") + " ORDER BY asi.GuaranteeDate, s.QtyOnHand";
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setMultiSelection(false);
        this.m_table.addMouseListener(this);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.refresh();
        this.m_table.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "doDispose");
        this.m_table.getActionMap().put("doDispose", this.doDispose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        String sql = this.m_sql;
        int pos = this.m_sql.lastIndexOf(" ORDER BY ");
        if (!this.showAll.isSelected()) {
            sql = this.m_sql.substring(0, pos) + s_sqlWhereSameWarehouse + s_sqlNonZero;
            if (s_sqlMinLife.length() > 0) {
                sql = sql + s_sqlMinLife;
            }
            sql = sql + this.m_sql.substring(pos);
        }
        log.finest(sql);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_M_Product_ID);
            if (!this.showAll.isSelected()) {
                pstmt.setInt(2, this.m_M_Warehouse_ID);
            }
            rs = pstmt.executeQuery();
            this.m_table.loadTable(rs);
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.enableButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.dispose();
            this.m_wasCancelled = false;
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            this.m_M_AttributeSetInstance_ID = -1;
            this.m_M_AttributeSetInstanceName = null;
            this.m_wasCancelled = true;
        } else if (e.getSource() == this.showAll) {
            this.refresh();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Integer ID;
        this.m_M_AttributeSetInstance_ID = -1;
        this.m_M_AttributeSetInstanceName = null;
        this.m_M_Locator_ID = 0;
        int row = this.m_table.getSelectedRow();
        if (row > -1 && (ID = this.m_table.getSelectedRowKey()) != null) {
            this.m_M_AttributeSetInstance_ID = ID;
            this.m_M_AttributeSetInstanceName = (String)this.m_table.getValueAt(row, 1);
            Object oo = this.m_table.getValueAt(row, 5);
            if (oo instanceof KeyNamePair) {
                KeyNamePair pp = (KeyNamePair)oo;
                this.m_M_Locator_ID = pp.getKey();
            }
        }
        log.fine("M_AttributeSetInstance_ID=" + this.m_M_AttributeSetInstance_ID + " - " + this.m_M_AttributeSetInstanceName + "; M_Locator_ID=" + this.m_M_Locator_ID);
        this.enableButtons();
    }

    private void enableButtons() {
        int row = this.m_table.getSelectedRow();
        boolean enabled = row > -1;
        this.confirmPanel.getOKButton().setEnabled(enabled);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && this.m_table.getSelectedRow() > -1) {
            this.dispose();
        }
    }

    public int getM_AttributeSetInstance_ID() {
        return this.m_M_AttributeSetInstance_ID;
    }

    public String getM_AttributeSetInstanceName() {
        return this.m_M_AttributeSetInstanceName;
    }

    public int getM_Locator_ID() {
        return this.m_M_Locator_ID;
    }

    public boolean wasCancelled() {
        return this.m_wasCancelled;
    }
}

