/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.wf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import org.compiere.wf.MWFNodeNext;

public class WFLine
extends Component {
    private static final long serialVersionUID = 7599996355185021897L;
    private MWFNodeNext m_next = null;
    private Rectangle m_from = null;
    private Rectangle m_to = null;
    private String m_description = null;
    private boolean m_visited = false;

    public WFLine(MWFNodeNext next) {
        this.m_next = next;
        this.setFocusable(false);
        this.m_description = next.getDescription();
        if (this.m_description != null && this.m_description.length() > 0) {
            this.m_description = "{" + String.valueOf(next.getSeqNo()) + ": " + this.m_description + "}";
        }
    }

    public Rectangle getFrom() {
        return this.m_from;
    }

    public Rectangle getTo() {
        return this.m_to;
    }

    public void setFromTo(Rectangle from, Rectangle to) {
        this.m_from = from;
        this.m_to = to;
    }

    public int getAD_WF_Node_ID() {
        return this.m_next.getAD_WF_Node_ID();
    }

    public int getAD_WF_Next_ID() {
        return this.m_next.getAD_WF_Next_ID();
    }

    public void setVisited(boolean visited) {
        this.m_visited = visited;
    }

    private boolean isRightTop() {
        return this.m_from.x + this.m_from.width <= this.m_to.x && this.m_from.y + this.m_from.height <= this.m_to.y;
    }

    private boolean isBottomTop() {
        return this.m_from.y + this.m_from.height <= this.m_to.y;
    }

    private boolean isTopBottom() {
        return this.m_to.y + this.m_to.height <= this.m_from.y;
    }

    private boolean isLeftRight() {
        return this.m_to.x + this.m_to.width <= this.m_from.x;
    }

    @Override
    public void paint(Graphics g) {
        if (this.m_from == null || this.m_to == null) {
            return;
        }
        Polygon arrow = new Polygon();
        Point from = null;
        Point to = null;
        if (this.isRightTop()) {
            from = this.addPoint(arrow, this.m_from, 4, true);
            to = this.addPoint(arrow, this.m_to, 1, false);
        } else if (this.isBottomTop()) {
            from = this.addPoint(arrow, this.m_from, 3, true);
            to = this.addPoint(arrow, this.m_to, 1, false);
        } else if (this.isTopBottom()) {
            from = this.addPoint(arrow, this.m_from, 1, true);
            to = this.addPoint(arrow, this.m_to, 3, false);
        } else if (this.isLeftRight()) {
            from = this.addPoint(arrow, this.m_from, 2, true);
            to = this.addPoint(arrow, this.m_to, 4, false);
        } else {
            from = this.addPoint(arrow, this.m_from, 4, true);
            to = this.addPoint(arrow, this.m_to, 2, false);
        }
        if (!this.m_next.isUnconditional()) {
            g.setColor(Color.red);
            g.fillPolygon(arrow);
        }
        if (this.m_visited) {
            g.setColor(Color.green);
        } else {
            g.setColor(Color.black);
        }
        g.drawPolygon(arrow);
        if (this.m_next.isFromSplitAnd()) {
            g.setColor(Color.magenta);
            g.fillOval(from.x - 3, from.y - 3, 6, 6);
        }
        if (this.m_next.isToJoinAnd()) {
            g.setColor(Color.magenta);
            g.fillOval(to.x - 3, to.y - 3, 6, 6);
        }
        if (this.m_description != null) {
            Graphics2D g2D = (Graphics2D)g;
            Font font = new Font("Dialog", 0, 9);
            if (this.m_next.isUnconditional()) {
                g2D.setColor(Color.black);
            } else {
                g2D.setColor(Color.red);
            }
            TextLayout layout = new TextLayout(this.m_description, font, g2D.getFontRenderContext());
            int x = 0;
            x = from.x < to.x ? from.x + (to.x - from.x) / 2 : to.x + (from.x - to.x) / 2;
            int y = 0;
            y = from.y < to.y ? from.y + (to.y - from.y) / 2 : to.y + (from.y - to.y) / 2;
            y = (int)((float)y - (layout.getAscent() - 3.0f));
            x = (int)((float)x - layout.getAdvance() / 2.0f);
            if (x < 2) {
                x = 2;
            }
            layout.draw(g2D, x, y);
        }
    }

    private Point addPoint(Polygon arrow, Rectangle rect, int pos, boolean from) {
        int x = rect.x;
        int y = rect.y;
        Point point = null;
        if (pos == 1) {
            x += rect.width / 2;
            if (from) {
                arrow.addPoint(x - 2, y);
                arrow.addPoint(x + 2, y);
            } else {
                arrow.addPoint(x, y);
            }
            point = new Point(x, y - 2);
        } else if (pos == 4) {
            x += rect.width;
            y += rect.height / 2;
            if (from) {
                arrow.addPoint(x, y - 2);
                arrow.addPoint(x, y + 2);
            } else {
                arrow.addPoint(x, y);
            }
            point = new Point(x + 2, y);
        } else if (pos == 2) {
            y += rect.height / 2;
            if (from) {
                arrow.addPoint(x, y - 2);
                arrow.addPoint(x, y + 2);
            } else {
                arrow.addPoint(x, y);
            }
            point = new Point(x - 2, y);
        } else {
            x += rect.width / 2;
            y += rect.height;
            if (from) {
                arrow.addPoint(x - 2, y);
                arrow.addPoint(x + 2, y);
            } else {
                arrow.addPoint(x, y);
            }
            point = new Point(x, y + 2);
        }
        return point;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("WFLine[");
        sb.append(this.getAD_WF_Node_ID()).append("->").append(this.getAD_WF_Next_ID());
        sb.append("]");
        return sb.toString();
    }
}

