/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import org.adempiere.controller.PaymentFormController;
import org.adempiere.controller.ed.CPaymentEditor;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VButton;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.GridTab;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class VPayment
extends CDialog
implements ActionListener,
CPaymentEditor {
    private static final long serialVersionUID = -7931457502030396154L;
    private int windowNo;
    PaymentFormController controller;
    private boolean m_initOK = false;
    private boolean m_needSave = false;
    private static CLogger log = CLogger.getCLogger(VPayment.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private CPanel centerPanel = new CPanel();
    private FlowLayout northLayout = new FlowLayout();
    private CComboBox paymentCombo = new CComboBox();
    private CLabel paymentLabel = new CLabel();
    private CardLayout centerLayout = new CardLayout();
    private CPanel bPanel = new CPanel();
    private GridBagLayout bPanelLayout = new GridBagLayout();
    private VDate bDateField = new VDate("DateAcct", false, false, true, 15, "DateAcct");
    private CLabel bCurrencyLabel = new CLabel();
    private CComboBox bCurrencyCombo = new CComboBox();
    private CLabel bAmountLabel = new CLabel();
    private VNumber bAmountField = new VNumber();
    private CPanel kPanel = new CPanel();
    private GridBagLayout kLayout = new GridBagLayout();
    private CLabel kTypeLabel = new CLabel();
    private CComboBox kTypeCombo = new CComboBox();
    private CLabel kNumberLabel = new CLabel();
    private CTextField kNumberField = new CTextField();
    private CLabel kNameLabel = new CLabel();
    private CTextField kNameField = new CTextField();
    private CLabel kExpLabel = new CLabel();
    private CTextField kExpField = new CTextField();
    private CLabel kApprovalLabel = new CLabel();
    private CTextField kApprovalField = new CTextField();
    private CLabel kAmountLabel = new CLabel();
    private VNumber kAmountField = new VNumber();
    private CPanel tPanel = new CPanel();
    private CLabel tAccountLabel = new CLabel();
    private CComboBox tAccountCombo = new CComboBox();
    private CLabel tAmountLabel = new CLabel();
    private VNumber tAmountField = new VNumber();
    private CPanel sPanel = new CPanel();
    private GridBagLayout sPanelLayout = new GridBagLayout();
    private CLabel sAccountNumberLabel = new CLabel();
    private CTextField sAccountNumberField = new CTextField();
    private CLabel sRoutingLabel = new CLabel();
    private CTextField sRoutingField = new CTextField();
    private CLabel sCurrencyLabel = new CLabel();
    private CComboBox sCurrencyCombo = new CComboBox();
    private CPanel pPanel = new CPanel();
    private CLabel pTermLabel = new CLabel();
    private CComboBox pTermCombo = new CComboBox();
    private CLabel sAmountLabel = new CLabel();
    private VNumber sAmountField = new VNumber();
    private CLabel bDateLabel = new CLabel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CTextField sCheckNumberField = new CTextField();
    private CLabel sCheckNumberLabel = new CLabel();
    private CButton kOnline = new CButton();
    private CButton sOnline = new CButton();
    private CComboBox sBankAccountCombo = new CComboBox();
    private CLabel sBankAccountLabel = new CLabel();
    private GridBagLayout pPanelLayout = new GridBagLayout();
    private CLabel bCashBookLabel = new CLabel();
    private CComboBox bCashBookCombo = new CComboBox();
    private GridBagLayout tPanelLayout = new GridBagLayout();
    private CButton tOnline = new CButton();
    private CLabel kStatus = new CLabel();
    private CLabel tStatus = new CLabel();
    private CLabel sStatus = new CLabel();

    public VPayment(int WindowNo, GridTab mTab, VButton button) {
        super(Env.getWindow(WindowNo), Msg.getMsg(Env.getCtx(), "Payment"), true);
        this.windowNo = WindowNo;
        this.controller = new PaymentFormController(this, WindowNo, mTab, button.getValues());
        try {
            this.jbInit();
            this.m_initOK = this.dynInit(button);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "VPayment", ex);
            this.m_initOK = false;
        }
        AEnv.positionCenterWindow(Env.getWindow(WindowNo), this);
    }

    private void jbInit() throws Exception {
        this.centerPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.setLayout(this.mainLayout);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.northPanel.setLayout(this.northLayout);
        this.paymentLabel.setText(Msg.translate(Env.getCtx(), "PaymentRule"));
        this.mainPanel.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.paymentLabel, null);
        this.northPanel.add((Component)this.paymentCombo, null);
        this.centerPanel.setLayout(this.centerLayout);
        this.kPanel.setLayout(this.kLayout);
        this.kNumberField.setPreferredSize(new Dimension(160, 21));
        this.kNameField.setPreferredSize(new Dimension(160, 21));
        this.kExpField.setPreferredSize(new Dimension(40, 21));
        this.kApprovalField.setPreferredSize(new Dimension(120, 21));
        this.kTypeLabel.setText(Msg.translate(Env.getCtx(), "CreditCardType"));
        this.kNumberLabel.setText(Msg.translate(Env.getCtx(), "CreditCardNumber"));
        this.kNameLabel.setText(Msg.translate(Env.getCtx(), "Name"));
        this.kExpLabel.setText(Msg.getMsg(Env.getCtx(), "Expires"));
        this.kApprovalLabel.setText(Msg.translate(Env.getCtx(), "VoiceAuthCode"));
        this.kAmountLabel.setText(Msg.getMsg(Env.getCtx(), "Amount"));
        this.kAmountField.setDisplayType(12);
        this.kOnline.setText(Msg.getMsg(Env.getCtx(), "Online"));
        this.kOnline.addActionListener(this);
        this.kStatus.setText(" ");
        this.centerPanel.add((Component)this.kPanel, "kPanel");
        this.centerLayout.addLayoutComponent(this.kPanel, "kPanel");
        this.kPanel.add((Component)this.kTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.kPanel.add((Component)this.kTypeCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.kPanel.add((Component)this.kNumberLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.kPanel.add((Component)this.kNumberField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(2, 5, 2, 5), 0, 0));
        this.kPanel.add((Component)this.kNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.kPanel.add((Component)this.kNameField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(2, 5, 2, 5), 0, 0));
        this.kPanel.add((Component)this.kExpLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.kPanel.add((Component)this.kExpField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.kPanel.add((Component)this.kAmountLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 5, 0), 0, 0));
        this.kPanel.add((Component)this.kAmountField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 5, 5), 0, 0));
        this.kPanel.add((Component)this.kApprovalLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.kPanel.add((Component)this.kApprovalField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.kPanel.add((Component)this.kStatus, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.kPanel.add((Component)this.kOnline, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.tPanel.setLayout(this.tPanelLayout);
        this.tAccountLabel.setText(Msg.translate(Env.getCtx(), "C_BP_BankAccount_ID"));
        this.tAmountLabel.setText(Msg.translate(Env.getCtx(), "Amount"));
        this.tAmountField.setDisplayType(12);
        this.tOnline.setText(Msg.getMsg(Env.getCtx(), "Online"));
        this.tOnline.addActionListener(this);
        this.tStatus.setText(" ");
        this.centerPanel.add((Component)this.tPanel, "tPanel");
        this.centerLayout.addLayoutComponent(this.tPanel, "tPanel");
        this.tPanel.add((Component)this.tAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.tPanel.add((Component)this.tAccountCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.tPanel.add((Component)this.tAmountLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.tPanel.add((Component)this.tAmountField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.tPanel.add((Component)this.tStatus, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.tPanel.add((Component)this.tOnline, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.sPanel.setLayout(this.sPanelLayout);
        this.sBankAccountLabel.setText(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
        this.sAmountLabel.setText(Msg.getMsg(Env.getCtx(), "Amount"));
        this.sAmountField.setDisplayType(12);
        this.sRoutingLabel.setText(Msg.translate(Env.getCtx(), "RoutingNo"));
        this.sAccountNumberLabel.setText(Msg.translate(Env.getCtx(), "AccountNo"));
        this.sCheckNumberLabel.setText(Msg.translate(Env.getCtx(), "CheckNo"));
        this.sCheckNumberField.setColumns(8);
        this.sCurrencyLabel.setText(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        this.sAccountNumberField.setPreferredSize(new Dimension(100, 21));
        this.sRoutingField.setPreferredSize(new Dimension(70, 21));
        this.sStatus.setText(" ");
        this.sOnline.setText(Msg.getMsg(Env.getCtx(), "Online"));
        this.sOnline.addActionListener(this);
        this.centerPanel.add((Component)this.sPanel, "sPanel");
        this.centerLayout.addLayoutComponent(this.sPanel, "sPanel");
        this.sPanel.add((Component)this.sBankAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sBankAccountCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.sPanel.add((Component)this.sCurrencyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sCurrencyCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.sPanel.add((Component)this.sAmountLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 5, 0), 0, 0));
        this.sPanel.add((Component)this.sAmountField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 5, 5), 0, 0));
        this.sPanel.add((Component)this.sRoutingLabel, new GridBagConstraints(0, 3, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sRoutingField, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sAccountNumberLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sAccountNumberField, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sCheckNumberLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sCheckNumberField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 0), 0, 0));
        this.sPanel.add((Component)this.sOnline, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.sPanel.add((Component)this.sStatus, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pPanel.setLayout(this.pPanelLayout);
        this.pTermLabel.setText(Msg.translate(Env.getCtx(), "C_PaymentTerm_ID"));
        this.centerPanel.add((Component)this.pPanel, "pPanel");
        this.centerLayout.addLayoutComponent(this.pPanel, "pPanel");
        this.pPanel.add((Component)this.pTermLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 0), 0, 0));
        this.pPanel.add((Component)this.pTermCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.bCurrencyLabel.setText(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        this.bPanel.setLayout(this.bPanelLayout);
        this.bAmountLabel.setText(Msg.getMsg(Env.getCtx(), "Amount"));
        this.bAmountField.setDisplayType(12);
        this.bDateLabel.setText(Msg.translate(Env.getCtx(), "DateAcct"));
        this.centerLayout.addLayoutComponent(this.bPanel, "bPanel");
        this.centerPanel.add((Component)this.bPanel, "bPanel");
        this.bCashBookLabel.setText(Msg.translate(Env.getCtx(), "PaymentFormController: CashJournal"));
        this.bCashBookCombo.setToolTipText(Msg.translate(Env.getCtx(), "PaymentFormController: CashJournalTip"));
        this.bPanel.add((Component)this.bCashBookLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.bPanel.add((Component)this.bCashBookCombo, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.bPanel.add((Component)this.bCurrencyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.bPanel.add((Component)this.bCurrencyCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.bPanel.add((Component)this.bDateLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 2, 0), 0, 0));
        this.bPanel.add((Component)this.bDateField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.bPanel.add((Component)this.bAmountLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 2, 0), 0, 0));
        this.bPanel.add((Component)this.bAmountField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
    }

    private boolean dynInit(VButton button) throws Exception {
        if (!this.controller.init() && !this.controller.getErrorMsg().isEmpty()) {
            ADialog.error(0, this, this.controller.getErrorMsg());
            return false;
        }
        this.centerPanel.setVisible(!this.controller.isOnlyChangePaymentRule());
        BigDecimal amount = this.controller.getPaymentAmount();
        this.bAmountField.setValue(amount);
        this.sAmountField.setValue(amount);
        this.kAmountField.setValue(amount);
        this.tAmountField.setValue(amount);
        this.bDateField.setValue(this.controller.getDate());
        if (this.controller.isEMUCurrency()) {
            Enumeration<Integer> en = this.controller.getCurrencies().keys();
            while (en.hasMoreElements()) {
                Integer key = en.nextElement();
                this.bCurrencyCombo.addItem(this.controller.getCurrencies().get(key));
                this.sCurrencyCombo.addItem(this.controller.getCurrencies().get(key));
            }
            this.sCurrencyCombo.addActionListener(this);
            this.sCurrencyCombo.setSelectedItem(this.controller.getCurrentCurrency());
            this.bCurrencyCombo.addActionListener(this);
            this.bCurrencyCombo.setSelectedItem(this.controller.getCurrentCurrency());
        } else {
            this.bCurrencyLabel.setVisible(false);
            this.bCurrencyCombo.setVisible(false);
            this.sCurrencyLabel.setVisible(false);
            this.sCurrencyCombo.setVisible(false);
        }
        for (ValueNamePair paymentRule : this.controller.getPaymentRules()) {
            this.paymentCombo.addItem(paymentRule);
        }
        for (KeyNamePair paymentTerm : this.controller.getPaymentTerms()) {
            this.pTermCombo.addItem(paymentTerm);
        }
        if (this.controller.getSelectedPaymentTerm() != null) {
            this.pTermCombo.setSelectedItem(this.controller.getSelectedPaymentTerm());
        }
        for (KeyNamePair account : this.controller.getBPAccounts()) {
            this.tAccountCombo.addItem(account);
        }
        for (ValueNamePair card : this.controller.getCreditCards()) {
            this.kTypeCombo.addItem(card);
        }
        if (this.controller.getSelecteCreditCard() != null) {
            this.kTypeCombo.setSelectedItem(this.controller.getSelecteCreditCard());
        }
        for (KeyNamePair account : this.controller.getBankAccounts()) {
            this.sBankAccountCombo.addItem(account);
        }
        if (this.controller.getSelectedBankAccount() != null) {
            this.sBankAccountCombo.setSelectedItem(this.controller.getSelectedBankAccount());
        }
        for (KeyNamePair cashBook : this.controller.getCashBooks()) {
            this.bCashBookCombo.addItem(cashBook);
        }
        if (this.controller.getSelectedCashBook() != null) {
            this.bCashBookCombo.setSelectedItem(this.controller.getSelectedCashBook());
        }
        this.paymentCombo.addActionListener(this);
        if (this.controller.getSelectedPaymentRule() != null) {
            this.paymentCombo.setSelectedItem(this.controller.getSelectedPaymentRule());
        }
        return true;
    }

    public boolean isInitOK() {
        return this.m_initOK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.fine("VPayment.actionPerformed - " + e.getActionCommand());
        if (e.getActionCommand().equals("Ok")) {
            if ((this.controller.isOnlyChangePaymentRule() || ADialog.ask(this.windowNo, this, "PaymentFormController: PaymentCreateConfirmation")) && this.saveChanges()) {
                this.dispose();
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getSource() == this.paymentCombo) {
            this.onPaymentComboSelection();
        } else if (e.getSource() == this.sCurrencyCombo) {
            KeyNamePair pp = (KeyNamePair)this.sCurrencyCombo.getSelectedItem();
            this.sAmountField.setValue(this.controller.getConvertedAmount(pp.getKey()));
        } else if (e.getSource() == this.bCurrencyCombo) {
            KeyNamePair pp = (KeyNamePair)this.bCurrencyCombo.getSelectedItem();
            this.bAmountField.setValue(this.controller.getConvertedAmount(pp.getKey()));
        } else if (e.getSource() == this.kOnline || e.getSource() == this.sOnline || e.getSource() == this.tOnline) {
            this.processOnline();
            if (this.controller.getErrorMsg().isEmpty()) {
                this.dispose();
            }
        }
    }

    private void onPaymentComboSelection() {
        ValueNamePair pp = (ValueNamePair)this.paymentCombo.getSelectedItem();
        if (pp != null) {
            this.bAmountField.setValue(this.controller.getPaymentAmount());
            this.sAmountField.setValue(this.controller.getPaymentAmount());
            this.kAmountField.setValue(this.controller.getPaymentAmount());
            this.centerLayout.show(this.centerPanel, this.controller.whichPanel(pp));
            this.controller.checkMandatory();
        }
    }

    private boolean saveChanges() {
        if (!this.controller.saveChanges()) {
            ADialog.error(this.windowNo, this, "PaymentError", this.controller.getErrorMsg());
            return false;
        }
        if (this.controller.getErrorMsg() != null && !this.controller.getErrorMsg().isEmpty()) {
            ADialog.error(this.windowNo, this, "PaymentError", this.controller.getErrorMsg());
        }
        if (this.controller.getPaymentDocNumber() != null && !this.controller.getPaymentDocNumber().isEmpty()) {
            ADialog.info(this.windowNo, this, "PaymentCreated", this.controller.getPaymentDocNumber());
        }
        return true;
    }

    private void processOnline() {
        log.config("");
        if (!this.controller.processOnline()) {
            ADialog.error(this.windowNo, this, "PaymentError", this.controller.getErrorMsg());
        } else {
            String info = this.controller.getOnlineInfo();
            ADialog.info(this.windowNo, this, "PaymentProcessed", info + "\n" + this.controller.getPaymentDocNumber());
            this.dispose();
        }
    }

    public boolean needSave() {
        return this.m_needSave;
    }

    @Override
    public String getPaymentRule() {
        return ((ValueNamePair)this.paymentCombo.getSelectedItem()).getValue();
    }

    @Override
    public int getBankAccount(String paymentRule) {
        KeyNamePair kp = null;
        if (paymentRule.equalsIgnoreCase("S")) {
            kp = (KeyNamePair)this.sBankAccountCombo.getSelectedItem();
        }
        if (kp != null) {
            return kp.getKey();
        }
        return 0;
    }

    @Override
    public int getCashBook(String paymentRule) {
        KeyNamePair kp = null;
        if (paymentRule.equalsIgnoreCase("B")) {
            kp = (KeyNamePair)this.bCashBookCombo.getSelectedItem();
        }
        if (kp != null) {
            return kp.getKey();
        }
        return 0;
    }

    @Override
    public Timestamp getDateAcct(String paymentRule) {
        if (paymentRule.equalsIgnoreCase("B")) {
            return (Timestamp)this.bDateField.getValue();
        }
        return null;
    }

    @Override
    public BigDecimal getPaymentAmount(String paymentRule) {
        BigDecimal amount = null;
        if (paymentRule.equalsIgnoreCase("B")) {
            amount = (BigDecimal)this.bAmountField.getValue();
        } else if (paymentRule.equalsIgnoreCase("S")) {
            amount = (BigDecimal)this.sAmountField.getValue();
        } else if (paymentRule.equalsIgnoreCase("K")) {
            amount = (BigDecimal)this.kAmountField.getValue();
        } else if (paymentRule.equalsIgnoreCase("T") || paymentRule.equalsIgnoreCase("D")) {
            return (BigDecimal)this.tAmountField.getValue();
        }
        if (amount != null) {
            return amount;
        }
        return Env.ZERO;
    }

    @Override
    public String getCreditCardType(String paymentRule) {
        ValueNamePair vp = null;
        if (paymentRule.equalsIgnoreCase("K")) {
            vp = (ValueNamePair)this.kTypeCombo.getSelectedItem();
        }
        if (vp != null) {
            return vp.getValue();
        }
        return "";
    }

    @Override
    public int getBPBankAccount(String paymentRule) {
        KeyNamePair kp = null;
        if (paymentRule.equalsIgnoreCase("T") || paymentRule.equalsIgnoreCase("D")) {
            kp = (KeyNamePair)this.tAccountCombo.getSelectedItem();
        }
        if (kp != null) {
            return kp.getKey();
        }
        return 0;
    }

    @Override
    public int getPaymentTerm(String paymentRule) {
        KeyNamePair kp = null;
        if (paymentRule.equalsIgnoreCase("P")) {
            kp = (KeyNamePair)this.pTermCombo.getSelectedItem();
        }
        if (kp != null) {
            return kp.getKey();
        }
        return 0;
    }

    @Override
    public String getCreditCardNumber(String paymentRule) {
        if (paymentRule.equalsIgnoreCase("K")) {
            return this.kNumberField.getText();
        }
        return "";
    }

    @Override
    public String getCreditCardExpiry(String paymentRule) {
        if (paymentRule.equalsIgnoreCase("K")) {
            return this.kExpField.getText();
        }
        return "";
    }

    @Override
    public String getCreditCardName(String paymentRule) {
        if (paymentRule.equalsIgnoreCase("K")) {
            return this.kNameField.getText();
        }
        return "";
    }

    @Override
    public String getCheckAccountNumber(String paymentRule) {
        if (paymentRule.equalsIgnoreCase("S")) {
            return this.sAccountNumberField.getText();
        }
        return "";
    }

    @Override
    public String getCheckRoutingNumber(String paymentRule) {
        if (paymentRule.equalsIgnoreCase("S")) {
            return this.sRoutingField.getText();
        }
        return "";
    }

    @Override
    public String getCheckNumber(String paymentRule) {
        if (paymentRule.equalsIgnoreCase("S")) {
            return this.sCheckNumberField.getText();
        }
        return "";
    }

    @Override
    public void setMandatory(String field, boolean mandatory) {
        if (field.equals("paymentCombo")) {
            this.paymentCombo.setMandatory(mandatory);
        }
        if (field.equals("kTypeCombo")) {
            this.kTypeCombo.setMandatory(mandatory);
        }
        if (field.equals("kNumberField")) {
            this.kNumberField.setMandatory(mandatory);
        }
        if (field.equals("kNameField")) {
            this.kNameField.setMandatory(mandatory);
        }
        if (field.equals("kExpField")) {
            this.kExpField.setMandatory(mandatory);
        }
        if (field.equals("kApprovalField")) {
            this.kApprovalField.setMandatory(mandatory);
        }
        if (field.equals("kAmountField")) {
            this.kAmountField.setMandatory(mandatory);
        }
        if (field.equals("tAccountCombo")) {
            this.tAccountCombo.setMandatory(mandatory);
        }
        if (field.equals("sCheckNumberField")) {
            this.sCheckNumberField.setMandatory(mandatory);
        }
        if (field.equals("sAccountNumberField")) {
            this.sAccountNumberField.setMandatory(mandatory);
        }
        if (field.equals("sRoutingField")) {
            this.sRoutingField.setMandatory(mandatory);
        }
        if (field.equals("sCurrencyCombo")) {
            this.sCurrencyCombo.setMandatory(mandatory);
        }
        if (field.equals("bCurrencyCombo")) {
            this.bCurrencyCombo.setMandatory(mandatory);
        }
        if (field.equals("pTermCombo")) {
            this.pTermCombo.setMandatory(mandatory);
        }
        if (field.equals("bAmountField")) {
            this.bAmountField.setMandatory(mandatory);
        }
        if (field.equals("sAmountField")) {
            this.sAmountField.setMandatory(mandatory);
        }
        if (field.equals("bDateField")) {
            this.bDateField.setMandatory(mandatory);
        }
        if (field.equals("sCheckField")) {
            this.sCheckNumberField.setMandatory(mandatory);
        }
        if (field.equals("sBankAccountCombo")) {
            this.sBankAccountCombo.setMandatory(mandatory);
        }
        if (field.equals("bCashBookCombo")) {
            this.bCashBookCombo.setMandatory(mandatory);
        }
    }

    @Override
    public void setError(String field, boolean error) {
        if (field.equals("paymentCombo")) {
            this.paymentCombo.setBackground(error);
        }
        if (field.equals("kTypeCombo")) {
            this.kTypeCombo.setBackground(error);
        }
        if (field.equals("kNumberField")) {
            this.kNumberField.setBackground(error);
        }
        if (field.equals("kNameField")) {
            this.kNameField.setBackground(error);
        }
        if (field.equals("kExpField")) {
            this.kExpField.setBackground(error);
        }
        if (field.equals("kApprovalField")) {
            this.kApprovalField.setBackground(error);
        }
        if (field.equals("kAmountField")) {
            this.kAmountField.setBackground(error);
        }
        if (field.equals("tAccountCombo")) {
            this.tAccountCombo.setBackground(error);
        }
        if (field.equals("sCheckNumberField")) {
            this.sCheckNumberField.setBackground(error);
        }
        if (field.equals("sAccountNumberField")) {
            this.sAccountNumberField.setBackground(error);
        }
        if (field.equals("sRoutingField")) {
            this.sRoutingField.setBackground(error);
        }
        if (field.equals("sCurrencyCombo")) {
            this.sCurrencyCombo.setBackground(error);
        }
        if (field.equals("bCurrencyCombo")) {
            this.bCurrencyCombo.setBackground(error);
        }
        if (field.equals("pTermCombo")) {
            this.pTermCombo.setBackground(error);
        }
        if (field.equals("bAmountField")) {
            this.bAmountField.setBackground(error);
        }
        if (field.equals("sAmountField")) {
            this.sAmountField.setBackground(error);
        }
        if (field.equals("bDateField")) {
            this.bDateField.setBackground(error);
        }
        if (field.equals("sCheckField")) {
            this.sCheckNumberField.setBackground(error);
        }
        if (field.equals("sBankAccountCombo")) {
            this.sBankAccountCombo.setBackground(error);
        }
        if (field.equals("bCashBookCombo")) {
            this.bCashBookCombo.setBackground(error);
        }
    }
}

