/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import org.compiere.apps.ADialog;
import org.compiere.apps.APanel;
import org.compiere.grid.GridController;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.GridTab;
import org.compiere.swing.CTabbedPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Evaluator;
import org.compiere.util.Language;

public class VTabbedPane
extends CTabbedPane {
    private static final long serialVersionUID = 716455372513747084L;
    private static CLogger log = CLogger.getCLogger(VTabbedPane.class);
    private boolean m_workbenchTab = false;
    private ArrayList<String> m_dependents = new ArrayList();
    private static Icon s_disabledIcon = null;
    private ArrayList<Component> components = new ArrayList();
    private ArrayList<GridTab> gTabs = new ArrayList();
    private ArrayList<String> tabNames = new ArrayList();

    public VTabbedPane(boolean isWorkbench) {
        this.setTabLayoutPolicy(1);
        this.setWorkbench(isWorkbench);
        this.setFocusable(false);
    }

    @Override
    public String toString() {
        return (this.m_workbenchTab ? "WorkbenchTab" : "WindowTab") + " - selected " + this.getSelectedIndex() + " of " + this.getTabCount();
    }

    public void addTab(String tabName, GridTab gTab, Component tabElement) {
        int index = this.getTabCount();
        this.tabNames.add(tabName);
        this.gTabs.add(gTab);
        this.components.add(tabElement);
        try {
            log.fine(tabName + " GridTab.Icon:" + gTab.getIcon() + " tabElement:" + tabElement + " GridTab.Description:" + gTab.getDescription());
            super.addTab(tabName, gTab.getIcon(), tabElement, gTab.getDescription());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.config(e.toString() + " catched. addTab(" + tabName + ")! Do not rethrow to the ui.");
        }
        ArrayList<String> dependents = gTab.getDependentOn();
        for (int i = 0; i < dependents.size(); ++i) {
            String name = dependents.get(i);
            if (this.m_dependents.contains(name)) continue;
            this.m_dependents.add(name);
        }
        if (s_disabledIcon == null) {
            s_disabledIcon = Env.getImageIcon("Cancel10.gif");
        }
        try {
            this.setDisabledIconAt(index, s_disabledIcon);
        }
        catch (Exception e) {
            log.config(e.toString() + " catched. setDisabledIconAt! Do not rethrow to the ui.");
        }
    }

    private void hideTab(String tabName) {
        int tabIndex = this.indexOfTab(tabName);
        if (tabIndex != -1) {
            this.removeTabAt(tabIndex);
        }
    }

    private void showTab(String tabName) {
        int insertAt = 0;
        if (this.indexOfTab(tabName) != -1) {
            return;
        }
        for (int i = 0; i < this.tabNames.size(); ++i) {
            String name = this.tabNames.get(i);
            if (name.equals(tabName)) {
                this.insertTab(tabName, this.gTabs.get(i).getIcon(), this.components.get(i), this.gTabs.get(i).getDescription(), insertAt);
                break;
            }
            if (this.indexOfTab(name) == -1) continue;
            ++insertAt;
        }
    }

    public int findTabindex(GridTab gridTab) {
        for (int i = 0; i < this.gTabs.size(); ++i) {
            if (this.gTabs.get(i) != gridTab) continue;
            return this.indexOfTab(this.tabNames.get(i));
        }
        return -1;
    }

    public void setWorkbench(boolean isWorkbench) {
        this.m_workbenchTab = isWorkbench;
        if (this.m_workbenchTab) {
            super.setTabPlacement(3);
        } else {
            super.setTabPlacement(Language.getLoginLanguage().isLeftToRight() ? 2 : 4);
        }
    }

    public boolean isWorkbench() {
        return this.m_workbenchTab;
    }

    @Override
    public void setTabPlacement(int notUsed) {
        new IllegalAccessError("Do not use VTabbedPane.setTabPlacement directly");
    }

    public void dispose(APanel aPanel) {
        Component[] comp = this.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (comp[i] instanceof VTabbedPane) {
                VTabbedPane tp = (VTabbedPane)comp[i];
                tp.removeChangeListener(aPanel);
                tp.dispose(aPanel);
                continue;
            }
            if (!(comp[i] instanceof GridController)) continue;
            GridController gc = (GridController)comp[i];
            gc.removeDataStatusListener(aPanel);
            gc.dispose();
        }
        this.removeAll();
    }

    @Override
    public boolean isEnabledAt(int index) {
        boolean enabled = super.isEnabledAt(index);
        if (!enabled) {
            return enabled;
        }
        Component comp = this.getComponentAt(index);
        GridController gc = null;
        if (comp instanceof GridController) {
            gc = (GridController)comp;
        }
        if (gc != null) {
            enabled = this.isDisplay(gc);
        }
        return enabled;
    }

    private boolean isDisplay(GridController gc) {
        boolean display;
        String logic = gc.getDisplayLogic();
        if (logic != null && logic.length() > 0 && !(display = Evaluator.evaluateLogic(gc, logic))) {
            log.info("Not displayed - " + logic);
            return false;
        }
        return true;
    }

    @Override
    public void setSelectedIndex(int index) {
        Component oldC;
        Component newC = this.getComponentAt(index);
        GridController newGC = null;
        if (newC instanceof GridController) {
            newGC = (GridController)newC;
        }
        if (newGC != null && !this.isDisplay(newGC)) {
            return;
        }
        int oldIndex = this.getSelectedIndex();
        if (newGC != null && oldIndex >= 0 && index != oldIndex && (oldC = this.getComponentAt(oldIndex)) != null && oldC instanceof GridController) {
            GridController oldGC = (GridController)oldC;
            if (newGC.getTabLevel() > oldGC.getTabLevel() + 1) {
                GridController rightGC = null;
                boolean canJump = true;
                int currentLevel = newGC.getTabLevel();
                for (int i = index - 1; i >= 0; --i) {
                    GridController gc;
                    Component rightC = this.getComponentAt(i);
                    if (!(rightC instanceof GridController) || (gc = (GridController)rightC).getTabLevel() >= currentLevel) continue;
                    if (gc.getTabLevel() == oldGC.getTabLevel() + 1) {
                        rightGC = gc;
                    }
                    if (!gc.isCurrent()) {
                        canJump = false;
                    }
                    currentLevel = gc.getTabLevel();
                }
                if (!canJump) {
                    if (rightGC != null) {
                        ADialog.warn(0, this, "TabSwitchJumpGo", rightGC.getTitle());
                    } else {
                        ADialog.warn(0, this, "TabSwitchJump");
                    }
                    return;
                }
            }
            oldGC.setMnemonics(false);
        }
        super.setSelectedIndex(index);
        if (newGC != null) {
            newGC.setMnemonics(true);
        }
    }

    public void evaluate(DataStatusEvent e) {
        boolean process = e == null;
        String columnName = null;
        if (!process) {
            columnName = e.getColumnName();
            process = columnName != null ? this.m_dependents.contains(columnName) : true;
        }
        if (process) {
            log.config(columnName == null ? "" : columnName);
            for (int i = 0; i < this.components.size(); ++i) {
                GridController gc;
                Component c = this.components.get(i);
                if (!(c instanceof GridController) || (gc = (GridController)c).isDetailGrid()) continue;
                boolean display = this.isDisplay(gc);
                if (display) {
                    this.showTab(this.tabNames.get(i));
                    continue;
                }
                this.hideTab(this.tabNames.get(i));
            }
        }
    }
}

