/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.swing.CDialog;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextArea;
import org.compiere.swing.CTextPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class Editor
extends CDialog
implements ChangeListener,
ActionListener,
KeyListener {
    private static final long serialVersionUID = -8314686583942866712L;
    private String m_text;
    private int m_maxSize = 0;
    private static CLogger log = CLogger.getCLogger(Editor.class);
    private CPanel panel = new CPanel();
    private BorderLayout panelLayout = new BorderLayout();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private CTextArea textArea = new CTextArea();
    private CTextPane textPane = new CTextPane();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu mFile = new JMenu();
    private CMenuItem mImport = new CMenuItem();
    private CMenuItem mExport = new CMenuItem();
    private ConfirmPanel confirmPanel = new ConfirmPanel();
    private StatusBar statusBar = new StatusBar(false);

    public static String startEditor(Container jc, String header, String text, boolean editable, int maxSize) {
        JFrame frame = Env.getFrame(jc);
        String hdr = header;
        if (hdr == null || hdr.length() == 0) {
            hdr = Msg.getMsg(Env.getCtx(), "Editor");
        }
        Editor ed = new Editor(frame, hdr, text, editable, maxSize);
        AEnv.showCenterWindow(frame, ed);
        String s = ed.getText();
        ed = null;
        return s;
    }

    public Editor(Frame frame) {
        this(frame, Msg.getMsg(Env.getCtx(), "Editor"), "", true, 0);
    }

    public Editor(Frame frame, String header, String text, boolean editable, int maxSize) {
        super(frame, header, frame != null);
        try {
            this.m_maxSize = maxSize;
            this.jbInit();
            this.setDefaultCloseOperation(2);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
        this.m_text = text;
        this.textArea.setText(this.m_text);
        this.textArea.setEditable(editable);
        if (editable) {
            this.textArea.setBackground(AdempierePLAF.getFieldBackground_Normal());
        } else {
            this.textArea.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        }
        this.textPane.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.updateStatusBar();
    }

    private void jbInit() throws Exception {
        this.panel.setLayout(this.panelLayout);
        this.setJMenuBar(this.menuBar);
        this.textArea.setPreferredSize(new Dimension(300, 300));
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.tabbedPane.add((Component)this.textArea, "Text");
        this.textArea.addKeyListener(this);
        this.textPane.setContentType("text/html");
        this.textPane.setEditable(false);
        this.tabbedPane.add((Component)this.textPane, "HTML");
        this.mFile.setText("File");
        this.mImport.setText("Import");
        this.mImport.addActionListener(this);
        this.mExport.setText("Export");
        this.mExport.addActionListener(this);
        this.tabbedPane.addChangeListener(this);
        this.panel.add((Component)this.tabbedPane, "Center");
        this.confirmPanel.addActionListener(this);
        this.panel.add((Component)this.confirmPanel, "South");
        this.getContentPane().add((Component)this.panel, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.menuBar.add(this.mFile);
        this.mFile.add(this.mImport);
        this.mFile.add(this.mExport);
        this.updateStatusBar();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.m_text = this.textArea.getText();
            log.fine("OK - length=" + this.m_text.length());
            this.dispose();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getSource() == this.mImport) {
            this.importText();
        } else if (e.getSource() == this.mExport) {
            this.exportText();
        }
    }

    private void updateStatusBar() {
        String str = this.textArea.getText();
        int length = str.length();
        this.statusBar.setStatusDB(length);
        int size = length;
        try {
            size = str.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, str, e);
        }
        if (this.m_maxSize == 0) {
            this.statusBar.setStatusLine(String.valueOf(size));
        } else if (size < this.m_maxSize) {
            this.statusBar.setStatusLine(size + " < " + this.m_maxSize, false);
        } else if (size == this.m_maxSize) {
            this.statusBar.setStatusLine(size + " = " + this.m_maxSize, false);
        } else {
            this.statusBar.setStatusLine(size + " > " + this.m_maxSize, true);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public String getText() {
        return this.m_text;
    }

    private void importText() {
        JFileChooser jc = new JFileChooser();
        jc.setDialogTitle(Msg.getMsg(Env.getCtx(), "ImportText"));
        jc.setDialogType(0);
        jc.setFileSelectionMode(0);
        if (jc.showOpenDialog(this) != 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        try {
            int count;
            InputStreamReader in = new InputStreamReader(new FileInputStream(jc.getSelectedFile()));
            char[] cbuf = new char[1024];
            while ((count = in.read(cbuf)) > 0) {
                sb.append(cbuf, 0, count);
            }
            in.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
            return;
        }
        this.textArea.setText(sb.toString());
        this.updateStatusBar();
    }

    private void exportText() {
        JFileChooser jc = new JFileChooser();
        jc.setDialogTitle(Msg.getMsg(Env.getCtx(), "ExportText"));
        jc.setDialogType(1);
        jc.setFileSelectionMode(0);
        if (jc.showSaveDialog(this) != 0) {
            return;
        }
        try {
            BufferedWriter bout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(jc.getSelectedFile())));
            bout.write(this.textArea.getText());
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.textPane.setText(this.textArea.getText());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateStatusBar();
    }
}

