/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.util.logging.Level;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.compiere.util.CLogger;

public final class MDocTime
extends PlainDocument {
    private static final long serialVersionUID = 5359545674957190259L;
    private boolean m_isHour;
    private boolean m_is12Hour;
    private static CLogger log = CLogger.getCLogger(MDocTime.class);

    public MDocTime(boolean isHour, boolean is12Hour) {
        this.m_isHour = isHour;
        this.m_is12Hour = is12Hour;
    }

    @Override
    public void insertString(int offset, String string, AttributeSet attr) throws BadLocationException {
        if (string != null && string.length() == 1) {
            if (offset > 2) {
                return;
            }
            if (!Character.isDigit(string.charAt(0))) {
                log.config("No Digit=" + string);
                return;
            }
            char[] cc = this.getText().toCharArray();
            cc[offset] = string.charAt(0);
            String result = new String(cc);
            int i = 0;
            try {
                i = Integer.parseInt(result.trim());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.toString());
            }
            if (i < 0) {
                log.config("Invalid value: " + i);
                return;
            }
            if (!this.m_isHour && i > 59) {
                log.config("Invalid minute value: " + i);
                return;
            }
            if (this.m_isHour && this.m_is12Hour && i > 12) {
                log.config("Invalid 12 hour value: " + i);
                return;
            }
            if (this.m_isHour && !this.m_is12Hour && i > 24) {
                log.config("Invalid 24 hour value: " + i);
                return;
            }
        }
        super.insertString(offset, string, attr);
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
    }

    private String getText() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.getContent().getString(0, this.getContent().length() - 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (sb.length() < 2) {
            sb.insert(0, ' ');
        }
        return sb.toString();
    }
}

