/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import org.adempiere.exceptions.ValueChangeListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.RecordInfo;
import org.compiere.apps.search.InfoSchedule;
import org.compiere.grid.ed.VAssignmentDialog;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.model.MResourceAssignment;
import org.compiere.swing.CButton;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VAssignment
extends JComponent
implements VEditor,
ActionListener {
    private static final long serialVersionUID = 1362298262975012883L;
    private Object m_value = null;
    private PreparedStatement m_pstmt = null;
    private JTextField m_text = new JTextField(15);
    private CButton m_button = new CButton();
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem menuEditor;
    private boolean m_readWrite;
    private boolean m_mandatory;
    private DateFormat m_dateFormat = DisplayType.getDateFormat(16);
    private NumberFormat m_qtyFormat = DisplayType.getNumberFormat(29);
    private GridField m_mField;
    private static CLogger log = CLogger.getCLogger(VAssignment.class);

    public VAssignment() {
        this(false, false, true);
    }

    public VAssignment(boolean mandatory, boolean isReadOnly, boolean isUpdateable) {
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(this.m_text.getPreferredSize());
        int height = this.m_text.getPreferredSize().height;
        this.m_text.setEditable(false);
        this.m_text.setFocusable(false);
        this.m_text.setBorder(null);
        this.m_text.setHorizontalAlignment(10);
        this.setMandatory(mandatory);
        this.add((Component)this.m_text, "Center");
        this.m_button.setIcon(Env.getImageIcon("Assignment10.gif"));
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setPreferredSize(new Dimension(height, height));
        this.m_button.addActionListener(this);
        this.m_button.setFocusable(true);
        this.add((Component)this.m_button, "East");
        this.setPreferredSize(this.getPreferredSize());
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        this.m_text.addMouseListener(new VAssignment_mouseAdapter(this));
        this.menuEditor = new CMenuItem(Msg.getMsg(Env.getCtx(), "InfoResource"), Env.getImageIcon("Zoom16.gif"));
        this.menuEditor.addActionListener(this);
        this.popupMenu.add(this.menuEditor);
    }

    @Override
    public void dispose() {
        try {
            if (this.m_pstmt != null) {
                this.m_pstmt.close();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "VAssignment.dispose");
        }
        this.m_text = null;
        this.m_button = null;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.m_button.setMandatory(mandatory);
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        this.m_readWrite = rw;
        this.m_button.setReadWrite(rw);
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return this.m_readWrite;
    }

    @Override
    public void setForeground(Color color) {
        this.m_text.setForeground(color);
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.m_readWrite) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getInfoBackground());
        }
    }

    @Override
    public void setBackground(Color color) {
        this.m_text.setBackground(color);
    }

    @Override
    public void requestFocus() {
        this.m_text.requestFocus();
    }

    @Override
    public void setValue(Object value) {
        if (value == this.m_value) {
            return;
        }
        this.m_value = value;
        int S_ResourceAssignment_ID = 0;
        if (this.m_value != null && this.m_value instanceof Integer) {
            S_ResourceAssignment_ID = (Integer)this.m_value;
        }
        if (S_ResourceAssignment_ID == 0) {
            this.m_text.setText("");
            return;
        }
        if (this.m_pstmt == null) {
            this.m_pstmt = DB.prepareStatement("SELECT r.Name,ra.AssignDateFrom,ra.Qty,uom.UOMSymbol FROM S_ResourceAssignment ra, S_Resource r, S_ResourceType rt, C_UOM uom WHERE ra.S_ResourceAssignment_ID=? AND ra.S_Resource_ID=r.S_Resource_ID AND r.S_ResourceType_ID=rt.S_ResourceType_ID and rt.C_UOM_ID=uom.C_UOM_ID", null);
        }
        try {
            this.m_pstmt.setInt(1, S_ResourceAssignment_ID);
            ResultSet rs = this.m_pstmt.executeQuery();
            if (rs.next()) {
                StringBuffer sb = new StringBuffer(rs.getString(1));
                sb.append(" ").append(this.m_dateFormat.format(rs.getTimestamp(2))).append(" ").append(this.m_qtyFormat.format(rs.getBigDecimal(3))).append(" ").append(rs.getString(4).trim());
                this.m_text.setText(sb.toString());
            } else {
                this.m_text.setText("<" + S_ResourceAssignment_ID + ">");
            }
            rs.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public String getDisplay() {
        return this.m_text.getText();
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
        if (this.m_mField != null) {
            RecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    @Override
    public void addActionListener(ActionListener listener) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ChangeLog")) {
            RecordInfo.start(this.m_mField);
            return;
        }
        if (!this.m_button.isEnabled()) {
            return;
        }
        this.m_button.setEnabled(false);
        Integer oldValue = (Integer)this.getValue();
        int S_ResourceAssignment_ID = oldValue == null ? 0 : oldValue;
        MResourceAssignment ma = new MResourceAssignment(Env.getCtx(), S_ResourceAssignment_ID, null);
        if (S_ResourceAssignment_ID != 0) {
            VAssignmentDialog vad = new VAssignmentDialog((Frame)Env.getFrame(this), ma, true, true);
            ma = vad.getMResourceAssignment();
        } else {
            InfoSchedule is = new InfoSchedule((Frame)Env.getFrame(this), ma, true);
            ma = is.getMResourceAssignment();
        }
        if (ma != null && ma.getS_ResourceAssignment_ID() != 0) {
            this.setValue(new Integer(ma.getS_ResourceAssignment_ID()));
            try {
                this.fireVetoableChange(this.getName(), new Object(), this.getValue());
            }
            catch (PropertyVetoException pve) {
                log.log(Level.SEVERE, "", pve);
            }
        }
        this.m_button.setEnabled(true);
        this.requestFocus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
    }

    final class VAssignment_mouseAdapter
    extends MouseAdapter {
        private VAssignment adaptee;

        VAssignment_mouseAdapter(VAssignment adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                this.adaptee.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "Mouse"));
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                this.adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

