/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.adempiere.model.POWrapper;
import org.compiere.apps.search.FieldAutoCompleter;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.I_AD_Table;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MTable;
import org.compiere.util.CLogMgt;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.ValueNamePair;

public class VLookupAutoCompleter
extends FieldAutoCompleter {
    public static final String FUNC_unaccent_string = "unaccent_string";
    private final VLookup editor;
    private final MLookup lookup;
    private final String[] searchColumns;
    private final String[] searchColumnsSQL;

    public VLookupAutoCompleter(JTextComponent comp, VLookup editor, MLookup lookup) {
        super(comp);
        this.editor = editor;
        this.lookup = lookup;
        MTable table2 = MTable.get(Env.getCtx(), lookup.getTableName());
        ArrayList<String> searchList = new ArrayList<String>();
        ArrayList<String> searchSQLList = new ArrayList<String>();
        for (MColumn c : table2.getColumns(false)) {
            if (!DisplayType.isText(c.getAD_Reference_ID()) || !c.isIdentifier() && !c.isSelectionColumn()) continue;
            searchList.add(c.getColumnName());
            if (c.isVirtualColumn()) {
                searchSQLList.add(c.getColumnSQL());
                continue;
            }
            searchSQLList.add(c.getColumnName());
        }
        this.searchColumns = searchList.toArray(new String[searchList.size()]);
        this.searchColumnsSQL = searchSQLList.toArray(new String[searchSQLList.size()]);
        int popupMinimumChars = POWrapper.create(table2, I_AD_Table.class).getACTriggerLength();
        if (popupMinimumChars > 0) {
            this.setPopupMinimumChars(popupMinimumChars);
        }
        editor.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                VLookupAutoCompleter.this.hidePopup();
            }
        });
    }

    @Override
    protected Object fetchUserObject(ResultSet rs) throws SQLException {
        boolean isNumber = this.lookup.getColumnName().endsWith("_ID");
        String name = rs.getString(3);
        if (isNumber) {
            int key = rs.getInt(1);
            KeyNamePair p2 = new KeyNamePair(key, name);
            return p2;
        }
        String value = rs.getString(2);
        ValueNamePair p3 = new ValueNamePair(value, name);
        return p3;
    }

    @Override
    protected String getSelectSQL(String searchInput, int caretPosition, List<Object> params) {
        String search = caretPosition > 0 && caretPosition < searchInput.length() ? new StringBuilder(searchInput).insert(caretPosition, "%").toString() : searchInput;
        String searchSQL = search;
        if (!searchSQL.startsWith("%")) {
            searchSQL = "%" + searchSQL;
        }
        if (!searchSQL.endsWith("%")) {
            searchSQL = searchSQL + "%";
        }
        StringBuffer sql_select = new StringBuffer();
        StringBuffer sql_where = new StringBuffer();
        sql_where.append(this.lookup.getTableName()).append(".IsActive=?");
        params.add(true);
        if (this.searchColumns.length > 0) {
            sql_where.append(" AND (");
            for (int i = 0; i < this.searchColumns.length; ++i) {
                sql_select.append(",");
                if (i > 0) {
                    sql_where.append(" OR ");
                }
                sql_where.append("UPPER(unaccent_string(");
                if (this.searchColumns[i].equals(this.searchColumnsSQL[i])) {
                    sql_select.append(this.lookup.getTableName()).append(".").append(this.searchColumnsSQL[i]).append(" AS ").append(this.searchColumns[i]);
                    sql_where.append(this.lookup.getTableName()).append(".").append(this.searchColumns[i]);
                } else {
                    sql_select.append(this.searchColumnsSQL[i]).append(" AS ").append(this.searchColumns[i]);
                    sql_where.append(this.lookup.getTableName()).append(".").append(this.searchColumns[i]);
                }
                sql_where.append(", 1)) LIKE UPPER(unaccent_string(?, 1)) ");
                params.add(searchSQL);
            }
            sql_where.append(" OR UPPER(unaccent_string(ZZ_DisplayName, 1)) LIKE UPPER(unaccent_string(?, 1))");
            params.add(searchSQL);
            sql_where.append(") ");
        } else {
            this.log.warning("No search columns found");
            sql_where.append(" AND 1=2 ");
        }
        MLookupInfo info = this.lookup.getLookupInfo();
        String sql = info.Query;
        if (!info.IsValidated) {
            String validation;
            info.parsedValidationCode = validation = Env.parseContext(info.ctx, info.WindowNo, info.ValidationCode, false);
            if (validation.length() == 0 && info.ValidationCode.length() > 0) {
                this.log.fine(info.KeyColumn + ": Loader NOT Validated: " + info.ValidationCode);
            } else {
                this.log.fine(info.KeyColumn + ": Loader Validated: " + validation);
                int posFrom = sql.lastIndexOf(" FROM ");
                boolean hasWhere = sql.indexOf(" WHERE ", posFrom) != -1;
                int posOrder = sql.lastIndexOf(" ORDER BY ");
                sql = posOrder != -1 ? sql.substring(0, posOrder) + (hasWhere ? " AND " : " WHERE ") + validation + sql.substring(posOrder) : sql + (hasWhere ? " AND " : " WHERE ") + validation;
                if (CLogMgt.isLevelFinest()) {
                    this.log.fine(info.KeyColumn + ": Validation=" + validation);
                }
            }
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(sql.replace("," + this.lookup.getTableName() + ".IsActive FROM " + this.lookup.getTableName() + " WHERE ", " AS ZZ_DisplayName," + this.lookup.getTableName() + ".IsActive " + sql_select + " FROM " + this.lookup.getTableName() + " WHERE "));
        int i = sqlBuf.lastIndexOf(" ORDER BY ");
        if (i > 0) {
            sqlBuf.insert(i, ") " + this.lookup.getTableName() + " WHERE " + sql_where);
        } else {
            sqlBuf.append(") " + this.lookup.getTableName() + " WHERE " + sql_where);
        }
        sqlBuf.insert(0, "SELECT * FROM (");
        sql = sqlBuf.toString();
        return sql;
    }

    @Override
    public boolean isEnabled() {
        return this.textBox.hasFocus();
    }

    @Override
    public void setUserObject(Object userObject) {
        String textOld = this.textBox.getText();
        int caretPosition = this.textBox.getCaretPosition();
        super.setUserObject(userObject);
        Object value = null;
        if (userObject == null) {
            this.editor.setValue(null);
        } else if (userObject instanceof ValueNamePair) {
            ValueNamePair vnp = (ValueNamePair)userObject;
            value = vnp.getValue();
        } else if (userObject instanceof KeyNamePair) {
            KeyNamePair knp = (KeyNamePair)userObject;
            value = knp.getKey();
        } else {
            this.log.warning("Not supported - " + userObject + ", class=" + userObject.getClass());
            return;
        }
        this.editor.actionCombo(value);
        if (value == null) {
            this.textBox.setText(textOld);
            this.textBox.setCaretPosition(caretPosition);
        }
    }
}

