/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.compiere.apps.RecordInfo;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.swing.CRadioButton;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VRadioButton
extends CRadioButton
implements VEditor,
ActionListener {
    private static final long serialVersionUID = -9199643773556184995L;
    private char savedMnemonic = '\u0000';
    private String columnName;
    private GridField field;
    JPopupMenu popupMenu = new JPopupMenu();
    private Object oldValue;

    public VRadioButton() {
        this("", false, false, true, "", null, false);
    }

    public VRadioButton(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, String title, String description, boolean tableEditor) {
        super.setName(columnName);
        this.columnName = columnName;
        this.setMandatory(mandatory);
        if (isReadOnly || !isUpdateable) {
            this.setEditable(false);
        } else {
            this.setEditable(true);
        }
        if (!tableEditor) {
            this.setText(title);
            if (description != null && description.length() > 0) {
                this.setToolTipText(description);
            }
        } else {
            this.setHorizontalAlignment(0);
        }
        this.addActionListener(this);
        this.addMouseListener(new VRadioButton_mouseAdapter(this));
    }

    @Override
    public void dispose() {
    }

    public void setEditable(boolean value) {
        super.setReadWrite(value);
    }

    public boolean isEditable() {
        return super.isReadWrite();
    }

    @Override
    public void setValue(Object value) {
        boolean sel = false;
        if (value != null) {
            sel = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
        }
        this.setSelected(sel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public Object getValue() {
        return new Boolean(this.isSelected());
    }

    @Override
    public String getDisplay() {
        String value = this.isSelected() ? "Y" : "N";
        return Msg.translate(Env.getCtx(), value);
    }

    public void setBackground() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ChangeLog")) {
            RecordInfo.start(this.field);
            return;
        }
        try {
            this.fireVetoableChange(this.columnName, null, this.getValue());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setField(GridField mField) {
        this.field = mField;
        if (this.field != null) {
            RecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public GridField getField() {
        return this.field;
    }

    public char getSavedMnemonic() {
        return this.savedMnemonic;
    }

    public void setSavedMnemonic(char savedMnemonic) {
        this.savedMnemonic = savedMnemonic;
    }

    public void set_oldValue() {
        this.oldValue = this.getValue();
    }

    public Object get_oldValue() {
        return this.oldValue;
    }

    public boolean hasChanged() {
        if (this.getValue() != null) {
            if (this.oldValue != null) {
                return !this.oldValue.equals(this.getValue());
            }
            return true;
        }
        return this.oldValue != null;
    }

    final class VRadioButton_mouseAdapter
    extends MouseAdapter {
        private VRadioButton m_adaptee;

        VRadioButton_mouseAdapter(VRadioButton adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

