/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.minigrid;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCellRenderer;
import org.compiere.grid.ed.VHeaderRenderer;
import org.compiere.minigrid.CheckRenderer;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IDColumnEditor;
import org.compiere.minigrid.IDColumnRenderer;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniCellEditor;
import org.compiere.minigrid.ROCellEditor;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Util;

public class MiniTable
extends CTable
implements IMiniTable {
    private static final long serialVersionUID = 2853772547464132497L;
    private boolean pressedInTable = false;
    private int pressedRow = -1;
    private int pressedColumn = -1;
    private boolean wasDragged = false;
    private boolean m_singleClickTogglesSelection = true;
    protected EventListenerList listenerList = new EventListenerList();
    public static final String SYSCONFIG_INFO_DEFAULTSELECTED = "INFO_DEFAULTSELECTED";
    public static final String SYSCONFIG_INFO_DOUBLECLICKTOGGLESSELECTION = "INFO_DOUBLECLICKTOGGLESSELECTION";
    private ArrayList<Integer> m_readWriteColumn = new ArrayList();
    private ArrayList<Integer> m_minWidth = new ArrayList();
    private int m_colorColumnIndex = -1;
    private Object m_colorDataCompare = Env.ZERO;
    private boolean m_multiSelection = false;
    private boolean p_doubleClickTogglesSelection = MSysConfig.getBooleanValue("INFO_DOUBLECLICKTOGGLESSELECTION", false, Env.getAD_Client_ID(Env.getCtx()));
    private boolean p_isDefaultSelected = MSysConfig.getBooleanValue("INFO_DEFAULTSELECTED", false, Env.getAD_Client_ID(Env.getCtx()));
    private ColumnInfo[] m_layout = null;
    private static CLogger log = CLogger.getCLogger(MiniTable.class);
    private boolean showTotals = false;
    private boolean autoResize = true;
    private Action doNothing = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    private Action doSelectAll = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int leadRow = 0;
            MiniTable table2 = (MiniTable)e.getSource();
            if (table2.getRowCount() <= 0 || table2.getColumnCount() <= 0) {
                return;
            }
            ListSelectionModel rsm = table2.getSelectionModel();
            int index = 0;
            int compare = table2.getRowCount();
            if (table2.getShowTotals()) {
                --compare;
            }
            leadRow = compare - 1;
            rsm.addSelectionInterval(index, leadRow);
            MiniTable.this.matchCheckWithSelectedRows();
            ((DefaultListSelectionModel)rsm).moveLeadSelectionIndex(index);
            Rectangle cellRect = table2.getCellRect(index, 0, false);
            if (cellRect != null) {
                table2.scrollRectToVisible(cellRect);
            }
        }
    };
    private Action doSelectRowDown = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int dy = 1;
            String actionName = "SelectRowDown";
            MiniTable.this.doAction(e, actionName, dy);
        }
    };
    private Action doSelectRowUp = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int dy = -1;
            String actionName = "SelectRowUp";
            MiniTable.this.doAction(e, actionName, dy);
        }
    };
    private Action doAddRowUp = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int dy = -1;
            String actionName = "AddRowUp";
            MiniTable.this.doAction(e, actionName, dy);
        }
    };
    private Action doAddRowDown = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int dy = 1;
            String actionName = "AddRowDown";
            MiniTable.this.doAction(e, actionName, dy);
        }
    };
    private Action doAddRowUpExtend = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int dy = -1;
            String actionName = "AddRowUpExtend";
            MiniTable.this.doAction(e, actionName, dy);
        }
    };
    private Action doAddRowDownExtend = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int dy = 1;
            String actionName = "AddRowDownExtend";
            MiniTable.this.doAction(e, actionName, dy);
        }
    };
    private Action doChangeLeadUp = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int dy = -1;
            String actionName = "ChangeLeadUp";
            MiniTable.this.doAction(e, actionName, dy);
        }
    };
    private Action doChangeLeadDown = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int dy = 1;
            String actionName = "ChangeLeadDown";
            MiniTable.this.doAction(e, actionName, dy);
        }
    };
    protected Action doMatchIdToSelection = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MiniTable.this.matchCheckWithSelectedRows();
        }
    };
    protected Action doToggleID = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MiniTable.this.toggleLeadRowChecked();
        }
    };
    protected Action doToggleBySelection = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MiniTable.this.toggleRowCheckedBySelection();
        }
    };
    private boolean m_changingMultipleRows;

    public MiniTable() {
        this.setCellSelectionEnabled(true);
        this.setRowSelectionAllowed(true);
        this.setCellEditor(new ROCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setSurrendersFocusOnKeystroke(true);
        this.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "doMatchIdToSelection");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl SPACE"), "doToggleID");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift SPACE"), "doToggleBySelection");
        this.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("KP_RIGHT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl RIGHT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl KP_RIGHT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("shift RIGHT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("shift KP_RIGHT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift RIGHT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift KP_RIGHT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("KP_LEFT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl LEFT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl KP_LEFT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("shift LEFT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("shift KP_LEFT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift LEFT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift KP_LEFT"), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "doSelectRowDown");
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), "doSelectRowUp");
        this.getInputMap().put(KeyStroke.getKeyStroke("UP"), "doSelectRowUp");
        this.getInputMap().put(KeyStroke.getKeyStroke("KP_UP"), "doSelectRowUp");
        this.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "doSelectRowDown");
        this.getInputMap().put(KeyStroke.getKeyStroke("KP_DOWN"), "doSelectRowDown");
        this.getActionMap().put("doNothing", this.doNothing);
        this.getActionMap().put("doSelectAll", this.doSelectAll);
        this.getActionMap().put("doSelectRowDown", this.doSelectRowDown);
        this.getActionMap().put("doSelectRowUp", this.doSelectRowUp);
        this.getActionMap().put("doAddRowDown", this.doAddRowDown);
        this.getActionMap().put("doAddRowUp", this.doAddRowUp);
        this.getActionMap().put("doAddRowDownExtend", this.doAddRowDownExtend);
        this.getActionMap().put("doAddRowUpExtend", this.doAddRowUpExtend);
        this.getActionMap().put("doChangeLeadDown", this.doChangeLeadDown);
        this.getActionMap().put("doChangeLeadUp", this.doChangeLeadUp);
        this.getActionMap().put("doMatchIdToSelection", this.doMatchIdToSelection);
        this.getActionMap().put("doToggleID", this.doToggleID);
        this.getActionMap().put("doToggleBySelection", this.doToggleBySelection);
        this.setShowTotals(false);
        this.getSelectionModel().addListSelectionListener(this);
        this.addPropertyChangeListener(new TablePropertyListener());
        this.config_table();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fe) {
                ((MiniTable)fe.getSource()).getParent().repaint();
            }

            @Override
            public void focusLost(FocusEvent fe) {
                if ((MiniTable)fe.getSource() != null) {
                    ((MiniTable)fe.getSource()).getParent().repaint();
                }
            }
        });
    }

    protected boolean isSingleClickTogglesSelection() {
        return this.m_singleClickTogglesSelection;
    }

    protected void setSingleClickTogglesSelection(boolean clickTogglesSelection) {
        this.m_singleClickTogglesSelection = clickTogglesSelection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void processMouseEvent(MouseEvent me) {
        block27: {
            MiniTable table2 = (MiniTable)me.getSource();
            if (me.isPopupTrigger()) {
                try {
                    super.processMouseEvent(me);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (me.getID() == 500 && me.getClickCount() % 2 == 0) {
                if (this.isMultiSelection() && this.isDoubleClickTogglesSelection()) {
                    this.toggleLeadRowChecked();
                    break block27;
                } else {
                    try {
                        super.processMouseEvent(me);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
            if (me.getID() == 502) {
                if (this.pressedInTable) {
                    boolean editable;
                    boolean releasedInTable = false;
                    if (table2.rowAtPoint(me.getPoint()) >= 0 && table2.columnAtPoint(me.getPoint()) >= 0) {
                        releasedInTable = true;
                    }
                    if (!releasedInTable) {
                        this.toggleRowCheckedBySelection();
                        return;
                    }
                    if (this.pressedRow == table2.rowAtPoint(me.getPoint()) && this.pressedColumn == table2.columnAtPoint(me.getPoint()) && (editable = this.isCellEditable(this.pressedRow, this.pressedColumn))) {
                        try {
                            super.processMouseEvent(me);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.fireRowSelectionEvent();
                        return;
                    }
                    int ctrlMask = 128;
                    if (!this.wasDragged && (me.getModifiersEx() & ctrlMask) == ctrlMask || this.isMultiSelection() && this.isSingleClickTogglesSelection()) {
                        if (this.pressedRow == table2.rowAtPoint(me.getPoint())) {
                            this.toggleLeadRowChecked();
                        } else {
                            this.toggleRowCheckedRange(this.pressedRow, table2.rowAtPoint(me.getPoint()));
                        }
                    } else {
                        this.matchCheckWithSelectedRows();
                    }
                }
                this.pressedInTable = false;
                this.pressedRow = -1;
                this.pressedColumn = -1;
                this.wasDragged = false;
            } else if (me.getID() == 501) {
                int rows = table2.getRowCount();
                int columns = table2.getColumnCount();
                if (table2.getShowTotals()) {
                    --rows;
                }
                this.pressedRow = table2.rowAtPoint(me.getPoint());
                this.pressedColumn = table2.columnAtPoint(me.getPoint());
                if (this.pressedRow >= 0 && this.pressedRow < rows && this.pressedColumn >= 0 && this.pressedColumn < columns) {
                    this.pressedInTable = true;
                } else {
                    this.pressedInTable = false;
                    this.pressedRow = -1;
                    this.pressedColumn = -1;
                }
            }
        }
        if (!this.pressedInTable) {
            return;
        }
        try {
            super.processMouseEvent(me);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mme) {
        if (mme.getID() == 506) {
            if (!this.pressedInTable) {
                this.wasDragged = false;
                mme.consume();
                return;
            }
            if (this.pressedInTable) {
                int totalRow;
                this.wasDragged = true;
                MiniTable table2 = (MiniTable)mme.getSource();
                if (this.getShowTotals() && (totalRow = table2.getRowCount() - 1) == table2.rowAtPoint(mme.getPoint())) {
                    mme.consume();
                    return;
                }
                if (!this.isMultiSelection()) {
                    ListSelectionModel rsm = table2.getSelectionModel();
                    int leadRow = rsm.getLeadSelectionIndex();
                    rsm.setSelectionInterval(leadRow, leadRow);
                }
            }
            super.processMouseMotionEvent(mme);
        }
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public TableColumn getColumn(int col) {
        return this.getColumnModel().getColumn(col);
    }

    @Override
    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    @Override
    public void autoSize() {
        if (!this.autoResize) {
            return;
        }
        long start = System.currentTimeMillis();
        int SLACK = 8;
        int MAXSIZE = 300;
        TableModel model = this.getModel();
        int size = model.getColumnCount();
        for (int col = 0; col < size; ++col) {
            TableCellRenderer renderer;
            TableColumn tc = this.getColumnModel().getColumn(col);
            int width = 0;
            if (this.m_minWidth.size() > col) {
                width = this.m_minWidth.get(col);
            }
            if ((renderer = tc.getHeaderRenderer()) == null) {
                renderer = new DefaultTableCellRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, tc.getHeaderValue(), false, false, 0, 0);
            width = Math.max(width, comp.getPreferredSize().width + 8);
            int maxRow = Math.min(30, this.getRowCount());
            for (int row = 0; row < maxRow; ++row) {
                renderer = this.getCellRenderer(row, col);
                comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                if (comp == null) continue;
                int rowWidth = comp.getPreferredSize().width + 8;
                width = Math.max(width, rowWidth);
            }
            width = Math.min(300, width);
            tc.setPreferredWidth(width);
        }
        log.finer("Cols=" + size + " - " + (System.currentTimeMillis() - start) + "ms");
    }

    @Override
    public boolean isRowChecked(int row) {
        int keyColumn = this.getKeyColumnIndex();
        if (keyColumn < 0) {
            return false;
        }
        Object data = this.getValueAt(row, this.convertColumnIndexToView(keyColumn));
        if (data instanceof IDColumn) {
            return ((IDColumn)data).isSelected();
        }
        if (data instanceof Boolean) {
            return (Boolean)data;
        }
        return false;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        int modelColumn = this.convertColumnIndexToModel(column);
        return (modelColumn == 0 && this.getValueAt(row, column) instanceof Boolean || this.isRowChecked(row)) && this.m_readWriteColumn.contains(new Integer(modelColumn));
    }

    @Override
    public void setColumnReadOnly(int column, boolean readOnly) {
        if (this.m_readWriteColumn.contains(new Integer(column))) {
            if (readOnly) {
                int size = this.m_readWriteColumn.size();
                for (int i = 0; i < size; ++i) {
                    if (this.m_readWriteColumn.get(i) != column) continue;
                    this.m_readWriteColumn.remove(i);
                    break;
                }
            }
        } else if (!readOnly) {
            this.m_readWriteColumn.add(new Integer(column));
        }
    }

    @Override
    public String prepareTable(ColumnInfo[] layout, String from, String where, boolean multiSelection, String tableName) {
        int i;
        this.m_layout = layout;
        this.setMultiSelection(multiSelection);
        StringBuffer sql = new StringBuffer("SELECT ");
        for (i = 0; i < layout.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(layout[i].getColSQL());
            if (layout[i].isKeyPairCol()) {
                sql.append(",").append(layout[i].getKeyPairColSQL());
            }
            this.addColumn(layout[i].getColHeader());
            if (layout[i].isColorColumn()) {
                this.setColorColumn(i);
            }
            if (layout[i].getColClass() != IDColumn.class) continue;
            this.p_keyColumnIndex = i;
        }
        for (i = 0; i < layout.length; ++i) {
            this.setColumnClass(i, layout[i].getColClass(), layout[i].isReadOnly(), layout[i].getColHeader());
        }
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ").append(where);
        this.setRowSelectionAllowed(true);
        if (from.length() == 0) {
            return sql.toString();
        }
        String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), tableName, true, false);
        log.finest(finalSQL);
        return finalSQL;
    }

    @Override
    public void addColumn(String header) {
        if (!(this.getModel() instanceof DefaultTableModel)) {
            throw new IllegalArgumentException("Model must be instance of DefaultTableModel");
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.addColumn(Util.cleanAmp(header));
    }

    public void addChangeListener(int column, ChangeListener listener) {
        TableColumn tc = this.getColumn(column);
        TableCellRenderer tcr = tc.getCellRenderer();
        if (tcr instanceof IDColumnRenderer || tcr instanceof CheckRenderer) {
            ((IDColumnRenderer)tcr).addChangeListener(listener);
        } else if (tcr instanceof CheckRenderer) {
            ((CheckRenderer)tcr).addChangeListener(listener);
        }
    }

    @Override
    public void setColumnClass(int index, Class c, boolean readOnly) {
        this.setColumnClass(index, c, readOnly, null);
    }

    @Override
    public void setColumnClass(int index, Class c, boolean readOnly, String header) {
        this.setColumnClass(index, c, 0, readOnly, header);
    }

    public void setColumnClass(int index, Class c, int displayType, boolean readOnly, String header) {
        TableColumn tc = this.getColumnModel().getColumn(index);
        if (tc == null) {
            return;
        }
        this.setColumnReadOnly(index, readOnly);
        if (header != null && header.length() > 0) {
            tc.setHeaderValue(Util.cleanAmp(header));
        }
        if (c == IDColumn.class) {
            IDColumnRenderer idcr = new IDColumnRenderer(this.m_multiSelection);
            tc.setCellRenderer(idcr);
            if (this.m_multiSelection) {
                VHeaderRenderer vhr = new VHeaderRenderer(this.m_multiSelection);
                tc.setCellEditor(new IDColumnEditor());
                tc.setHeaderRenderer(vhr);
                idcr.addChangeListener(vhr);
                this.setColumnReadOnly(index, false);
            } else {
                tc.setCellEditor(new ROCellEditor());
                tc.setHeaderRenderer(new VHeaderRenderer(22));
            }
            this.m_minWidth.add(new Integer(10));
            tc.setMaxWidth(20);
            tc.setPreferredWidth(20);
            tc.setResizable(false);
        } else if (20 == displayType || c == Boolean.class) {
            CheckRenderer cr = new CheckRenderer();
            tc.setCellRenderer(cr);
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
                tc.setHeaderRenderer(new VHeaderRenderer(20));
            } else if (this.m_multiSelection) {
                VHeaderRenderer vhr = new VHeaderRenderer(this.m_multiSelection);
                this.setColumnReadOnly(index, false);
                CCheckBox check = new CCheckBox();
                check.setMargin(new Insets(0, 0, 0, 0));
                check.setHorizontalAlignment(0);
                tc.setCellEditor(new DefaultCellEditor(check));
                tc.setHeaderRenderer(vhr);
                cr.addChangeListener(vhr);
            }
            this.m_minWidth.add(new Integer(30));
        } else if (15 == displayType || 16 == displayType || c == Timestamp.class) {
            if (16 == displayType) {
                tc.setCellRenderer(new VCellRenderer(16));
            } else {
                tc.setCellRenderer(new VCellRenderer(15));
            }
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
            } else if (15 == displayType || 16 == displayType) {
                tc.setCellEditor(new MiniCellEditor(c, displayType));
            } else {
                tc.setCellEditor(new MiniCellEditor(c));
            }
            this.m_minWidth.add(new Integer(30));
            if (16 == displayType) {
                tc.setHeaderRenderer(new VHeaderRenderer(16));
            } else {
                tc.setHeaderRenderer(new VHeaderRenderer(15));
            }
        } else if (12 == displayType || c == BigDecimal.class) {
            tc.setCellRenderer(new VCellRenderer(12));
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
                this.m_minWidth.add(new Integer(70));
            } else {
                tc.setCellEditor(new MiniCellEditor(c));
                this.m_minWidth.add(new Integer(80));
            }
            tc.setHeaderRenderer(new VHeaderRenderer(22));
        } else if (22 == displayType || c == Double.class) {
            tc.setCellRenderer(new VCellRenderer(22));
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
                this.m_minWidth.add(new Integer(70));
            } else {
                tc.setCellEditor(new MiniCellEditor(c));
                this.m_minWidth.add(new Integer(80));
            }
            tc.setHeaderRenderer(new VHeaderRenderer(22));
        } else if (11 == displayType || c == Integer.class) {
            tc.setCellRenderer(new VCellRenderer(11));
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
            } else {
                tc.setCellEditor(new MiniCellEditor(c));
            }
            this.m_minWidth.add(new Integer(30));
            tc.setHeaderRenderer(new VHeaderRenderer(22));
        } else {
            tc.setCellRenderer(new VCellRenderer(10));
            if (readOnly) {
                tc.setCellEditor(new ROCellEditor());
            } else {
                tc.setCellEditor(new MiniCellEditor(String.class));
            }
            this.m_minWidth.add(new Integer(30));
            tc.setHeaderRenderer(new VHeaderRenderer(10));
        }
    }

    @Override
    public void setRowCount(int no) {
        if (!(this.getModel() instanceof DefaultTableModel)) {
            throw new IllegalArgumentException("Model must be instance of DefaultTableModel");
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.setRowCount(no);
    }

    @Override
    public void loadTable(ResultSet rs) {
        if (this.m_layout == null) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        this.setRowCount(0);
        try {
            while (rs.next()) {
                int row = this.getRowCount();
                this.setRowCount(row + 1);
                int colOffset = 1;
                for (int col = 0; col < this.m_layout.length; ++col) {
                    Object data = null;
                    Class<?> c = this.m_layout[col].getColClass();
                    int colIndex = col + colOffset;
                    if (c == IDColumn.class) {
                        data = new IDColumn(rs.getInt(colIndex));
                    } else if (c == Boolean.class) {
                        data = new Boolean("Y".equals(rs.getString(colIndex)));
                    } else if (c == Timestamp.class) {
                        data = rs.getTimestamp(colIndex);
                    } else if (c == BigDecimal.class) {
                        data = rs.getBigDecimal(colIndex);
                    } else if (c == Double.class) {
                        data = rs.getDouble(colIndex);
                    } else if (c == Integer.class) {
                        data = rs.getInt(colIndex);
                    } else if (c == KeyNamePair.class) {
                        String display = rs.getString(colIndex);
                        int key = rs.getInt(colIndex + 1);
                        data = new KeyNamePair(key, display);
                        ++colOffset;
                    } else {
                        String s = rs.getString(colIndex);
                        if (s != null) {
                            data = s.trim();
                        }
                    }
                    this.setValueAt(data, row, col);
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "", e);
        }
        if (this.getShowTotals()) {
            this.addTotals(this.m_layout);
        }
        this.autoSize();
        log.config("Row(rs)=" + this.getRowCount());
    }

    @Override
    public void loadTable(PO[] pos) {
        if (this.m_layout == null) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        this.setRowCount(0);
        for (int i = 0; i < pos.length; ++i) {
            PO myPO = pos[i];
            int row = this.getRowCount();
            this.setRowCount(row + 1);
            for (int col = 0; col < this.m_layout.length; ++col) {
                String columnName = this.m_layout[col].getColSQL();
                Object data = myPO.get_Value(columnName);
                if (data != null) {
                    Class<?> c = this.m_layout[col].getColClass();
                    if (c == IDColumn.class) {
                        data = new IDColumn((int)((Integer)data));
                    } else if (c == Double.class) {
                        data = new Double(((BigDecimal)data).doubleValue());
                    }
                }
                this.setValueAt(data, row, col);
            }
        }
        if (this.getShowTotals()) {
            this.addTotals(this.m_layout);
        }
        this.autoSize();
        log.config("Row(array)=" + this.getRowCount());
    }

    @Override
    public void setKeyColumnIndex(int keyColumnIndex) {
        super.setKeyColumnIndex(keyColumnIndex);
    }

    @Override
    public int getKeyColumnIndex() {
        return super.getKeyColumnIndex();
    }

    @Override
    public int getRowKey(int row) {
        Object data;
        if (this.getKeyColumnIndex() < 0) {
            throw new UnsupportedOperationException("Key Column is not defined");
        }
        int rows = this.getRowCount();
        if (this.getShowTotals()) {
            --rows;
        }
        if (row >= 0 && row < rows && (data = this.getValueAt(row, this.convertColumnIndexToView(this.getKeyColumnIndex()))) instanceof IDColumn) {
            IDColumn id = (IDColumn)data;
            return id.getRecord_ID();
        }
        return 0;
    }

    @Override
    public Integer getSelectedRowKey() {
        int selectedRow = this.getSelectedRow();
        return new Integer(this.getRowKey(selectedRow));
    }

    @Override
    public ArrayList<Integer> getSelectedKeys() {
        if (this.getModel() == null) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        if (this.p_keyColumnIndex < 0) {
            throw new UnsupportedOperationException("Key Column is not defined");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            IDColumn record;
            Object data = this.getModel().getValueAt(row, this.p_keyColumnIndex);
            if (!(data instanceof IDColumn) || !(record = (IDColumn)data).isSelected()) continue;
            list.add(record.getRecord_ID());
        }
        return list;
    }

    public int getLeadRowKey() {
        int leadRow = this.getSelectionModel().getLeadSelectionIndex();
        return this.getRowKey(leadRow);
    }

    @Override
    public ColumnInfo[] getLayoutInfo() {
        return this.m_layout;
    }

    @Override
    public void setMultiSelection(boolean multiSelection) {
        this.m_multiSelection = multiSelection;
        this.config_table();
    }

    @Override
    public boolean isMultiSelection() {
        return this.m_multiSelection;
    }

    public void setDoubleClickTogglesSelection(boolean value) {
        this.p_doubleClickTogglesSelection = value;
    }

    public boolean isDoubleClickTogglesSelection() {
        return this.p_doubleClickTogglesSelection;
    }

    public void setColorColumn(int modelIndex) {
        this.m_colorColumnIndex = modelIndex;
    }

    public void setDefaultSelected(boolean value) {
        this.p_isDefaultSelected = value;
    }

    public boolean isDefaultSelected() {
        return this.p_isDefaultSelected;
    }

    @Override
    public void setColorCompare(Object dataCompare) {
        this.m_colorDataCompare = dataCompare;
    }

    @Override
    public int getColorCode(int row) {
        if (this.m_colorColumnIndex == -1) {
            return 0;
        }
        Object data = this.getModel().getValueAt(row, this.m_colorColumnIndex);
        int cmp = 0;
        if (data == null) {
            return 0;
        }
        try {
            if (data instanceof Timestamp) {
                if (this.m_colorDataCompare == null || !(this.m_colorDataCompare instanceof Timestamp)) {
                    this.m_colorDataCompare = new Timestamp(System.currentTimeMillis());
                }
                cmp = ((Timestamp)this.m_colorDataCompare).compareTo((Timestamp)data);
            } else {
                if (this.m_colorDataCompare == null || !(this.m_colorDataCompare instanceof BigDecimal)) {
                    this.m_colorDataCompare = Env.ZERO;
                }
                if (!(data instanceof BigDecimal)) {
                    data = new BigDecimal(data.toString());
                }
                cmp = ((BigDecimal)this.m_colorDataCompare).compareTo((BigDecimal)data);
            }
        }
        catch (Exception e) {
            return 0;
        }
        if (cmp > 0) {
            return -1;
        }
        if (cmp < 0) {
            return 1;
        }
        return 0;
    }

    public void setShowTotals(boolean show) {
        this.showTotals = show;
    }

    @Override
    public boolean getShowTotals() {
        return this.showTotals;
    }

    public void addTotals(ColumnInfo[] layout) {
        int modelCol;
        int row;
        if (this.getRowCount() == 0 || layout.length == 0) {
            return;
        }
        Object[] total = new Object[layout.length];
        for (row = 0; row < this.getRowCount(); ++row) {
            for (int col = 0; col < layout.length; ++col) {
                Number amt;
                Number subtotal;
                int modelRow = this.convertRowIndexToModel(row);
                modelCol = this.convertColumnIndexToModel(col);
                Object data = this.getModel().getValueAt(modelRow, modelCol);
                Class<?> c = layout[modelCol].getColClass();
                if (c == BigDecimal.class) {
                    subtotal = Env.ZERO;
                    if (total[col] != null) {
                        subtotal = (BigDecimal)total[col];
                    }
                    amt = (BigDecimal)data;
                    if (subtotal == null) {
                        subtotal = Env.ZERO;
                    }
                    if (amt == null) {
                        amt = Env.ZERO;
                    }
                    total[col] = ((BigDecimal)subtotal).add((BigDecimal)amt);
                    continue;
                }
                if (c != Double.class) continue;
                subtotal = new Double(0.0);
                if (total[col] != null) {
                    subtotal = (Double)total[col];
                }
                amt = (Double)data;
                if (subtotal == null) {
                    subtotal = new Double(0.0);
                }
                if (amt == null) {
                    subtotal = new Double(0.0);
                }
                total[col] = (Double)subtotal + (Double)amt;
            }
        }
        row = this.getRowCount() + 1;
        boolean markerSet = false;
        this.setRowCount(row);
        for (int col = 0; col < layout.length; ++col) {
            modelCol = this.convertColumnIndexToModel(col);
            Class<?> c = layout[modelCol].getColClass();
            if (c == BigDecimal.class) {
                this.setValueAt(total[col], row - 1, col);
                continue;
            }
            if (c == Double.class) {
                this.setValueAt(total[col], row - 1, col);
                continue;
            }
            if (c == String.class && !markerSet) {
                this.setValueAt(" \u03a3  ", row - 1, col);
                markerSet = true;
                continue;
            }
            this.setValueAt(null, row - 1, col);
        }
    }

    public void addTotals(Info_Column[] layout) {
        this.addTotals((ColumnInfo[])layout);
    }

    private void config_table() {
        if (this.isMultiSelection()) {
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl A"), "doSelectAll");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl UP"), "doChangeLeadUp");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl KP_UP"), "doChangeLeadUp");
            this.getInputMap().put(KeyStroke.getKeyStroke("shift UP"), "doAddRowUpExtend");
            this.getInputMap().put(KeyStroke.getKeyStroke("shift KP_UP"), "doAddRowUpExtend");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift UP"), "doAddRowUp");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift KP_UP"), "doAddRowUp");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl DOWN"), "doChangeLeadDown");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl KP_DOWN"), "doChangeLeadDown");
            this.getInputMap().put(KeyStroke.getKeyStroke("shift DOWN"), "doAddRowDownExtend");
            this.getInputMap().put(KeyStroke.getKeyStroke("shift KP_DOWN"), "doAddRowDownExtend");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift DOWN"), "doAddRowDown");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift KP_DOWN"), "doAddRowDown");
        } else {
            this.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "doNothing");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl A"), "doNothing");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl UP"), "doSelectRowUp");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl KP_UP"), "doSelectRowUp");
            this.getInputMap().put(KeyStroke.getKeyStroke("shift UP"), "doSelectRowUp");
            this.getInputMap().put(KeyStroke.getKeyStroke("shift KP_UP"), "doSelectRowUp");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift UP"), "doSelectRowUp");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift KP_UP"), "doSelectRowUp");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl DOWN"), "doSelectRowDown");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl KP_DOWN"), "doSelectRowDown");
            this.getInputMap().put(KeyStroke.getKeyStroke("shift DOWN"), "doSelectRowDown");
            this.getInputMap().put(KeyStroke.getKeyStroke("shift KP_DOWN"), "doSelectRowDown");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift DOWN"), "doSelectRowDown");
            this.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift KP_DOWN"), "doSelectRowDown");
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Class<?> editorClass = null;
        try {
            editorClass = this.getColumnModel().getColumn(column).getCellEditor().getClass();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean editable = this.isCellEditable(row, column);
        if (editable && editorClass == MiniCellEditor.class) {
            Color borderColor = AdempierePLAF.getFieldBackground_Mandatory();
            CompoundBorder cb = null;
            MiniCellEditor jc = (MiniCellEditor)this.getColumnModel().getColumn(column).getCellEditor();
            if (column == 0) {
                cb = new CompoundBorder(new EmptyBorder(new Insets(0, 0, 0, 1)), new MatteBorder(1, 1, 1, 0, borderColor));
                jc.setBorder(cb);
            } else if (column == this.getColumnCount() - 1) {
                cb = new CompoundBorder(new EmptyBorder(new Insets(0, 1, 0, 0)), new MatteBorder(1, 0, 1, 1, borderColor));
                jc.setBorder(cb);
            } else {
                cb = new CompoundBorder(new EmptyBorder(new Insets(0, 1, 0, 1)), new MatteBorder(1, 0, 1, 0, borderColor));
                jc.setBorder(cb);
            }
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        return super.getCellEditor(row, column);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        boolean readOnly;
        Component c = super.prepareRenderer(renderer, row, column);
        JComponent jc = (JComponent)c;
        if (c == null) {
            return c;
        }
        Color selectedColor = AdempierePLAF.getFieldBackground_Selected();
        Color normalColor = AdempierePLAF.getFieldBackground_Normal();
        Color backColor = AdempierePLAF.getInfoBackground();
        Color borderColor = AdempierePLAF.getFieldBackground_Mandatory();
        CompoundBorder cb = null;
        ListSelectionModel rsm = this.getSelectionModel();
        boolean bl = readOnly = !this.isCellEditable(row, column);
        if (row != rsm.getLeadSelectionIndex()) {
            if (rsm.isSelectedIndex(row)) {
                c.setBackground(selectedColor);
                jc.setBorder(new MatteBorder(1, 1, 1, 1, selectedColor));
            } else if (row % 2 == 0) {
                c.setBackground(normalColor);
                jc.setBorder(new MatteBorder(1, 1, 1, 1, normalColor));
            } else {
                c.setBackground(backColor);
                jc.setBorder(new MatteBorder(1, 1, 1, 1, backColor));
            }
            if (c.getClass().equals(JCheckBox.class)) {
                ((JCheckBox)c).setBorderPainted(false);
            } else if (c.getClass().equals(JButton.class)) {
                ((JButton)c).setBorderPainted(false);
            }
        } else {
            if (c.getClass().equals(JCheckBox.class)) {
                ((JCheckBox)c).setBorderPainted(true);
            } else if (c.getClass().equals(JButton.class)) {
                ((JButton)c).setBorderPainted(true);
            }
            cb = column == 0 ? new CompoundBorder(new EmptyBorder(new Insets(0, 0, 0, 1)), new MatteBorder(1, 1, 1, 0, borderColor)) : (column == this.getColumnCount() - 1 ? new CompoundBorder(new EmptyBorder(new Insets(0, 1, 0, 0)), new MatteBorder(1, 0, 1, 1, borderColor)) : new CompoundBorder(new EmptyBorder(new Insets(0, 1, 0, 1)), new MatteBorder(1, 0, 1, 0, borderColor)));
            jc.setBorder(cb);
            if (!readOnly && this.isRowChecked(row)) {
                c.setBackground(normalColor);
            } else {
                c.setBackground(selectedColor);
            }
        }
        return c;
    }

    private void doAction(ActionEvent e, String actionName, int dy) {
        Rectangle cellRect;
        int leadRow = 0;
        MiniTable table2 = (MiniTable)e.getSource();
        if (table2.getRowCount() <= 0 || table2.getColumnCount() <= 0) {
            return;
        }
        ListSelectionModel rsm = table2.getSelectionModel();
        int index = rsm.getLeadSelectionIndex();
        int compare = table2.getRowCount();
        if (table2.getShowTotals()) {
            --compare;
        }
        int n = index = index < compare ? index : -1;
        if (dy != 0) {
            if (dy < 0) {
                leadRow = Math.min(Math.max(index + dy, 0), index);
            } else if (dy > 0) {
                leadRow = Math.min(Math.max(index + dy, 0), compare - 1);
            }
            if (actionName.equals("SelectRowUp") || actionName.equals("SelectRowDown")) {
                rsm.clearSelection();
                rsm.addSelectionInterval(leadRow, leadRow);
                this.matchCheckWithSelectedRows();
            } else if (actionName.equals("AddRowUp") || actionName.equals("AddRowDown")) {
                Object data = table2.getValueAt(index, table2.convertColumnIndexToView(this.getKeyColumnIndex()));
                if (data instanceof IDColumn) {
                    rsm.addSelectionInterval(index, leadRow);
                    this.setRowChecked(index, true);
                    this.setRowChecked(leadRow, true);
                }
            } else if (actionName.equals("AddRowUpExtend") || actionName.equals("AddRowDownExtend")) {
                table2.changeSelection(index, 0, false, true);
                table2.changeSelection(leadRow, 0, false, true);
                this.matchCheckWithSelectedRows();
            } else if (actionName.equals("ChangeLeadUp") || actionName.equals("ChangeLeadDown")) {
                if (this.isRowChecked(index)) {
                    rsm.addSelectionInterval(index, index);
                } else if (!this.isRowChecked(index) && table2.isRowSelected(index)) {
                    rsm.removeSelectionInterval(index, index);
                }
                ((DefaultListSelectionModel)rsm).moveLeadSelectionIndex(leadRow);
            }
        }
        if ((cellRect = table2.getCellRect(leadRow, 0, false)) != null) {
            table2.scrollRectToVisible(cellRect);
        }
    }

    public void matchCheckWithSelectedRows() {
        int totalRow;
        int rows = this.getRowCount();
        if (this.getShowTotals()) {
            --rows;
        }
        if (rows <= 0) {
            return;
        }
        ListSelectionModel rsm = this.getSelectionModel();
        int leadRow = rsm.getLeadSelectionIndex();
        if (leadRow >= 0 && leadRow < rows && !rsm.isSelectedIndex(leadRow)) {
            if (this.isMultiSelection()) {
                rsm.addSelectionInterval(leadRow, leadRow);
            } else {
                rsm.setSelectionInterval(leadRow, leadRow);
            }
        }
        if (this.getShowTotals() && rsm.isSelectedIndex(totalRow = this.getRowCount() - 1)) {
            rsm.removeIndexInterval(totalRow, totalRow);
        }
        int[] selectedRows = this.getSelectedRows();
        this.m_changingMultipleRows = true;
        if (selectedRows.length < rows) {
            for (int row = 0; row < rows; ++row) {
                this.setRowChecked(row, false);
            }
        }
        for (int row : selectedRows) {
            this.setRowChecked(row, true);
        }
        this.fireRowSelectionEvent();
        this.m_changingMultipleRows = false;
    }

    private void toggleLeadRowChecked() {
        ListSelectionModel rsm = this.getSelectionModel();
        int leadRow = rsm.getLeadSelectionIndex();
        if (leadRow == -1) {
            return;
        }
        this.setRowChecked(leadRow, !this.isRowChecked(leadRow));
        if (this.isRowChecked(leadRow)) {
            if (this.isMultiSelection()) {
                rsm.addSelectionInterval(leadRow, leadRow);
            } else {
                rsm.setSelectionInterval(leadRow, leadRow);
            }
        } else {
            rsm.removeSelectionInterval(leadRow, leadRow);
            rsm.setLeadSelectionIndex(leadRow);
        }
    }

    private void toggleRowChecked(int row) {
        int rows = this.getRowCount();
        if (this.getShowTotals()) {
            --rows;
        }
        if (row < 0 || row >= rows) {
            return;
        }
        ListSelectionModel rsm = this.getSelectionModel();
        this.setRowChecked(row, !this.isRowChecked(row));
        if (this.isRowChecked(row)) {
            if (this.isMultiSelection()) {
                rsm.addSelectionInterval(row, row);
            } else {
                rsm.setSelectionInterval(row, row);
            }
        } else {
            rsm.removeSelectionInterval(row, row);
        }
    }

    private void toggleRowCheckedRange(int index0, int index1) {
        if (this.isMultiSelection() && this.getKeyColumnIndex() >= 0) {
            int rows = this.getRowCount();
            if (this.getShowTotals()) {
                --rows;
            }
            if (index0 < 0 || index0 >= rows || index1 < 0 || index1 >= rows) {
                return;
            }
            ListSelectionModel rsm = this.getSelectionModel();
            int leadRow = rsm.getLeadSelectionIndex();
            int low = index0 <= index1 ? index0 : index1;
            int high = index0 <= index1 ? index1 : index0;
            this.m_changingMultipleRows = true;
            for (int row = low; row <= high; ++row) {
                this.toggleRowChecked(row);
            }
            rsm.setLeadSelectionIndex(leadRow);
            this.fireRowSelectionEvent();
            this.m_changingMultipleRows = false;
        }
    }

    private void toggleRowCheckedBySelection() {
        if (this.isMultiSelection()) {
            ListSelectionModel rsm = this.getSelectionModel();
            int leadRow = rsm.getLeadSelectionIndex();
            int[] selectedRows = this.getSelectedRows();
            this.m_changingMultipleRows = selectedRows.length > 1;
            for (int row : selectedRows) {
                this.toggleRowChecked(row);
            }
            rsm.setLeadSelectionIndex(leadRow);
            if (this.m_changingMultipleRows) {
                this.fireRowSelectionEvent();
                this.m_changingMultipleRows = false;
            }
        }
    }

    @Override
    public void setRowChecked(int row, boolean setValue) {
        Object data = this.getValueAt(row, this.convertColumnIndexToView(this.getKeyColumnIndex()));
        if (data instanceof IDColumn) {
            IDColumn id = (IDColumn)data;
            id.setSelected(setValue);
        } else if (data instanceof Boolean) {
            data = setValue;
        } else {
            return;
        }
        this.setValueAt(data, row, this.convertColumnIndexToView(this.getKeyColumnIndex()));
        if (!this.m_changingMultipleRows) {
            this.fireRowSelectionEvent();
        }
    }

    public void fireRowSelectionEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        RowSelectionEvent rowSelectionEvent = new RowSelectionEvent(this, 2000);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MiniTableSelectionListener.class) continue;
            ((MiniTableSelectionListener)listeners[i + 1]).rowSelected(rowSelectionEvent);
        }
    }

    public void addMiniTableSelectionListener(MiniTableSelectionListener l) {
        this.listenerList.add(MiniTableSelectionListener.class, l);
    }

    public void removeMiniTableSelectionListener(MiniTableSelectionListener l) {
        this.listenerList.remove(MiniTableSelectionListener.class, l);
    }

    public class RowSelectionEvent
    extends AWTEvent {
        public static final int ROW_TOGGLED = 2000;

        public RowSelectionEvent(MiniTable source, int id) {
            super(source, id);
        }
    }

    public static interface MiniTableSelectionListener
    extends EventListener {
        public void rowSelected(RowSelectionEvent var1);
    }

    public class TablePropertyListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName == "model") {
                ((MiniTable)e.getSource()).setShowGrid(false);
                ((MiniTable)e.getSource()).setIntercellSpacing(new Dimension(0, 0));
            }
        }
    }
}

