/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MElementValue;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MSalesRegion;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Activity;
import org.compiere.model.X_C_BPartner;
import org.compiere.model.X_C_Campaign;
import org.compiere.model.X_C_Location;
import org.compiere.model.X_C_Project;
import org.compiere.model.X_C_SalesRegion;
import org.compiere.model.X_C_SubAcct;
import org.compiere.model.X_C_ValidCombination;
import org.compiere.model.X_Fact_Acct;
import org.compiere.model.X_M_Product;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MAccount
extends X_C_ValidCombination {
    private static final long serialVersionUID = -1936396369349550834L;
    private static CLogger s_log = CLogger.getCLogger(MAccount.class);
    private MElementValue m_accountEV = null;

    @Deprecated
    public static MAccount get(Properties ctx, int AD_Client_ID, int AD_Org_ID, int C_AcctSchema_ID, int Account_ID, int C_SubAcct_ID, int M_Product_ID, int C_BPartner_ID, int AD_OrgTrx_ID, int C_LocFrom_ID, int C_LocTo_ID, int C_SalesRegion_ID, int C_Project_ID, int C_Campaign_ID, int C_Activity_ID, int User1_ID, int User2_ID, int UserElement1_ID, int UserElement2_ID) {
        return MAccount.get(ctx, AD_Client_ID, AD_Org_ID, C_AcctSchema_ID, Account_ID, C_SubAcct_ID, M_Product_ID, C_BPartner_ID, AD_OrgTrx_ID, C_LocFrom_ID, C_LocTo_ID, C_SalesRegion_ID, C_Project_ID, C_Campaign_ID, C_Activity_ID, User1_ID, User2_ID, 0, 0, UserElement1_ID, UserElement2_ID, null);
    }

    @Deprecated
    public static MAccount get(Properties ctx, int AD_Client_ID, int AD_Org_ID, int C_AcctSchema_ID, int Account_ID, int C_SubAcct_ID, int M_Product_ID, int C_BPartner_ID, int AD_OrgTrx_ID, int C_LocFrom_ID, int C_LocTo_ID, int C_SalesRegion_ID, int C_Project_ID, int C_Campaign_ID, int C_Activity_ID, int User1_ID, int User2_ID, int UserElement1_ID, int UserElement2_ID, String trxName) {
        return MAccount.get(ctx, AD_Client_ID, AD_Org_ID, C_AcctSchema_ID, Account_ID, C_SubAcct_ID, M_Product_ID, C_BPartner_ID, AD_OrgTrx_ID, C_LocFrom_ID, C_LocTo_ID, C_SalesRegion_ID, C_Project_ID, C_Campaign_ID, C_Activity_ID, User1_ID, User2_ID, 0, 0, UserElement1_ID, UserElement2_ID, trxName);
    }

    public static MAccount get(Properties ctx, int clientId, int orgId, int acctSchemaId, int accountId, int subAcctId, int productId, int partnerId, int orgTrxId, int locFromId, int locToId, int salesRegionId, int projectId, int campaignId, int activityId, int user1Id, int User2Id, int user3Id, int user4Id, int userElement1Id, int userElement2Id, String trxName) {
        StringBuffer info = new StringBuffer();
        info.append("AD_Client_ID=").append(clientId).append(",AD_Org_ID=").append(orgId);
        info.append(",C_AcctSchema_ID=").append(acctSchemaId);
        info.append(",Account_ID=").append(accountId).append(" ");
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("AD_Client_ID=? AND AD_Org_ID=? AND C_AcctSchema_ID=? AND Account_ID=?");
        params.add(clientId);
        params.add(orgId);
        params.add(acctSchemaId);
        params.add(accountId);
        if (subAcctId == 0) {
            whereClause.append(" AND C_SubAcct_ID IS NULL");
        } else {
            whereClause.append(" AND C_SubAcct_ID=?");
            params.add(subAcctId);
        }
        if (productId == 0) {
            whereClause.append(" AND M_Product_ID IS NULL");
        } else {
            whereClause.append(" AND M_Product_ID=?");
            params.add(productId);
        }
        if (partnerId == 0) {
            whereClause.append(" AND C_BPartner_ID IS NULL");
        } else {
            whereClause.append(" AND C_BPartner_ID=?");
            params.add(partnerId);
        }
        if (orgTrxId == 0) {
            whereClause.append(" AND AD_OrgTrx_ID IS NULL");
        } else {
            whereClause.append(" AND AD_OrgTrx_ID=?");
            params.add(orgTrxId);
        }
        if (locFromId == 0) {
            whereClause.append(" AND C_LocFrom_ID IS NULL");
        } else {
            whereClause.append(" AND C_LocFrom_ID=?");
            params.add(locFromId);
        }
        if (locToId == 0) {
            whereClause.append(" AND C_LocTo_ID IS NULL");
        } else {
            whereClause.append(" AND C_LocTo_ID=?");
            params.add(locToId);
        }
        if (salesRegionId == 0) {
            whereClause.append(" AND C_SalesRegion_ID IS NULL");
        } else {
            whereClause.append(" AND C_SalesRegion_ID=?");
            params.add(salesRegionId);
        }
        if (projectId == 0) {
            whereClause.append(" AND C_Project_ID IS NULL");
        } else {
            whereClause.append(" AND C_Project_ID=?");
            params.add(projectId);
        }
        if (campaignId == 0) {
            whereClause.append(" AND C_Campaign_ID IS NULL");
        } else {
            whereClause.append(" AND C_Campaign_ID=?");
            params.add(campaignId);
        }
        if (activityId == 0) {
            whereClause.append(" AND C_Activity_ID IS NULL");
        } else {
            whereClause.append(" AND C_Activity_ID=?");
            params.add(activityId);
        }
        if (user1Id == 0) {
            whereClause.append(" AND User1_ID IS NULL");
        } else {
            whereClause.append(" AND User1_ID=?");
            params.add(user1Id);
        }
        if (User2Id == 0) {
            whereClause.append(" AND User2_ID IS NULL");
        } else {
            whereClause.append(" AND User2_ID=?");
            params.add(User2Id);
        }
        if (user3Id == 0) {
            whereClause.append(" AND User3_ID IS NULL");
        } else {
            whereClause.append(" AND User3_ID=?");
            params.add(user3Id);
        }
        if (user4Id == 0) {
            whereClause.append(" AND User4_ID IS NULL");
        } else {
            whereClause.append(" AND User4_ID=?");
            params.add(user4Id);
        }
        if (userElement1Id == 0) {
            whereClause.append(" AND UserElement1_ID IS NULL");
        } else {
            whereClause.append(" AND UserElement1_ID=?");
            params.add(userElement1Id);
        }
        if (userElement2Id == 0) {
            whereClause.append(" AND UserElement2_ID IS NULL");
        } else {
            whereClause.append(" AND UserElement2_ID=?");
            params.add(userElement2Id);
        }
        MAccount existingAccount = (MAccount)new Query(ctx, "C_ValidCombination", whereClause.toString(), trxName).setClient_ID().setParameters(params).setOnlyActiveRecords(true).firstOnly();
        if (existingAccount != null) {
            return existingAccount;
        }
        MAccount newAccount = new MAccount(ctx, 0, trxName);
        newAccount.setClientOrg(clientId, orgId);
        newAccount.setC_AcctSchema_ID(acctSchemaId);
        newAccount.setAccount_ID(accountId);
        newAccount.setC_SubAcct_ID(subAcctId);
        newAccount.setM_Product_ID(productId);
        newAccount.setC_BPartner_ID(partnerId);
        newAccount.setAD_OrgTrx_ID(orgTrxId);
        newAccount.setC_LocFrom_ID(locFromId);
        newAccount.setC_LocTo_ID(locToId);
        newAccount.setC_SalesRegion_ID(salesRegionId);
        newAccount.setC_Project_ID(projectId);
        newAccount.setC_Campaign_ID(campaignId);
        newAccount.setC_Activity_ID(activityId);
        newAccount.setUser1_ID(user1Id);
        newAccount.setUser2_ID(User2Id);
        newAccount.setUser3_ID(user3Id);
        newAccount.setUser4_ID(user4Id);
        newAccount.setUserElement1_ID(userElement1Id);
        newAccount.setUserElement2_ID(userElement2Id);
        if (!newAccount.save()) {
            s_log.log(Level.SEVERE, "Could not create new account - " + info);
            return null;
        }
        s_log.fine("New: " + newAccount);
        return newAccount;
    }

    @Deprecated
    public static MAccount get(Properties ctx, int C_AcctSchema_ID, String alias) {
        String whereClause = "C_AcctSchema_ID=? AND Alias=?";
        MAccount retValue = (MAccount)new Query(ctx, "C_ValidCombination", "C_AcctSchema_ID=? AND Alias=?", null).setParameters(C_AcctSchema_ID, alias).firstOnly();
        return retValue;
    }

    public static MAccount get(X_Fact_Acct factAcct) {
        MAccount account = MAccount.get(factAcct.getCtx(), factAcct.getAD_Client_ID(), factAcct.getAD_Org_ID(), factAcct.getC_AcctSchema_ID(), factAcct.getAccount_ID(), factAcct.getC_SubAcct_ID(), factAcct.getM_Product_ID(), factAcct.getC_BPartner_ID(), factAcct.getAD_OrgTrx_ID(), factAcct.getC_LocFrom_ID(), factAcct.getC_LocTo_ID(), factAcct.getC_SalesRegion_ID(), factAcct.getC_Project_ID(), factAcct.getC_Campaign_ID(), factAcct.getC_Activity_ID(), factAcct.getUser1_ID(), factAcct.getUser2_ID(), factAcct.getUser3_ID(), factAcct.getUser4_ID(), factAcct.getUserElement1_ID(), factAcct.getUserElement2_ID(), factAcct.get_TrxName());
        return account;
    }

    public static MAccount getDefault(Properties ctx, int acctSchemaId, boolean optionalNull, String trxName) {
        MAcctSchema acctSchema = new MAcctSchema(ctx, acctSchemaId, trxName);
        return MAccount.getDefault(acctSchema, optionalNull);
    }

    public static MAccount getDefault(MAcctSchema acctSchema, boolean optionalNull) {
        MAccount vc = new MAccount(acctSchema);
        MAcctSchemaElement[] elements = acctSchema.getAcctSchemaElements();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            boolean setValue;
            MAcctSchemaElement ase = elements[i2];
            String elementType = ase.getElementType();
            int defaultValue = ase.getDefaultValue();
            boolean bl = setValue = ase.isMandatory() || !ase.isMandatory() && !optionalNull;
            if (elementType.equals("OO")) {
                vc.setAD_Org_ID(defaultValue);
                continue;
            }
            if (elementType.equals("AC")) {
                vc.setAccount_ID(defaultValue);
                continue;
            }
            if (elementType.equals("SA") && setValue) {
                vc.setC_SubAcct_ID(defaultValue);
                continue;
            }
            if (elementType.equals("BP") && setValue) {
                vc.setC_BPartner_ID(defaultValue);
                continue;
            }
            if (elementType.equals("PR") && setValue) {
                vc.setM_Product_ID(defaultValue);
                continue;
            }
            if (elementType.equals("AY") && setValue) {
                vc.setC_Activity_ID(defaultValue);
                continue;
            }
            if (elementType.equals("LF") && setValue) {
                vc.setC_LocFrom_ID(defaultValue);
                continue;
            }
            if (elementType.equals("LT") && setValue) {
                vc.setC_LocTo_ID(defaultValue);
                continue;
            }
            if (elementType.equals("MC") && setValue) {
                vc.setC_Campaign_ID(defaultValue);
                continue;
            }
            if (elementType.equals("OT") && setValue) {
                vc.setAD_OrgTrx_ID(defaultValue);
                continue;
            }
            if (elementType.equals("PJ") && setValue) {
                vc.setC_Project_ID(defaultValue);
                continue;
            }
            if (elementType.equals("SR") && setValue) {
                vc.setC_SalesRegion_ID(defaultValue);
                continue;
            }
            if (elementType.equals("U1") && setValue) {
                vc.setUser1_ID(defaultValue);
                continue;
            }
            if (elementType.equals("U2") && setValue) {
                vc.setUser2_ID(defaultValue);
                continue;
            }
            if (elementType.equals("U3") && setValue) {
                vc.setUser3_ID(defaultValue);
                continue;
            }
            if (elementType.equals("U4") && setValue) {
                vc.setUser4_ID(defaultValue);
                continue;
            }
            if (elementType.equals("X1") && setValue) {
                vc.setUserElement1_ID(defaultValue);
                continue;
            }
            if (!elementType.equals("X2") || !setValue) continue;
            vc.setUserElement2_ID(defaultValue);
        }
        s_log.fine("Client_ID=" + vc.getAD_Client_ID() + ", Org_ID=" + vc.getAD_Org_ID() + " - AcctSchema_ID=" + vc.getC_AcctSchema_ID() + ", Account_ID=" + vc.getAccount_ID());
        return vc;
    }

    @Deprecated
    public static MAccount get(Properties ctx, int C_ValidCombination_ID) {
        return new MAccount(ctx, C_ValidCombination_ID, null);
    }

    public static MAccount getValidCombination(Properties ctx, int validCombinationId, String trxName) {
        return new MAccount(ctx, validCombinationId, trxName);
    }

    public static void updateValueDescription(Properties ctx, String where, String trxName) {
        List accounts = new Query(ctx, "C_ValidCombination", where, trxName).setOrderBy("C_ValidCombination_ID").list();
        for (MAccount account : accounts) {
            account.setValueDescription();
            account.saveEx();
        }
    }

    public MAccount(Properties ctx, int validCombinationId, String trxName) {
        super(ctx, validCombinationId, trxName);
        if (validCombinationId == 0) {
            this.setIsFullyQualified(false);
        }
    }

    public MAccount(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAccount(MAcctSchema as) {
        this(as.getCtx(), 0, as.get_TrxName());
        this.setClientOrg(as);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MAccount=[");
        sb.append(this.getC_ValidCombination_ID());
        if (this.getCombination() != null) {
            sb.append(",").append(this.getCombination());
        } else {
            sb.append(",Schema=").append(this.getC_AcctSchema_ID()).append(",Org=").append(this.getAD_Org_ID()).append(",Acct=").append(this.getAccount_ID()).append(" ");
            if (this.getC_SubAcct_ID() != 0) {
                sb.append(",C_SubAcct_ID=").append(this.getC_SubAcct_ID());
            }
            if (this.getM_Product_ID() != 0) {
                sb.append(",M_Product_ID=").append(this.getM_Product_ID());
            }
            if (this.getC_BPartner_ID() != 0) {
                sb.append(",C_BPartner_ID=").append(this.getC_BPartner_ID());
            }
            if (this.getAD_OrgTrx_ID() != 0) {
                sb.append(",AD_OrgTrx_ID=").append(this.getAD_OrgTrx_ID());
            }
            if (this.getC_LocFrom_ID() != 0) {
                sb.append(",C_LocFrom_ID=").append(this.getC_LocFrom_ID());
            }
            if (this.getC_LocTo_ID() != 0) {
                sb.append(",C_LocTo_ID=").append(this.getC_LocTo_ID());
            }
            if (this.getC_SalesRegion_ID() != 0) {
                sb.append(",C_SalesRegion_ID=").append(this.getC_SalesRegion_ID());
            }
            if (this.getC_Project_ID() != 0) {
                sb.append(",C_Project_ID=").append(this.getC_Project_ID());
            }
            if (this.getC_Campaign_ID() != 0) {
                sb.append(",C_Campaign_ID=").append(this.getC_Campaign_ID());
            }
            if (this.getC_Activity_ID() != 0) {
                sb.append(",C_Activity_ID=").append(this.getC_Activity_ID());
            }
            if (this.getUser1_ID() != 0) {
                sb.append(",User1_ID=").append(this.getUser1_ID());
            }
            if (this.getUser2_ID() != 0) {
                sb.append(",User2_ID=").append(this.getUser2_ID());
            }
            if (this.getUser3_ID() != 0) {
                sb.append(",User3_ID=").append(this.getUser3_ID());
            }
            if (this.getUser4_ID() != 0) {
                sb.append(",User4_ID=").append(this.getUser4_ID());
            }
            if (this.getUserElement1_ID() != 0) {
                sb.append(",UserElement1_ID=").append(this.getUserElement1_ID());
            }
            if (this.getUserElement2_ID() != 0) {
                sb.append(",UserElement2_ID=").append(this.getUserElement2_ID());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void setAccount_ID(int accountId) {
        this.m_accountEV = null;
        super.setAccount_ID(accountId);
    }

    @Override
    public MElementValue getAccount() {
        if (this.m_accountEV == null && this.getAccount_ID() != 0) {
            this.m_accountEV = new MElementValue(this.getCtx(), this.getAccount_ID(), this.get_TrxName());
        }
        return this.m_accountEV;
    }

    public String getAccountType() {
        if (this.m_accountEV == null) {
            this.getAccount();
        }
        if (this.m_accountEV == null) {
            this.log.log(Level.SEVERE, "No ElementValue for Account_ID=" + this.getAccount_ID());
            return "";
        }
        return this.m_accountEV.getAccountType();
    }

    public boolean isBalanceSheet() {
        String accountType = this.getAccountType();
        return "A".equals(accountType) || "L".equals(accountType) || "O".equals(accountType);
    }

    public boolean isActiva() {
        return "A".equals(this.getAccountType());
    }

    public boolean isPassiva() {
        String accountType = this.getAccountType();
        return "L".equals(accountType) || "O".equals(accountType);
    }

    public void setValueDescription() {
        StringBuffer combi = new StringBuffer();
        StringBuffer descr = new StringBuffer();
        boolean fullyQualified = true;
        MAcctSchema acctSchema = new MAcctSchema(this.getCtx(), this.getC_AcctSchema_ID(), this.get_TrxName());
        MAcctSchemaElement[] elements = MAcctSchemaElement.getAcctSchemaElements(acctSchema);
        for (int i2 = 0; i2 < elements.length; ++i2) {
            MElementValue ev;
            PO loc;
            MOrg org;
            if (i2 > 0) {
                combi.append(acctSchema.getSeparator());
                descr.append(acctSchema.getSeparator());
            }
            MAcctSchemaElement element = elements[i2];
            String combiStr = "_";
            String descrStr = "_";
            if ("OO".equals(element.getElementType())) {
                if (this.getAD_Org_ID() != 0) {
                    org = new MOrg(this.getCtx(), this.getAD_Org_ID(), this.get_TrxName());
                    combiStr = org.getValue();
                    descrStr = org.getName();
                } else {
                    combiStr = "*";
                    descrStr = "*";
                    fullyQualified = false;
                }
            } else if ("AC".equals(element.getElementType())) {
                if (this.getAccount_ID() != 0) {
                    if (this.m_accountEV == null) {
                        this.m_accountEV = new MElementValue(this.getCtx(), this.getAccount_ID(), this.get_TrxName());
                    }
                    combiStr = this.m_accountEV.getValue();
                    descrStr = this.m_accountEV.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Account");
                    fullyQualified = false;
                }
            } else if ("SA".equals(element.getElementType())) {
                if (this.getC_SubAcct_ID() != 0) {
                    X_C_SubAcct sa = new X_C_SubAcct(this.getCtx(), this.getC_SubAcct_ID(), this.get_TrxName());
                    combiStr = sa.getValue();
                    descrStr = sa.getName();
                }
            } else if ("PR".equals(element.getElementType())) {
                if (this.getM_Product_ID() != 0) {
                    X_M_Product product = new X_M_Product(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
                    combiStr = product.getValue();
                    descrStr = product.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Product");
                    fullyQualified = false;
                }
            } else if ("BP".equals(element.getElementType())) {
                if (this.getC_BPartner_ID() != 0) {
                    X_C_BPartner partner = new X_C_BPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
                    combiStr = partner.getValue();
                    descrStr = partner.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Business Partner");
                    fullyQualified = false;
                }
            } else if ("OT".equals(element.getElementType())) {
                if (this.getAD_OrgTrx_ID() != 0) {
                    org = new MOrg(this.getCtx(), this.getAD_OrgTrx_ID(), this.get_TrxName());
                    combiStr = org.getValue();
                    descrStr = org.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Trx Org");
                    fullyQualified = false;
                }
            } else if ("LF".equals(element.getElementType())) {
                if (this.getC_LocFrom_ID() != 0) {
                    loc = new MLocation(this.getCtx(), this.getC_LocFrom_ID(), this.get_TrxName());
                    combiStr = ((X_C_Location)loc).getPostal();
                    descrStr = ((X_C_Location)loc).getCity();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Location From");
                    fullyQualified = false;
                }
            } else if ("LT".equals(element.getElementType())) {
                if (this.getC_LocTo_ID() != 0) {
                    loc = new MLocation(this.getCtx(), this.getC_LocFrom_ID(), this.get_TrxName());
                    combiStr = ((X_C_Location)loc).getPostal();
                    descrStr = ((X_C_Location)loc).getCity();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Location To");
                    fullyQualified = false;
                }
            } else if ("SR".equals(element.getElementType())) {
                if (this.getC_SalesRegion_ID() != 0) {
                    loc = new MSalesRegion(this.getCtx(), this.getC_SalesRegion_ID(), this.get_TrxName());
                    combiStr = ((X_C_SalesRegion)loc).getValue();
                    descrStr = ((X_C_SalesRegion)loc).getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: SalesRegion");
                    fullyQualified = false;
                }
            } else if ("PJ".equals(element.getElementType())) {
                if (this.getC_Project_ID() != 0) {
                    X_C_Project project = new X_C_Project(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
                    combiStr = project.getValue();
                    descrStr = project.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Project");
                    fullyQualified = false;
                }
            } else if ("MC".equals(element.getElementType())) {
                if (this.getC_Campaign_ID() != 0) {
                    X_C_Campaign campaign = new X_C_Campaign(this.getCtx(), this.getC_Campaign_ID(), this.get_TrxName());
                    combiStr = campaign.getValue();
                    descrStr = campaign.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Campaign");
                    fullyQualified = false;
                }
            } else if ("AY".equals(element.getElementType())) {
                if (this.getC_Activity_ID() != 0) {
                    X_C_Activity act = new X_C_Activity(this.getCtx(), this.getC_Activity_ID(), this.get_TrxName());
                    combiStr = act.getValue();
                    descrStr = act.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Campaign");
                    fullyQualified = false;
                }
            } else if ("U1".equals(element.getElementType())) {
                if (this.getUser1_ID() != 0) {
                    ev = new MElementValue(this.getCtx(), this.getUser1_ID(), this.get_TrxName());
                    combiStr = ev.getValue();
                    descrStr = ev.getName();
                }
            } else if ("U2".equals(element.getElementType())) {
                if (this.getUser2_ID() != 0) {
                    ev = new MElementValue(this.getCtx(), this.getUser2_ID(), this.get_TrxName());
                    combiStr = ev.getValue();
                    descrStr = ev.getName();
                }
            } else if ("U3".equals(element.getElementType())) {
                if (this.getUser3_ID() != 0) {
                    ev = new MElementValue(this.getCtx(), this.getUser3_ID(), this.get_TrxName());
                    combiStr = ev.getValue();
                    descrStr = ev.getName();
                }
            } else if ("U4".equals(element.getElementType())) {
                if (this.getUser4_ID() != 0) {
                    ev = new MElementValue(this.getCtx(), this.getUser4_ID(), this.get_TrxName());
                    combiStr = ev.getValue();
                    descrStr = ev.getName();
                }
            } else if ("X1".equals(element.getElementType()) ? this.getUserElement1_ID() != 0 : !"X2".equals(element.getElementType()) || this.getUserElement2_ID() != 0) {
                // empty if block
            }
            combi.append(combiStr);
            descr.append(descrStr);
        }
        super.setCombination(combi.toString());
        super.setDescription(descr.toString());
        if (fullyQualified != this.isFullyQualified()) {
            this.setIsFullyQualified(fullyQualified);
        }
        this.log.fine("Combination=" + this.getCombination() + " - " + this.getDescription() + " - FullyQualified=" + fullyQualified);
    }

    public boolean validate() {
        X_C_SubAcct sa;
        boolean ok = true;
        if (this.getC_SubAcct_ID() != 0 && (sa = new X_C_SubAcct(this.getCtx(), this.getC_SubAcct_ID(), this.get_TrxName())).getC_ElementValue_ID() != this.getAccount_ID()) {
            this.log.saveError("Error", "C_SubAcct.C_ElementValue_ID=" + sa.getC_ElementValue_ID() + "<>Account_ID=" + this.getAccount_ID());
            ok = false;
        }
        return ok;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.setValueDescription();
        return this.validate();
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        MAccount acct = MAccount.get(Env.getCtx(), 11, 11, 101, 600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null);
        System.out.println(acct);
        System.out.println(acct.get_xmlString(new StringBuffer("xxxx")));
        MAccount acct2 = MAccount.get(Env.getCtx(), 11, 12, 101, 600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null);
        System.out.println(acct2);
    }
}

