/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrg;
import org.compiere.model.MRefList;
import org.compiere.model.Query;
import org.compiere.model.X_C_AcctSchema;
import org.compiere.report.MReportTree;
import org.compiere.util.CCache;
import org.compiere.util.KeyNamePair;

public class MAcctSchema
extends X_C_AcctSchema {
    private static final long serialVersionUID = -7228171623905614596L;
    private static CCache<Integer, MAcctSchema[]> s_schema = new CCache("AD_ClientInfo", 3);
    private static CCache<Integer, MAcctSchema> s_cache = new CCache("C_AcctSchema", 3);
    private MAcctSchemaElement[] m_elements = null;
    private MAcctSchemaGL m_gl = null;
    private MAcctSchemaDefault m_default = null;
    private MAccount m_SuspenseError_Acct = null;
    private MAccount m_CurrencyBalancing_Acct = null;
    private MAccount m_DueTo_Acct = null;
    private MAccount m_DueFrom_Acct = null;
    private int m_stdPrecision = -1;
    private int m_costPrecision = -1;
    private MOrg m_onlyOrg = null;
    private Integer[] m_onlyOrgs = null;

    public static MAcctSchema get(Properties ctx, int C_AcctSchema_ID) {
        return MAcctSchema.get(ctx, C_AcctSchema_ID, null);
    }

    public static MAcctSchema get(Properties ctx, int C_AcctSchema_ID, String trxName) {
        Integer key = new Integer(C_AcctSchema_ID);
        MAcctSchema retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MAcctSchema(ctx, C_AcctSchema_ID, trxName);
        if (trxName == null) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MAcctSchema[] getClientAcctSchema(Properties ctx, int AD_Client_ID) {
        return MAcctSchema.getClientAcctSchema(ctx, AD_Client_ID, null);
    }

    public static MAcctSchema[] getClientAcctSchema(Properties ctx, int AD_Client_ID, String trxName) {
        Integer key = new Integer(AD_Client_ID);
        if (s_schema.containsKey(key)) {
            return s_schema.get(key);
        }
        ArrayList<MAcctSchema> list = new ArrayList<MAcctSchema>();
        MClientInfo info = MClientInfo.get(ctx, AD_Client_ID, trxName);
        MAcctSchema as = MAcctSchema.get(ctx, info.getC_AcctSchema1_ID(), trxName);
        if (as.get_ID() != 0) {
            list.add(as);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        String whereClause = "IsActive=?  AND EXISTS (SELECT * FROM C_AcctSchema_GL gl WHERE C_AcctSchema.C_AcctSchema_ID=gl.C_AcctSchema_ID) AND EXISTS (SELECT * FROM C_AcctSchema_Default d WHERE C_AcctSchema.C_AcctSchema_ID=d.C_AcctSchema_ID)";
        params.add("Y");
        if (AD_Client_ID != 0) {
            whereClause = whereClause + " AND AD_Client_ID=?";
            params.add(AD_Client_ID);
        }
        List ass = new Query(ctx, "C_AcctSchema", whereClause, trxName).setParameters(params).setOrderBy("C_AcctSchema_ID").list();
        for (MAcctSchema acctschema : ass) {
            if (acctschema.get_ID() == info.getC_AcctSchema1_ID() || acctschema.get_ID() == 0) continue;
            list.add(acctschema);
        }
        MAcctSchema[] retValue = new MAcctSchema[list.size()];
        list.toArray(retValue);
        s_schema.put(key, retValue);
        return retValue;
    }

    public MAcctSchema(Properties ctx, int C_AcctSchema_ID, String trxName) {
        super(ctx, C_AcctSchema_ID, trxName);
        if (C_AcctSchema_ID == 0) {
            this.setAutoPeriodControl(true);
            this.setPeriod_OpenFuture(2);
            this.setPeriod_OpenHistory(2);
            this.setCostingMethod("S");
            this.setCostingLevel("C");
            this.setIsAdjustCOGS(false);
            this.setGAAP("UN");
            this.setHasAlias(true);
            this.setHasCombination(false);
            this.setIsAccrual(true);
            this.setCommitmentType("N");
            this.setIsDiscountCorrectsTax(false);
            this.setTaxCorrectionType("N");
            this.setIsTradeDiscountPosted(false);
            this.setIsPostServices(false);
            this.setIsExplicitCostAdjustment(false);
            this.setSeparator("-");
        }
    }

    public MAcctSchema(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAcctSchema(MClient client, KeyNamePair currency) {
        this(client.getCtx(), 0, client.get_TrxName());
        this.setClientOrg(client);
        this.setC_Currency_ID(currency.getKey());
        this.setName(client.getName() + " " + this.getGAAP() + "/" + this.get_ColumnCount() + " " + currency.getName());
    }

    public MAcctSchemaElement[] getAcctSchemaElements() {
        if (this.m_elements == null) {
            this.m_elements = MAcctSchemaElement.getAcctSchemaElements(this);
        }
        return this.m_elements;
    }

    public MAcctSchemaElement getAcctSchemaElement(String elementType) {
        if (this.m_elements == null) {
            this.getAcctSchemaElements();
        }
        for (int i2 = 0; i2 < this.m_elements.length; ++i2) {
            MAcctSchemaElement ase = this.m_elements[i2];
            if (!ase.getElementType().equals(elementType)) continue;
            return ase;
        }
        return null;
    }

    public boolean isAcctSchemaElement(String segmentType) {
        return this.getAcctSchemaElement(segmentType) != null;
    }

    public MAcctSchemaGL getAcctSchemaGL() {
        if (this.m_gl == null) {
            this.m_gl = MAcctSchemaGL.get(this.getCtx(), this.getC_AcctSchema_ID());
        }
        if (this.m_gl == null) {
            throw new IllegalStateException("No GL Definition for C_AcctSchema_ID=" + this.getC_AcctSchema_ID());
        }
        return this.m_gl;
    }

    public MAcctSchemaDefault getAcctSchemaDefault() {
        if (this.m_default == null) {
            this.m_default = MAcctSchemaDefault.get(this.getCtx(), this.getC_AcctSchema_ID());
        }
        if (this.m_default == null) {
            throw new IllegalStateException("No Default Definition for C_AcctSchema_ID=" + this.getC_AcctSchema_ID());
        }
        return this.m_default;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("AcctSchema[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public boolean isSuspenseBalancing() {
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        return this.m_gl.isUseSuspenseBalancing() && this.m_gl.getSuspenseBalancing_Acct() != 0;
    }

    public MAccount getSuspenseBalancing_Acct() {
        if (this.m_SuspenseError_Acct != null) {
            return this.m_SuspenseError_Acct;
        }
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        int validCombinationId = this.m_gl.getSuspenseBalancing_Acct();
        this.m_SuspenseError_Acct = MAccount.getValidCombination(this.getCtx(), validCombinationId, this.get_TrxName());
        return this.m_SuspenseError_Acct;
    }

    public boolean isCurrencyBalancing() {
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        return this.m_gl.isUseCurrencyBalancing();
    }

    public MAccount getCurrencyBalancing_Acct() {
        if (this.m_CurrencyBalancing_Acct != null) {
            return this.m_CurrencyBalancing_Acct;
        }
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        int validCombinationId = this.m_gl.getCurrencyBalancing_Acct();
        this.m_CurrencyBalancing_Acct = MAccount.getValidCombination(this.getCtx(), validCombinationId, this.get_TrxName());
        return this.m_CurrencyBalancing_Acct;
    }

    public MAccount getDueTo_Acct(String segment) {
        if (this.m_DueTo_Acct != null) {
            return this.m_DueTo_Acct;
        }
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        int validCombinationId = this.m_gl.getIntercompanyDueTo_Acct();
        this.m_DueTo_Acct = MAccount.getValidCombination(this.getCtx(), validCombinationId, this.get_TrxName());
        return this.m_DueTo_Acct;
    }

    public MAccount getDueFrom_Acct(String segment) {
        if (this.m_DueFrom_Acct != null) {
            return this.m_DueFrom_Acct;
        }
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        int validCombinationId = this.m_gl.getIntercompanyDueFrom_Acct();
        this.m_DueFrom_Acct = MAccount.getValidCombination(this.getCtx(), validCombinationId, this.get_TrxName());
        return this.m_DueFrom_Acct;
    }

    public void setOnlyOrgs(Integer[] orgs) {
        throw new IllegalStateException("The OnlyOrgs are now fetched automatically");
    }

    public Integer[] getOnlyOrgs() {
        if (this.m_onlyOrgs == null) {
            this.m_onlyOrgs = MReportTree.getChildIDs(this.getCtx(), 0, "OO", this.getAD_OrgOnly_ID());
        }
        return this.m_onlyOrgs;
    }

    public boolean isSkipOrg(int AD_Org_ID) {
        if (this.getAD_OrgOnly_ID() == 0) {
            return false;
        }
        if (this.getAD_OrgOnly_ID() == AD_Org_ID) {
            return false;
        }
        if (this.m_onlyOrg == null) {
            this.m_onlyOrg = MOrg.get(this.getCtx(), this.getAD_OrgOnly_ID());
        }
        if (!this.m_onlyOrg.isSummary()) {
            return true;
        }
        Integer[] onlyOrgs = this.getOnlyOrgs();
        if (onlyOrgs == null) {
            return false;
        }
        for (int i2 = 0; i2 < onlyOrgs.length; ++i2) {
            if (AD_Org_ID != onlyOrgs[i2]) continue;
            return false;
        }
        return true;
    }

    public int getStdPrecision() {
        if (this.m_stdPrecision < 0) {
            MCurrency cur = MCurrency.get(this.getCtx(), this.getC_Currency_ID());
            this.m_stdPrecision = cur.getStdPrecision();
            this.m_costPrecision = cur.getCostingPrecision();
        }
        return this.m_stdPrecision;
    }

    public int getCostingPrecision() {
        if (this.m_costPrecision < 0) {
            this.getStdPrecision();
        }
        return this.m_costPrecision;
    }

    public void checkCosting() {
        this.log.info(this.toString());
        if (this.getM_CostType_ID() == 0) {
            MCostType ct = new MCostType(this.getCtx(), 0, this.get_TrxName());
            ct.setClientOrg(this.getAD_Client_ID(), 0);
            ct.setName(this.getName());
            ct.saveEx();
            this.setM_CostType_ID(ct.getM_CostType_ID());
        }
        MCostElement.getMaterialCostElement(this);
        if (this.getCostingLevel() == null) {
            this.setCostingLevel("C");
        }
        if (this.getCostingMethod() == null) {
            this.setCostingMethod("S");
        }
        if (this.getGAAP() == null) {
            this.setGAAP("UN");
        }
    }

    public boolean isCostingLevelClient() {
        String s = this.getCostingLevel();
        return s == null || "C".equals(s);
    }

    public boolean isCostingLevelOrg() {
        return "O".equals(this.getCostingLevel());
    }

    public boolean isCostingLevelBatch() {
        return "B".equals(this.getCostingLevel());
    }

    public boolean isCreatePOCommitment() {
        String s = this.getCommitmentType();
        if (s == null) {
            return false;
        }
        return "C".equals(s) || "B".equals(s) || "A".equals(s) || "O".equals(s);
    }

    public boolean isCreateSOCommitment() {
        String s = this.getCommitmentType();
        if (s == null) {
            return false;
        }
        return "S".equals(s) || "A".equals(s) || "O".equals(s);
    }

    public boolean isCreateReservation() {
        String s = this.getCommitmentType();
        if (s == null) {
            return false;
        }
        return "B".equals(s) || "A".equals(s);
    }

    @Override
    public String getTaxCorrectionType() {
        if (super.getTaxCorrectionType() == null) {
            this.setTaxCorrectionType(this.isDiscountCorrectsTax() ? "B" : "N");
        }
        return super.getTaxCorrectionType();
    }

    public boolean isTaxCorrection() {
        return !this.getTaxCorrectionType().equals("N");
    }

    public boolean isTaxCorrectionDiscount() {
        return this.getTaxCorrectionType().equals("D") || this.getTaxCorrectionType().equals("B");
    }

    public boolean isTaxCorrectionWriteOff() {
        return this.getTaxCorrectionType().equals("W") || this.getTaxCorrectionType().equals("B");
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MClientInfo info;
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        if (super.getTaxCorrectionType() == null) {
            this.setTaxCorrectionType(this.isDiscountCorrectsTax() ? "B" : "N");
        }
        this.checkCosting();
        if (this.getAD_OrgOnly_ID() != 0 && (info = MClientInfo.get(this.getCtx(), this.getAD_Client_ID())).getC_AcctSchema1_ID() == this.getC_AcctSchema_ID()) {
            this.setAD_OrgOnly_ID(0);
        }
        if (!this.getCostingMethod().equals(this.getM_CostType().getCostingMethod())) {
            throw new AdempiereException("@M_CostType_ID@ @Not Valid@ @ActionNotAllowedHere@ @CostingMethod@ : " + MRefList.get(this.getCtx(), 122, this.getCostingMethod(), this.get_TrxName()));
        }
        return true;
    }
}

