/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MAccount;
import org.compiere.model.Query;
import org.compiere.model.X_C_Activity;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MActivity
extends X_C_Activity {
    private static final long serialVersionUID = 3014706648686670575L;
    private static CCache<Integer, MActivity> activityCacheIds = new CCache("C_Activity", 30);
    private static CCache<String, MActivity> activityCacheValues = new CCache("C_Activity", 30);

    @Deprecated
    public static MActivity get(Properties ctx, int activityId) {
        return MActivity.getById(ctx, activityId, null);
    }

    public static MActivity getById(Properties ctx, int activityId, String trxName) {
        if (activityId <= 0) {
            return null;
        }
        MActivity activity = activityCacheIds.get(activityId);
        if (activity != null && activity.get_ID() > 0) {
            return activity;
        }
        activity = (MActivity)new Query(ctx, "C_Activity", "C_Activity_ID=?", trxName).setClient_ID().setParameters(activityId).first();
        if (activity != null && activity.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID(ctx);
            String key = clientId + "#" + activity.getValue();
            activityCacheValues.put(key, activity);
            activityCacheIds.put(activity.get_ID(), activity);
        }
        return activity;
    }

    public static MActivity getByValue(Properties ctx, String activityvalue, String trxName) {
        int clientId;
        String key;
        MActivity activity;
        if (activityvalue == null) {
            return null;
        }
        if (activityCacheValues.size() == 0) {
            MActivity.getAll(ctx, true, trxName);
        }
        if ((activity = activityCacheValues.get(key = (clientId = Env.getAD_Client_ID(ctx)) + "#" + activityvalue)) != null && activity.get_ID() > 0) {
            return activity;
        }
        activity = (MActivity)new Query(ctx, "C_Activity", "Value=?", trxName).setClient_ID().setParameters(activityvalue).first();
        if (activity != null && activity.get_ID() > 0) {
            activityCacheValues.put(key, activity);
            activityCacheIds.put(activity.get_ID(), activity);
        }
        return activity;
    }

    public static List<MActivity> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || activityCacheIds.size() > 0) {
            List<MActivity> activitiesList = new Query(Env.getCtx(), "C_Activity", null, trxName).setClient_ID().setOrderBy("Name").list();
            activitiesList.stream().forEach(activity -> {
                int clientId = Env.getAD_Client_ID(ctx);
                String key = clientId + "#" + activity.getValue();
                activityCacheIds.put(activity.getC_Activity_ID(), (MActivity)activity);
                activityCacheValues.put(key, (MActivity)activity);
            });
            return activitiesList;
        }
        List<MActivity> activitiesList = activityCacheIds.entrySet().stream().map(activity -> (MActivity)activity.getValue()).collect(Collectors.toList());
        return activitiesList;
    }

    public MActivity(Properties ctx, int C_Activity_ID, String trxName) {
        super(ctx, C_Activity_ID, trxName);
    }

    public MActivity(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "C_Activity_ID=" + this.getC_Activity_ID(), this.get_TrxName());
        }
        return true;
    }
}

