/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.FA.exceptions.AssetCheckDocumentException;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetChange;
import org.compiere.model.MAssetDelivery;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.MAssetType;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MIFixedAsset;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MProduct;
import org.compiere.model.MProductDownload;
import org.compiere.model.MProject;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_M_Product;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MAsset
extends X_A_Asset {
    public static final int CHANGETYPE_setAssetGroup = Table_ID * 100 + 1;
    private static final long serialVersionUID = -7537696364072606170L;
    private MProduct m_product = null;
    private static CLogger s_log = CLogger.getCLogger(MAsset.class);
    private int m_UseLifeMonths_F = 0;
    private int m_A_Current_Period = 0;
    private Timestamp m_DateAcct = null;
    private int m_A_Depreciation_ID = 0;
    private int m_A_Depreciation_F_ID = 0;
    private BigDecimal m_A_Asset_Cost = Env.ZERO;
    private BigDecimal m_A_Accumulated_Depr = Env.ZERO;
    private BigDecimal m_A_Accumulated_Depr_F = Env.ZERO;

    public static MAsset getFromShipment(Properties properties, int n, String string) {
        MAsset mAsset = (MAsset)new Query(properties, "A_Asset", "M_InOutLine_ID=?", string).setParameters(n).first();
        return mAsset;
    }

    public static MAsset get(Properties properties, int n, String string) {
        return (MAsset)MTable.get(properties, "A_Asset").getPO(n, string);
    }

    public static Collection<MAsset> forASI(Properties properties, int n, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = "M_AttributeSetInstance_ID=?";
        arrayList.add(n2);
        if (n > 0) {
            string = string + " AND M_Product_ID=?";
            arrayList.add(n);
        }
        return new Query(properties, "A_Asset", string, null).setParameters(arrayList).list();
    }

    public MAsset(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setA_Asset_Status("NW");
        }
    }

    public MAsset(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    protected MAsset(MMatchInv mMatchInv) {
        this(mMatchInv.getCtx(), 0, mMatchInv.get_TrxName());
        MInvoiceLine mInvoiceLine = new MInvoiceLine(this.getCtx(), mMatchInv.getC_InvoiceLine_ID(), this.get_TrxName());
        MInOutLine mInOutLine = new MInOutLine(this.getCtx(), mMatchInv.getM_InOutLine_ID(), this.get_TrxName());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        this.setA_Asset_CreateDate(mInOutLine.getM_InOut().getMovementDate());
        if (mInvoiceLine.getC_Project_ID() > 0) {
            this.setC_Project_ID(mInvoiceLine.getC_Project_ID());
        }
        if (mInvoiceLine.getC_Activity_ID() > 0) {
            this.setC_Activity_ID(mInvoiceLine.getC_Activity_ID());
        }
        int n = mInvoiceLine.getA_Asset_Group_ID();
        MProduct mProduct = MProduct.get(this.getCtx(), mInvoiceLine.getM_Product_ID());
        if (n <= 0) {
            n = mProduct.getA_Asset_Group_ID();
        }
        this.setA_Asset_Group_ID(n);
        this.setHelp(Msg.getMsg(MClient.get(this.getCtx()).getAD_Language(), "CreatedFromInvoiceLine", new Object[]{mInvoiceLine.getC_Invoice().getDocumentNo(), mInvoiceLine.getLine()}));
        String string = "";
        if (mInOutLine.getM_Product_ID() > 0) {
            string = string + mProduct.getName() + "-";
            this.setM_Product_ID(mInOutLine.getM_Product_ID());
            this.setM_AttributeSetInstance_ID(mInOutLine.getM_AttributeSetInstance_ID());
        }
        string = string + mInvoiceLine.getC_Invoice().getDocumentNo();
        this.setName(string);
        this.log.fine("name=" + string);
        this.setDescription(mInvoiceLine.getDescription());
    }

    protected MAsset(MIFixedAsset mIFixedAsset) {
        this(mIFixedAsset.getCtx(), 0, mIFixedAsset.get_TrxName());
        this.setAD_Org_ID(mIFixedAsset.getAD_Org_ID());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        String string = mIFixedAsset.getInventoryNo();
        if (string != null) {
            string = string.trim();
            this.setInventoryNo(string);
            this.setValue(string);
        }
        this.setA_Asset_CreateDate(mIFixedAsset.getAssetServiceDate());
        MProduct mProduct = mIFixedAsset.getProduct();
        if (mProduct != null) {
            this.setM_Product_ID(mProduct.getM_Product_ID());
            this.setA_Asset_Group_ID(mIFixedAsset.getA_Asset_Group_ID());
            MAttributeSetInstance mAttributeSetInstance = MAttributeSetInstance.create(this.getCtx(), mProduct, this.get_TrxName());
            this.setM_AttributeSetInstance_ID(mAttributeSetInstance.getM_AttributeSetInstance_ID());
        }
        this.setDateAcct(mIFixedAsset.getDateAcct());
        this.setName(mIFixedAsset.getName());
        this.setDescription(mIFixedAsset.getDescription());
    }

    protected MAsset(MProject mProject) {
        this(mProject.getCtx(), 0, mProject.get_TrxName());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        this.setA_Asset_CreateDate(new Timestamp(System.currentTimeMillis()));
        this.setHelp(Msg.getMsg(MClient.get(this.getCtx()).getAD_Language(), "CreatedFromProject", new Object[]{mProject.getName()}));
        this.setDateAcct(new Timestamp(System.currentTimeMillis()));
        this.setDescription(mProject.getDescription());
        this.setC_Project_ID(mProject.getC_Project_ID());
    }

    public MAsset(MInOut mInOut, MInOutLine mInOutLine, int n) {
        this(mInOut.getCtx(), 0, mInOut.get_TrxName());
        this.setIsOwned(false);
        this.setIsInPosession(false);
        this.setA_Asset_CreateDate(new Timestamp(System.currentTimeMillis()));
        this.setHelp(Msg.getMsg(MClient.get(this.getCtx()).getAD_Language(), "CreatedFromShipment: ", new Object[]{mInOut.getDocumentNo()}));
        this.setDateAcct(new Timestamp(System.currentTimeMillis()));
        this.setDescription(mInOutLine.getDescription());
    }

    public MAsset(MInventory mInventory2, MInventoryLine mInventoryLine2, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(mInventoryLine2.getCtx(), 0, mInventoryLine2.get_TrxName());
        this.setClientOrg(mInventoryLine2);
        MProduct mProduct = MProduct.get(this.getCtx(), mInventoryLine2.getM_Product_ID());
        MAssetGroup mAssetGroup = MAssetGroup.get(mInventoryLine2.getCtx(), mInventoryLine2.getM_Product().getM_Product_Category().getA_Asset_Group_ID());
        if (mAssetGroup == null) {
            mAssetGroup = MAssetGroup.get(mInventoryLine2.getCtx(), mProduct.getA_Asset_Group_ID());
        }
        this.setAssetGroup(mAssetGroup);
        this.setName(mProduct.getName());
        this.setHelp(mInventoryLine2.getDescription());
        this.setAssetServiceDate(mInventory2.getMovementDate());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        this.setM_Product_ID(mProduct.getM_Product_ID());
        this.setVersionNo(mProduct.getVersionNo());
        if (mInventoryLine2.getM_AttributeSetInstance_ID() != 0) {
            MAttributeSetInstance mAttributeSetInstance = new MAttributeSetInstance(this.getCtx(), mInventoryLine2.getM_AttributeSetInstance_ID(), this.get_TrxName());
            this.setASI(mAttributeSetInstance);
        }
        this.setQty(bigDecimal);
        Optional.ofNullable(mInventoryLine2).ifPresent(mInventoryLine -> {
            if (mInventoryLine.getC_Activity_ID() > 0) {
                this.setC_Activity_ID(mInventoryLine.getC_Activity_ID());
            }
            if (mInventoryLine.getC_Project_ID() > 0) {
                this.setC_Project_ID(mInventoryLine.getC_Project_ID());
            }
        });
        Optional.ofNullable(mInventory2).ifPresent(mInventory -> {
            if (mInventory.getC_Activity_ID() > 0) {
                this.setC_Project_ID(mInventory.getC_Activity_ID());
            }
            if (mInventory.getC_Project_ID() > 0) {
                this.setC_Project_ID(mInventory.getC_Project_ID());
            }
        });
        if (MAssetType.isFixedAsset(this)) {
            this.setA_Asset_Status("NW");
        } else {
            this.setA_Asset_Status("AC");
            this.setProcessed(true);
        }
        this.setA_Asset_Status("NW");
    }

    public void setAssetGroup(MAssetGroup mAssetGroup) {
        this.setA_Asset_Group_ID(mAssetGroup.getA_Asset_Group_ID());
    }

    public MAssetGroup getAssetGroup() {
        return MAssetGroup.get(this.getCtx(), this.getA_Asset_Group_ID());
    }

    public void setASI(MAttributeSetInstance mAttributeSetInstance) {
        this.setM_AttributeSetInstance_ID(mAttributeSetInstance.getM_AttributeSetInstance_ID());
        this.setLot(mAttributeSetInstance.getLot());
        this.setSerNo(mAttributeSetInstance.getSerNo());
    }

    public MAssetDelivery[] getDeliveries() {
        List<MAssetDelivery> list = new Query(this.getCtx(), "A_Asset_Delivery", "A_Asset_ID=?", this.get_TrxName()).setParameters(this.getA_Asset_ID()).setOrderBy("Created DESC").list();
        MAssetDelivery[] mAssetDeliveryArray = new MAssetDelivery[list.size()];
        list.toArray(mAssetDeliveryArray);
        return mAssetDeliveryArray;
    }

    public int getDeliveryCount() {
        String string = "SELECT COUNT(*) FROM A_Asset_Delivery WHERE A_Asset_ID=?";
        return DB.getSQLValue(this.get_TrxName(), string, this.getA_Asset_ID());
    }

    public boolean isDownloadable() {
        if (!this.isActive()) {
            return false;
        }
        Timestamp timestamp = this.getGuaranteeDate();
        if (timestamp == null) {
            return false;
        }
        timestamp = TimeUtil.getDay(timestamp);
        Timestamp timestamp2 = TimeUtil.getDay(System.currentTimeMillis());
        if (!timestamp2.after(timestamp)) {
            this.getProduct();
            return this.m_product != null && this.m_product.hasDownloads();
        }
        return false;
    }

    public String getProductVersionNo() {
        return this.getProduct().getVersionNo();
    }

    public int getProductR_MailText_ID() {
        return this.getProduct().getR_MailText_ID();
    }

    private MProduct getProduct() {
        if (this.m_product == null) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public MProductDownload[] getProductDownloads() {
        if (this.m_product == null) {
            this.getProduct();
        }
        if (this.m_product != null) {
            return this.m_product.getProductDownloads(false);
        }
        return null;
    }

    public String[] getDownloadNames() {
        MProductDownload[] mProductDownloadArray = this.getProductDownloads();
        if (mProductDownloadArray != null && mProductDownloadArray.length > 0) {
            String[] stringArray = new String[mProductDownloadArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = mProductDownloadArray[i].getName();
            }
            this.log.fine("#" + mProductDownloadArray.length);
            return stringArray;
        }
        return new String[0];
    }

    public String[] getDownloadURLs() {
        MProductDownload[] mProductDownloadArray = this.getProductDownloads();
        if (mProductDownloadArray != null && mProductDownloadArray.length > 0) {
            String[] stringArray = new String[mProductDownloadArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = mProductDownloadArray[i].getDownloadURL();
                int n = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringArray[i] = string;
            }
            return stringArray;
        }
        return new String[0];
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        Object object;
        String string;
        if (this.getA_Parent_Asset_ID() <= 0) {
            this.setA_Parent_Asset_ID(this.getA_Asset_ID());
        }
        if ((string = this.getInventoryNo()) == null || string.trim().length() == 0 || string.equals("0")) {
            string = "" + this.get_ID();
            this.setInventoryNo(string);
        }
        if (string != null) {
            this.setInventoryNo(string.trim());
        }
        this.log.fine("InventoryNo=" + this.getInventoryNo());
        if (this.getA_Asset_Group_ID() <= 0) {
            this.setA_Asset_Group_ID(MAssetGroup.getDefault_ID(SetGetUtil.wrap(this)));
        }
        if (!this.getA_Asset_Group().equals(this.getM_Product().getM_Product_Category().getA_Asset_Group())) {
            throw new AssetCheckDocumentException("Asset Group and Product's Asset Group are different");
        }
        if (this.getA_Asset_Group_ID() > 0 && (object = MAssetGroupAcct.forA_Asset_Group_ID(this.getCtx(), this.getA_Asset_Group_ID())).size() == 0) {
            this.log.saveError("Create Asset Error: ", Msg.translate(this.getCtx(), "No Asset Group Account"));
            return false;
        }
        if (this.is_ValueChanged("C_BPartner_Location_ID") && this.getC_BPartner_Location_ID() > 0) {
            SetGetUtil.copyValues(SetGetUtil.wrap(this), "C_BPartner_Location", this.getC_BPartner_Location_ID(), new String[]{"C_Location_ID"});
        }
        if (this.getM_Product_ID() > 0 && this.getM_AttributeSetInstance_ID() <= 0) {
            object = MProduct.get(this.getCtx(), this.getM_Product_ID());
            MAttributeSetInstance mAttributeSetInstance = new MAttributeSetInstance(this.getCtx(), 0, ((X_M_Product)object).getM_AttributeSet_ID(), this.get_TrxName());
            mAttributeSetInstance.setSerNo(this.getSerNo());
            mAttributeSetInstance.setDescription();
            mAttributeSetInstance.saveEx();
            this.setM_AttributeSetInstance_ID(mAttributeSetInstance.getM_AttributeSetInstance_ID());
        }
        this.updateStatus();
        return true;
    }

    @Override
    protected boolean afterSave(boolean bl, boolean bl2) {
        if (!bl2) {
            return bl2;
        }
        String string = this.getInventoryNo();
        if (string == null || string.trim().length() == 0 || string.equals("0")) {
            string = "" + this.get_ID();
            this.setInventoryNo(string);
        }
        if (string != null) {
            this.setInventoryNo(string.trim());
        }
        this.log.fine("InventoryNo=" + this.getInventoryNo());
        if (this.getA_Parent_Asset_ID() <= 0) {
            int n = this.getA_Asset_ID();
            this.setA_Parent_Asset_ID(n);
            DB.executeUpdateEx("UPDATE A_Asset SET A_Parent_Asset_ID=A_Asset_ID WHERE A_Asset_ID=" + n, this.get_TrxName());
            this.log.fine("A_Parent_Asset_ID=" + this.getA_Parent_Asset_ID());
        }
        if (bl) {
            MAssetGroup mAssetGroup = new MAssetGroup(this.getCtx(), this.getA_Asset_Group_ID(), this.get_TrxName());
            String string2 = mAssetGroup.isDepreciated() ? "Y" : "N";
            String string3 = mAssetGroup.isOwned() ? "Y" : "N";
            this.setIsDepreciated(mAssetGroup.isDepreciated());
            this.setIsOwned(mAssetGroup.isOwned());
            DB.executeUpdateEx("UPDATE A_Asset SET IsDepreciated='" + string2 + "', isOwned ='" + string3 + "' WHERE A_Asset_ID=" + this.getA_Asset_ID(), this.get_TrxName());
            for (MAssetGroupAcct mAssetGroupAcct : MAssetGroupAcct.forA_Asset_Group_ID(this.getCtx(), this.getA_Asset_Group_ID())) {
                MAssetAcct mAssetAcct = new MAssetAcct(this, mAssetGroupAcct);
                mAssetAcct.setAD_Org_ID(this.getAD_Org_ID());
                mAssetAcct.saveEx();
                MDepreciationWorkfile mDepreciationWorkfile = new MDepreciationWorkfile(this, mAssetAcct.getPostingType(), mAssetGroupAcct);
                mDepreciationWorkfile.setAD_Org_ID(this.getAD_Org_ID());
                mDepreciationWorkfile.setUseLifeYears(0);
                mDepreciationWorkfile.setUseLifeMonths(0);
                mDepreciationWorkfile.setUseLifeYears_F(0);
                mDepreciationWorkfile.setUseLifeMonths_F(0);
                mDepreciationWorkfile.saveEx();
                MAssetChange.createAndSave(this.getCtx(), "CRT", new PO[]{this, mDepreciationWorkfile, mAssetAcct}, null);
            }
        } else {
            MAssetChange.createAndSave(this.getCtx(), "UPD", new PO[]{this}, null);
        }
        if (!bl && this.is_ValueChanged("IsDepreciated")) {
            DB.executeUpdateEx("UPDATE A_Depreciation_Workfile SET IsDepreciated=? WHERE A_Asset_ID=?", new Object[]{this.isDepreciated(), this.getA_Asset_ID()}, this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        String string = "DELETE FROM A_Asset_Addition WHERE Processed=? AND A_Asset_ID=?";
        int n = DB.executeUpdateEx(string, new Object[]{false, this.getA_Asset_ID()}, this.get_TrxName());
        this.log.info("@A_Asset_Addition@ @Deleted@ #" + n);
        n = DB.executeUpdateEx("UPDATE C_InvoiceLine SET  A_Asset_ID=?,A_Processed=? WHERE A_Asset_ID=?", new Object[]{null, false, this.getA_Asset_ID()}, this.get_TrxName());
        this.log.info("@C_InvoiceLine@ @Updated@ #" + n);
        return true;
    }

    public void updateStatus() {
        String string = this.getA_Asset_Status();
        this.setProcessed(!string.equals("NW"));
        this.setIsDisposed(string.equals("DI"));
        this.setIsFullyDepreciated(string.equals("DP"));
        if (this.isFullyDepreciated() || string.equals("DI")) {
            this.setIsDepreciated(false);
        }
        if (string.equals("AC") || this.getAssetActivationDate() == null) {
            this.setAssetActivationDate(this.getAssetServiceDate());
        }
    }

    public void changeStatus(String string, Timestamp timestamp) {
        String string2 = this.getA_Asset_Status();
        if (CLogMgt.isLevelFinest()) {
            this.log.finest("Entering: " + string2 + "->" + string + ", date=" + timestamp);
        }
        if (timestamp == null) {
            timestamp = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (string.equals("AC")) {
            this.setAssetActivationDate(timestamp);
        }
        if (string.equals("PR")) {
            this.setAssetDisposalDate(timestamp);
            List<MDepreciationWorkfile> list = MDepreciationWorkfile.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
            for (MDepreciationWorkfile mDepreciationWorkfile : list) {
                mDepreciationWorkfile.truncDepreciation();
                mDepreciationWorkfile.saveEx();
            }
        }
        if (string.equals("DI")) {
            this.setAssetDisposalDate(timestamp);
        }
        this.setA_Asset_Status(string);
    }

    public int getUseLifeMonths_F() {
        return this.m_UseLifeMonths_F;
    }

    public void setUseLifeMonths_F(int n) {
        this.m_UseLifeMonths_F = n;
    }

    public int getA_Current_Period() {
        return this.m_A_Current_Period;
    }

    public void setA_Current_Period(int n) {
        this.m_A_Current_Period = n;
    }

    public Timestamp getDateAcct() {
        return this.m_DateAcct;
    }

    public void setDateAcct(Timestamp timestamp) {
        this.m_DateAcct = timestamp;
    }

    public int getA_Depreciation_ID() {
        return this.m_A_Depreciation_ID;
    }

    public void setA_Depreciation_ID(int n) {
        this.m_A_Depreciation_ID = n;
    }

    public int getA_Depreciation_F_ID() {
        return this.m_A_Depreciation_F_ID;
    }

    public void setA_Depreciation_F_ID(int n) {
        this.m_A_Depreciation_F_ID = n;
    }

    public BigDecimal getA_Asset_Cost() {
        return this.m_A_Asset_Cost;
    }

    public void setA_Asset_Cost(BigDecimal bigDecimal) {
        this.m_A_Asset_Cost = bigDecimal;
    }

    public BigDecimal getA_Accumulated_Depr() {
        return this.m_A_Accumulated_Depr;
    }

    public void setA_Accumulated_Depr(BigDecimal bigDecimal) {
        this.m_A_Accumulated_Depr = bigDecimal;
    }

    public BigDecimal getA_Accumulated_Depr_F() {
        return this.m_A_Accumulated_Depr_F;
    }

    public void setA_Accumulated_Depr_F(BigDecimal bigDecimal) {
        this.m_A_Accumulated_Depr_F = bigDecimal;
    }
}

