/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.POCacheLocal;
import org.compiere.FA.exceptions.AssetAlreadyDepreciatedException;
import org.compiere.FA.exceptions.AssetNotImplementedException;
import org.compiere.FA.exceptions.AssetNotSupportedException;
import org.compiere.FA.exceptions.AssetStatusChangedException;
import org.compiere.model.I_A_Asset_Disposed;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetChange;
import org.compiere.model.MAssetProduct;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset_Disposed;
import org.compiere.model.X_A_Asset_Product;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;

public class MAssetDisposed
extends X_A_Asset_Disposed
implements DocAction {
    private static final long serialVersionUID = 1763997880662445638L;
    private final POCacheLocal<MInvoiceLine> m_cacheInvoiceLine = POCacheLocal.newInstance(this, MInvoiceLine.class);
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MAssetDisposed(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public static MAssetDisposed createAssetDisposed(MInvoiceLine mInvoiceLine) {
        MAssetDisposed mAssetDisposed = new MAssetDisposed(mInvoiceLine);
        mAssetDisposed.dump();
        return mAssetDisposed;
    }

    private MAssetDisposed(MInvoiceLine mInvoiceLine) {
        this(mInvoiceLine.getCtx(), 0, mInvoiceLine.get_TrxName());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entering: Project=" + mInvoiceLine);
        }
        this.setAD_Org_ID(mInvoiceLine.getAD_Org_ID());
        this.setPostingType("A");
        this.setDateDoc(mInvoiceLine.getC_Invoice().getDateInvoiced());
        this.setDateAcct(mInvoiceLine.getC_Invoice().getDateInvoiced());
        this.setA_Disposed_Date(mInvoiceLine.getC_Invoice().getDateInvoiced());
        this.setA_Disposed_Method("T1");
        this.setA_Asset_ID(mInvoiceLine.getA_Asset_ID());
        this.set_ValueNoCheck("C_Invoice_ID", mInvoiceLine.getC_Invoice_ID());
        this.setM_InvoiceLine(mInvoiceLine);
        this.saveEx(mInvoiceLine.get_TrxName());
    }

    public MInvoiceLine getM_InvoiceLine(boolean bl) {
        return this.m_cacheInvoiceLine.get(bl);
    }

    private void setM_InvoiceLine(MInvoiceLine mInvoiceLine) {
        this.set_Value("C_InvoiceLine_ID", (Object)mInvoiceLine.get_ID());
        this.m_cacheInvoiceLine.set(mInvoiceLine);
    }

    public MAssetDisposed(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MAsset getAsset() {
        return MAsset.get(this.getCtx(), this.getA_Asset_ID(), null);
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        return false;
    }

    @Override
    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "FAD", this.getAD_Org_ID());
        MAssetDisposed.updateFromAsset(this);
        this.saveEx(this.get_TrxName());
        if (this.is_Changed()) {
            throw new AssetStatusChangedException();
        }
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (mDepreciationWorkfile.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        this.setDocAction("CO");
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String completeIt() {
        Object object;
        String string;
        if (!this.m_justPrepared && !"IP".equals(string = this.prepareIt())) {
            return string;
        }
        string = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        MAsset mAsset = this.getAsset();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("asset=" + mAsset);
        }
        if (!this.isDisposal()) {
            object = this.getA_Activation_Method();
            if (!((String)object).equals("AA")) throw new AssetNotSupportedException("A_Activation_Method", (String)object);
            mAsset.changeStatus("AC", this.getDateDoc());
        } else {
            object = this.getA_Disposed_Method();
            if ("PR".equals(object)) {
                mAsset.changeStatus("PR", this.getDateDoc());
            } else if ("S_".equals(object) || "T1".equals(object)) {
                mAsset.changeStatus("DI", null);
                this.setA_Disposal_Amt(this.getA_Asset_Cost());
                this.setA_Accumulated_Depr_Delta(this.getA_Accumulated_Depr());
                this.setExpense(this.getA_Disposal_Amt().subtract(this.getA_Accumulated_Depr_Delta()));
                this.createDisposal();
            } else {
                if (!"PD".equals(object)) throw new AssetNotSupportedException("A_Disposed_Method", (String)object);
                this.createDisposal();
            }
        }
        object = MAssetProduct.getCreate(this.getCtx(), this.getA_Asset_ID(), mAsset.getM_Product_ID(), mAsset.getM_AttributeSetInstance_ID(), this.get_TrxName());
        ((X_A_Asset_Product)object).setA_QTY_Current(Env.ZERO);
        ((PO)object).setAD_Org_ID(mAsset.getAD_Org_ID());
        ((PO)object).saveEx();
        ((MAssetProduct)object).updateAsset(mAsset);
        mAsset.setA_QTY_Current(Env.ZERO);
        mAsset.setQty(Env.ZERO);
        mAsset.saveEx(this.get_TrxName());
        string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public boolean reverseAccrualIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public boolean reActivateIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public String getSummary() {
        return new StringBuffer().append(this.getDocumentNo()).append("/").append(this.getDateDoc()).toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return MClient.get(this.getCtx(), this.getAD_Client_ID()).getAcctSchema().getC_Currency_ID();
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateDoc());
        }
        if (bl || this.is_ValueChanged("DateAcct")) {
            this.setC_Period_ID(MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID()).get_ID());
        }
        if (this.getA_Disposed_Date() == null) {
            this.setA_Disposed_Date(this.getDateAcct());
        }
        return true;
    }

    public static void updateFromAsset(I_A_Asset_Disposed i_A_Asset_Disposed) {
        int n = i_A_Asset_Disposed.getA_Asset_ID();
        SetGetUtil.copyValues(SetGetUtil.wrap(i_A_Asset_Disposed), "A_Asset", n, new String[]{"IsDisposed", "A_Asset_Status", "AD_Org_ID"});
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(Env.getCtx(), n, i_A_Asset_Disposed.getPostingType(), null);
        if (mDepreciationWorkfile != null) {
            i_A_Asset_Disposed.setA_Asset_Cost(mDepreciationWorkfile.getA_Asset_Cost());
            i_A_Asset_Disposed.setA_Accumulated_Depr(mDepreciationWorkfile.getA_Accumulated_Depr());
        } else {
            i_A_Asset_Disposed.setA_Asset_Cost(Env.ZERO);
            i_A_Asset_Disposed.setA_Accumulated_Depr(Env.ZERO);
        }
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    public boolean isDisposal() {
        return !this.isDisposed();
    }

    public static void setA_Disposal_Amt(I_A_Asset_Disposed i_A_Asset_Disposed) {
        int n = 2;
        BigDecimal bigDecimal = i_A_Asset_Disposed.getA_Asset_Cost();
        BigDecimal bigDecimal2 = i_A_Asset_Disposed.getA_Disposal_Amt();
        BigDecimal bigDecimal3 = Env.ZERO;
        if (bigDecimal.signum() != 0) {
            bigDecimal3 = bigDecimal2.divide(bigDecimal, 12, RoundingMode.HALF_UP);
        }
        BigDecimal bigDecimal4 = i_A_Asset_Disposed.getA_Accumulated_Depr();
        BigDecimal bigDecimal5 = bigDecimal4.multiply(bigDecimal3).setScale(n, RoundingMode.HALF_UP);
        BigDecimal bigDecimal6 = bigDecimal2.subtract(bigDecimal5);
        i_A_Asset_Disposed.setA_Accumulated_Depr_Delta(bigDecimal5);
        i_A_Asset_Disposed.setExpense(bigDecimal6);
    }

    private void createDisposal() {
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        mDepreciationWorkfile.adjustCost(this.getA_Disposal_Amt().negate(), mDepreciationWorkfile.getA_QTY_Current().negate(), false);
        mDepreciationWorkfile.adjustAccumulatedDepr(this.getA_Accumulated_Depr_Delta().negate(), this.getA_Accumulated_Depr_Delta().negate(), false);
        mDepreciationWorkfile.saveEx();
        mDepreciationWorkfile.buildDepreciation();
        List<MDepreciationExp> list = MDepreciationExp.getNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        for (MDepreciationExp mDepreciationExp : list) {
            mDepreciationExp.deleteEx(false);
        }
        MAssetChange.createDisposal(this, mDepreciationWorkfile);
    }
}

