/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.FA.exceptions.AssetAlreadyDepreciatedException;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetChange;
import org.compiere.model.MAssetProduct;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_A_Asset_Split;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;

public class MAssetSplit
extends X_A_Asset_Split
implements DocAction {
    private static final long serialVersionUID = 20180418L;
    private String processMsg = null;
    private boolean justPrepared = false;
    Optional<MDepreciationWorkfile> optionalDepreciationWorkfile = Optional.empty();
    Optional<MAsset> optionalFixedAssetToBeSplit = Optional.empty();

    public MAssetSplit(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MAssetSplit(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (bl) {
            this.getAssetBalance().ifPresent(mDepreciationWorkfile -> {
                this.setA_Depreciation_Workfile_ID(mDepreciationWorkfile.getA_Depreciation_Workfile_ID());
                this.setA_Asset_Cost(mDepreciationWorkfile.getA_Asset_Cost());
                this.setA_Percent_Original(BigDecimal.valueOf(100L));
                this.setA_QTY_Current(mDepreciationWorkfile.getA_QTY_Current());
                if (this.getA_QTY_Split().signum() <= 0) {
                    this.setA_QTY_Split(mDepreciationWorkfile.getA_QTY_Current());
                }
            });
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean bl, boolean bl2) {
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        return true;
    }

    @Override
    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String string) {
        this.processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.processMsg != null) {
            return "IN";
        }
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), mDocType.getDocBaseType(), this.getAD_Org_ID())) {
            this.processMsg = "@PeriodClosed@";
            return "IN";
        }
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (mDepreciationWorkfile.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.processMsg != null) {
            return "IN";
        }
        this.justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String string;
        if (!this.justPrepared && !"IP".equals(string = this.prepareIt())) {
            return string;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        this.createSplit();
        string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.processMsg = string;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (mDocType.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (mDocType.isOverwriteSeqOnComplete()) {
            String string = null;
            int n = this.p_info.getColumnIndex("C_DocType_ID");
            if (n == -1) {
                n = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (n != -1) {
                string = DB.getDocumentNo(this.get_ValueAsInt(n), this.get_TrxName(), true);
            }
            if (string != null) {
                this.setDocumentNo(string);
            }
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        return this.closeIt();
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.setProcessed(false);
        return this.reverseCorrectIt();
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            stringBuffer.append(" - ").append(this.getDescription());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MAssetSplit[").append(this.getSummary()).append("]");
        return stringBuffer.toString();
    }

    private List<MAsset> createSplit() {
        ArrayList<MAsset> arrayList = new ArrayList<MAsset>();
        if (!this.isProcessed()) {
            this.getAssetBalance().ifPresent(mDepreciationWorkfile -> {
                MAsset mAsset;
                MAsset mAsset2;
                MAsset mAsset3 = this.getAssetToBeSplit();
                BigDecimal bigDecimal = BigDecimal.ZERO;
                BigDecimal bigDecimal2 = BigDecimal.ZERO;
                BigDecimal bigDecimal3 = BigDecimal.ZERO;
                if ("QTY".equals(this.getA_Split_Type())) {
                    if (this.getA_QTY_Split().signum() <= 0) {
                        throw new AdempiereException("@A_QTY_Split@ @NotFound@");
                    }
                    bigDecimal = mDepreciationWorkfile.getA_Asset_Cost().divide(this.getA_QTY_Split(), 7, 4);
                    bigDecimal2 = mDepreciationWorkfile.getA_Accumulated_Depr().divide(this.getA_QTY_Split(), 7, 4);
                    bigDecimal3 = mDepreciationWorkfile.getA_Asset_Remaining().divide(this.getA_QTY_Split(), 7, 4);
                    for (int i = 1; i < this.getA_QTY_Split().intValue() + 1; ++i) {
                        mAsset2 = this.createAssetSplit(mAsset3, (MDepreciationWorkfile)mDepreciationWorkfile, bigDecimal, bigDecimal2, bigDecimal3, i);
                        arrayList.add(mAsset2);
                    }
                }
                if ("AMT".equals(this.getA_Split_Type())) {
                    BigDecimal bigDecimal4 = this.getA_Amount_Split().divide(this.getA_Asset_Cost(), 7, 4);
                    bigDecimal = mDepreciationWorkfile.getA_Asset_Cost().subtract(this.getA_Amount_Split());
                    bigDecimal2 = mDepreciationWorkfile.getA_Accumulated_Depr().multiply(bigDecimal4);
                    bigDecimal3 = mDepreciationWorkfile.getA_Asset_Remaining().multiply(bigDecimal4);
                    mAsset2 = this.createAssetSplit(mAsset3, (MDepreciationWorkfile)mDepreciationWorkfile, mDepreciationWorkfile.getActualCost().subtract(bigDecimal), mDepreciationWorkfile.getA_Accumulated_Depr().subtract(bigDecimal2), mDepreciationWorkfile.getA_Asset_Remaining().subtract(bigDecimal3), 1);
                    arrayList.add(mAsset2);
                    mAsset = this.createAssetSplit(mAsset3, (MDepreciationWorkfile)mDepreciationWorkfile, bigDecimal, bigDecimal2, bigDecimal3, 2);
                    arrayList.add(mAsset);
                }
                if ("PER".equals(this.getA_Split_Type())) {
                    BigDecimal bigDecimal5 = this.getA_Percent_Split().divide(BigDecimal.valueOf(100L));
                    bigDecimal = mDepreciationWorkfile.getA_Asset_Cost().multiply(bigDecimal5);
                    bigDecimal2 = mDepreciationWorkfile.getA_Accumulated_Depr().multiply(bigDecimal5);
                    bigDecimal3 = mDepreciationWorkfile.getA_Asset_Remaining().multiply(bigDecimal5);
                    mAsset2 = this.createAssetSplit(mAsset3, (MDepreciationWorkfile)mDepreciationWorkfile, mDepreciationWorkfile.getActualCost().subtract(bigDecimal), mDepreciationWorkfile.getA_Accumulated_Depr().subtract(bigDecimal2), mDepreciationWorkfile.getA_Asset_Remaining().subtract(bigDecimal3), 1);
                    arrayList.add(mAsset2);
                    mAsset = this.createAssetSplit(mAsset3, (MDepreciationWorkfile)mDepreciationWorkfile, bigDecimal, bigDecimal2, bigDecimal3, 2);
                    arrayList.add(mAsset);
                }
                this.split(mAsset3);
            });
        }
        if (arrayList.size() == 0) {
            throw new AdempiereException("@A_Asset_Split_ID@ @ProcessRunError@");
        }
        return arrayList;
    }

    private void split(MAsset mAsset) {
        mAsset.changeStatus("PR", this.getDateDoc());
        MAssetProduct mAssetProduct = MAssetProduct.getCreate(this.getCtx(), this.getA_Asset_ID(), mAsset.getM_Product_ID(), mAsset.getM_AttributeSetInstance_ID(), this.get_TrxName());
        mAssetProduct.setA_QTY_Current(BigDecimal.ZERO);
        mAssetProduct.setAD_Org_ID(mAsset.getAD_Org_ID());
        mAssetProduct.saveEx();
        mAssetProduct.updateAsset(mAsset);
        mAsset.setA_QTY_Current(BigDecimal.ZERO);
        mAsset.setQty(BigDecimal.ZERO);
        mAsset.saveEx();
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        mDepreciationWorkfile.setA_Asset_Cost(BigDecimal.ZERO);
        mDepreciationWorkfile.setA_Salvage_Value(BigDecimal.ZERO);
        mDepreciationWorkfile.setA_Accumulated_Depr(BigDecimal.ZERO);
        mDepreciationWorkfile.setA_Asset_Remaining(BigDecimal.ZERO);
        mDepreciationWorkfile.setA_Accumulated_Depr_F(BigDecimal.ZERO);
        mDepreciationWorkfile.setA_Asset_Remaining_F(BigDecimal.ZERO);
        mDepreciationWorkfile.setIsDepreciated(false);
        mDepreciationWorkfile.saveEx();
        MDepreciationExp.getNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName()).forEach(mDepreciationExp -> mDepreciationExp.deleteEx(false));
        MAssetChange.createSplit(this, mDepreciationWorkfile);
    }

    private MAsset createAssetSplit(MAsset mAsset, MDepreciationWorkfile mDepreciationWorkfile, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, Integer n) {
        String string = null;
        if (n < 10) {
            string = "00" + n.toString();
        } else if (n < 100) {
            string = "0" + n.toString();
        } else if (n < 1000) {
            string = n.toString();
        }
        MAsset mAsset2 = new MAsset(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues(mAsset, mAsset2);
        mAsset2.setValue(mAsset.getValue() + string);
        mAsset2.setName(mAsset.getName() + "-" + mAsset.getInventoryNo());
        mAsset2.setInventoryNo(mAsset.getInventoryNo() + string);
        mAsset2.setA_Asset_Split_ID(this.getA_Asset_Split_ID());
        mAsset2.setA_Parent_Asset_ID(mAsset.getA_Asset_ID());
        mAsset2.setA_Asset_Status(mAsset.getA_Asset_Status());
        mAsset2.saveEx();
        MAssetProduct.getAssetProduct(mAsset).ifPresent(mAssetProduct -> {
            MAssetProduct mAssetProduct2 = new MAssetProduct(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(mAssetProduct, mAssetProduct2);
            mAssetProduct.setA_Asset_ID(mAsset2.getA_Asset_ID());
            mAssetProduct.setA_QTY_Current(BigDecimal.ONE);
            mAssetProduct.saveEx();
        });
        MDepreciationWorkfile mDepreciationWorkfile2 = Optional.ofNullable(MDepreciationWorkfile.get(this.getCtx(), mAsset2.getA_Asset_ID(), this.getPostingType(), mAsset2.get_TrxName())).orElseGet(() -> new MDepreciationWorkfile(this.getCtx(), 0, this.get_TrxName()));
        PO.copyValues(mDepreciationWorkfile, mDepreciationWorkfile2);
        mDepreciationWorkfile2.setA_Asset_ID(mAsset2.getA_Asset_ID());
        mDepreciationWorkfile2.setA_Asset_Cost(bigDecimal);
        mDepreciationWorkfile2.setA_Accumulated_Depr(bigDecimal2);
        mDepreciationWorkfile2.setA_Accumulated_Depr_F(bigDecimal2);
        mDepreciationWorkfile2.setA_Asset_Remaining(bigDecimal3);
        mDepreciationWorkfile2.setA_Asset_Remaining_F(bigDecimal3);
        mDepreciationWorkfile2.saveEx();
        this.createDepreciation(mAsset2, bigDecimal);
        MAssetChange.createAddition(this, mAsset, mAsset2, mDepreciationWorkfile2);
        return mAsset2;
    }

    private void createDepreciation(MAsset mAsset, BigDecimal bigDecimal) {
        List<MDepreciationExp> list = MDepreciationExp.getEntries(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        list.stream().filter(mDepreciationExp -> !mDepreciationExp.isProcessed()).forEach(mDepreciationExp -> {
            BigDecimal bigDecimal2;
            Object object;
            MDepreciationExp mDepreciationExp2 = new MDepreciationExp(this.getCtx(), 0, this.get_TrxName());
            BigDecimal bigDecimal3 = BigDecimal.ZERO;
            BigDecimal bigDecimal4 = BigDecimal.ZERO;
            BigDecimal bigDecimal5 = BigDecimal.ZERO;
            BigDecimal bigDecimal6 = BigDecimal.ZERO;
            BigDecimal bigDecimal7 = BigDecimal.ZERO;
            BigDecimal bigDecimal8 = BigDecimal.ZERO;
            BigDecimal bigDecimal9 = BigDecimal.ZERO;
            BigDecimal bigDecimal10 = BigDecimal.ZERO;
            if ("QTY".equals(this.getA_Split_Type())) {
                bigDecimal3 = mDepreciationExp.getA_Accumulated_Depr().divide(this.getA_QTY_Split(), 7, 4);
                bigDecimal4 = mDepreciationExp.getA_Accumulated_Depr_Delta().divide(this.getA_QTY_Split(), 7, 4);
                bigDecimal5 = mDepreciationExp.getA_Asset_Remaining().divide(this.getA_QTY_Split(), 7, 4);
                bigDecimal6 = mDepreciationExp.getExpense().divide(this.getA_QTY_Split(), 7, 4);
                bigDecimal7 = mDepreciationExp.getA_Accumulated_Depr_F().divide(this.getA_QTY_Split(), 7, 4);
                bigDecimal8 = mDepreciationExp.getA_Accumulated_Depr_F_Delta().divide(this.getA_QTY_Split(), 7, 4);
                bigDecimal9 = mDepreciationExp.getA_Asset_Remaining_F().divide(this.getA_QTY_Split(), 7, 4);
                bigDecimal10 = mDepreciationExp.getExpense_F().divide(this.getA_QTY_Split());
            }
            if ("AMT".equals(this.getA_Split_Type())) {
                object = bigDecimal.divide(mDepreciationExp.getA_Asset_Cost(), 7, 4);
                bigDecimal2 = this.getA_Amount_Split().divide(this.getA_Asset_Cost());
                bigDecimal3 = mDepreciationExp.getA_Accumulated_Depr().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal4 = mDepreciationExp.getA_Accumulated_Depr_Delta().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal5 = mDepreciationExp.getA_Asset_Remaining().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal6 = mDepreciationExp.getExpense().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal7 = mDepreciationExp.getA_Accumulated_Depr_F().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal8 = mDepreciationExp.getA_Accumulated_Depr_F_Delta().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal9 = mDepreciationExp.getA_Asset_Remaining_F().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal10 = mDepreciationExp.getExpense_F().multiply((BigDecimal)object).multiply(bigDecimal2);
            }
            if ("PER".equals(this.getA_Split_Type())) {
                object = bigDecimal.divide(mDepreciationExp.getA_Asset_Cost(), 7, 4);
                bigDecimal2 = this.getA_Percent_Split().divide(BigDecimal.valueOf(100L));
                bigDecimal3 = mDepreciationExp.getA_Accumulated_Depr().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal4 = mDepreciationExp.getA_Accumulated_Depr_Delta().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal5 = mDepreciationExp.getA_Asset_Remaining().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal6 = mDepreciationExp.getExpense().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal7 = mDepreciationExp.getA_Accumulated_Depr_F().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal8 = mDepreciationExp.getA_Accumulated_Depr_F_Delta().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal9 = mDepreciationExp.getA_Asset_Remaining_F().multiply((BigDecimal)object).multiply(bigDecimal2);
                bigDecimal10 = mDepreciationExp.getExpense_F().multiply((BigDecimal)object).multiply(bigDecimal2);
            }
            PO.copyValues(mDepreciationExp, mDepreciationExp2);
            object = "" + bigDecimal3.subtract(bigDecimal6) + "|" + bigDecimal7.subtract(bigDecimal10) + " + " + bigDecimal6 + "|" + bigDecimal10 + " = " + bigDecimal3 + "|" + bigDecimal7;
            mDepreciationExp2.setHelp((String)object);
            mDepreciationExp2.setA_Asset_ID(mAsset.getA_Asset_ID());
            mDepreciationExp2.setA_Asset_Cost(bigDecimal);
            mDepreciationExp2.setA_Accumulated_Depr(bigDecimal3);
            mDepreciationExp2.setA_Accumulated_Depr_Delta(bigDecimal4);
            mDepreciationExp2.setA_Asset_Remaining(bigDecimal5);
            mDepreciationExp2.setExpense(bigDecimal6);
            mDepreciationExp2.setA_Accumulated_Depr_F(bigDecimal7);
            mDepreciationExp2.setA_Accumulated_Depr_F_Delta(bigDecimal8);
            mDepreciationExp2.setA_Asset_Remaining_F(bigDecimal9);
            mDepreciationExp2.setExpense_F(bigDecimal10);
            mDepreciationExp2.saveEx();
        });
    }

    private MAsset getAssetToBeSplit() {
        if (!this.optionalFixedAssetToBeSplit.isPresent()) {
            this.optionalFixedAssetToBeSplit = Optional.ofNullable(new MAsset(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName()));
        }
        return this.optionalFixedAssetToBeSplit.orElseThrow(() -> new AdempiereException("@A_Asset_ID@ @NotFound@"));
    }

    public Optional<MDepreciationWorkfile> getAssetBalance() {
        if (!this.optionalDepreciationWorkfile.isPresent()) {
            this.optionalDepreciationWorkfile = Optional.ofNullable(MDepreciationWorkfile.get(this.getCtx(), this.getAssetToBeSplit().getA_Asset_ID(), this.getPostingType(), this.get_TrxName()));
        }
        return this.optionalDepreciationWorkfile;
    }

    public List<MAsset> getAssetsSplit() {
        return new Query(this.getCtx(), "A_Asset", "A_Asset_Split_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.getA_Asset_Split_ID()).list(MAsset.class);
    }
}

