/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.internet.InternetAddress;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MEMailConfig;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTree;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Client;
import org.compiere.model.X_AD_UserMail;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;

public class MClient
extends X_AD_Client {
    private static final long serialVersionUID = -6482473737885701403L;
    private static CCache<Integer, MClient> s_cache = new CCache("AD_Client", 3);
    private MClientInfo m_info = null;
    private Language m_language = null;
    private boolean m_createNew = false;
    private int m_AD_Tree_Account_ID;
    private static final String CLIENT_ACCOUNTING_DISABLED = "D";
    private static final String CLIENT_ACCOUNTING_QUEUE = "Q";
    private static final String CLIENT_ACCOUNTING_IMMEDIATE = "I";

    public static MClient get(Properties ctx, int AD_Client_ID) {
        Integer key = new Integer(AD_Client_ID);
        MClient client = s_cache.get(key);
        if (client != null) {
            return client;
        }
        client = new MClient(ctx, AD_Client_ID, null);
        s_cache.put(key, client);
        return client;
    }

    public static MClient[] getAll(Properties ctx) {
        List<MClient> list = new Query(ctx, "AD_Client", null, null).list();
        for (MClient client : list) {
            s_cache.put(new Integer(client.getAD_Client_ID()), client);
        }
        MClient[] retValue = new MClient[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MClient get(Properties ctx) {
        return MClient.get(ctx, Env.getAD_Client_ID(ctx));
    }

    public MClient(Properties ctx, int AD_Client_ID, boolean createNew, String trxName) {
        super(ctx, AD_Client_ID, trxName);
        this.m_createNew = createNew;
        if (AD_Client_ID == 0) {
            if (this.m_createNew) {
                this.setAD_Org_ID(0);
                this.setIsMultiLingualDocument(false);
                this.setIsUseBetaFunctions(true);
                this.setIsServerEMail(false);
                this.setAD_Language(Language.getBaseAD_Language());
                this.setAutoArchive("N");
                this.setMMPolicy("F");
                this.setIsPostImmediate(false);
                this.setIsCostImmediate(false);
            } else {
                this.load(this.get_TrxName());
            }
        }
    }

    public MClient(Properties ctx, int AD_Client_ID, String trxName) {
        this(ctx, AD_Client_ID, false, trxName);
    }

    public MClient(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MClient(Properties ctx, String trxName) {
        this(ctx, Env.getAD_Client_ID(ctx), trxName);
    }

    public String getSMTPHost() {
        String s = null;
        MEMailConfig eMailConfig = MEMailConfig.get(this.getCtx(), this.getAD_EMailConfig_ID());
        if (eMailConfig != null) {
            s = eMailConfig.getSMTPHost();
        }
        if (s == null) {
            s = "localhost";
        }
        return s;
    }

    public boolean isSmtpAuthorization() {
        MEMailConfig eMailConfig = MEMailConfig.get(this.getCtx(), this.getAD_EMailConfig_ID());
        if (eMailConfig != null) {
            return eMailConfig.isSmtpAuthorization();
        }
        return false;
    }

    public MClientInfo getInfo() {
        if (this.m_info == null) {
            this.m_info = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        }
        return this.m_info;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MClient[").append(this.get_ID()).append("-").append(this.getValue()).append("]");
        return sb.toString();
    }

    public int getC_Currency_ID() {
        if (this.m_info == null) {
            this.getInfo();
        }
        if (this.m_info != null) {
            return this.m_info.getC_Currency_ID();
        }
        return 0;
    }

    public Language getLanguage() {
        if (this.m_language == null) {
            this.m_language = Language.getLanguage(this.getAD_Language());
            Env.verifyLanguage(this.getCtx(), this.m_language);
        }
        return this.m_language;
    }

    @Override
    public void setAD_Language(String AD_Language) {
        this.m_language = null;
        super.setAD_Language(AD_Language);
    }

    @Override
    public String getAD_Language() {
        String s = super.getAD_Language();
        if (s == null) {
            return Language.getBaseAD_Language();
        }
        return s;
    }

    public Locale getLocale() {
        Language lang = this.getLanguage();
        if (lang != null) {
            return lang.getLocale();
        }
        return Locale.getDefault();
    }

    public boolean setupClientInfo(String language) {
        String sql = null;
        sql = Env.isBaseLanguage(language, "AD_Ref_List") ? "SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=120 AND IsActive='Y'" : "SELECT l.Value, t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Reference_ID=120 AND l.AD_Ref_List_ID=t.AD_Ref_List_ID AND l.IsActive='Y' AND t.AD_Language=" + DB.TO_STRING(language);
        int AD_Tree_Org_ID = 0;
        int AD_Tree_BPartner_ID = 0;
        int AD_Tree_Project_ID = 0;
        int AD_Tree_SalesRegion_ID = 0;
        int AD_Tree_Product_ID = 0;
        int AD_Tree_Campaign_ID = 0;
        int AD_Tree_Activity_ID = 0;
        boolean success = false;
        try {
            CPreparedStatement stmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = stmt.executeQuery();
            MTree tree = null;
            while (rs.next()) {
                String value = rs.getString(1);
                String name = this.getName() + " " + rs.getString(2);
                if (value.equals("OO")) {
                    tree = new MTree(this, name, value);
                    success = tree.save();
                    AD_Tree_Org_ID = tree.getAD_Tree_ID();
                } else if (value.equals("BP")) {
                    tree = new MTree(this, name, value);
                    success = tree.save();
                    AD_Tree_BPartner_ID = tree.getAD_Tree_ID();
                } else if (value.equals("PJ")) {
                    tree = new MTree(this, name, value);
                    success = tree.save();
                    AD_Tree_Project_ID = tree.getAD_Tree_ID();
                } else if (value.equals("SR")) {
                    tree = new MTree(this, name, value);
                    success = tree.save();
                    AD_Tree_SalesRegion_ID = tree.getAD_Tree_ID();
                } else if (value.equals("PR")) {
                    tree = new MTree(this, name, value);
                    success = tree.save();
                    AD_Tree_Product_ID = tree.getAD_Tree_ID();
                } else if (value.equals("EV")) {
                    tree = new MTree(this, name, value);
                    success = tree.save();
                    this.m_AD_Tree_Account_ID = tree.getAD_Tree_ID();
                } else if (value.equals("MC")) {
                    tree = new MTree(this, name, value);
                    success = tree.save();
                    AD_Tree_Campaign_ID = tree.getAD_Tree_ID();
                } else if (value.equals("AY")) {
                    tree = new MTree(this, name, value);
                    success = tree.save();
                    AD_Tree_Activity_ID = tree.getAD_Tree_ID();
                } else if (value.equals("MM")) {
                    success = true;
                } else {
                    tree = new MTree(this, name, value);
                    success = tree.save();
                }
                if (success) continue;
                this.log.log(Level.SEVERE, "Tree NOT created: " + name);
                break;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e1) {
            this.log.log(Level.SEVERE, "Trees", e1);
            success = false;
        }
        if (!success) {
            return false;
        }
        MClientInfo clientInfo = new MClientInfo(this, AD_Tree_Org_ID, AD_Tree_BPartner_ID, AD_Tree_Project_ID, AD_Tree_SalesRegion_ID, AD_Tree_Product_ID, AD_Tree_Campaign_ID, AD_Tree_Activity_ID, this.get_TrxName());
        success = clientInfo.save();
        return success;
    }

    public int getSetup_AD_Tree_Account_ID() {
        return this.m_AD_Tree_Account_ID;
    }

    public boolean isAutoArchive() {
        String aa = this.getAutoArchive();
        return aa != null && !aa.equals("N");
    }

    public boolean isAutoUpdateTrl(String TableName) {
        if (super.isMultiLingualDocument()) {
            return false;
        }
        if (TableName == null) {
            return false;
        }
        return !TableName.startsWith("AD") || this.getAD_Client_ID() != 0;
    }

    public MAcctSchema getAcctSchema() {
        int C_AcctSchema_ID;
        if (this.m_info == null) {
            this.m_info = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        }
        if (this.m_info != null && (C_AcctSchema_ID = this.m_info.getC_AcctSchema1_ID()) != 0) {
            return MAcctSchema.get(this.getCtx(), C_AcctSchema_ID);
        }
        return null;
    }

    @Override
    public boolean save() {
        if (this.get_ID() == 0 && !this.m_createNew) {
            return this.saveUpdate();
        }
        return super.save();
    }

    public String testEMail() {
        if (this.getRequestEMail() == null || this.getRequestEMail().length() == 0) {
            return "No Request EMail for " + this.getName();
        }
        EMail email = this.createEMail(this.getRequestEMail(), "Adempiere EMail Test", "Adempiere EMail Test: " + this.toString());
        if (email == null) {
            return "Could not create EMail: " + this.getName();
        }
        try {
            String msg = email.send();
            if ("OK".equals(msg)) {
                this.log.info("Sent Test EMail to " + this.getRequestEMail());
                return "OK";
            }
            this.log.warning("Could NOT send Test EMail from " + this.getSMTPHost() + ": " + this.getRequestEMail() + " (" + this.getRequestUser() + ") to " + this.getRequestEMail() + ": " + msg);
            return msg;
        }
        catch (Exception ex) {
            this.log.severe(this.getName() + " - " + ex.getLocalizedMessage());
            return ex.getLocalizedMessage();
        }
    }

    public boolean sendEMail(int AD_User_ID, String subject, String message, File attachment) {
        ArrayList<File> attachments = new ArrayList<File>();
        if (attachment != null) {
            attachments.add(attachment);
        }
        return this.sendEMailAttachments(AD_User_ID, subject, message, attachments);
    }

    public boolean sendEMailAttachments(int AD_User_ID, String subject, String message, Collection<File> attachments) {
        return this.sendEMailAttachments(AD_User_ID, subject, message, attachments, false);
    }

    public boolean sendEMailAttachments(int AD_User_ID, String subject, String message, Collection<File> attachments, boolean html) {
        MUser to = MUser.get(this.getCtx(), AD_User_ID);
        String toEMail = to.getEMail();
        if (toEMail == null || toEMail.length() == 0) {
            this.log.warning("No EMail for recipient: " + to);
            return false;
        }
        EMail email = this.createEMail(null, to, subject, message, html);
        if (email == null) {
            return false;
        }
        email.addAttachments(attachments);
        try {
            return this.sendEmailNow(null, to, email);
        }
        catch (Exception ex) {
            this.log.severe(this.getName() + " - " + ex.getLocalizedMessage());
            return false;
        }
    }

    public boolean sendEMail(String to, String subject, String message, File attachment) {
        return this.sendEMail(to, subject, message, attachment, false);
    }

    public boolean sendEMail(String to, String subject, String message, File attachment, boolean html) {
        EMail email = this.createEMail(to, subject, message, html);
        if (email == null) {
            return false;
        }
        if (attachment != null) {
            email.addAttachment(attachment);
        }
        try {
            String msg = email.send();
            if ("OK".equals(msg)) {
                this.log.info("Sent EMail " + subject + " to " + to);
                return true;
            }
            this.log.warning("Could NOT Send Email: " + subject + " to " + to + ": " + msg + " (" + this.getName() + ")");
            return false;
        }
        catch (Exception ex) {
            this.log.severe(this.getName() + " - " + ex.getLocalizedMessage());
            return false;
        }
    }

    public boolean sendEMail(MUser from, MUser to, String subject, String message, File attachment) {
        return this.sendEMail(from, to, subject, message, attachment, false);
    }

    public boolean sendEMail(MUser from, MUser to, String subject, String message, File attachment, boolean isHtml) {
        EMail email = this.createEMail(from, to, subject, message, isHtml);
        if (email == null) {
            return false;
        }
        if (attachment != null) {
            email.addAttachment(attachment);
        }
        InternetAddress emailFrom = email.getFrom();
        try {
            return this.sendEmailNow(from, to, email);
        }
        catch (Exception ex) {
            this.log.severe(this.getName() + " - from " + emailFrom + " to " + to + ": " + ex.getLocalizedMessage());
            return false;
        }
    }

    public boolean sendEmailNow(MUser from, MUser to, EMail email) {
        String msg = email.send();
        X_AD_UserMail um = new X_AD_UserMail(this.getCtx(), 0, null);
        um.setClientOrg(this);
        um.setAD_User_ID(to.getAD_User_ID());
        um.setSubject(email.getSubject());
        um.setMailText(email.getMessageCRLF());
        if (email.isSentOK()) {
            um.setMessageID(email.getMessageID());
        } else {
            um.setMessageID(email.getSentMsg());
            um.setIsDelivered("N");
        }
        um.saveEx();
        if (email.isSentOK()) {
            if (from != null) {
                this.log.info("Sent Email: " + email.getSubject() + " from " + from.getEMail() + " to " + to.getEMail());
            } else {
                this.log.info("Sent Email: " + email.getSubject() + " to " + to.getEMail());
            }
            return true;
        }
        if (from != null) {
            this.log.warning("Could NOT Send Email: " + email.getSubject() + " from " + from.getEMail() + " to " + to.getEMail() + ": " + msg + " (" + this.getName() + ")");
        } else {
            this.log.warning("Could NOT Send Email: " + email.getSubject() + " to " + to.getEMail() + ": " + msg + " (" + this.getName() + ")");
        }
        return false;
    }

    public EMail createEMail(String to, String subject, String message) {
        return this.createEMail(to, subject, message, false);
    }

    public EMail createEMail(String to, String subject, String message, boolean html) {
        if (to == null || to.length() == 0) {
            this.log.warning("No To");
            return null;
        }
        EMail email = null;
        if (this.isServerEMail() && Ini.isClient()) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    if (html && message != null) {
                        message = "ContentType=text/html;" + message;
                    }
                    email = server.createEMail(Env.getRemoteCallCtx(this.getCtx()), this.getAD_Client_ID(), to, subject, message);
                } else {
                    this.log.log(Level.WARNING, "No AppsServer");
                }
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, this.getName() + " - AppsServer error", ex);
            }
        }
        if (email == null) {
            email = new EMail(this, this.getAD_EMailConfig_ID(), this.getRequestEMail(), to, subject, message, html);
        }
        if (this.isSmtpAuthorization()) {
            email.createAuthenticator(this.getRequestUser(), this.getRequestUserPW());
        }
        return email;
    }

    public EMail createEMail(MUser from, MUser to, String subject, String message) {
        return this.createEMail(from, to, subject, message, false);
    }

    public EMail createEMail(MUser from, MUser to, String subject, String message, boolean html) {
        if (to == null) {
            this.log.warning("No To user");
            return null;
        }
        if (to.getEMail() == null || to.getEMail().length() == 0) {
            this.log.warning("No To address: " + to);
            return null;
        }
        return this.createEMail(from, to.getEMail(), subject, message, html);
    }

    public EMail createEMail(MUser from, String to, String subject, String message) {
        return this.createEMail(from, to, subject, message, false);
    }

    public EMail createEMail(MUser from, String to, String subject, String message, boolean html) {
        if (to == null || to.length() == 0) {
            this.log.warning("No To address");
            return null;
        }
        if (from == null) {
            return this.createEMail(to, subject, message, html);
        }
        if (from.getEMail() == null || from.getEMailUser() == null || this.isSmtpAuthorization() && from.getEMailUserPW() == null) {
            this.log.warning("From EMail incomplete: " + from + " (" + this.getName() + ")");
            return null;
        }
        EMail email = null;
        if (this.isServerEMail() && Ini.isClient()) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    if (html && message != null) {
                        message = "ContentType=text/html;" + message;
                    }
                    email = server.createEMail(Env.getRemoteCallCtx(this.getCtx()), this.getAD_Client_ID(), from.getAD_User_ID(), to, subject, message);
                } else {
                    this.log.log(Level.WARNING, "No AppsServer");
                }
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, this.getName() + " - AppsServer error", ex);
            }
        }
        if (email == null) {
            email = new EMail(this, from.getAD_EMailConfig_ID(), from.getEMail(), to, subject, message, html);
        }
        if (from.getAD_EMailConfig_ID() != 0) {
            MEMailConfig emailConfig = MEMailConfig.get(this.getCtx(), from.getAD_EMailConfig_ID());
            if (emailConfig.isSmtpAuthorization() || emailConfig.getAuthMechanism().equals("O")) {
                email.createAuthenticator(from.getEMailUser(), from.getEMailUserPW());
            }
        } else if (this.isSmtpAuthorization()) {
            email.createAuthenticator(from.getEMailUser(), from.getEMailUserPW());
        }
        return email;
    }

    public static boolean isClientAccounting() {
        String ca = MSysConfig.getValue("CLIENT_ACCOUNTING", CLIENT_ACCOUNTING_DISABLED, Env.getAD_Client_ID(Env.getCtx()));
        return ca.equalsIgnoreCase(CLIENT_ACCOUNTING_IMMEDIATE) || ca.equalsIgnoreCase(CLIENT_ACCOUNTING_QUEUE);
    }

    public static boolean isClientAccountingQueue() {
        String ca = MSysConfig.getValue("CLIENT_ACCOUNTING", CLIENT_ACCOUNTING_DISABLED, Env.getAD_Client_ID(Env.getCtx()));
        return ca.equalsIgnoreCase(CLIENT_ACCOUNTING_QUEUE);
    }

    public static boolean isClientAccountingImmediate() {
        String ca = MSysConfig.getValue("CLIENT_ACCOUNTING", CLIENT_ACCOUNTING_DISABLED, Env.getAD_Client_ID(Env.getCtx()));
        return ca.equalsIgnoreCase(CLIENT_ACCOUNTING_IMMEDIATE);
    }
}

