/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_Column;
import org.compiere.model.MClient;
import org.compiere.model.MField;
import org.compiere.model.MSequence;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Column;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MColumn
extends X_AD_Column {
    private static final long serialVersionUID = 3455817869952578951L;
    private static CCache<Integer, MColumn> s_cache = new CCache("AD_Column", 20);
    private static CLogger s_log = CLogger.getCLogger(MColumn.class);

    public static boolean isEncrypted(int columnId) {
        String sql = "SELECT IsEncrypted FROM AD_Column WHERE AD_Column_ID = ?";
        return "Y".equals(DB.getSQLValueString(null, "SELECT IsEncrypted FROM AD_Column WHERE AD_Column_ID = ?", columnId));
    }

    public static I_AD_Column setAD_Column(Properties ctx, I_AD_Column column, String trxName) {
        String entityType;
        MTable table2 = (MTable)column.getAD_Table();
        M_Element element = new M_Element(ctx, column.getAD_Element_ID(), trxName);
        if (element.getAD_Reference_ID() == 13) {
            String columnName = table2.getTableName() + "_ID";
            String tableDir = element.getColumnName().replace("_ID", "");
            if (!columnName.equals(element.getColumnName()) && MTable.getTable_ID(tableDir) > 0) {
                column.setAD_Reference_ID(19);
            }
        }
        if ((entityType = column.getAD_Table().getEntityType()) == null) {
            throw new AdempiereException("@EntityType@ @@AD_Table_ID@ @NotFound@");
        }
        if (!"D".equals(entityType)) {
            column.setEntityType(entityType);
        }
        if (column.getColumnName() == null || column.getColumnName().length() <= 0) {
            column.setColumnName(element.getColumnName());
        }
        if (column.getFieldLength() <= 0) {
            column.setFieldLength(element.getFieldLength());
        }
        if (column.getAD_Reference_ID() <= 0) {
            column.setAD_Reference_ID(element.getAD_Reference_ID());
        }
        if (column.getAD_Reference_Value_ID() <= 0) {
            column.setAD_Reference_Value_ID(element.getAD_Reference_Value_ID());
        }
        if (column.getName() == null || column.getName().length() <= 0) {
            column.setName(element.getName());
        }
        if (column.getDescription() == null || column.getDescription().length() <= 0) {
            column.setDescription(element.getDescription());
        }
        if (column.getHelp() == null || column.getHelp().length() <= 0) {
            column.setHelp(element.getHelp());
        }
        return column;
    }

    public static MColumn get(Properties ctx, int AD_Column_ID) {
        Integer key = new Integer(AD_Column_ID);
        MColumn retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MColumn(ctx, AD_Column_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static String getColumnName(Properties ctx, int AD_Column_ID) {
        MColumn col = MColumn.get(ctx, AD_Column_ID);
        if (col.get_ID() == 0) {
            return null;
        }
        return col.getColumnName();
    }

    public MColumn(Properties ctx, int AD_Column_ID, String trxName) {
        super(ctx, AD_Column_ID, trxName);
        if (AD_Column_ID == 0) {
            this.setIsAlwaysUpdateable(false);
            this.setIsEncrypted(false);
            this.setIsIdentifier(false);
            this.setIsKey(false);
            this.setIsMandatory(false);
            this.setIsParent(false);
            this.setIsSelectionColumn(false);
            this.setIsTranslated(false);
            this.setIsUpdateable(true);
            this.setVersion(Env.ZERO);
        }
    }

    public MColumn(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn(MTable parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
    }

    public MColumn(MTable parent, String columnName, int length, int AD_Reference, String defaultValue) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
        this.setColumnName(columnName);
        M_Element AD_Element = M_Element.get(this.getCtx(), columnName);
        if (AD_Element != null) {
            this.setAD_Element_ID(AD_Element.get_ID());
        }
        this.setName(columnName);
        this.setIsActive(true);
        this.setVersion(Env.ONE);
        this.setIsMandatory(true);
        this.setIsAllowLogging(true);
        this.setFieldLength(length);
        this.setAD_Reference_ID(AD_Reference);
        this.setDefaultValue(defaultValue);
        this.setUpdateable(false);
    }

    public boolean isStandardColumn() {
        String columnName = this.getColumnName();
        return columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || columnName.equals("IsActive") || columnName.startsWith("Created") || columnName.startsWith("Updated");
    }

    public boolean isVirtualColumn() {
        String s = this.getColumnSQL();
        return s != null && s.length() > 0;
    }

    public boolean isEncrypted() {
        String s = this.getIsEncrypted();
        return "Y".equals(s);
    }

    public void setIsEncrypted(boolean IsEncrypted) {
        this.setIsEncrypted(IsEncrypted ? "Y" : "N");
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord) {
            MColumn.setAD_Column(this.getCtx(), this, this.get_TrxName());
            if (!this.isDirectLoad() && "DocumentNo".equals(this.getColumnName()) || !this.isDirectLoad() && "Value".equals(this.getColumnName())) {
                String tableName = MTable.getTableName(this.getCtx(), this.getAD_Table_ID());
                String whereClause = "AD_Client_ID=? AND Name=? ";
                Arrays.stream(MClient.getAll(this.getCtx())).forEach(client -> {
                    MSequence sequence = (MSequence)new Query(this.getCtx(), "AD_Sequence", "AD_Client_ID=? AND Name=? ", this.get_TrxName()).setParameters(client.getAD_Client_ID(), "DocumentNo_" + tableName).first();
                    if (sequence == null || sequence.getAD_Sequence_ID() <= 0) {
                        sequence = new MSequence(this.getCtx(), client.getAD_Client_ID(), tableName, this.get_TrxName());
                        sequence.saveEx();
                    }
                });
            }
            if (!this.isDirectLoad()) {
                this.setIsAllowCopy(MColumn.isAllowCopy(this.getColumnName(), this.getAD_Reference_ID()));
            }
        }
        this.setFieldLength(DisplayType.getDBDataLength(this));
        if (!this.isDirectLoad() && this.get_Value("AD_Element_ID").equals(this.get_ValueOld("AD_Element_ID"))) {
            MColumn.validLookup(this.getColumnName(), this.getAD_Reference_ID(), this.getAD_Reference_Value_ID());
        }
        if (this.isVirtualColumn()) {
            if (this.isMandatory()) {
                this.setIsMandatory(false);
            }
            if (this.isUpdateable()) {
                this.setIsUpdateable(false);
            }
        }
        if (this.isParent() || this.isKey()) {
            this.setIsUpdateable(false);
        }
        if (this.isAlwaysUpdateable() && !this.isUpdateable()) {
            this.setIsAlwaysUpdateable(false);
        }
        if (this.isEncrypted()) {
            int dt = this.getAD_Reference_ID();
            if (this.isKey() || this.isParent() || this.isStandardColumn() || this.isVirtualColumn() || this.isIdentifier() || this.isTranslated() || DisplayType.isLookup(dt) || DisplayType.isLOB(dt) || "DocumentNo".equalsIgnoreCase(this.getColumnName()) || "Value".equalsIgnoreCase(this.getColumnName()) || "Name".equalsIgnoreCase(this.getColumnName())) {
                this.log.warning("Encryption not sensible - " + this.getColumnName());
                this.setIsEncrypted(false);
            }
        }
        if ((newRecord || this.is_ValueChanged("AD_Element_ID")) && this.getAD_Element_ID() != 0) {
            M_Element element = new M_Element(this.getCtx(), this.getAD_Element_ID(), this.get_TrxName());
            if (element.is_new()) {
                throw new AdempiereException("@AD_Element_ID@ " + this.getAD_Element_ID() + " @NotFound@");
            }
            this.setColumnName(element.getColumnName());
            this.setName(element.getName());
            this.setDescription(element.getDescription());
            this.setHelp(element.getHelp());
        }
        return true;
    }

    public static void validLookup(String p_ColumnName, int p_AD_Reference_ID, int p_AD_Reference_Value_ID) {
        if (p_ColumnName == null || p_ColumnName.trim().length() == 0 || !DisplayType.isLookup(p_AD_Reference_ID)) {
            return;
        }
        String m_TableName = p_ColumnName.replace("_ID", "");
        if (p_AD_Reference_ID == 19) {
            if (!p_ColumnName.endsWith("_ID")) {
                throw new AdempiereException("@Reference@ @of@ @ColumnName@ @NotValid@");
            }
            MTable table2 = MTable.get(Env.getCtx(), m_TableName);
            if (table2 == null) {
                throw new AdempiereException("@AD_Table_ID@ @NotFound@");
            }
        } else if (p_AD_Reference_ID == 18 || p_AD_Reference_ID == 30 ? p_AD_Reference_Value_ID == 0 && !M_Element.isLookupColumnName(p_ColumnName, p_AD_Reference_ID) : p_AD_Reference_ID == 17 && p_AD_Reference_Value_ID == 0) {
            throw new AdempiereException("@AD_Reference_Value_ID@ @IsMandatory@");
        }
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help"))) {
            StringBuffer whereClause = new StringBuffer("AD_Column_ID=? ").append(" AND IsCentrallyMaintained=? ");
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(this.getAD_Column_ID());
            parameters.add(true);
            List fields = new Query(this.getCtx(), "AD_Field", whereClause.toString(), this.get_TrxName()).setParameters(parameters).list();
            int no = 0;
            for (MField field : fields) {
                field.setName(this.getName());
                field.setDescription(this.getDescription());
                field.setHelp(this.getHelp());
                field.saveEx();
                ++no;
            }
            this.log.fine("afterSave - Fields updated #" + no);
        }
        return success;
    }

    public String getSQLAdd(MTable table2) {
        if (this.isVirtualColumn()) {
            return null;
        }
        StringBuffer sql = new StringBuffer("ALTER TABLE ").append(table2.getTableName()).append(" ADD ").append(this.getSQLDDL());
        String constraint = this.getConstraint(table2.getTableName());
        if (constraint != null && constraint.length() > 0) {
            sql.append("; ").append("ALTER TABLE ").append(table2.getTableName()).append(" ADD ").append(constraint);
        }
        return sql.toString();
    }

    public String getSQLDDL() {
        if (this.isVirtualColumn()) {
            return null;
        }
        StringBuffer sql = new StringBuffer(this.getColumnName()).append(" ").append(this.getSQLDataType());
        String defaultValue = this.getDefaultValue();
        if (!(defaultValue == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID(this.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if ((DisplayType.isText(this.getAD_Reference_ID()) || this.getAD_Reference_ID() == 17 || this.getAD_Reference_ID() == 20 || this.getColumnName().equals("EntityType") || this.getColumnName().equals("AD_Language") || this.getAD_Reference_ID() == 28 && !this.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING(defaultValue);
            }
            sql.append(" DEFAULT ").append(defaultValue);
        } else {
            if (!this.isMandatory()) {
                sql.append(" DEFAULT NULL ");
            }
            defaultValue = null;
        }
        if (this.getAD_Reference_ID() == 20) {
            sql.append(" CHECK (").append(this.getColumnName()).append(" IN ('Y','N'))");
        }
        if (this.isMandatory()) {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    private String getDefaultValueSQL() {
        String defaultValue = this.getDefaultValue();
        if (!(defaultValue == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID(this.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if ((DisplayType.isText(this.getAD_Reference_ID()) || this.getAD_Reference_ID() == 17 || this.getAD_Reference_ID() == 20 || this.getColumnName().equals("EntityType") || this.getColumnName().equals("AD_Language") || this.getAD_Reference_ID() == 28 && !this.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING(defaultValue);
            }
            return defaultValue;
        }
        return null;
    }

    public String getSQLModify(MTable table2, boolean setNullOption) {
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlBase = new StringBuffer("ALTER TABLE ").append(table2.getTableName()).append(" MODIFY ").append(this.getColumnName());
        StringBuffer sqlDefault = new StringBuffer(sqlBase).append(" ").append(this.getSQLDataType());
        String defaultValue = this.getDefaultValueSQL();
        if (defaultValue != null) {
            sqlDefault.append(" DEFAULT ").append(defaultValue);
        } else if (!this.isMandatory()) {
            sqlDefault.append(" DEFAULT NULL ");
        }
        sql.append(sqlDefault);
        if (this.isMandatory() && defaultValue != null && defaultValue.length() > 0) {
            StringBuffer sqlSet = new StringBuffer("UPDATE ").append(table2.getTableName()).append(" SET ").append(this.getColumnName()).append("=").append(defaultValue).append(" WHERE ").append(this.getColumnName()).append(" IS NULL");
            sql.append("; ").append(sqlSet);
        }
        if (setNullOption) {
            StringBuffer sqlNull = new StringBuffer(sqlBase);
            if (this.isMandatory()) {
                sqlNull.append(" NOT NULL");
            } else {
                sqlNull.append(" NULL");
            }
            sql.append("; ").append(sqlNull);
        }
        return sql.toString();
    }

    public String getSQLDataType() {
        String columnName = this.getColumnName();
        int dt = this.getAD_Reference_ID();
        return DisplayType.getSQLDataType(dt, columnName, this.getFieldLength(), this.getAD_Reference_Value_ID());
    }

    public String getConstraint(String tableName) {
        if (this.isKey()) {
            String constraintName = tableName.length() > 26 ? tableName.substring(0, 26) + "_Key" : tableName + "_Key";
            return "CONSTRAINT " + constraintName + " PRIMARY KEY (" + this.getColumnName() + ")";
        }
        return "";
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MColumn[");
        sb.append(this.get_ID()).append("-").append(this.getColumnName()).append("]");
        return sb.toString();
    }

    public static int getColumn_ID(String tableName, String columnName) {
        int m_table_id = MTable.getTable_ID(tableName);
        if (m_table_id == 0) {
            return 0;
        }
        int retValue = 0;
        String SQL = "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID = ?  AND columnname = ?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, m_table_id);
            pstmt.setString(2, columnName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, SQL, e);
            retValue = -1;
        }
        return retValue;
    }

    public static int getTable_ID(Properties ctx, int AD_Column_ID, String trxName) {
        String sqlStmt = "SELECT AD_Table_ID FROM AD_Column WHERE AD_Column_ID=?";
        return DB.getSQLValue(trxName, sqlStmt, AD_Column_ID);
    }

    public String syncDatabase() {
        String string;
        MTable table2 = new MTable(this.getCtx(), this.getAD_Table_ID(), this.get_TrxName());
        if (table2.isView()) {
            return "Cannot sync view";
        }
        table2.set_TrxName(this.get_TrxName());
        if (table2.get_ID() == 0) {
            throw new AdempiereException("@NotFound@ @AD_Table_ID@ " + this.getAD_Table_ID());
        }
        Connection conn = null;
        try {
            String columnName;
            conn = DB.getConnectionRO();
            DatabaseMetaData md = conn.getMetaData();
            String catalog = DB.getDatabase().getCatalog();
            String schema = DB.getDatabase().getSchema();
            String tableName = table2.getTableName();
            if (md.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            } else if (md.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            }
            int noColumns = 0;
            boolean existsColumn = false;
            String sql = null;
            ResultSet rs = md.getColumns(catalog, schema, tableName, null);
            while (rs.next()) {
                ++noColumns;
                columnName = rs.getString("COLUMN_NAME");
                if (!columnName.equalsIgnoreCase(this.getColumnName())) continue;
                existsColumn = true;
                boolean currentNotNull = 0 == rs.getInt("NULLABLE");
                int currentDataType = rs.getInt("DATA_TYPE");
                int currentColumnSize = rs.getInt("COLUMN_SIZE");
                String currentColumnDef = rs.getString("COLUMN_DEF");
                String columnDef = this.getDefaultValueSQL();
                if (DisplayType.isSameType(this, currentDataType, currentColumnSize) && this.isMandatory() == currentNotNull && (currentColumnDef == null || columnDef == null || currentColumnDef.startsWith(columnDef))) break;
                sql = this.getSQLModify(table2, this.isMandatory() != currentNotNull);
                break;
            }
            rs.close();
            rs = null;
            if (noColumns == 0) {
                sql = table2.getSQLCreate();
            } else if (sql == null && !existsColumn) {
                sql = this.getSQLAdd(table2);
            }
            if (sql == null) {
                columnName = "OK";
                return columnName;
            }
            if (sql.indexOf("; ") == -1) {
                DB.executeUpdateEx(sql, null);
            } else {
                String[] statements = sql.split("; ");
                for (int i2 = 0; i2 < statements.length; ++i2) {
                    DB.executeUpdateEx(statements[i2], null);
                }
            }
            POInfo.removeFromCache(this.getAD_Table_ID());
            string = sql;
        }
        catch (SQLException e) {
            throw new AdempiereException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }

    public static boolean isSuggestSelectionColumn(String columnName, boolean caseSensitive) {
        if (Util.isEmpty(columnName, true)) {
            return false;
        }
        if (columnName.equals("Value") || !caseSensitive && columnName.equalsIgnoreCase("Value")) {
            return true;
        }
        if (columnName.equals("Name") || !caseSensitive && columnName.equalsIgnoreCase("Name")) {
            return true;
        }
        if (columnName.equals("DocumentNo") || !caseSensitive && columnName.equalsIgnoreCase("DocumentNo")) {
            return true;
        }
        if (columnName.equals("Description") || !caseSensitive && columnName.equalsIgnoreCase("Description")) {
            return true;
        }
        return columnName.indexOf("Name") != -1 || !caseSensitive && columnName.toUpperCase().indexOf("Name".toUpperCase()) != -1;
    }

    public static boolean isForSynchronizeColumn(String columnName) {
        if (Util.isEmpty(columnName, true)) {
            return false;
        }
        return columnName.equals("IsMandatory") || columnName.equals("IsParent") || columnName.equals("ColumnName") || columnName.equals("AD_Reference_ID") || columnName.equals("FieldLength") || columnName.equals("IsKey") || columnName.equals("DefaultValue");
    }

    public static boolean isAllowCopy(Properties ctx, int p_AD_Column_ID) {
        MColumn column = MColumn.get(ctx, p_AD_Column_ID);
        if (column != null) {
            MColumn.isAllowCopy(column.getColumnName(), column.getAD_Reference_ID());
            return true;
        }
        return false;
    }

    public static boolean isAllowCopy(String columnName, int referenceId) {
        return 13 != referenceId && 21 != referenceId && !M_Element.isReservedColumnName(columnName);
    }
}

