/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MCommissionLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Commission;
import org.compiere.util.DB;

public class MCommission
extends X_C_Commission {
    private static final long serialVersionUID = 1786202619739310928L;

    public MCommission(Properties ctx, int C_Commission_ID, String trxName) {
        super(ctx, C_Commission_ID, trxName);
        if (C_Commission_ID == 0) {
            this.setDocBasisType("I");
            this.setFrequencyType("M");
            this.setListDetails(false);
        }
    }

    public MCommission(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCommissionLine[] getLines() {
        String whereClause = "IsActive='Y' AND C_Commission_ID=?";
        List<MCommissionLine> list = new Query(this.getCtx(), "C_CommissionLine", "IsActive='Y' AND C_Commission_ID=?", this.get_TrxName()).setParameters(this.getC_Commission_ID()).setOrderBy("Line").list();
        MCommissionLine[] retValue = new MCommissionLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    public void setDateLastRun(Timestamp DateLastRun) {
        if (DateLastRun != null) {
            super.setDateLastRun(DateLastRun);
        }
    }

    public int copyLinesFrom(MCommission otherCom) {
        if (otherCom == null) {
            return 0;
        }
        MCommissionLine[] fromLines = otherCom.getLines();
        int count = 0;
        for (int i2 = 0; i2 < fromLines.length; ++i2) {
            MCommissionLine line = new MCommissionLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(fromLines[i2], line, this.getAD_Client_ID(), this.getAD_Org_ID());
            line.setC_Commission_ID(this.getC_Commission_ID());
            if (!line.save()) continue;
            ++count;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "copyLinesFrom - Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public List<MBPartner> getSalesRepsOfCommission() {
        List<MBPartner> salesRepsList = new ArrayList<MBPartner>();
        if (this.getC_BPartner_ID() != 0) {
            salesRepsList.add((MBPartner)this.getC_BPartner());
        } else {
            salesRepsList = new Query(this.getCtx(), "C_BPartner", "EXISTS(SELECT 1 FROM C_CommissionSalesRep csr WHERE csr.C_BPartner_ID = C_BPartner.C_BPartner_ID AND csr.C_Commission_ID = ?AND csr.IsActive = 'Y')", this.get_TrxName()).setParameters(this.getC_Commission_ID()).setOnlyActiveRecords(true).list();
        }
        return salesRepsList;
    }

    public static BigDecimal getCommissionAmt(int bPartnerId, Timestamp from, Timestamp to, String docBasisType) {
        ArrayList<Object> params = new ArrayList<Object>();
        String whereClause = new String();
        params.add(bPartnerId);
        params.add(from);
        params.add(to);
        if (docBasisType != null && docBasisType.trim().length() > 0) {
            params.add(docBasisType);
            whereClause = "AND EXISTS(SELECT 1 FROM C_Commission c \t\t\t\t\tINNER JOIN C_CommissionLine cl ON(cl.C_Commission_ID = c.C_Commission_ID) \t\t\t\t\tWHERE cl.C_CommissionLine_ID = cah.C_CommissionLine_ID \t\t\t\t\tAND c.DocBasisType = ?)";
        }
        String sql = new String("SELECT COALESCE(SUM(cah.CommissionAmt), 0) FROM C_CommissionRun crh INNER JOIN C_CommissionAmt cah ON(cah.C_CommissionRun_ID = crh.C_CommissionRun_ID) WHERE crh.DocStatus IN('CO', 'CL') AND cah.C_BPartner_ID = ? AND crh.DateDoc BETWEEN ? AND ? ") + whereClause;
        BigDecimal value = DB.getSQLValueBDEx(null, sql.toString(), params);
        return value;
    }

    public static BigDecimal getCommissionAmt(int bPartnerId, Timestamp from, Timestamp to) {
        return MCommission.getCommissionAmt(bPartnerId, from, to, null);
    }
}

