/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MCommissionDetail;
import org.compiere.model.MCommissionRun;
import org.compiere.model.Query;
import org.compiere.model.X_C_CommissionAmt;
import org.compiere.util.Env;

public class MCommissionAmt
extends X_C_CommissionAmt {
    private static final long serialVersionUID = 1747802539808391638L;

    public MCommissionAmt(Properties ctx, int C_CommissionAmt_ID, String trxName) {
        super(ctx, C_CommissionAmt_ID, trxName);
        if (C_CommissionAmt_ID == 0) {
            this.setActualQty(Env.ZERO);
            this.setCommissionAmt(Env.ZERO);
            this.setConvertedAmt(Env.ZERO);
        }
    }

    public MCommissionAmt(MCommissionRun run, int C_CommissionLine_ID) {
        this(run.getCtx(), 0, run.get_TrxName());
        this.setClientOrg(run);
        this.setC_CommissionRun_ID(run.getC_CommissionRun_ID());
        this.setC_CommissionLine_ID(C_CommissionLine_ID);
    }

    public MCommissionAmt(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCommissionDetail[] getDetails() {
        String whereClause = "C_CommissionAmt_ID=?";
        List<MCommissionDetail> list = new Query(this.getCtx(), "C_CommissionDetail", "C_CommissionAmt_ID=?", this.get_TrxName()).setParameters(this.getC_CommissionAmt_ID()).list();
        MCommissionDetail[] retValue = new MCommissionDetail[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void updateCommissionAmount() {
        BigDecimal totalConvertedAmt = Env.ZERO;
        BigDecimal totalActualQty = Env.ZERO;
        BigDecimal totalCommissionAmt = Env.ZERO;
        for (MCommissionDetail detail : this.getDetails()) {
            totalConvertedAmt = totalConvertedAmt.add(detail.getConvertedAmt());
            totalActualQty = totalActualQty.add(detail.getActualQty());
            totalCommissionAmt = totalCommissionAmt.add(detail.getCommissionAmt());
        }
        this.setConvertedAmt(totalConvertedAmt);
        this.setActualQty(totalActualQty);
        this.setCommissionAmt(totalCommissionAmt);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord) {
            this.updateRunHeader();
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.updateRunHeader();
        }
        return success;
    }

    private void updateRunHeader() {
        MCommissionRun run = new MCommissionRun(this.getCtx(), this.getC_CommissionRun_ID(), this.get_TrxName());
        run.updateFromAmt();
        run.saveEx();
    }
}

