/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionAmt;
import org.compiere.model.MCommissionDetail;
import org.compiere.model.MCommissionGroup;
import org.compiere.model.MCommissionLine;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.MSalesRegion;
import org.compiere.model.MTree;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.X_C_CommissionRun;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class MCommissionRun
extends X_C_CommissionRun
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20170318L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private StringBuffer m_comissionLog = null;

    public MCommissionRun(Properties ctx, int C_CommissionRun_ID, String trxName) {
        super(ctx, C_CommissionRun_ID, trxName);
    }

    public MCommissionRun(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCommissionRun(MCommission commission) {
        this(commission.getCtx(), 0, commission.get_TrxName());
        this.setClientOrg(commission);
        this.setC_Commission_ID(commission.getC_Commission_ID());
    }

    public MCommissionAmt[] getAmts() {
        String whereClause = "C_CommissionRun_ID=?";
        List<MCommissionAmt> list = new Query(this.getCtx(), "C_CommissionAmt", "C_CommissionRun_ID=?", this.get_TrxName()).setParameters(this.getC_CommissionRun_ID()).list();
        MCommissionAmt[] retValue = new MCommissionAmt[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void updateFromAmt() {
        MCommissionAmt[] amts = this.getAmts();
        BigDecimal GrandTotal = Env.ZERO;
        for (int i2 = 0; i2 < amts.length; ++i2) {
            MCommissionAmt amt = amts[i2];
            GrandTotal = GrandTotal.add(amt.getCommissionAmt());
        }
        this.setGrandTotal(GrandTotal);
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_comissionLog = new StringBuffer();
        this.m_comissionLog.append("<!DOCTYPE html>");
        this.m_comissionLog.append("<html><head> <title>Commission calculation process</title> <meta charset=\"UTF-8\"> </head><body>");
        this.m_comissionLog.append("<h1>Commission calculation process: start</h1>");
        Date todayAsDate = new Date();
        Timestamp todayAsTime = new Timestamp(todayAsDate.getTime());
        this.m_comissionLog.append("Starting date: " + todayAsTime);
        this.m_comissionLog.append("<br>Document No: <b>" + this.getDocumentNo() + "</b>");
        this.m_comissionLog.append("<br>Recalculate: " + (this.isReCalculate() ? "Y" : "N"));
        this.m_comissionLog.append("<br>");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            this.m_comissionLog.append("<br>Period Closed");
            this.m_comissionLog.append("<br>Commission calculation process: end");
            return "IN";
        }
        if (this.getDocStatus().equals("DR") || this.getDocStatus().equals("IN") || this.getDocStatus().equals("IP") && this.isReCalculate()) {
            try {
                this.createMovements();
                this.m_comissionLog.append("<br>");
            }
            catch (Exception e) {
                this.m_processMsg = e.getMessage();
                this.m_comissionLog.append("<br>Exception: " + this.m_processMsg);
                this.m_comissionLog.append("<br>Commission calculation process: end");
                return "IN";
            }
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
            if (this.m_processMsg != null) {
                this.m_comissionLog.append("<br>Validation After Prepare failed");
                this.m_comissionLog.append("<br>Commission calculation process: end");
                return "IN";
            }
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        todayAsDate = new Date();
        todayAsTime = new Timestamp(todayAsDate.getTime());
        this.m_comissionLog.append("<br>Ending date: " + todayAsTime);
        this.m_comissionLog.append("<br>Commission calculation process: end");
        this.m_comissionLog.append("</body></html>");
        try {
            File tempFile = File.createTempFile("CommissionRun", ".html");
            BufferedWriter bwr = new BufferedWriter(new FileWriter(tempFile));
            bwr.write(this.m_comissionLog.toString());
            bwr.flush();
            bwr.close();
        }
        catch (Exception e) {
            this.log.severe("Could not create commission log file CommissionRun.html - " + e.getMessage());
        }
        return "IP";
    }

    private void deleteMovements() {
        this.m_comissionLog = new StringBuffer();
        this.m_comissionLog.append("<br>----Delete old Commission calculations: start");
        int no = DB.executeUpdateEx("DELETE FROM C_CommissionAmt c WHERE C_CommissionRun_ID = ?", new Object[]{this.getC_CommissionRun_ID()}, this.get_TrxName());
        this.m_comissionLog.append("<br>----Delete old Commission calculations: end (" + no + "deleted)");
        this.log.info("C_CommissionAmt deleted #" + no);
    }

    private void createMovements() throws Exception {
        String frequencyType = null;
        List<Object> commissionList = new ArrayList<MCommission>();
        if (this.getC_Commission_ID() != 0) {
            MCommission commission = new MCommission(this.getCtx(), this.getC_Commission_ID(), this.get_TrxName());
            if (commission.isActive()) {
                commissionList.add(commission);
                this.m_comissionLog.append("<br>----Commission added to be processed: " + commission.getName());
                frequencyType = commission.getFrequencyType();
            }
        } else if (this.getC_CommissionGroup_ID() != 0) {
            MCommissionGroup group = new MCommissionGroup(this.getCtx(), this.getC_CommissionGroup_ID(), this.get_TrxName());
            this.m_comissionLog.append("<br>----Commission group added to be processed: " + group.getName());
            commissionList = group.getLines("IsActiveY");
            frequencyType = group.getFrequencyType();
        }
        if (commissionList.size() == 0) {
            this.m_comissionLog.append("<br>----No Commission defined: ending with Exception");
            throw new AdempiereException("@NoCommissionDefined@");
        }
        this.deleteMovements();
        this.setStartEndDate(frequencyType);
        this.m_comissionLog.append("<br>----Start and end date of this commission run has been set: StartDate = " + this.getStartDate() + ", EndDate = " + this.getEndDate());
        this.log.info("StartDate = " + this.getStartDate() + ", EndDate = " + this.getEndDate());
        for (MCommission mCommission : commissionList) {
            this.m_comissionLog.append("<h2>Commission processing</h2>");
            this.m_comissionLog.append("--------Commission processing start: <b>" + mCommission.getName() + "</b>");
            this.m_comissionLog.append("<br>Calculation basis:" + mCommission.getDocBasisType() + ", Frequency type: " + mCommission.getFrequencyType());
            this.m_comissionLog.append(", must to have been paid totally?: " + (mCommission.isTotallyPaid() ? "Y" : "N") + ", includes RMA?: " + (mCommission.isAllowRMA() ? "Y" : "N"));
            this.m_comissionLog.append(" Charge: " + mCommission.getC_Charge().getName());
            this.m_comissionLog.append(", list details?: " + (mCommission.isListDetails() ? "Y" : "N"));
            this.m_comissionLog.append("<h3>Commission for Sales representatives</h3>");
            for (MBPartner salesRep : mCommission.getSalesRepsOfCommission()) {
                this.m_comissionLog.append("------------Commission for Sales representative start: <b>" + salesRep.getName() + "</b>");
                this.processCommissionLine(salesRep, mCommission);
                if (mCommission.isAllowRMA()) {
                    // empty if block
                }
                this.m_comissionLog.append("------------Commission for Sales representative end: " + salesRep.getName() + "<br><br>");
            }
            this.m_comissionLog.append("<br>------------Commission for Sales representatives end");
            this.m_comissionLog.append("<br>--------Commission processing end: " + mCommission.getName() + "<br>");
        }
        this.saveEx();
    }

    private void createDetail(String sql, MCommission commission, MCommissionLine line, MCommissionAmt commissionAmt) {
        String language = Env.getAD_Language(this.getCtx());
        BigDecimal qtyReturned = Env.ZERO;
        this.m_comissionLog.append("<h5>Matching commission line definition with documents</h5>");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Client_ID());
            pstmt.setTimestamp(2, this.getStartDate());
            pstmt.setTimestamp(3, this.getEndDate());
            if (commission.getDocBasisType().equals("R") && commission.isTotallyPaid()) {
                pstmt.setTimestamp(4, this.getStartDate());
                pstmt.setTimestamp(5, this.getEndDate());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.m_comissionLog.append("------------One match found start: try to create a Commission detail");
                int C_InvoiceLine_ID = rs.getInt(5);
                if (commission.getDocBasisType().equals("R") && commission.isTotallyPaid()) {
                    this.m_comissionLog.append("<br>----------------Calculation basis=R and must to have been paid totally: check if totally paid");
                    if (!this.invoiceCompletelyPaid(C_InvoiceLine_ID)) {
                        this.m_comissionLog.append("<br>----------------<mark>Not totally paid</mark> . Skipping");
                        this.m_comissionLog.append("<br>------------One match found end<br><br>");
                        continue;
                    }
                    this.m_comissionLog.append("<br>----------------Totally paid test <mark>passed</mark> . Continuing creating a new Commission Detail");
                }
                MCommissionDetail commissionDetail = new MCommissionDetail(commissionAmt, rs.getInt(1), rs.getBigDecimal(2), rs.getBigDecimal(3));
                this.m_comissionLog.append("<br>----------------Actual Amount: <b>" + rs.getBigDecimal(2).setScale(2, 4) + "</b>");
                this.m_comissionLog.append("<br>----------------Actual Quantity: <b>" + rs.getBigDecimal(3).setScale(2, 4) + "</b>");
                commissionDetail.setLineIDs(rs.getInt(4), rs.getInt(5));
                String s = rs.getString(6);
                if (s != null) {
                    commissionDetail.setReference(Msg.translate(language, "Payment") + "_" + Msg.translate(language, "Invoice") + ": " + s);
                    this.m_comissionLog.append("<br>----------------<b>" + commissionDetail.getReference() + "</b>");
                }
                if ((s = rs.getString(7)) != null) {
                    commissionDetail.setInfo(Msg.translate(language, "ProductValue") + ": " + s);
                    this.m_comissionLog.append("<br>----------------<b>" + commissionDetail.getInfo() + "</b>");
                }
                Timestamp date = rs.getTimestamp(8);
                commissionDetail.setConvertedAmt(date);
                commissionDetail.calculateCommission();
                this.m_comissionLog.append("<br>----------------Converted Amount: <b>" + commissionDetail.getConvertedAmt().setScale(2, 4) + "</b>");
                commissionDetail.saveEx();
                if (commission.isAllowRMA() && (qtyReturned = this.returnedItemsQty(C_InvoiceLine_ID)).compareTo(Env.ZERO) == 1) {
                    this.m_comissionLog.append("<br>----------------Compensation needed start: " + qtyReturned + " RMAs");
                    MCommissionDetail compensationCD = MCommissionDetail.copy(this.getCtx(), commissionDetail, this.get_TrxName());
                    compensationCD.setInfo(Msg.translate(language, "CompensationFor") + " " + commissionDetail.getInfo() + " (" + Msg.translate(language, "QtyReturned") + ": " + qtyReturned + "), ");
                    compensationCD.correctForRMA(qtyReturned);
                    compensationCD.saveEx();
                    this.m_comissionLog.append("<br>--------------------Compensation data: ");
                    this.m_comissionLog.append(compensationCD.getReference() + ", " + compensationCD.getInfo() + ", ");
                    this.m_comissionLog.append("Actual Amount:" + compensationCD.getActualAmt() + ", ");
                    this.m_comissionLog.append("Actual Qty:" + compensationCD.getActualQty() + ", ");
                    this.m_comissionLog.append("Converted Amount:" + compensationCD.getConvertedAmt());
                    this.m_comissionLog.append("<br>----------------Compensation needed end: ");
                }
                this.m_comissionLog.append("<br>------------One match found end<br><br>");
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException("System Error: " + e.getLocalizedMessage(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private boolean invoiceCompletelyPaid(int C_IvoiceLine_ID) {
        BigDecimal payedSum = Env.ZERO;
        BigDecimal grandTotal = Env.ZERO;
        StringBuffer sql = new StringBuffer();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        sql.append("SELECT coalesce(al1.payedSum,0) as payedSum, i.grandTotal, i.documentno  FROM C_Invoice i  INNER JOIN C_InvoiceLine il on (i.C_Invoice_ID=il.C_Invoice_ID)  LEFT JOIN (  SELECT al2.C_Invoice_ID, sum(al2.amount) as payedSum               FROM C_AllocationLine al2               INNER JOIN C_AllocationHdr ah on (al2.c_allocationhdr_id=ah.c_allocationhdr_id)  \t\t\t INNER JOIN c_Payment p on al2.c_Payment_ID = p.c_Payment_ID                WHERE al2.C_Charge_ID IS NULL AND ah.docstatus<>'RE' and p.datetrx <=?              GROUP BY al2.C_Invoice_ID             ) al1 on (i.C_Invoice_ID = al1.C_Invoice_ID)  WHERE il.C_InvoiceLine_ID=" + C_IvoiceLine_ID + " AND i.DocStatus IN ('CL','CO') AND i.AD_Client_ID = ?  AND i.IsSOTrx='Y'");
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            pstmt.setTimestamp(1, this.getEndDate());
            pstmt.setInt(2, this.getAD_Client_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                payedSum = rs.getBigDecimal(1);
                grandTotal = rs.getBigDecimal(2);
                this.m_comissionLog.append("<br>----------------Invoice: <b>" + rs.getString(3) + "</b>");
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException("System Error: " + e.getLocalizedMessage(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.m_comissionLog.append("<br>----------------Check if totally paid: Grand Total: <b>" + grandTotal + "</b>, Payed sum: <b>" + payedSum.setScale(2, 4) + "</b>");
        return grandTotal.compareTo(payedSum) != 1;
    }

    private BigDecimal returnedItemsQty(int C_IvoiceLine_ID) {
        BigDecimal qtyReturned = Env.ZERO;
        StringBuffer sql = new StringBuffer();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        sql.append("SELECT iol2.movementqty, i.documentno as invoice, rma.documentno as rma, io.documentno as io  FROM C_InvoiceLine il  INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID AND i.DocStatus NOT IN ('DR', 'IP', 'VO', 'RE') )  INNER JOIN M_InOutLine iol1 ON (il.C_OrderLine_ID=iol1.C_OrderLine_ID)  INNER JOIN M_RMALine rmal ON (iol1.M_InOutLine_ID=rmal.M_InOutLine_ID)  INNER JOIN M_RMA rma ON (rmal.M_RMA_ID=rma.M_RMA_ID AND rma.DocStatus NOT IN ('DR', 'IP', 'VO', 'RE') )  INNER JOIN M_InOutLine iol2 ON (rmal.M_RMALine_ID=iol2.M_RMALine_ID)  INNER JOIN M_InOut io ON (iol2.M_InOut_ID=io.M_InOut_ID AND io.DocStatus NOT IN ('DR', 'IP', 'VO', 'RE') )  WHERE il.C_InvoiceLine_ID=" + C_IvoiceLine_ID + " AND i.AD_Client_ID = ?  AND i.IsSOTrx='Y'");
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            pstmt.setInt(1, this.getAD_Client_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                qtyReturned = qtyReturned.add(rs.getBigDecimal(1));
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException("System Error: " + e.getLocalizedMessage(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return qtyReturned;
    }

    private BigDecimal getAmountPercentage(MCommission commission, boolean isPercentageFromPrice, StringBuffer sqlWhere) {
        if (!commission.getDocBasisType().equals("F") && !commission.getDocBasisType().equals("G")) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        if (commission.getDocBasisType().equals("F")) {
            if (!isPercentageFromPrice) {
                sql.append("SELECT ((SUM(l.QtyInvoiced) / MAX(fl.ForecastQty)) * 100) FROM C_Invoice h INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) INNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t\t\t\tpd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\t\t\tFROM M_Forecast f \t\t\t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID)\t\t\t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID)\t\t\t\tGROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate) fl ON(fl.M_Product_ID = l.M_Product_ID AND fl.SalesRep_ID = h.SalesRep_ID) WHERE h.AD_Client_ID = ? AND h.DocStatus IN('CO', 'CL') AND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate AND h.DateInvoiced BETWEEN ? AND ?");
            } else {
                sql.append("SELECT ((SUM(linenetamtrealinvoiceline(l.c_Invoiceline_ID)) / MAX(fl.ForecastAmt)) * 100) FROM C_Invoice h INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) INNER JOIN (SELECT f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, \t\t\t\tpd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\t\t\tFROM RV_M_Forecast f \t\t\t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = f.PP_Period_ID)\t\t\t\tGROUP BY f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate) fl ON(fl.M_Product_ID = l.M_Product_ID AND fl.SalesRep_ID = h.SalesRep_ID) WHERE h.AD_Client_ID = ? AND h.DocStatus IN('CO', 'CL') AND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate AND h.DateInvoiced BETWEEN ? AND ?");
            }
        } else if (commission.getDocBasisType().equals("G")) {
            if (!isPercentageFromPrice) {
                sql.append("SELECT ((SUM(l.QtyOrdered) / MAX(fl.ForecastQty)) * 100) FROM C_Order h INNER JOIN C_OrderLine l ON (h.C_Order_ID = l.C_Order_ID) INNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t\t\t\tpd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\t\t\tFROM M_Forecast f \t\t\t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID)\t\t\t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID)\t\t\t\tGROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate) fl ON(fl.M_Product_ID = l.M_Product_ID AND fl.SalesRep_ID = h.SalesRep_ID) WHERE h.AD_Client_ID = ? AND h.DocStatus IN('CO', 'CL') AND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate AND h.DateOrdered BETWEEN ? AND ?");
            } else {
                sql.append("SELECT ((SUM(linenetamtrealorderline(l.c_Invoiceline_ID)) / MAX(fl.ForecastAmt)) * 100) FROM C_Order h INNER JOIN C_OrderLine l ON (h.C_Order_ID = l.C_Order_ID) INNER JOIN (SELECT f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, \t\t\t\tpd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\t\t\tFROM RV_M_Forecast f \t\t\t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = f.PP_Period_ID)\t\t\t\tGROUP BY f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate) fl ON(fl.M_Product_ID = l.M_Product_ID AND fl.SalesRep_ID = h.SalesRep_ID) WHERE h.AD_Client_ID = ? AND h.DocStatus IN('CO', 'CL') AND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate AND h.DateOrdered BETWEEN ? AND ?");
            }
        }
        sql.append(sqlWhere);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getAD_Client_ID());
        params.add(this.getStartDate());
        params.add(this.getEndDate());
        if (commission.isTotallyPaid()) {
            params.add(this.getStartDate());
            params.add(this.getEndDate());
        }
        BigDecimal percentage = DB.getSQLValueBD(this.get_TrxName(), sql.toString(), params);
        return percentage;
    }

    private String processCommissionLine(MBPartner salesRep, MCommission commission) {
        MCommissionLine[] commissionLines = commission.getLines();
        this.m_comissionLog.append("<h4>Processing Commission line</h4>");
        for (MCommissionLine commissionLine : commissionLines) {
            this.m_comissionLog.append("Commission Line No: <b>" + commissionLine.getLine() + "</b><br>");
            this.m_comissionLog.append("Quantity to subtract: " + commissionLine.getQtySubtract() + ", Value to multiply: " + commissionLine.getQtyMultiplier());
            this.m_comissionLog.append(", Subtract Amount: " + commissionLine.getAmtSubtract() + ", Multiplier Amount: " + commissionLine.getAmtMultiplier());
            this.m_comissionLog.append(", Positive only?: " + (commissionLine.isPositiveOnly() ? "Y" : "N"));
            this.m_comissionLog.append(", Business Partner: " + commissionLine.getC_BPartner().getName() + ", Product: " + commissionLine.getM_Product().getName());
            this.m_comissionLog.append(", Valid if paid from: " + commissionLine.getDaysFrom() + " days to: " + commissionLine.getDaysTo() + " days");
            this.m_comissionLog.append("<br>Description: " + commissionLine.getDescription());
            ArrayList<Integer> salesRegion = new ArrayList<Integer>();
            MCommissionAmt commissionAmt = new MCommissionAmt(this, commissionLine.getC_CommissionLine_ID());
            commissionAmt.setC_BPartner_ID(salesRep.getC_BPartner_ID());
            commissionAmt.saveEx();
            StringBuffer sql = new StringBuffer();
            StringBuffer sqlWhere = new StringBuffer();
            if ("R".equals(commission.getDocBasisType())) {
                String sqlAppend = "";
                sqlAppend = commission.isTotallyPaid() ? " AND (p.DateTrx <? or  p.DateTrx <?) AND maxPayDate(h.c_Invoice_ID) between ? AND ? " : " AND p.DateTrx BETWEEN ? AND ? ";
                if (commission.isListDetails()) {
                    sql.append("SELECT h.C_Currency_ID, (linenetamtrealinvoiceline(l.c_Invoiceline_ID) *(al.Amount/h.GrandTotal)) AS Amt, (l.QtyInvoiced*al.Amount/h.GrandTotal) AS Qty, NULL, l.C_InvoiceLine_ID, p.DocumentNo||'_'||h.DocumentNo, COALESCE(prd.Value,l.Description), h.DateInvoiced FROM C_Payment p INNER JOIN C_AllocationLine al ON (p.C_Payment_ID=al.C_Payment_ID) INNER JOIN C_Invoice h ON (al.C_Invoice_ID = h.C_Invoice_ID) INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID)  LEFT OUTER JOIN M_Product prd ON (l.M_Product_ID = prd.M_Product_ID) WHERE p.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND p.AD_Client_ID = ?  AND al.C_Charge_ID IS NULL " + sqlAppend);
                } else {
                    sql.append("SELECT h.C_Currency_ID, SUM(linenetamtrealinvoiceline(l.c_Invoiceline_ID) *(al.Amount/h.GrandTotal)) AS Amt, SUM(l.QtyInvoiced*al.Amount/h.GrandTotal) AS Qty, NULL, NULL, NULL, NULL, MAX(h.DateInvoiced) FROM C_Payment p INNER JOIN C_AllocationLine al ON (p.C_Payment_ID=al.C_Payment_ID) INNER JOIN C_Invoice h ON (al.C_Invoice_ID = h.C_Invoice_ID) INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) WHERE p.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND p.AD_Client_ID = ?  AND al.C_Charge_ID IS NULL " + sqlAppend);
                }
                if (commissionLine.getDaysFrom() != 0) {
                    if (commission.isDaysDueFromPaymentTerm()) {
                        sqlWhere.append(" AND paymenttermduedays(h.C_PaymentTerm_ID, h.DateInvoiced, p.DateTrx) >= ").append(commissionLine.get_ValueAsInt("DaysFrom"));
                    } else {
                        sqlWhere.append(" AND daysbetween(p.DateTrx, h.DateInvoiced) >= ").append(commissionLine.get_ValueAsInt("DaysFrom"));
                    }
                }
                if (commissionLine.getDaysTo() != 0) {
                    if (commission.isDaysDueFromPaymentTerm()) {
                        sqlWhere.append(" AND paymenttermduedays(h.C_PaymentTerm_ID, h.DateInvoiced, p.DateTrx) <= ").append(commissionLine.get_ValueAsInt("DaysTo"));
                    } else {
                        sqlWhere.append(" AND daysbetween(p.DateTrx, h.DateInvoiced) <= ").append(commissionLine.get_ValueAsInt("DaysTo"));
                    }
                }
            } else if ("O".equals(commission.getDocBasisType()) || "G".equals(commission.getDocBasisType())) {
                if (commission.isListDetails()) {
                    sql.append("SELECT h.C_Currency_ID, linenetamtrealorderline(l.c_OrderLine_ID), l.QtyOrdered, l.C_OrderLine_ID, NULL, h.DocumentNo, COALESCE(prd.Value,l.Description),h.DateOrdered FROM C_Order h INNER JOIN C_OrderLine l ON (h.C_Order_ID = l.C_Order_ID) LEFT OUTER JOIN M_Product prd ON (l.M_Product_ID = prd.M_Product_ID) WHERE h.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateOrdered BETWEEN ? AND ?");
                } else {
                    sql.append("SELECT h.C_Currency_ID, SUM(linenetamtrealorderline(l.c_OrderLine_ID)) AS Amt, SUM(l.QtyOrdered) AS Qty, NULL, NULL, NULL, NULL, MAX(h.DateOrdered) FROM C_Order h INNER JOIN C_OrderLine l ON (h.C_Order_ID = l.C_Order_ID) WHERE h.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateOrdered BETWEEN ? AND ?");
                }
            } else if ("I".equals(commission.getDocBasisType()) || "F".equals(commission.getDocBasisType())) {
                if (commission.isListDetails()) {
                    sql.append("SELECT h.C_Currency_ID, linenetamtrealinvoiceline(l.c_Invoiceline_ID), l.QtyInvoiced, NULL, l.C_InvoiceLine_ID, h.DocumentNo, COALESCE(prd.Value,l.Description),h.DateInvoiced FROM C_Invoice h INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) LEFT OUTER JOIN M_Product prd ON (l.M_Product_ID = prd.M_Product_ID) WHERE h.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateInvoiced BETWEEN ? AND ?");
                } else {
                    sql.append("SELECT h.C_Currency_ID, SUM(linenetamtrealinvoiceline(l.c_Invoiceline_ID)) AS Amt, SUM(l.QtyInvoiced) AS Qty, NULL, NULL, NULL, NULL, MAX(h.DateInvoiced) FROM C_Invoice h INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) WHERE h.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateInvoiced BETWEEN ? AND ?");
                }
                if (commissionLine.getC_DunningLevel_ID() != 0) {
                    sqlWhere.append(" AND h.C_DunningLevel_ID=").append(commissionLine.getC_DunningLevel_ID());
                }
                if (commissionLine.getInvoiceCollectionType() != null) {
                    sqlWhere.append(" AND h.InvoiceCollectionType='").append(commissionLine.getInvoiceCollectionType()).append("'");
                }
            }
            if ("F".equals(commission.getDocBasisType())) {
                if (!commissionLine.isPercentageFromPrice()) {
                    if (commissionLine.getMinCompliance() != null && commissionLine.getMinCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND EXISTS(SELECT 1 FROM C_Invoice i INNER JOIN C_InvoiceLine il ON(il.C_Invoice_ID = i.C_Invoice_ID)\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\tFROM M_Forecast f \t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID) \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t\tWHERE f.IsActive = 'Y' \t\tAND fl.IsActive = 'Y' \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastQty HAVING(((SUM(il.QtyInvoiced) / fl.ForecastQty) * 100) >= " + DB.TO_NUMBER(commissionLine.getMinCompliance(), 12));
                        if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                            sql.append(" AND ((SUM(il.QtyInvoiced) / fl.ForecastQty) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + ")");
                        } else {
                            sql.append(")");
                        }
                        sql.append(")");
                    } else if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND EXISTS(SELECT 1 FROM C_Invoice i INNER JOIN C_InvoiceLine il ON(il.C_Invoice_ID = i.C_Invoice_ID)\t\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\tFROM M_Forecast f \t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID) \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t\tWHERE f.IsActive = 'Y' \t\tAND fl.IsActive = 'Y' \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastQty HAVING(((SUM(il.QtyInvoiced) / fl.ForecastQty) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + "))");
                    }
                } else if (commissionLine.getMinCompliance() != null && commissionLine.getMinCompliance().compareTo(Env.ZERO) > 0) {
                    sql.append(" AND EXISTS(SELECT 1 FROM C_Invoice i INNER JOIN C_InvoiceLine il ON(il.C_Invoice_ID = i.C_Invoice_ID)\tINNER JOIN (SELECT f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\tFROM RV_M_Forecast f \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = f.PP_Period_ID) \t    GROUP BY f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastAmt HAVING(((SUM(linenetamtrealinvoiceline(il.c_Invoiceline_ID)) / fl.ForecastAmt) * 100) >= " + DB.TO_NUMBER(commissionLine.getMinCompliance(), 12));
                    if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND ((SUM(linenetamtrealinvoiceline(il.c_Invoiceline_ID)) / fl.ForecastAmt) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + ")");
                    } else {
                        sql.append(")");
                    }
                    sql.append(")");
                } else if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                    sql.append(" AND EXISTS(SELECT 1 FROM C_Invoice i INNER JOIN C_InvoiceLine il ON(il.C_Invoice_ID = i.C_Invoice_ID)\t\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\tFROM RV_M_Forecast f \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastAmt HAVING(((SUM(linenetamtrealinvoiceline(il.c_Invoiceline_ID)) / fl.ForecastAmt) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + "))");
                }
            } else if ("G".equals(commission.getDocBasisType())) {
                if (!commissionLine.isPercentageFromPrice()) {
                    if (commissionLine.getMinCompliance() != null && commissionLine.getMinCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND EXISTS(SELECT 1 FROM C_Order i INNER JOIN C_OrderLine il ON(il.C_Order_ID = i.C_Order_ID)\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\tFROM M_Forecast f \t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID) \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t\tWHERE f.IsActive = 'Y' \t\tAND fl.IsActive = 'Y' \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateOrdered BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastQty HAVING(((SUM(il.QtyOrdered) / fl.ForecastQty) * 100) >= " + DB.TO_NUMBER(commissionLine.getMinCompliance(), 12));
                        if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                            sql.append(" AND ((SUM(il.QtyOrdered) / fl.ForecastQty) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + ")");
                        } else {
                            sql.append(")");
                        }
                        sql.append(")");
                    } else if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND EXISTS(SELECT 1 FROM C_Order i INNER JOIN C_OrderLine il ON(il.C_Order_ID = i.C_Order_ID)\t\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\tFROM M_Forecast f \t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID) \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t\tWHERE f.IsActive = 'Y' \t\tAND fl.IsActive = 'Y' \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateOrdered BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastQty HAVING(((SUM(il.QtyOrdered) / fl.ForecastQty) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + "))");
                    }
                } else if (commissionLine.getMinCompliance() != null && commissionLine.getMinCompliance().compareTo(Env.ZERO) > 0) {
                    sql.append(" AND EXISTS(SELECT 1 FROM C_Order i INNER JOIN C_OrderLine il ON(il.C_Order_ID = i.C_Order_ID)\tINNER JOIN (SELECT f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\tFROM RV_M_Forecast f \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = f.PP_Period_ID) \t    GROUP BY f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateOrdered BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastAmt HAVING(((SUM(linenetamtrealorderline(il.C_Orderline_ID)) / fl.ForecastAmt) * 100) >= " + DB.TO_NUMBER(commissionLine.getMinCompliance(), 12));
                    if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND ((SUM(linenetamtrealorderline(il.C_Orderline_ID)) / fl.ForecastAmt) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + ")");
                    } else {
                        sql.append(")");
                    }
                    sql.append(")");
                } else if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                    sql.append(" AND EXISTS(SELECT 1 FROM C_Order i INNER JOIN C_OrderLine il ON(il.C_Order_ID = i.C_Order_ID)\t\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\tFROM RV_M_Forecast f \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateOrdered BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastAmt HAVING(((SUM(linenetamtrealorderline(il.C_Orderline_ID)) / fl.ForecastAmt) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + "))");
                }
            }
            if (commissionLine.isCommissionOrders()) {
                MUser[] users = MUser.getOfBPartner(this.getCtx(), salesRep.getC_BPartner_ID(), this.get_TrxName());
                if (users == null || users.length == 0) continue;
                if (users.length == 1) {
                    int SalesRep_ID = users[0].getAD_User_ID();
                    sqlWhere.append(" AND h.SalesRep_ID=").append(SalesRep_ID);
                } else {
                    this.log.warning("Not 1 User/Contact for C_BPartner_ID=" + salesRep.getC_BPartner_ID() + " but " + users.length);
                    sqlWhere.append(" AND EXISTS(SELECT 1 FROM AD_User u WHERE u.AD_User_ID = h.SalesRep_ID AND u.C_BPartner_ID=").append(salesRep.getC_BPartner_ID()).append(")");
                }
            }
            if (commissionLine.getOrg_ID() != 0) {
                sqlWhere.append(" AND h.AD_Org_ID=").append(commissionLine.getOrg_ID());
            }
            if (commissionLine.getC_BPartner_ID() != 0) {
                sqlWhere.append(" AND h.C_BPartner_ID=").append(commissionLine.getC_BPartner_ID());
            }
            if (commissionLine.getC_BP_Group_ID() != 0) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner \t\t\t\t\t\tWHERE C_BPartner.C_BPartner_ID = h.C_BPartner_ID \t\t\t\t\t\tAND C_BP_Group_ID=").append(commissionLine.getC_BP_Group_ID()).append(")");
            }
            if (commissionLine.getC_SalesRegion_ID() != 0) {
                sqlWhere.append(" AND (h.C_BPartner_Location_ID IN (SELECT C_BPartner_Location_ID FROM C_BPartner_Location WHERE C_SalesRegion_ID ").append(this.getSalesRegionClause(salesRegion, commissionLine.getC_SalesRegion_ID())).append(") OR EXISTS(SELECT 1 FROM C_Order o \t\t\t\t\tINNER JOIN C_BPartner_Location bpl ON(bpl.C_BPartner_Location_ID = o.C_BPartner_Location_ID)\t\t\t\t\tWHERE o.C_Order_ID = h.C_Order_ID \t\t\t\t\tAND bpl.C_SalesRegion_ID " + this.getSalesRegionClause(salesRegion, commissionLine.getC_SalesRegion_ID()) + "))");
            }
            if (commissionLine.getM_Product_ID() != 0) {
                sqlWhere.append(" AND l.M_Product_ID=").append(commissionLine.getM_Product_ID());
            }
            if (commissionLine.getM_Product_Category_ID() != 0) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM M_Product \t\t\t\t\tWHERE M_Product.M_Product_ID = l.M_Product_ID \t\t\t\t\tAND M_Product_Category_ID=").append(commissionLine.getM_Product_Category_ID()).append(")");
            }
            if (commissionLine.getM_Product_Group_ID() != 0) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM M_Product \t\t\t\t\tWHERE M_Product.M_Product_ID = l.M_Product_ID \t\t\t\t\tAND M_Product_Group_ID=").append(commissionLine.getM_Product_Group_ID()).append(")");
            }
            if (commissionLine.getM_Product_Class_ID() != 0) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM M_Product \t\t\t\t\tWHERE M_Product.M_Product_ID = l.M_Product_ID \t\t\t\t\tAND M_Product_Class_ID=").append(commissionLine.getM_Product_Class_ID()).append(")");
            }
            if (commissionLine.getM_Product_Classification_ID() != 0) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM M_Product \t\t\t\t\tWHERE M_Product.M_Product_ID = l.M_Product_ID \t\t\t\t\tAND M_Product_Classification_ID=").append(commissionLine.getM_Product_Classification_ID()).append(")");
            }
            if (commissionLine.getC_Project_ID() != 0) {
                sqlWhere.append(" AND l.C_Project_ID=").append(commissionLine.getC_Project_ID());
            }
            if (commissionLine.getC_Campaign_ID() != 0) {
                sqlWhere.append(" AND l.C_Campaign_ID=").append(commissionLine.getC_Campaign_ID());
            }
            if (commissionLine.getC_Channel_ID() != 0) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM C_Campaign \t\t\t\t\tWHERE C_Campaign.C_Campaign_ID = l.C_Campaign_ID \t\t\t\t\tAND C_Campaign.C_Channel_ID=").append(commissionLine.getC_Channel_ID()).append(")");
            }
            if (commissionLine.getPaymentRule() != null) {
                sqlWhere.append(" AND h.PaymentRule='").append(commissionLine.getPaymentRule()).append("'");
            }
            if (commissionLine.getC_PaymentTerm_ID() != 0) {
                sqlWhere.append(" AND h.C_PaymentTerm_ID= ").append(commissionLine.getC_PaymentTerm_ID());
            }
            sqlWhere.append(this.getExclusionWhere(commission.getDocBasisType(), commissionLine, commissionLines));
            if (!commission.isListDetails()) {
                sqlWhere.append(" GROUP BY h.C_Currency_ID");
            }
            sql.append(sqlWhere);
            this.log.fine("Line=" + commissionLine.getLine() + " - " + sql);
            commissionAmt.setPercentage(this.getAmountPercentage(commission, commissionLine.isPercentageFromPrice(), sqlWhere));
            commissionAmt.setMaxPercentage(commissionLine.getMaxPercentage());
            this.createDetail(sql.toString(), commission, commissionLine, commissionAmt);
            if (commissionAmt.getDetails().length == 0) {
                commissionAmt.deleteEx(true, this.get_TrxName());
                this.m_comissionLog.append("<br>------------No match found ->  Delete Commission Amount because it has no details");
                continue;
            }
            this.m_comissionLog.append("<h3 style=\"background-color:orange\">Calculate summary for " + salesRep.getName() + " start</h3>");
            commissionAmt.updateCommissionAmount();
            this.m_comissionLog.append("Commission Amount: " + commissionAmt.getCommissionAmt().setScale(2, 4));
            this.m_comissionLog.append("<br>Actual qty: " + commissionAmt.getActualQty().setScale(2, 4));
            this.m_comissionLog.append("<br>Base for commission: " + commissionAmt.getConvertedAmt().setScale(2, 4));
            this.m_comissionLog.append("<h3 style=\"background-color:orange\">Calculate summary end</h3>");
            commissionAmt.saveEx();
        }
        commission.setDateLastRun(this.getDateDoc());
        commission.saveEx();
        return "@C_CommissionRun_ID@ = " + this.getDocumentNo() + " - " + this.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSalesRegion(List<Integer> salesRegionList, int salesRegionId) {
        int m_Tree_ID = MTree.getDefaultTreeIdFromTableName(this.getAD_Client_ID(), "C_SalesRegion");
        String sql = "SELECT tn.Node_ID AS C_SalesRegion_ID FROM AD_Tree t INNER JOIN AD_TreeNode tn ON(t.AD_Tree_ID = tn.AD_Tree_ID) WHERE t.AD_Tree_ID = ? AND tn.Parent_ID = ?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement("SELECT tn.Node_ID AS C_SalesRegion_ID FROM AD_Tree t INNER JOIN AD_TreeNode tn ON(t.AD_Tree_ID = tn.AD_Tree_ID) WHERE t.AD_Tree_ID = ? AND tn.Parent_ID = ?", null);
            pstmt.setInt(1, m_Tree_ID);
            pstmt.setInt(2, salesRegionId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MSalesRegion salesRegion = new MSalesRegion(this.getCtx(), rs.getInt("C_SalesRegion_ID"), this.get_TrxName());
                if (salesRegion.getC_SalesRegion_ID() <= 0) continue;
                if (!salesRegion.isSummary()) {
                    salesRegionList.add(salesRegion.getC_SalesRegion_ID());
                    continue;
                }
                this.loadSalesRegion(salesRegionList, salesRegion.getC_SalesRegion_ID());
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "SELECT tn.Node_ID AS C_SalesRegion_ID FROM AD_Tree t INNER JOIN AD_TreeNode tn ON(t.AD_Tree_ID = tn.AD_Tree_ID) WHERE t.AD_Tree_ID = ? AND tn.Parent_ID = ?", e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private String getSalesRegionClause(List<Integer> salesRegionList, int salesRegionId) {
        if (salesRegionList.size() == 0) {
            this.loadSalesRegion(salesRegionList, salesRegionId);
        }
        StringBuffer srClause = new StringBuffer();
        if (salesRegionList.size() == 0) {
            srClause.append("= " + salesRegionId);
        } else {
            srClause = new StringBuffer("IN(");
            for (int i2 = 0; i2 < salesRegionList.size(); ++i2) {
                if (i2 > 0) {
                    srClause.append(", ");
                }
                srClause.append(salesRegionList.get(i2));
            }
            srClause.append(")");
        }
        return srClause.toString();
    }

    private String getExclusionWhere(String docBasisType, MCommissionLine currentLine, MCommissionLine[] lines) {
        ArrayList<Integer> orgId = new ArrayList<Integer>();
        ArrayList<Integer> bPartnerId = new ArrayList<Integer>();
        ArrayList<Integer> bPGroupId = new ArrayList<Integer>();
        ArrayList<Integer> salesRegionId = new ArrayList<Integer>();
        ArrayList<Integer> productId = new ArrayList<Integer>();
        ArrayList<Integer> productCategoryId = new ArrayList<Integer>();
        ArrayList<Integer> productGroupId = new ArrayList<Integer>();
        ArrayList<Integer> productClassId = new ArrayList<Integer>();
        ArrayList<Integer> productClassificationId = new ArrayList<Integer>();
        ArrayList<Integer> projectId = new ArrayList<Integer>();
        ArrayList<Integer> campaignId = new ArrayList<Integer>();
        ArrayList<Integer> channelId = new ArrayList<Integer>();
        ArrayList<String> paymentRule = new ArrayList<String>();
        ArrayList<Integer> dunningLevelId = new ArrayList<Integer>();
        ArrayList<String> invoiceCollectionType = new ArrayList<String>();
        for (MCommissionLine line : lines) {
            if (line.getC_CommissionLine_ID() == currentLine.getC_CommissionLine_ID()) continue;
            if (currentLine.getOrg_ID() == 0 && line.getOrg_ID() != 0) {
                orgId.add(line.getOrg_ID());
            }
            if (currentLine.getC_BPartner_ID() == 0 && line.getC_BPartner_ID() != 0) {
                bPartnerId.add(line.getC_BPartner_ID());
            }
            if (currentLine.getC_BP_Group_ID() == 0 && line.getC_BP_Group_ID() != 0) {
                bPGroupId.add(line.getC_BP_Group_ID());
            }
            if (currentLine.getC_SalesRegion_ID() == 0 && line.getC_SalesRegion_ID() != 0) {
                salesRegionId.add(line.getC_SalesRegion_ID());
            }
            if (currentLine.getM_Product_ID() == 0 && line.getM_Product_ID() != 0) {
                productId.add(line.getM_Product_ID());
            }
            if (currentLine.getM_Product_Category_ID() == 0 && line.getM_Product_Category_ID() != 0) {
                productCategoryId.add(line.getM_Product_Category_ID());
            }
            if (currentLine.getM_Product_Group_ID() == 0 && line.getM_Product_Group_ID() != 0) {
                productGroupId.add(line.getM_Product_Group_ID());
            }
            if (currentLine.getM_Product_Class_ID() == 0 && line.getM_Product_Class_ID() != 0) {
                productClassId.add(line.getM_Product_Class_ID());
            }
            if (currentLine.getM_Product_Classification_ID() == 0 && line.getM_Product_Classification_ID() != 0) {
                productClassificationId.add(line.getM_Product_Classification_ID());
            }
            if (currentLine.getPaymentRule() == null && line.getPaymentRule() != null) {
                paymentRule.add(line.getPaymentRule());
            }
            if (currentLine.getC_Project_ID() == 0 && line.getC_Project_ID() != 0) {
                projectId.add(line.getC_Project_ID());
            }
            if (currentLine.getC_Campaign_ID() == 0 && line.getC_Campaign_ID() != 0) {
                campaignId.add(line.getC_Campaign_ID());
            }
            if (currentLine.getC_Channel_ID() == 0 && line.getC_Channel_ID() != 0) {
                channelId.add(line.getC_Channel_ID());
            }
            if (!docBasisType.equals("I")) continue;
            if (currentLine.getC_DunningLevel_ID() == 0 && line.getC_DunningLevel_ID() != 0) {
                dunningLevelId.add(line.getC_DunningLevel_ID());
            }
            if (currentLine.getInvoiceCollectionType() != null || line.getInvoiceCollectionType() == null) continue;
            invoiceCollectionType.add(line.getInvoiceCollectionType());
        }
        StringBuffer sql = new StringBuffer();
        if (orgId.size() != 0) {
            sql.append(" AND h.AD_Org_ID NOT IN").append(((Object)orgId).toString().replace('[', '(').replace(']', ')'));
        }
        if (bPartnerId.size() != 0) {
            sql.append(" AND h.C_BPartner_ID NOT IN").append(((Object)bPartnerId).toString().replace('[', '(').replace(']', ')'));
        }
        if (bPGroupId.size() != 0) {
            sql.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp \t\tWHERE bp.C_BPartner_ID = h.C_BPartner_ID \t\tAND bp.C_BP_Group_ID NOT IN").append(((Object)bPGroupId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (salesRegionId.size() != 0) {
            sql.append(" AND EXISTS(SELECT 1 FROM C_BPartner_Location l \t\tWHERE l.C_BPartner_Location_ID = h.C_BPartner_Location_ID \t\tAND C_SalesRegion_ID NOT IN").append(((Object)salesRegionId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (productId.size() != 0) {
            sql.append(" AND l.M_Product_ID NOT IN").append(((Object)productId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (productCategoryId.size() != 0) {
            sql.append(" AND EXISTS(SELECT 1 FROM M_Product p \t\tWHERE p.M_Product_ID = l.M_Product_ID \t\tAND M_Product_Category_ID NOT IN").append(((Object)productCategoryId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (productGroupId.size() != 0) {
            sql.append(" AND EXISTS(SELECT 1 FROM M_Product p \t\tWHERE p.M_Product_ID = l.M_Product_ID \t\tAND M_Product_Group_ID NOT IN").append(((Object)productGroupId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (productClassId.size() != 0) {
            sql.append(" AND EXISTS(SELECT 1 FROM M_Product p \t\tWHERE p.M_Product_ID = l.M_Product_ID \t\tAND M_Product_Class_ID NOT IN").append(((Object)productClassId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (productClassId.size() != 0) {
            sql.append(" AND EXISTS(SELECT 1 FROM M_Product p \t\tWHERE p.M_Product_ID = l.M_Product_ID \t\tAND M_Product_Classification_ID NOT IN").append(((Object)productClassificationId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (projectId.size() != 0) {
            sql.append(" AND l.C_Project_ID NOT IN").append(((Object)projectId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (campaignId.size() != 0) {
            sql.append(" AND l.C_Campaign_ID NOT IN").append(((Object)campaignId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (campaignId.size() != 0) {
            sql.append(" AND EXISTS(SELECT 1 FROM C_Campaign \t\t\t\t\tWHERE C_Campaign.C_Campaign_ID = l.C_Campaign_ID \t\t\t\t\tAND C_Campaign.C_Channel_ID NOT IN").append(((Object)campaignId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (paymentRule.size() != 0) {
            sql.append(" AND h.PaymentRule NOT IN('").append(((Object)paymentRule).toString().replace('[', ' ').replace(']', ')').replaceAll(",", ",'")).append(")");
        }
        if (docBasisType.equals("I")) {
            if (dunningLevelId.size() != 0) {
                sql.append(" AND h.C_DunningLevel_ID NOT IN").append(((Object)dunningLevelId).toString().replace('[', '(').replace(']', ')')).append(")");
            }
            if (invoiceCollectionType.size() != 0) {
                sql.append(" AND h.InvoiceCollectionType NOT IN('").append(((Object)invoiceCollectionType).toString().replace('[', ' ').replace(']', ')').replaceAll(",", ",'")).append(")");
            }
        }
        return sql.toString();
    }

    private void setStartEndDate(String frequencyType) {
        if (this.getStartDate() != null && this.getEndDate() != null && !this.isReCalculate()) {
            return;
        }
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(this.getDateDoc().getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if ("Y".equals(frequencyType)) {
            cal.set(6, 1);
            this.setStartDate(new Timestamp(cal.getTimeInMillis()));
            cal.add(1, 1);
            cal.add(6, -1);
            this.setEndDate(new Timestamp(cal.getTimeInMillis()));
        } else if ("Q".equals(frequencyType)) {
            cal.set(5, 1);
            int month = cal.get(2);
            if (month < 3) {
                cal.set(2, 0);
            } else if (month < 6) {
                cal.set(2, 3);
            } else if (month < 9) {
                cal.set(2, 6);
            } else {
                cal.set(2, 9);
            }
            this.setStartDate(new Timestamp(cal.getTimeInMillis()));
            cal.add(2, 3);
            cal.add(6, -1);
            this.setEndDate(new Timestamp(cal.getTimeInMillis()));
        } else if ("W".equals(frequencyType)) {
            cal.set(7, 1);
            this.setStartDate(new Timestamp(cal.getTimeInMillis()));
            cal.add(6, 7);
            this.setEndDate(new Timestamp(cal.getTimeInMillis()));
        } else {
            cal.set(5, 1);
            this.setStartDate(new Timestamp(cal.getTimeInMillis()));
            cal.add(2, 1);
            cal.add(6, -1);
            this.setEndDate(new Timestamp(cal.getTimeInMillis()));
        }
        this.log.fine("setStartEndDate = " + this.getStartDate() + " - " + this.getEndDate());
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setStartDate(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo(this.get_ValueAsInt(index), this.get_TrxName(), true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        return this.closeIt();
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.deleteMovements();
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("CO")) {
            options[index++] = "RE";
            options[index++] = "VO";
            options[index++] = "CL";
        } else if (docStatus.equals("IP") || docStatus.equals("DR")) {
            options[index++] = "PR";
            options[index++] = "CO";
            options[index++] = "VO";
        }
        return index;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MCCommissionRun[").append(this.getSummary()).append("]");
        return sb.toString();
    }
}

