/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import org.adempiere.exceptions.NoCurrencyConversionException;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public final class MConversionRateUtil {
    private static final CLogger s_log = CLogger.getCLogger(MConversionRateUtil.class);

    private MConversionRateUtil() {
    }

    public static BigDecimal convertBase(SetGetModel setGetModel, String string, String string2, String string3, String string4) {
        BigDecimal bigDecimal;
        if (string4 != null && "C_Currency_ID".equalsIgnoreCase(string4)) {
            setGetModel.set_AttrValue("CurrencyRate", Env.ZERO);
        }
        if ((bigDecimal = SetGetUtil.get_AttrValueAsBigDecimal(setGetModel, string2)) == null || bigDecimal.signum() == 0) {
            if (string3 != null) {
                setGetModel.set_AttrValue(string3, Env.ZERO);
            }
            return Env.ZERO;
        }
        int n = SetGetUtil.get_AttrValueAsInt(setGetModel, "AD_Client_ID");
        int n2 = MClient.get(setGetModel.getCtx(), n).getAcctSchema().getC_Currency_ID();
        BigDecimal bigDecimal2 = SetGetUtil.get_AttrValueAsBigDecimal(setGetModel, "CurrencyRate");
        if (bigDecimal2 == null || bigDecimal2.signum() == 0) {
            int n3 = SetGetUtil.get_AttrValueAsInt(setGetModel, "AD_Client_ID");
            Timestamp timestamp = SetGetUtil.get_AttrValueAsDate(setGetModel, string);
            int n4 = SetGetUtil.get_AttrValueAsInt(setGetModel, "C_Currency_ID");
            if (n4 == n2) {
                bigDecimal2 = Env.ONE;
            } else {
                int n5 = SetGetUtil.get_AttrValueAsInt(setGetModel, "C_ConversionType_ID");
                bigDecimal2 = MConversionRate.getRate(n4, n2, timestamp, n5, n, n3);
                if (bigDecimal2 == null) {
                    throw new NoCurrencyConversionException(n4, n2, timestamp, n5, n, n3);
                }
            }
        }
        setGetModel.set_AttrValue("CurrencyRate", bigDecimal2);
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
        int n6 = MCurrency.getStdPrecision(setGetModel.getCtx(), n2);
        bigDecimal3 = bigDecimal3.setScale(n6, RoundingMode.HALF_UP);
        if (string3 != null) {
            setGetModel.set_AttrValue(string3, bigDecimal3);
        }
        if (CLogMgt.isLevelFine()) {
            s_log.fine("amt=" + bigDecimal + " * " + bigDecimal2 + "=" + bigDecimal3 + ", scale=" + n6);
        }
        return bigDecimal3;
    }
}

