/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.Query;
import org.compiere.model.X_A_Depreciation_Method;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;

public class MDepreciationMethod
extends X_A_Depreciation_Method {
    private static CCache<Integer, MDepreciationMethod> s_cache = new CCache("A_Depreciation_Method", 5);
    private static CCache<String, MDepreciationMethod> s_cache_forType = new CCache("A_Depreciation_Method_DepreciationType", 5);

    public MDepreciationMethod(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MDepreciationMethod(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    private static void addToCache(MDepreciationMethod mDepreciationMethod) {
        if (mDepreciationMethod == null) {
            return;
        }
        s_cache.put(mDepreciationMethod.get_ID(), mDepreciationMethod);
        s_cache_forType.put(mDepreciationMethod.getDepreciationType(), mDepreciationMethod);
    }

    private static int getPrecision() {
        return 2;
    }

    public static MDepreciationMethod get(Properties properties, int n) {
        MDepreciationMethod mDepreciationMethod = s_cache.get(n);
        if (mDepreciationMethod != null) {
            return mDepreciationMethod;
        }
        mDepreciationMethod = new MDepreciationMethod(properties, n, null);
        if (mDepreciationMethod.get_ID() > 0) {
            MDepreciationMethod.addToCache(mDepreciationMethod);
        } else {
            mDepreciationMethod = null;
        }
        return mDepreciationMethod;
    }

    public static MDepreciationMethod get(Properties properties, String string) {
        String string2 = string;
        MDepreciationMethod mDepreciationMethod = s_cache_forType.get(string2);
        if (mDepreciationMethod != null) {
            return mDepreciationMethod;
        }
        mDepreciationMethod = (MDepreciationMethod)new Query(properties, "A_Depreciation_Method", "DepreciationType=?", null).setParameters(string).firstOnly();
        MDepreciationMethod.addToCache(mDepreciationMethod);
        return mDepreciationMethod;
    }

    public static BigDecimal invoke(Properties properties, String string, int n, BigDecimal bigDecimal, int n2, String string2, int n3) {
        MDepreciationMethod mDepreciationMethod = MDepreciationMethod.get(properties, string);
        if (mDepreciationMethod == null) {
            throw new IllegalArgumentException("@NotFound@ @DepreciationType@ " + string);
        }
        return mDepreciationMethod.invoke(n, bigDecimal, n2, string2, n3);
    }

    public BigDecimal invoke(MDepreciationWorkfile mDepreciationWorkfile, MAssetAcct mAssetAcct, BigDecimal bigDecimal, int n) {
        return this.invoke(mDepreciationWorkfile.getA_Asset_ID(), bigDecimal, n, mAssetAcct.getPostingType(), mAssetAcct.get_ID());
    }

    public BigDecimal invoke(int n, BigDecimal bigDecimal, int n2, String string, int n3) {
        String string2 = this.getDepreciationType();
        BigDecimal bigDecimal2 = null;
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Entering: DepreciationMethodType=" + string2 + ", A_Asset_ID=" + n + ", A_Asset_Adjustment=" + bigDecimal + ", A_PeriodNo=" + n2 + ", PostingType=" + string + ", A_Asset_Acct_ID=" + n3);
        }
        if (string2.equalsIgnoreCase("MDI")) {
            bigDecimal2 = this.apply_MDI(n, bigDecimal, n2, string, n3);
        } else if (string2.equalsIgnoreCase("YDI")) {
            bigDecimal2 = this.apply_YDI(n, bigDecimal, n2, string, n3);
        } else if (string2.equalsIgnoreCase("LDI")) {
            bigDecimal2 = this.apply_LDI(n, bigDecimal, n2, string, n3);
        } else {
            String string3 = "{ ? = call " + string2 + "(?, ?, ?, ?, ?) }";
            CallableStatement callableStatement = null;
            try {
                callableStatement = DB.prepareCall(string3);
                callableStatement.registerOutParameter(1, 3);
                callableStatement.setInt(2, n);
                callableStatement.setBigDecimal(3, bigDecimal);
                callableStatement.setInt(4, n2);
                callableStatement.setString(5, string);
                callableStatement.setInt(6, n3);
                callableStatement.execute();
                bigDecimal2 = callableStatement.getBigDecimal(1);
                callableStatement.close();
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
            finally {
                DB.close(callableStatement);
                callableStatement = null;
            }
        }
        if (bigDecimal2 == null) {
            bigDecimal2 = BigDecimal.ZERO;
        }
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Leaving: retValue=" + bigDecimal2);
        }
        return bigDecimal2;
    }

    public BigDecimal apply_MDI(int n, BigDecimal bigDecimal, int n2, String string, int n3) {
        return bigDecimal;
    }

    public BigDecimal apply_YDI(int n, BigDecimal bigDecimal, int n2, String string, int n3) {
        BigDecimal bigDecimal2 = new BigDecimal(12 - n2);
        if (bigDecimal2.signum() == 0) {
            this.log.warning("A_PeriodNo=" + n2 + " => remainingPeriods=" + bigDecimal2);
        }
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, MDepreciationMethod.getPrecision(), RoundingMode.HALF_UP);
        if (CLogMgt.isLevelFine()) {
            this.log.fine("A_Asset_Adjustment=" + bigDecimal + ", remainingPeriods=" + bigDecimal2 + " => periodAdjustment=" + bigDecimal3);
        }
        return bigDecimal3;
    }

    public BigDecimal apply_LDI(int n, BigDecimal bigDecimal, int n2, String string, int n3) {
        int n4;
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), n, string);
        int n5 = mDepreciationWorkfile.getA_Life_Period();
        BigDecimal bigDecimal2 = new BigDecimal(n5 - (n4 = mDepreciationWorkfile.getA_Period_Posted()) + 1);
        if (bigDecimal2.signum() == 0) {
            this.log.warning("A_Life_Period=" + n5 + ", A_Period_Posted=" + n4 + " => remainingPeriods=" + bigDecimal2);
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, MDepreciationMethod.getPrecision(), RoundingMode.HALF_UP);
        if (CLogMgt.isLevelFine()) {
            this.log.fine("A_Asset_Adjustment=" + bigDecimal + ", remainingPeriods=" + bigDecimal2 + " => periodAdjustment=" + bigDecimal3);
        }
        return bigDecimal3;
    }
}

