/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.model.X_C_DocType;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDocType
extends X_C_DocType {
    private static final long serialVersionUID = -1406832071359080959L;
    private static CCache<Integer, MDocType> s_cache = new CCache("C_DocType", 20);

    public static int getDocTypeBaseOnSubType(int orgId, String docBaseType, String docSubTypeSO) {
        Integer documentId = null;
        for (MDocType docType : MDocType.getOfDocBaseType(Env.getCtx(), docBaseType)) {
            if (docSubTypeSO == null || !docSubTypeSO.equals(docType.getDocSubTypeSO()) || docType.getAD_Org_ID() != orgId) continue;
            documentId = docType.get_ID();
        }
        for (MDocType docType : MDocType.getOfDocBaseType(Env.getCtx(), docBaseType)) {
            if (docSubTypeSO == null || !docSubTypeSO.equals(docType.getDocSubTypeSO())) continue;
            documentId = docType.get_ID();
        }
        return documentId;
    }

    public static int getDocType(String DocBaseType) {
        MDocType[] doc = MDocType.getOfDocBaseType(Env.getCtx(), DocBaseType);
        return doc.length > 0 ? doc[0].get_ID() : 0;
    }

    public static int getDocType(String docBaseType, int AD_Org_ID) {
        MDocType[] docs = MDocType.getOfDocBaseType(Env.getCtx(), docBaseType);
        if (docs == null || docs.length == 0) {
            throw new AdempiereException("@C_DocType_ID@ @NotFound@ " + docBaseType);
        }
        for (MDocType doc : docs) {
            if (doc.getAD_Org_ID() != AD_Org_ID) continue;
            return doc.getC_DocType_ID();
        }
        return docs[0].getC_DocType_ID();
    }

    public static MDocType[] getOfDocBaseType(Properties ctx, String DocBaseType) {
        String whereClause = "AD_Client_ID=? AND DocBaseType=?";
        List<MDocType> list = new Query(ctx, "C_DocType", "AD_Client_ID=? AND DocBaseType=?", null).setParameters(Env.getAD_Client_ID(ctx), DocBaseType).setOnlyActiveRecords(true).setOrderBy("IsDefault DESC, C_DocType_ID").list();
        return list.toArray(new MDocType[list.size()]);
    }

    public static MDocType[] getOfClient(Properties ctx) {
        List<MDocType> list = new Query(ctx, "C_DocType", null, null).setClient_ID().setOnlyActiveRecords(true).list();
        return list.toArray(new MDocType[list.size()]);
    }

    public static MDocType get(Properties ctx, int C_DocType_ID) {
        MDocType retValue = s_cache.get(C_DocType_ID);
        if (retValue == null) {
            retValue = new MDocType(ctx, C_DocType_ID, null);
            s_cache.put(C_DocType_ID, retValue);
        }
        return retValue;
    }

    public MDocType(Properties ctx, int C_DocType_ID, String trxName) {
        super(ctx, C_DocType_ID, trxName);
        if (C_DocType_ID == 0) {
            this.setDocumentCopies(0);
            this.setHasCharges(false);
            this.setIsDefault(false);
            this.setIsDocNoControlled(false);
            this.setIsSOTrx(false);
            this.setIsPickQAConfirm(false);
            this.setIsShipConfirm(false);
            this.setIsSplitWhenDifference(false);
            this.setIsCreateCounter(true);
            this.setIsDefaultCounterDoc(false);
            this.setIsIndexed(true);
        }
    }

    public MDocType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDocType(Properties ctx, String DocBaseType, String Name2, String trxName) {
        this(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setDocBaseType(DocBaseType);
        this.setName(Name2);
        this.setPrintName(Name2);
        this.setGL_Category_ID();
    }

    public void setGL_Category_ID() {
        String sql = "SELECT GL_Category_ID FROM GL_Category WHERE AD_Client_ID=? ORDER BY IsDefault DESC, GL_Category_ID";
        int GL_Category_ID = DB.getSQLValue(this.get_TrxName(), "SELECT GL_Category_ID FROM GL_Category WHERE AD_Client_ID=? ORDER BY IsDefault DESC, GL_Category_ID", this.getAD_Client_ID());
        this.setGL_Category_ID(GL_Category_ID);
    }

    public void setIsSOTrx() {
        boolean isSOTrx = "SOO".equals(this.getDocBaseType()) || "MMS".equals(this.getDocBaseType()) || this.getDocBaseType().startsWith("AR");
        super.setIsSOTrx(isSOTrx);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MDocType[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",DocNoSequence_ID=").append(this.getDocNoSequence_ID()).append("]");
        return sb.toString();
    }

    public boolean isQuotation() {
        return "OB".equals(this.getDocSubTypeSO()) && "SOO".equals(this.getDocBaseType());
    }

    public boolean isProposal() {
        return "ON".equals(this.getDocSubTypeSO()) && "SOO".equals(this.getDocBaseType());
    }

    public boolean isOffer() {
        return ("ON".equals(this.getDocSubTypeSO()) || "OB".equals(this.getDocSubTypeSO())) && "SOO".equals(this.getDocBaseType());
    }

    public String getPrintName(String AD_Language) {
        if (AD_Language == null || AD_Language.length() == 0) {
            return super.getPrintName();
        }
        return this.get_Translation("PrintName", AD_Language);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            String sqlDocAction = "INSERT INTO AD_Document_Action_Access (AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,C_DocType_ID , AD_Ref_List_ID, AD_Role_ID) (SELECT " + this.getAD_Client_ID() + ",0,'Y', SysDate," + this.getUpdatedBy() + ", SysDate," + this.getUpdatedBy() + ", doctype.C_DocType_ID, action.AD_Ref_List_ID, rol.AD_Role_ID FROM AD_Client client INNER JOIN C_DocType doctype ON (doctype.AD_Client_ID=client.AD_Client_ID) INNER JOIN AD_Ref_List action ON (action.AD_Reference_ID=135) INNER JOIN AD_Role rol ON (rol.AD_Client_ID=client.AD_Client_ID) WHERE client.AD_Client_ID=" + this.getAD_Client_ID() + " AND doctype.C_DocType_ID=" + this.get_ID() + " AND rol.IsManual='N')";
            int docact = DB.executeUpdate(sqlDocAction, this.get_TrxName());
            this.log.fine("AD_Document_Action_Access=" + docact);
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            int docactDel = DB.executeUpdate("DELETE FROM AD_Document_Action_Access WHERE C_DocType_ID=" + this.get_IDOld(), this.get_TrxName());
            this.log.fine("Delete AD_Document_Action_Access=" + docactDel + " for C_DocType_ID: " + this.get_IDOld());
        }
        return success;
    }
}

