/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.I_C_DunningLevel;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_DunningRunLine;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDunningRunLine
extends X_C_DunningRunLine {
    private static final long serialVersionUID = -6329441027195611155L;
    private MDunningRunEntry parent = null;
    private MInvoice invoice = null;
    private MPayment payment = null;
    private int currencyFromId = 0;
    private int currencyToId = 0;

    public MDunningRunLine(Properties ctx, int C_DunningRunLine_ID, String trxName) {
        super(ctx, C_DunningRunLine_ID, trxName);
        if (C_DunningRunLine_ID == 0) {
            this.setAmt(Env.ZERO);
            this.setOpenAmt(Env.ZERO);
            this.setConvertedAmt(Env.ZERO);
            this.setFeeAmt(Env.ZERO);
            this.setInterestAmt(Env.ZERO);
            this.setTotalAmt(Env.ZERO);
            this.setDaysDue(0);
            this.setTimesDunned(0);
            this.setIsInDispute(false);
            this.setProcessed(false);
        }
    }

    public MDunningRunLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDunningRunLine(MDunningRunEntry parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setC_DunningRunEntry_ID(parent.getC_DunningRunEntry_ID());
        this.parent = parent;
        this.currencyToId = parent.getC_Currency_ID();
    }

    public MDunningRunEntry getParent() {
        if (this.parent == null) {
            this.parent = new MDunningRunEntry(this.getCtx(), this.getC_DunningRunEntry_ID(), this.get_TrxName());
        }
        return this.parent;
    }

    public MInvoice getInvoice() {
        if (this.getC_Invoice_ID() == 0) {
            this.invoice = null;
        } else if (this.invoice == null) {
            this.invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.invoice;
    }

    public void setInvoice(MInvoice invoice) {
        this.invoice = invoice;
        if (invoice != null) {
            this.currencyFromId = invoice.getC_Currency_ID();
            this.setAmt(invoice.getGrandTotal());
            this.setOpenAmt(this.getAmt());
            this.setConvertedAmt(MConversionRate.convert(this.getCtx(), this.getOpenAmt(), this.getC_CurrencyFrom_ID(), this.getC_CurrencyTo_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()));
        } else {
            this.currencyFromId = 0;
            this.setAmt(Env.ZERO);
            this.setOpenAmt(Env.ZERO);
            this.setConvertedAmt(Env.ZERO);
        }
    }

    public void setInvoice(int invoiceId, int currencyId, BigDecimal grandTotal, BigDecimal open, BigDecimal feeAmount, int daysDue, boolean isInDispute, int timesDunned, int daysAfterLast, int orderId) {
        this.setC_Invoice_ID(invoiceId);
        this.currencyFromId = currencyId;
        this.setAmt(grandTotal);
        this.setOpenAmt(open);
        this.setFeeAmt(feeAmount);
        this.setConvertedAmt(MConversionRate.convert(this.getCtx(), this.getOpenAmt(), currencyId, this.getC_CurrencyTo_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()));
        this.setIsInDispute(isInDispute);
        this.setDaysDue(daysDue);
        this.setTimesDunned(timesDunned);
        if (orderId != 0) {
            this.setC_Order_ID(orderId);
        }
    }

    public void setFee(int C_Currency_ID, BigDecimal FeeAmount) {
        this.currencyFromId = C_Currency_ID;
        this.setAmt(FeeAmount);
        this.setOpenAmt(FeeAmount);
        this.setFeeAmt(FeeAmount);
        this.setConvertedAmt(MConversionRate.convert(this.getCtx(), this.getOpenAmt(), C_Currency_ID, this.getC_CurrencyTo_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()));
    }

    public MPayment getPayment() {
        if (this.getC_Payment_ID() == 0) {
            this.payment = null;
        } else if (this.payment == null) {
            this.payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        }
        return this.payment;
    }

    public void setPayment(int paymentId, int currencyId, BigDecimal payAmt, BigDecimal openAmt, int orderId) {
        this.setC_Payment_ID(paymentId);
        this.currencyFromId = currencyId;
        this.setAmt(payAmt);
        this.setOpenAmt(openAmt);
        this.setConvertedAmt(MConversionRate.convert(this.getCtx(), this.getOpenAmt(), currencyId, this.getC_CurrencyTo_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()));
        if (orderId != 0) {
            this.setC_Order_ID(orderId);
        }
    }

    public int getC_CurrencyFrom_ID() {
        if (this.currencyFromId == 0) {
            if (this.getC_Invoice_ID() != 0) {
                this.currencyFromId = this.getInvoice().getC_Currency_ID();
            } else if (this.getC_Payment_ID() != 0) {
                this.currencyFromId = this.getPayment().getC_Currency_ID();
            }
        }
        return this.currencyFromId;
    }

    public int getC_CurrencyTo_ID() {
        if (this.currencyToId == 0) {
            this.currencyToId = this.getParent().getC_Currency_ID();
        }
        return this.currencyToId;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        I_C_DunningLevel level;
        if (this.getC_Invoice_ID() == 0 && this.getC_Payment_ID() == 0) {
            this.setAmt(Env.ZERO);
            this.setOpenAmt(Env.ZERO);
        }
        if (Env.ZERO.compareTo(this.getOpenAmt()) == 0) {
            this.setConvertedAmt(Env.ZERO);
        } else if (Env.ZERO.compareTo(this.getConvertedAmt()) == 0) {
            this.setConvertedAmt(MConversionRate.convert(this.getCtx(), this.getOpenAmt(), this.getC_CurrencyFrom_ID(), this.getC_CurrencyTo_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()));
        }
        this.setTotalAmt(this.getConvertedAmt().add(this.getFeeAmt()).add(this.getInterestAmt()));
        if (this.isProcessed() && this.getInvoice() != null && (level = this.getParent().getC_DunningLevel()) != null) {
            this.getInvoice().setC_DunningLevel_ID(level.getC_DunningLevel_ID());
            if (level.getInvoiceCollectionType() != null) {
                this.getInvoice().setInvoiceCollectionType(level.getInvoiceCollectionType());
            } else if (!level.isStatement()) {
                this.getInvoice().setInvoiceCollectionType("D");
            }
            this.getInvoice().saveEx();
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        this.updateEntry();
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        this.updateEntry();
        return success;
    }

    private void updateEntry() {
        String sql = "UPDATE C_DunningRunEntry e SET Amt=NVL((SELECT SUM(ConvertedAmt)+SUM(FeeAmt)+SUM(InterestAmt) FROM C_DunningRunLine l WHERE e.C_DunningRunEntry_ID=l.C_DunningRunEntry_ID), 0), QTY=(SELECT COUNT(*) FROM C_DunningRunLine l WHERE e.C_DunningRunEntry_ID=l.C_DunningRunEntry_ID  AND (NOT C_Invoice_ID IS NULL OR NOT C_Payment_ID IS NULL)) WHERE C_DunningRunEntry_ID=" + this.getC_DunningRunEntry_ID();
        DB.executeUpdate(sql, this.get_TrxName());
    }
}

