/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.p;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.X_AD_Memo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MMemo
extends X_AD_Memo {
    private static final long serialVersionUID = 1182089396648565786L;
    private static CLogger s_log = CLogger.getCLogger(MMemo.class);
    private static SimpleDateFormat m_format;

    public MMemo(Properties ctx, int AD_Memo_ID, String trxName) {
        super(ctx, AD_Memo_ID, trxName);
    }

    public MMemo(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMemo(Properties ctx, int AD_User_ID, int AD_Table_ID, int Record_ID, String comment, String trxName) {
        this(ctx, 0, trxName);
        this.setRecord(AD_Table_ID, Record_ID);
        this.setComments(comment);
    }

    public void setRecord(int AD_Table_ID, int Record_ID) {
        this.setAD_Table_ID(AD_Table_ID);
        this.setRecord_ID(Record_ID);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MMemo[").append(this.get_ID()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAlerts(Properties ctx, String tableName, int Record_ID) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        ArrayList<MMemo> list = new ArrayList<MMemo>();
        MTable table2 = MTable.get(ctx, tableName);
        if (table2 == null) {
            return null;
        }
        String sql = "SELECT * FROM AD_Memo WHERE AD_Client_ID=? AND AD_Table_ID=? AND Record_ID=?  AND IsAlert = 'Y' AND IsActive = 'Y' ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, table2.getAD_Table_ID());
            pstmt.setInt(3, Record_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMemo(ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() == 0) {
            return null;
        }
        p history = new p();
        boolean first = true;
        for (MMemo memo : list) {
            if (first) {
                first = false;
            } else {
                history.addElement((Element)new hr());
            }
            b b2 = new b();
            MUser user = MUser.get(ctx, memo.getCreatedBy());
            b2.addElement(user.getName());
            b2.addElement(" \t");
            Timestamp created = memo.getCreated();
            if (m_format == null) {
                m_format = DisplayType.getDateFormat(16);
            }
            b2.addElement(m_format.format(created));
            history.addElement((Element)b2);
            p p2 = new p();
            String data = memo.getComments();
            data = Util.maskHTML(data, true);
            p2.addElement(data);
            history.addElement((Element)p2);
        }
        return history.toString();
    }
}

