/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.compiere.model.MAccount;
import org.compiere.model.MInvoice;
import org.compiere.model.MPriceList;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectType;
import org.compiere.model.MProjectTypePhase;
import org.compiere.model.MRequest;
import org.compiere.model.MStandardRequestType;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Project;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MProjectMember;
import org.eevolution.model.X_I_Project;

public class MProject
extends X_C_Project {
    private static CCache<Integer, MProject> projectCacheIds = new CCache("C_Project", 100, 0);
    private static CCache<String, MProject> projectCacheValues = new CCache("C_Project", 100, 0);
    private static final long serialVersionUID = 2151648902207548617L;
    private int m_M_PriceList_ID = 0;

    public static MProject getById(Properties ctx, Integer projectId, String trxName) {
        MProject project;
        if (projectId <= 0) {
            return null;
        }
        if (projectCacheIds.size() == 0) {
            MProject.getAll(ctx, true, trxName);
        }
        if ((project = projectCacheIds.get(projectId)) != null) {
            return project;
        }
        project = (MProject)new Query(ctx, "C_Project", "C_Project_ID=?", null).setClient_ID().setParameters(projectId).first();
        if (project != null && project.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID(ctx);
            String key = clientId + "#" + project.getValue();
            projectCacheIds.put(project.get_ID(), project);
            projectCacheValues.put(key, project);
        }
        return project;
    }

    public static MProject getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MProject project;
        if (value == null) {
            return null;
        }
        if (projectCacheValues.size() == 0) {
            MProject.getAll(ctx, true, trxName);
        }
        if ((project = projectCacheValues.get(key = (clientId = Env.getAD_Client_ID(ctx)) + "#" + value)) != null && project.get_ID() > 0) {
            return project;
        }
        project = (MProject)new Query(ctx, "C_Project", "Value=?", trxName).setClient_ID().setParameters(value).first();
        if (project != null && project.get_ID() > 0) {
            projectCacheValues.put(key, project);
            projectCacheIds.put(project.get_ID(), project);
        }
        return project;
    }

    public static List<MProject> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || projectCacheIds.size() > 0) {
            List<MProject> projectList = new Query(Env.getCtx(), "C_Project", null, trxName).setClient_ID().setOrderBy("Name").list();
            projectList.stream().forEach(project -> {
                int clientId = Env.getAD_Client_ID(ctx);
                String key = clientId + "#" + project.getValue();
                projectCacheIds.put(project.getC_Project_ID(), (MProject)project);
                projectCacheValues.put(key, (MProject)project);
            });
            return projectList;
        }
        List<MProject> projectList = projectCacheIds.entrySet().stream().map(project -> (MProject)project.getValue()).collect(Collectors.toList());
        return projectList;
    }

    public static MProject copyFrom(Properties ctx, int C_Project_ID, Timestamp dateDoc, String trxName) {
        MProject from = new MProject(ctx, C_Project_ID, trxName);
        if (from.getC_Project_ID() == 0) {
            throw new IllegalArgumentException("From Project not found C_Project_ID=" + C_Project_ID);
        }
        MProject to = new MProject(ctx, 0, trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Project_ID", I_ZERO);
        String Value = to.getValue() + " ";
        String Time2 = dateDoc.toString();
        int length = Value.length() + Time2.length();
        Value = length <= 40 ? Value + Time2 : Value + Time2.substring(length - 40);
        to.setValue(Value);
        to.setInvoicedAmt(Env.ZERO);
        to.setProjectBalanceAmt(Env.ZERO);
        to.setProcessed(false);
        if (!to.save()) {
            throw new IllegalStateException("Could not create Project");
        }
        if (to.copyDetailsFrom(from) == 0) {
            throw new IllegalStateException("Could not create Project Details");
        }
        return to;
    }

    public MProject(Properties ctx, int C_Project_ID, String trxName) {
        super(ctx, C_Project_ID, trxName);
        if (C_Project_ID == 0) {
            this.setCommittedAmt(Env.ZERO);
            this.setCommittedQty(Env.ZERO);
            this.setInvoicedAmt(Env.ZERO);
            this.setInvoicedQty(Env.ZERO);
            this.setPlannedAmt(Env.ZERO);
            this.setPlannedMarginAmt(Env.ZERO);
            this.setPlannedQty(Env.ZERO);
            this.setProjectBalanceAmt(Env.ZERO);
            this.setProjInvoiceRule("-");
            this.setProjectLineLevel("P");
            this.setIsCommitCeiling(false);
            this.setIsCommitment(false);
            this.setIsSummary(false);
            this.setProcessed(false);
        }
    }

    public MProject(X_I_Project projectImport) {
        super(projectImport.getCtx(), 0, projectImport.get_TrxName());
        this.setAD_Org_ID(projectImport.getAD_Org_ID());
        this.setM_PriceList_Version_ID(projectImport.getM_PriceList_Version_ID());
        this.setAD_Color_ID(projectImport.getAD_Color_ID());
        this.setAD_OrgTrx_ID(projectImport.getAD_OrgTrx_ID());
        this.setAD_User_ID(projectImport.getAD_User_ID());
        this.setC_Activity_ID(projectImport.getC_Activity_ID());
        this.setC_BPartner_ID(projectImport.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(projectImport.getC_BPartner_Location_ID());
        this.setC_BPartnerSR_ID(projectImport.getC_BPartnerSR_ID());
        this.setC_Campaign_ID(projectImport.getC_Campaign_ID());
        this.setC_Currency_ID(projectImport.getC_Currency_ID());
        this.setC_PaymentTerm_ID(projectImport.getC_PaymentTerm_ID());
        this.setC_PaymentTerm_ID(projectImport.getC_PaymentTerm_ID());
        this.setC_ProjectCategory_ID(projectImport.getC_ProjectCategory_ID());
        this.setC_ProjectClass_ID(projectImport.getC_ProjectClass_ID());
        this.setC_ProjectGroup_ID(projectImport.getC_ProjectGroup_ID());
        this.setC_ProjectStatus_ID(projectImport.getC_ProjectStatus_ID());
        this.setC_SalesRegion_ID(projectImport.getC_SalesRegion_ID());
        this.setCommittedAmt(projectImport.getCommittedAmt());
        this.setCommittedQty(projectImport.getCommittedQty());
        this.setDateContract(projectImport.getDateContract());
        this.setDateDeadline(projectImport.getDateDeadline());
        this.setDateFinish(projectImport.getDateFinish());
        this.setDateStart(projectImport.getDateStart());
        this.setDateFinishSchedule(projectImport.getDateFinishSchedule());
        this.setDateStartSchedule(projectImport.getDateStartSchedule());
        this.setDescription(projectImport.getDescription());
        this.setDurationUnit(projectImport.getDurationUnit());
        this.setInvoicedAmt(projectImport.getInvoicedAmt());
        this.setInvoicedQty(projectImport.getInvoicedQty());
        this.setIsCommitCeiling(projectImport.isCommitCeiling());
        this.setIsCommitment(this.isCommitment());
        this.setIsIndefinite(projectImport.isIndefinite());
        this.setIsSummary(projectImport.isSummary());
        this.setM_Warehouse_ID(projectImport.getM_Warehouse_ID());
        this.setName(projectImport.getName());
        this.setNote(projectImport.getNote());
        this.setPlannedAmt(projectImport.getPlannedAmt());
        this.setPlannedMarginAmt(projectImport.getPlannedMarginAmt());
        this.setPlannedQty(projectImport.getPlannedQty());
        this.setPOReference(projectImport.getPOReference());
        this.setPriorityRule(projectImport.getPriorityRule());
        this.setProjectBalanceAmt(projectImport.getProjectBalanceAmt());
        this.setProjectLineLevel(projectImport.getProjectLineLevel());
        this.setProjectManager_ID(projectImport.getProjectManager_ID());
        this.setProjInvoiceRule(projectImport.getProjInvoiceRule());
        this.setSalesRep_ID(projectImport.getSalesRep_ID());
        this.setUser1_ID(projectImport.getUser1_ID());
        this.setUser2_ID(projectImport.getUser2_ID());
        this.setUser3_ID(projectImport.getUser3_ID());
        this.setUser4_ID(projectImport.getUser4_ID());
        this.setValue(projectImport.getValue());
    }

    public MProject(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public int getC_ProjectType_ID_Int() {
        String pj = super.getC_ProjectType_ID();
        if (pj == null) {
            return 0;
        }
        int C_ProjectType_ID = 0;
        try {
            C_ProjectType_ID = Integer.parseInt(pj);
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, pj, ex);
        }
        return C_ProjectType_ID;
    }

    public void setC_ProjectType_ID(int C_ProjectType_ID) {
        if (C_ProjectType_ID == 0) {
            super.setC_ProjectType_ID(null);
        } else {
            super.set_Value("C_ProjectType_ID", (Object)C_ProjectType_ID);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProject[").append(this.get_ID()).append("-").append(this.getValue()).append(",ProjectCategory=").append(this.getProjectCategory()).append("]");
        return sb.toString();
    }

    public int getM_PriceList_ID() {
        if (this.getM_PriceList_Version_ID() == 0) {
            return 0;
        }
        if (this.m_M_PriceList_ID > 0) {
            return this.m_M_PriceList_ID;
        }
        String sql = "SELECT M_PriceList_ID FROM M_PriceList_Version WHERE M_PriceList_Version_ID=?";
        this.m_M_PriceList_ID = DB.getSQLValue(null, sql, this.getM_PriceList_Version_ID());
        return this.m_M_PriceList_ID;
    }

    @Override
    public void setM_PriceList_Version_ID(int M_PriceList_Version_ID) {
        super.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        this.m_M_PriceList_ID = 0;
    }

    public List<MProjectLine> getLines() {
        String whereClause = "C_Project_ID=?";
        return new Query(this.getCtx(), "C_ProjectLine", "C_Project_ID=?", this.get_TrxName()).setParameters(this.getC_Project_ID()).setOrderBy("Line").list();
    }

    public List<MProjectIssue> getIssues() {
        String whereClause = "C_Project_ID=?";
        return new Query(this.getCtx(), "C_ProjectIssue", whereClause, this.get_TrxName()).setParameters(this.getC_Project_ID()).setOrderBy("Line").list();
    }

    public List<MProjectPhase> getPhases() {
        String whereClause = "C_Project_ID=?";
        return new Query(this.getCtx(), "C_ProjectPhase", whereClause, this.get_TrxName()).setParameters(this.getC_Project_ID()).setOrderBy("SeqNo").list();
    }

    public int copyDetailsFrom(MProject project) {
        if (this.isProcessed() || project == null) {
            return 0;
        }
        int count = this.copyLinesFrom(project) + this.copyPhasesFrom(project);
        return count;
    }

    public int copyLinesFrom(MProject project) {
        if (this.isProcessed() || project == null) {
            return 0;
        }
        AtomicInteger count = new AtomicInteger(0);
        List<MProjectLine> fromProjectLines = project.getLines();
        fromProjectLines.stream().filter(fromProjectLine -> fromProjectLine.getC_ProjectPhase_ID() <= 0 || fromProjectLine.getC_ProjectTask_ID() <= 0).forEach(fromProjectLine -> {
            MProjectLine toProjectLine = new MProjectLine(this.getCtx(), 0, project.get_TrxName());
            PO.copyValues(fromProjectLine, toProjectLine, this.getAD_Client_ID(), this.getAD_Org_ID());
            toProjectLine.setC_Project_ID(this.getC_Project_ID());
            toProjectLine.setInvoicedAmt(Env.ZERO);
            toProjectLine.setInvoicedQty(Env.ZERO);
            toProjectLine.setC_OrderPO_ID(0);
            toProjectLine.setC_Order_ID(0);
            toProjectLine.setProcessed(false);
            toProjectLine.saveEx();
            count.getAndUpdate(no -> no + 1);
        });
        if (fromProjectLines.size() != count.get()) {
            this.log.log(Level.SEVERE, "Lines difference - Project=" + fromProjectLines.size() + " <> Saved=" + count);
        }
        return count.get();
    }

    public int copyPhasesFrom(MProject fromProject) {
        if (this.isProcessed() || fromProject == null) {
            return 0;
        }
        AtomicInteger count = new AtomicInteger(0);
        AtomicInteger taskCount = new AtomicInteger(0);
        AtomicInteger lineCount = new AtomicInteger(0);
        List<MProjectPhase> toPhases = this.getPhases();
        List<MProjectPhase> fromPhases = fromProject.getPhases();
        fromPhases.stream().forEach(fromPhase -> {
            Boolean exists = toPhases.stream().anyMatch(toPhase -> toPhase.getC_Phase_ID() == fromPhase.getC_Phase_ID());
            if (exists.booleanValue()) {
                this.log.info("Phase already exists here, ignored - " + fromPhase);
            } else {
                MProjectPhase toPhase2 = new MProjectPhase(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues(fromPhase, toPhase2, this.getAD_Client_ID(), this.getAD_Org_ID());
                toPhase2.setC_Project_ID(this.getC_Project_ID());
                toPhase2.setC_Order_ID(0);
                toPhase2.setIsComplete(false);
                toPhase2.saveEx();
                count.getAndUpdate(no -> no + 1);
                taskCount.getAndUpdate(taskNo -> taskNo + toPhase2.copyTasksFrom((MProjectPhase)fromPhase));
                lineCount.getAndUpdate(lineNo -> lineNo + toPhase2.copyLinesFrom((MProjectPhase)fromPhase));
            }
        });
        if (fromPhases.size() != count.get()) {
            this.log.warning("Count difference - Project=" + fromPhases.size() + " <> Saved=" + count.get());
        }
        return count.get() + taskCount.get() + lineCount.get();
    }

    public void setProjectType(MProjectType type) {
        if (type == null) {
            return;
        }
        this.setC_ProjectType_ID(Integer.toString(type.getC_ProjectType_ID()));
        this.setProjectCategory(type.getProjectCategory());
        this.createRequest(type);
        this.copyPhasesFrom(type);
    }

    public int copyPhasesFrom(MProjectType type) {
        AtomicInteger count = new AtomicInteger(0);
        AtomicInteger taskCount = new AtomicInteger(0);
        List<MProjectTypePhase> typePhases = type.getPhases();
        typePhases.stream().forEach(fromPhase -> {
            MProjectPhase toPhase = new MProjectPhase(this, (MProjectTypePhase)fromPhase);
            toPhase.setC_Project_ID(this.getC_Project_ID());
            toPhase.setProjInvoiceRule(this.getProjInvoiceRule());
            toPhase.saveEx();
            count.getAndUpdate(no -> no + 1);
            taskCount.getAndUpdate(no -> no + toPhase.copyTasksFrom((MProjectTypePhase)fromPhase));
        });
        this.log.fine("#" + count.get() + "/" + taskCount.get() + " - " + type);
        if (typePhases.size() != count.get()) {
            this.log.log(Level.SEVERE, "Count difference - Type=" + typePhases.size() + " <> Saved=" + count.get());
        }
        return count.get();
    }

    public void createRequest(MProjectType projectType) {
        if (projectType.getR_StandardRequestType_ID() > 0) {
            MStandardRequestType standardRequestType = (MStandardRequestType)projectType.getR_StandardRequestType();
            List<MRequest> requests = standardRequestType.createStandardRequest(this);
            requests.stream().forEach(request -> {
                request.setC_Project_ID(this.getC_Project_ID());
                request.setDateStartPlan(this.getDateStartSchedule());
                request.setDateCompletePlan(this.getDateFinishSchedule());
                request.saveEx();
            });
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MPriceList pl;
        if (this.getAD_User_ID() == -1) {
            this.setAD_User_ID(0);
        }
        if (this.is_ValueChanged("M_PriceList_Version_ID") && this.getM_PriceList_Version_ID() != 0 && (pl = MPriceList.get(this.getCtx(), this.getM_PriceList_ID(), null)) != null && pl.get_ID() != 0) {
            this.setC_Currency_ID(pl.getC_Currency_ID());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            this.insert_Accounting("C_Project_Acct", "C_AcctSchema_Default", null);
        }
        if (success && !newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "C_Project_ID=" + this.getC_Project_ID(), this.get_TrxName());
        }
        if (this.getSalesRep_ID() > 0 && !MProjectMember.memberExists(this, this.getSalesRep_ID()).booleanValue()) {
            MProjectMember.addMember(this, this.getSalesRep_ID());
        }
        if (this.getProjectManager_ID() > 0 && !MProjectMember.memberExists(this, this.getProjectManager_ID()).booleanValue()) {
            MProjectMember.addMember(this, this.getProjectManager_ID());
        }
        if (this.getAD_User_ID() > 0 && !MProjectMember.memberExists(this, this.getAD_User_ID()).booleanValue()) {
            MProjectMember.addMember(this, this.getAD_User_ID());
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        return this.delete_Accounting("C_Project_Acct");
    }

    public MInvoice[] getMInvoices() {
        StringBuilder sb = new StringBuilder();
        sb.append("C_Project_ID").append("=?");
        Query qry = new Query(this.getCtx(), "C_Invoice", sb.toString(), this.get_TrxName());
        qry.setParameters(this.getC_Project_ID());
        return (MInvoice[])qry.list().toArray();
    }
}

