/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.X_AD_SearchDefinition;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MSearchDefinition
extends X_AD_SearchDefinition {
    private static final long serialVersionUID = 2448668218372939766L;
    public static final String SEARCHTYPE_TABLE = "T";
    public static final String SEARCHTYPE_QUERY = "Q";
    public static final String DATATYPE_STRING = "S";
    public static final String DATATYPE_INTEGER = "I";

    public MSearchDefinition(Properties ctx, int AD_SearchDefinition_ID, String trxName) {
        super(ctx, AD_SearchDefinition_ID, trxName);
    }

    public MSearchDefinition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static List<MSearchDefinition> getForCode(String transactionCode) throws SQLException {
        ArrayList<MSearchDefinition> list = new ArrayList<MSearchDefinition>();
        String sql = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        sql = "SELECT AD_SearchDefinition_ID FROM AD_SearchDefinition WHERE IsActive = 'Y' ";
        if (transactionCode != null) {
            sql = sql + "AND UPPER(TransactionCode) = ?";
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, transactionCode.toUpperCase());
        } else {
            sql = sql + "AND IsDefault = 'Y'";
            pstmt = DB.prepareStatement(sql, null);
        }
        if (pstmt != null) {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MSearchDefinition msd = new MSearchDefinition(Env.getCtx(), rs.getInt(1), null);
                if (!msd.isActive()) continue;
                list.add(msd);
            }
        }
        DB.close(rs, pstmt);
        return list;
    }

    public static boolean isValidTransactionCode(String transactionCode) throws SQLException {
        boolean found = false;
        if (transactionCode != null) {
            String sql = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            sql = "SELECT AD_SearchDefinition_ID FROM AD_SearchDefinition WHERE UPPER(TransactionCode) = ? AND IsActive = 'Y'";
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, transactionCode.toUpperCase());
            if (pstmt != null) {
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    found = true;
                }
            }
            DB.close(rs, pstmt);
        }
        return found;
    }
}

