/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.model.POWrapper;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.POIterator;
import org.compiere.model.POResultSet;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class Query {
    public static final String AGGREGATE_COUNT = "COUNT";
    public static final String AGGREGATE_SUM = "SUM";
    public static final String AGGREGATE_AVG = "AVG";
    public static final String AGGREGATE_MIN = "MIN";
    public static final String AGGREGATE_MAX = "MAX";
    public static final int NO_LIMIT = -1;
    private int limit = -1;
    private static CLogger log = CLogger.getCLogger(Query.class);
    private Properties ctx = null;
    private MTable table = null;
    private String whereClause = null;
    private String orderBy = null;
    private String trxName = null;
    private Object[] parameters = null;
    private boolean applyAccessFilter = false;
    private boolean applyAccessFilterRW = false;
    private boolean applyAccessFilterFullyQualified = true;
    private boolean onlyActiveRecords = false;
    private boolean onlyClient_ID = false;
    private int onlySelection_ID = -1;

    public Query(MTable table2, String whereClause, String trxName) {
        this.ctx = table2.getCtx();
        this.table = table2;
        this.whereClause = whereClause;
        this.trxName = trxName;
    }

    public Query(Properties ctx, MTable table2, String whereClause, String trxName) {
        this.ctx = ctx;
        this.table = table2;
        this.whereClause = whereClause;
        this.trxName = trxName;
    }

    public Query(Properties ctx, String tableName, String whereClause, String trxName) {
        this(ctx, MTable.get(ctx, tableName), whereClause, trxName);
        if (this.table == null) {
            throw new IllegalArgumentException("Table Name Not Found - " + tableName);
        }
    }

    public Query setParameters(Object ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public Query setParameters(List<Object> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return this;
        }
        this.parameters = new Object[parameters.size()];
        parameters.toArray(this.parameters);
        return this;
    }

    public Query setOrderBy(String orderBy) {
        String string = this.orderBy = orderBy != null ? orderBy.trim() : null;
        if (this.orderBy != null && this.orderBy.toUpperCase().startsWith("ORDER BY")) {
            this.orderBy = this.orderBy.substring(8);
        }
        return this;
    }

    public Query setApplyAccessFilter(boolean flag) {
        this.applyAccessFilter = flag;
        return this;
    }

    public Query setApplyAccessFilter(boolean fullyQualified, boolean RW) {
        this.applyAccessFilter = true;
        this.applyAccessFilterFullyQualified = fullyQualified;
        this.applyAccessFilterRW = RW;
        return this;
    }

    public Query setOnlyActiveRecords(boolean onlyActiveRecords) {
        this.onlyActiveRecords = onlyActiveRecords;
        return this;
    }

    public Query setClient_ID() {
        this.onlyClient_ID = true;
        return this;
    }

    public Query setOnlySelection(int AD_PInstance_ID) {
        this.onlySelection_ID = AD_PInstance_ID;
        return this;
    }

    public <T extends PO> List<T> list() throws DBException {
        return this.list(null);
    }

    public <T> List<T> list(Class<T> clazz) throws DBException {
        ArrayList<PO> list = this.limit > 0 ? new ArrayList(this.limit) : new ArrayList<PO>();
        String sql = this.buildSQL(null, true);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.trxName);
            rs = this.createResultSet(pstmt);
            while (rs.next()) {
                PO o = this.table.getPO(rs, this.trxName);
                PO po = clazz != null && !o.getClass().isAssignableFrom(clazz) ? POWrapper.create(o, clazz) : o;
                list.add(po);
                if (this.limit <= 0 || list.size() < this.limit) continue;
                log.fine("Limit of " + this.limit + " reached. Stop.");
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql, e);
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return list;
    }

    public <T extends PO> T first() throws DBException {
        PO po = null;
        String sql = this.buildSQL(null, true);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.trxName);
            rs = this.createResultSet(pstmt);
            if (rs.next()) {
                po = this.table.getPO(rs, this.trxName);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql, e);
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return (T)po;
    }

    public <T extends PO> T firstOnly() throws DBException {
        PO po = null;
        String sql = this.buildSQL(null, true);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.trxName);
            rs = this.createResultSet(pstmt);
            if (rs.next()) {
                po = this.table.getPO(rs, this.trxName);
            }
            if (rs.next()) {
                throw new DBException("QueryMoreThanOneRecordsFound");
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql, e);
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return (T)po;
    }

    public int firstId() throws DBException {
        return this.firstId(false);
    }

    public int firstIdOnly() throws DBException {
        return this.firstId(true);
    }

    private int firstId(boolean assumeOnlyOneResult) throws DBException {
        String[] keys = this.table.getKeyColumns();
        if (keys.length != 1) {
            throw new DBException("Table " + this.table + " has 0 or more than 1 key columns");
        }
        StringBuffer selectClause = new StringBuffer("SELECT ");
        selectClause.append(keys[0]);
        selectClause.append(" FROM ").append(this.table.getTableName());
        String sql = this.buildSQL(selectClause, true);
        int id = -1;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.trxName);
            rs = this.createResultSet(pstmt);
            if (rs.next()) {
                id = rs.getInt(1);
            }
            if (assumeOnlyOneResult && rs.next()) {
                throw new DBException("QueryMoreThanOneRecordsFound");
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return id;
    }

    public String getSQL() throws DBException {
        return this.buildSQL(null, true);
    }

    public BigDecimal aggregate(String sqlExpression, String sqlFunction) throws DBException {
        return this.aggregate(sqlExpression, sqlFunction, BigDecimal.class);
    }

    public <T> T aggregate(String sqlExpression, String sqlFunction, Class<T> returnType) throws DBException {
        if (Util.isEmpty(sqlFunction, true)) {
            throw new DBException("No Aggregate Function defined");
        }
        if (Util.isEmpty(sqlExpression, true)) {
            if (AGGREGATE_COUNT == sqlFunction) {
                sqlExpression = "*";
            } else {
                throw new DBException("No Expression defined");
            }
        }
        StringBuffer sqlSelect = new StringBuffer("SELECT ").append(sqlFunction).append("(").append(sqlExpression).append(")").append(" FROM ").append(this.table.getTableName());
        Object value = null;
        Comparable<BigDecimal> defaultValue = null;
        String sql = this.buildSQL(sqlSelect, false);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.trxName);
            rs = this.createResultSet(pstmt);
            if (rs.next()) {
                if (returnType.isAssignableFrom(BigDecimal.class)) {
                    value = rs.getBigDecimal(1);
                    defaultValue = Env.ZERO;
                } else if (returnType.isAssignableFrom(Double.class)) {
                    value = rs.getDouble(1);
                    defaultValue = 0.0;
                } else if (returnType.isAssignableFrom(Integer.class)) {
                    value = rs.getInt(1);
                    defaultValue = 0;
                } else if (returnType.isAssignableFrom(Timestamp.class)) {
                    value = rs.getTimestamp(1);
                } else if (returnType.isAssignableFrom(Boolean.class)) {
                    value = "Y".equals(rs.getString(1));
                    defaultValue = Boolean.FALSE;
                } else {
                    value = rs.getObject(1);
                }
            }
            if (rs.next()) {
                throw new DBException("QueryMoreThanOneRecordsFound");
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public int count() throws DBException {
        return this.aggregate("*", AGGREGATE_COUNT).intValue();
    }

    public BigDecimal sum(String sqlExpression) {
        return this.aggregate(sqlExpression, AGGREGATE_SUM);
    }

    public boolean match() throws DBException {
        ResultSet rs;
        CPreparedStatement pstmt;
        block4: {
            boolean bl;
            String sql = this.buildSQL(new StringBuffer("SELECT 1 FROM ").append(this.table.getTableName()), false);
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = this.createResultSet(pstmt);
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            return bl;
        }
        DB.close(rs, pstmt);
        return false;
    }

    public <T extends PO> Iterator<T> iterate() throws DBException {
        String[] keys = this.table.getKeyColumns();
        StringBuffer sqlBuffer = new StringBuffer(" SELECT ");
        for (int i2 = 0; i2 < keys.length; ++i2) {
            if (i2 > 0) {
                sqlBuffer.append(", ");
            }
            sqlBuffer.append(keys[i2]);
        }
        sqlBuffer.append(" FROM ").append(this.table.getTableName());
        String sql = this.buildSQL(sqlBuffer, true);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Object[]> idList = new ArrayList<Object[]>();
        try {
            pstmt = DB.prepareStatement(sql, this.trxName);
            rs = this.createResultSet(pstmt);
            while (rs.next()) {
                Object[] ids = new Object[keys.length];
                for (int i3 = 0; i3 < ids.length; ++i3) {
                    ids[i3] = rs.getObject(i3 + 1);
                }
                idList.add(ids);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql, e);
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return new POIterator(this.table, idList, this.trxName);
    }

    public <T extends PO> POResultSet<T> scroll() throws DBException {
        POResultSet pOResultSet;
        block5: {
            String sql = this.buildSQL(null, true);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            POResultSet rsPO = null;
            try {
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = this.createResultSet(pstmt);
                rsPO = new POResultSet(this.table, pstmt, rs, this.trxName);
                rsPO.setCloseOnError(true);
                pOResultSet = rsPO;
                if (rsPO != null) break block5;
            }
            catch (SQLException e) {
                try {
                    log.log(Level.SEVERE, sql, e);
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    if (rsPO == null) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                    }
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return pOResultSet;
    }

    private final String buildSQL(StringBuffer selectClause, boolean useOrderByClause) {
        if (selectClause == null) {
            POInfo info = POInfo.getPOInfo(this.ctx, this.table.getAD_Table_ID(), this.trxName);
            if (info == null) {
                throw new IllegalStateException("No POInfo found for AD_Table_ID=" + this.table.getAD_Table_ID());
            }
            selectClause = info.buildSelect();
        }
        StringBuffer whereBuffer = new StringBuffer();
        if (!Util.isEmpty(this.whereClause, true)) {
            if (whereBuffer.length() > 0) {
                whereBuffer.append(" AND ");
            }
            whereBuffer.append("(").append(this.whereClause).append(")");
        }
        if (this.onlyActiveRecords) {
            if (whereBuffer.length() > 0) {
                whereBuffer.append(" AND ");
            }
            whereBuffer.append("IsActive=?");
        }
        if (this.onlyClient_ID) {
            if (whereBuffer.length() > 0) {
                whereBuffer.append(" AND ");
            }
            whereBuffer.append("AD_Client_ID=?");
        }
        if (this.onlySelection_ID > 0) {
            String[] keys = this.table.getKeyColumns();
            if (keys.length != 1) {
                throw new DBException("Table " + this.table + " has 0 or more than 1 key columns");
            }
            if (whereBuffer.length() > 0) {
                whereBuffer.append(" AND ");
            }
            whereBuffer.append(" EXISTS (SELECT 1 FROM T_Selection s WHERE s.AD_PInstance_ID=? AND s.T_Selection_ID=" + this.table.getTableName() + "." + keys[0] + ")");
        }
        StringBuffer sqlBuffer = new StringBuffer(selectClause);
        if (whereBuffer.length() > 0) {
            sqlBuffer.append(" WHERE ").append(whereBuffer);
        }
        if (useOrderByClause && !Util.isEmpty(this.orderBy, true)) {
            sqlBuffer.append(" ORDER BY ").append(this.orderBy);
        }
        String sql = sqlBuffer.toString();
        if (this.applyAccessFilter) {
            MRole role = MRole.getDefault(this.ctx, false);
            sql = role.addAccessSQL(sql, this.table.getTableName(), this.applyAccessFilterFullyQualified, this.applyAccessFilterRW);
        }
        if (CLogMgt.isLevelFinest()) {
            log.finest("TableName = " + this.table.getTableName() + "... SQL = " + sql);
        }
        return sql;
    }

    private final ResultSet createResultSet(PreparedStatement pstmt) throws SQLException {
        DB.setParameters(pstmt, this.parameters);
        int i2 = 1 + (this.parameters != null ? this.parameters.length : 0);
        if (this.onlyActiveRecords) {
            DB.setParameter(pstmt, i2++, true);
            log.finest("Parameter IsActive = Y");
        }
        if (this.onlyClient_ID) {
            int AD_Client_ID = Env.getAD_Client_ID(this.ctx);
            DB.setParameter(pstmt, i2++, AD_Client_ID);
            log.finest("Parameter AD_Client_ID = " + AD_Client_ID);
        }
        if (this.onlySelection_ID > 0) {
            DB.setParameter(pstmt, i2++, this.onlySelection_ID);
            log.finest("Parameter Selection AD_PInstance_ID = " + this.onlySelection_ID);
        }
        return pstmt.executeQuery();
    }

    public int[] getIDs() {
        String[] keys = this.table.getKeyColumns();
        if (keys.length != 1) {
            throw new DBException("Table " + this.table + " has 0 or more than 1 key columns");
        }
        StringBuffer selectClause = new StringBuffer("SELECT ");
        selectClause.append(keys[0]);
        selectClause.append(" FROM ").append(this.table.getTableName());
        String sql = this.buildSQL(selectClause, true);
        ArrayList<Integer> list = new ArrayList<Integer>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.trxName);
            rs = this.createResultSet(pstmt);
            while (rs.next()) {
                list.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        int[] retValue = new int[list.size()];
        for (int i2 = 0; i2 < retValue.length; ++i2) {
            retValue[i2] = (Integer)list.get(i2);
        }
        return retValue;
    }
}

