/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.basic.BasicButtonListener;

public class CompiereButtonListener
extends BasicButtonListener {
    public CompiereButtonListener(AbstractButton b2) {
        super(b2);
    }

    @Override
    public void installKeyboardActions(JComponent c) {
        super.installKeyboardActions(c);
        this.updateMnemonicBindingX((AbstractButton)c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("mnemonic")) {
            this.updateMnemonicBindingX((AbstractButton)e.getSource());
        } else {
            super.propertyChange(e);
        }
    }

    void updateMnemonicBindingX(AbstractButton b2) {
        int m = b2.getMnemonic();
        if (m != 0) {
            InputMap map = SwingUtilities.getUIInputMap(b2, 2);
            if (map == null) {
                map = new ComponentInputMapUIResource(b2);
                SwingUtilities.replaceUIInputMap(b2, 2, map);
            }
            map.clear();
            String className = b2.getClass().getName();
            int mask = 8;
            if (b2 instanceof JCheckBox || className.indexOf("VButton") != -1) {
                mask = 3;
            }
            map.put(KeyStroke.getKeyStroke(m, mask, false), "pressed");
            map.put(KeyStroke.getKeyStroke(m, mask, true), "released");
            map.put(KeyStroke.getKeyStroke(m, 0, true), "released");
        } else {
            InputMap map = SwingUtilities.getUIInputMap(b2, 2);
            if (map != null) {
                map.clear();
            }
        }
    }
}

