/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.metal.MetalLabelUI;
import sun.swing.UIAction;

public class CompiereLabelUI
extends MetalLabelUI {
    protected static CompiereLabelUI adempiereLabelUI = new CompiereLabelUI();
    private static final String PRESS = "press";
    private static PressAction ACTION_PRESS = new PressAction();

    public static CompiereLabelUI createUI(JComponent c) {
        return adempiereLabelUI;
    }

    @Override
    protected void installKeyboardActions(JLabel l) {
        Component lf;
        int dka = l.getDisplayedMnemonic();
        if (dka != 0 && (lf = l.getLabelFor()) != null) {
            ActionMap actionMap = l.getActionMap();
            actionMap.put(PRESS, ACTION_PRESS);
            InputMap inputMap = SwingUtilities.getUIInputMap(l, 2);
            if (inputMap == null) {
                inputMap = new ComponentInputMapUIResource(l);
                SwingUtilities.replaceUIInputMap(l, 2, inputMap);
            }
            inputMap.clear();
            inputMap.put(KeyStroke.getKeyStroke(dka, 3, false), PRESS);
        }
    }

    private static class PressAction
    extends UIAction {
        PressAction() {
            super(CompiereLabelUI.PRESS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JLabel label = (JLabel)e.getSource();
            String key = this.getName();
            if (key.equals(CompiereLabelUI.PRESS)) {
                this.doPress(label);
            }
        }

        private void doPress(JLabel label) {
            Component labelFor = label.getLabelFor();
            if (labelFor != null && labelFor.isEnabled()) {
                Component owner = label.getLabelFor();
                if (owner instanceof Container && ((Container)owner).isFocusCycleRoot()) {
                    owner.requestFocus();
                } else {
                    if (owner instanceof Container) {
                        FocusTraversalPolicy policy;
                        Component comp;
                        FocusTraversalPolicy policy2;
                        Component comp2;
                        Container container = (Container)owner;
                        if (container.isFocusCycleRoot() && (comp2 = (policy2 = container.getFocusTraversalPolicy()).getDefaultComponent(container)) != null) {
                            comp2.requestFocus();
                            return;
                        }
                        Container rootAncestor = container.getFocusCycleRootAncestor();
                        if (rootAncestor != null && (comp = (policy = rootAncestor.getFocusTraversalPolicy()).getComponentAfter(rootAncestor, container)) != null && SwingUtilities.isDescendingFrom(comp, container)) {
                            comp.requestFocus();
                            return;
                        }
                    }
                    if (owner.isFocusable()) {
                        owner.requestFocus();
                        return;
                    }
                }
            }
        }
    }
}

