/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.event.PrintServiceAttributeEvent;
import javax.print.event.PrintServiceAttributeListener;
import org.adempiere.pdf.ITextDocument;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MProject;
import org.compiere.model.MQuery;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.CPrinter;
import org.compiere.print.DataEngine;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.MPrintFormat;
import org.compiere.print.PrintData;
import org.compiere.print.PrintUtil;
import org.compiere.print.View;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.X_HR_PaySelectionCheck;
import org.eevolution.model.X_PP_Order;
import org.spin.util.ExportFormatCSV;
import org.spin.util.ExportFormatHTML;
import org.spin.util.ExportFormatPDF;
import org.spin.util.ExportFormatPS;
import org.spin.util.ExportFormatXLS;
import org.spin.util.ExportFormatXLSX;
import org.spin.util.ExportFormatXML;

public class ReportEngine
implements PrintServiceAttributeListener {
    private static CLogger log = CLogger.getCLogger(ReportEngine.class);
    protected Properties m_ctx;
    protected MPrintFormat m_printFormat;
    private PrintInfo m_info;
    protected MQuery m_query;
    private PrintData m_printData;
    private LayoutEngine m_layout = null;
    private String m_printerName = Ini.getProperty("Printer");
    private View m_view = null;
    protected String m_trxName = null;
    private String m_whereExtended = null;
    private int m_windowNo = -1;
    private ProcessInfo processInfo = null;
    private boolean m_summary = false;
    private int m_AD_ReportView_ID = 0;
    private int m_priority = 0;
    public static final int ORDER = 0;
    public static final int SHIPMENT = 1;
    public static final int INVOICE = 2;
    public static final int PROJECT = 3;
    public static final int RFQ = 4;
    public static final int REMITTANCE = 5;
    public static final int CHECK = 6;
    public static final int DUNNING = 7;
    public static final int MANUFACTURING_ORDER = 8;
    public static final int DISTRIBUTION_ORDER = 9;
    public static final int HR_CHECK = 10;
    public static final int HR_REMITTANCE = 11;
    public static final int MOVEMENT = 12;
    private static final String[] DOC_BASETABLES = new String[]{"C_Order", "M_InOut", "C_Invoice", "C_Project", "C_RfQResponse", "C_PaySelectionCheck", "C_PaySelectionCheck", "C_DunningRunEntry", "PP_Order", "DD_Order", "HR_PaySelectionCheck", "HR_PaySelectionCheck", "M_Movement"};
    private static final String[] DOC_IDS = new String[]{"C_Order_ID", "M_InOut_ID", "C_Invoice_ID", "C_Project_ID", "C_RfQResponse_ID", "C_PaySelectionCheck_ID", "C_PaySelectionCheck_ID", "C_DunningRunEntry_ID", "PP_Order_ID", "DD_Order_ID", "HR_PaySelectionCheck_ID", "HR_PaySelectionCheck_ID", "M_Movement_ID"};
    private static final int[] DOC_TABLE_ID = new int[]{MOrder.Table_ID, MInOut.Table_ID, MInvoice.Table_ID, MProject.Table_ID, MRfQResponse.Table_ID, MPaySelectionCheck.Table_ID, MPaySelectionCheck.Table_ID, MDunningRunEntry.Table_ID, X_PP_Order.Table_ID, MDDOrder.Table_ID, X_HR_PaySelectionCheck.Table_ID, X_HR_PaySelectionCheck.Table_ID, MMovement.Table_ID};
    private String reportType;

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info) {
        this(ctx, pf, query, info, null);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, ProcessInfo pInfo, PrintInfo info) {
        this(ctx, pf, query, info, null);
        this.setProcessInfo(pInfo);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, String trxName) {
        if (pf == null) {
            throw new IllegalArgumentException("ReportEngine - no PrintFormat");
        }
        log.info(pf + " -- " + query);
        this.m_ctx = ctx;
        this.m_printFormat = pf;
        this.m_info = info;
        this.m_trxName = trxName;
        this.setSummary(this.m_printFormat.isSummary());
        this.setQuery(query);
    }

    public void setAD_ReportView_ID(int p_AD_ReportView_ID) {
        this.m_AD_ReportView_ID = p_AD_ReportView_ID;
    }

    public int getAD_ReportView_ID() {
        return this.m_AD_ReportView_ID;
    }

    public void setPriority(int priority) {
        if (priority > 0 && priority <= 100) {
            this.m_priority = priority;
        }
    }

    public void setPrintFormat(MPrintFormat pf) {
        this.m_printFormat = pf;
        if (this.m_layout != null) {
            this.setPrintData();
            this.m_layout.setPrintFormat(pf, false);
            this.m_layout.setPrintData(this.m_printData, this.m_query, true);
        }
        if (this.m_view != null) {
            this.m_view.revalidate();
        }
    }

    public void setQuery(MQuery query) {
        this.m_query = query;
        if (query == null) {
            return;
        }
        this.setPrintData();
        if (this.m_layout != null) {
            this.m_layout.setPrintData(this.m_printData, this.m_query, true);
        }
        if (this.m_view != null) {
            this.m_view.revalidate();
        }
    }

    public MQuery getQuery() {
        return this.m_query;
    }

    protected void setPrintData() {
        if (this.m_query == null) {
            return;
        }
        DataEngine de = new DataEngine(this.m_printFormat.getLanguage(), this.m_trxName);
        this.setPrintData(de.getPrintData(this.m_ctx, this.m_printFormat, this.m_query, this.m_summary, this.getAD_ReportView_ID()));
    }

    public PrintData getPrintData() {
        return this.m_printData;
    }

    public void setPrintData(PrintData printData) {
        if (printData == null) {
            return;
        }
        this.m_printData = printData;
    }

    private void layout() {
        if (this.m_printFormat == null) {
            throw new IllegalStateException("No print format");
        }
        if (this.m_printData == null) {
            throw new IllegalStateException("No print data (Delete Print Format and restart)");
        }
        this.m_layout = new LayoutEngine(this.m_printFormat, this.m_printData, this.m_query, this.m_info, this.m_trxName);
    }

    public LayoutEngine getLayout() {
        if (this.m_layout == null) {
            this.layout();
        }
        return this.m_layout;
    }

    public String getName() {
        return this.m_printFormat.getName();
    }

    public MPrintFormat getPrintFormat() {
        return this.m_printFormat;
    }

    public PrintInfo getPrintInfo() {
        return this.m_info;
    }

    public Properties getCtx() {
        return this.getLayout().getCtx();
    }

    public int getRowCount() {
        return this.m_printData.getRowCount();
    }

    public int getColumnCount() {
        return this.m_printData.getColumnInfo().length;
    }

    public View getView() {
        if (this.m_layout == null) {
            this.layout();
        }
        if (this.m_view == null) {
            this.m_view = new View(this.m_layout);
        }
        return this.m_view;
    }

    public void print() {
        log.info(this.m_info.toString());
        if (this.m_layout == null) {
            this.layout();
        }
        PrintRequestAttributeSet prats = this.m_layout.getPaper().getPrintRequestAttributeSet();
        if (this.m_info.isDocumentCopy() || this.m_info.getCopies() < 1) {
            prats.add(new Copies(1));
        } else {
            prats.add(new Copies(this.m_info.getCopies()));
        }
        Locale locale = Language.getLoginLanguage().getLocale();
        prats.add(new JobName(this.m_printFormat.getName(), locale));
        JobPriority priority = PrintUtil.getJobPriority(this.m_layout.getNumberOfPages(), this.m_info.getCopies(), true);
        if (this.m_priority > 0 && this.m_priority <= 100) {
            priority = new JobPriority(this.m_priority);
        }
        prats.add(priority);
        try {
            PrinterJob job = this.getPrinterJob(this.m_info.getPrinterName());
            job.setPageable(this.m_layout.getPageable(false));
            try {
                if (this.m_info.isWithDialog() && !job.printDialog(prats)) {
                    return;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Operating System Print Issue, check & try again", e);
                return;
            }
            boolean printCopy = this.m_info.isDocumentCopy() && this.m_info.getCopies() > 1;
            ArchiveEngine.get().archive(this.m_layout, this.m_info);
            PrintUtil.print(job, prats, false, !this.m_info.isAsync() || printCopy);
            if (printCopy) {
                log.info("Copy " + (this.m_info.getCopies() - 1));
                prats.add(new Copies(this.m_info.getCopies() - 1));
                job = this.getPrinterJob(this.m_info.getPrinterName());
                job.setPageable(this.m_layout.getPageable(true));
                PrintUtil.print(job, prats, false, false);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public void attributeUpdate(PrintServiceAttributeEvent psae) {
        log.fine("attributeUpdate - " + psae);
    }

    private PrinterJob getPrinterJob(String printerName) {
        if (printerName != null && printerName.length() > 0) {
            return CPrinter.getPrinterJob(printerName);
        }
        return CPrinter.getPrinterJob(this.m_printerName);
    }

    public void pageSetupDialog() {
        if (this.m_layout == null) {
            this.layout();
        }
        this.m_layout.pageSetupDialog(this.getPrinterJob(this.m_printerName));
        if (this.m_view != null) {
            this.m_view.revalidate();
        }
    }

    public void setPrinterName(String printerName) {
        this.m_printerName = printerName == null ? Ini.getProperty("Printer") : printerName;
    }

    public String getPrinterName() {
        return this.m_printerName;
    }

    @Deprecated
    public boolean createHTML(File file, boolean onlyTable) {
        return new ExportFormatHTML(this.getCtx(), this).createHTML(file, onlyTable, null);
    }

    @Deprecated
    public boolean createHTML(File file, boolean onlyTable, IHTMLExtension extension) {
        return new ExportFormatHTML(this.m_ctx, this).createHTML(file, onlyTable, extension);
    }

    @Deprecated
    public boolean createCSV(File file, char delimiter) {
        return new ExportFormatCSV(this.getCtx(), this).createCSV(file, delimiter, null);
    }

    @Deprecated
    public boolean createCSV(Writer writer, char delimiter, Language language) {
        return this.createCSV(writer, delimiter, language, true);
    }

    @Deprecated
    public boolean createCSV(Writer writer, char delimiter, Language language, boolean printHeader) {
        return new ExportFormatCSV(this.getCtx(), this).createCSV(writer, delimiter, language, printHeader);
    }

    @Deprecated
    public boolean createXML(File file) {
        return new ExportFormatXML(this.getCtx(), this).exportToFile(file);
    }

    @Deprecated
    public boolean createXML(Writer writer) {
        return new ExportFormatXML(this.getCtx(), this).createXML(writer);
    }

    @Deprecated
    public boolean createDelimitedFile(Writer writer, char delimiter, Language language, boolean printHeader) {
        return new ExportFormatXML(this.getCtx(), this).createDelimitedFile(writer, delimiter, language, printHeader);
    }

    public File getPDF() {
        return this.getPDF(null);
    }

    public File getPDF(File file) {
        try {
            if (file == null) {
                file = File.createTempFile("ReportEngine", ".pdf");
            }
            if (!file.getName().contains("_") && !file.getName().contains("-")) {
                file = this.rename(file);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        if (this.createPDF(file)) {
            return file;
        }
        return null;
    }

    public boolean createPDF(File file) {
        URI uri = null;
        try {
            if (file == null) {
                file = File.createTempFile("ReportEngine", ".pdf");
            }
            uri = file.toURI();
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "file", e);
            return false;
        }
        log.fine(uri.toString());
        return new ExportFormatPDF(this.m_ctx, this).createPDF(file);
    }

    public byte[] createPDFData() {
        try {
            if (this.m_layout == null) {
                this.layout();
            }
            return new ITextDocument().getPDFAsArray(this.m_layout.getPageable(false));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "PDF", e);
            return null;
        }
    }

    public boolean createPS(File file) {
        return new ExportFormatPS(this.m_ctx, this).exportToFile(file);
    }

    public void createXLS(File outFile) {
        new ExportFormatXLS(this.m_ctx, this).exportToFile(outFile);
    }

    public void createXLSX(File outFile) {
        new ExportFormatXLSX(this.m_ctx, this).exportToFile(outFile);
    }

    @Deprecated
    public void createXLS(File outFile, Language language) throws Exception {
        new ExportFormatXLS(this.m_ctx, this).exportToFile(outFile, language);
    }

    @Deprecated
    public void createXLSX(File outFile, Language language) throws Exception {
        new ExportFormatXLSX(this.m_ctx, this).exportToFile(outFile, language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportEngine get(Properties ctx, ProcessInfo pi) {
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        int Client_ID;
        boolean IsForm;
        int AD_PrintFormat_ID;
        String whereClause;
        String TableName;
        int AD_ReportView_ID;
        int AD_Table_ID;
        int AD_Client_ID;
        block21: {
            AD_Client_ID = pi.getAD_Client_ID();
            AD_Table_ID = 0;
            AD_ReportView_ID = 0;
            TableName = null;
            whereClause = "";
            AD_PrintFormat_ID = 0;
            IsForm = false;
            Client_ID = -1;
            sql = "SELECT rv.AD_ReportView_ID,rv.WhereClause, t.AD_Table_ID,t.TableName, pf.AD_PrintFormat_ID, pf.IsForm, pf.AD_Client_ID FROM AD_PInstance pi INNER JOIN AD_Process p ON (pi.AD_Process_ID=p.AD_Process_ID) INNER JOIN AD_ReportView rv ON (p.AD_ReportView_ID=rv.AD_ReportView_ID) INNER JOIN AD_Table t ON (rv.AD_Table_ID=t.AD_Table_ID) LEFT OUTER JOIN AD_PrintFormat pf ON (p.AD_ReportView_ID=pf.AD_ReportView_ID AND pf.AD_Client_ID IN (0,?)) WHERE pi.AD_PInstance_ID=? ORDER BY pf.AD_Client_ID DESC, pf.IsDefault DESC";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Client_ID);
                pstmt.setInt(2, pi.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block21;
                AD_ReportView_ID = rs.getInt(1);
                whereClause = rs.getString(2);
                if (rs.wasNull()) {
                    whereClause = "";
                }
                whereClause = Env.parseContext(ctx, 0, whereClause, false);
                AD_Table_ID = rs.getInt(3);
                TableName = rs.getString(4);
                AD_PrintFormat_ID = rs.getInt(5);
                IsForm = "Y".equals(rs.getString(6));
                Client_ID = rs.getInt(7);
            }
            catch (SQLException e1) {
                try {
                    log.log(Level.SEVERE, "(1) - " + sql, e1);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (AD_ReportView_ID == 0) {
            sql = "SELECT t.AD_Table_ID,t.TableName, pf.AD_PrintFormat_ID, pf.IsForm FROM AD_PInstance pi INNER JOIN AD_Process p ON (pi.AD_Process_ID=p.AD_Process_ID) INNER JOIN AD_PrintFormat pf ON (p.AD_PrintFormat_ID=pf.AD_PrintFormat_ID) INNER JOIN AD_Table t ON (pf.AD_Table_ID=t.AD_Table_ID) WHERE pi.AD_PInstance_ID=?";
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, pi.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    whereClause = "";
                    AD_Table_ID = rs.getInt(1);
                    TableName = rs.getString(2);
                    AD_PrintFormat_ID = rs.getInt(3);
                    IsForm = "Y".equals(rs.getString(4));
                    Client_ID = AD_Client_ID;
                }
            }
            catch (SQLException e1) {
                log.log(Level.SEVERE, "(2) - " + sql, e1);
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (AD_PrintFormat_ID == 0) {
                log.log(Level.SEVERE, "Report Info NOT found AD_PInstance_ID=" + pi.getAD_PInstance_ID() + ",AD_Client_ID=" + AD_Client_ID);
                return null;
            }
        }
        MQuery query = null;
        if (IsForm && pi.getRecord_ID() != 0 && !TableName.startsWith("T_")) {
            MTable table2 = MTable.get(ctx, AD_Table_ID);
            String columnKey = null;
            columnKey = table2.isSingleKey() ? table2.getKeyColumns()[0] : TableName + "_ID";
            query = MQuery.getEqualQuery(columnKey, pi.getRecord_ID());
        } else {
            query = MQuery.get(ctx, pi.getAD_PInstance_ID(), TableName);
        }
        if (whereClause.length() != 0) {
            query.addRestriction(whereClause);
        }
        MPrintFormat format = null;
        Serializable so = pi.getSerializableObject();
        if (so instanceof MPrintFormat) {
            format = (MPrintFormat)so;
        }
        if (format == null && AD_PrintFormat_ID != 0) {
            format = Client_ID == AD_Client_ID ? MPrintFormat.get(ctx, AD_PrintFormat_ID, false) : MPrintFormat.copyToClient(ctx, AD_PrintFormat_ID, AD_Client_ID);
        }
        if (format != null && format.getItemCount() == 0) {
            log.info("No Items - recreating:  " + format);
            format.delete(true);
            format = null;
        }
        if (format == null && AD_ReportView_ID != 0) {
            format = MPrintFormat.createFromReportView(ctx, AD_ReportView_ID, pi.getTitle());
        }
        if (format == null) {
            return null;
        }
        format.setTranslationLanguage(format.getLanguage());
        PrintInfo info = new PrintInfo(pi);
        info.setAD_Table_ID(AD_Table_ID);
        query.setWindowNo(pi.getWindowNo());
        ReportEngine re = new ReportEngine(ctx, format, query, info, pi.getTransactionName());
        re.setProcessInfo(pi);
        return re;
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID) {
        return ReportEngine.get(ctx, type, Record_ID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportEngine get(Properties ctx, int type, int Record_ID, String trxName) {
        ResultSet rs;
        CPreparedStatement pstmt;
        Language language;
        int copies;
        String DocumentNo;
        int C_BPartner_ID;
        int AD_PrintFormat_ID;
        block14: {
            int[] what;
            if (Record_ID < 1) {
                log.log(Level.WARNING, "No PrintFormat for Record_ID=" + Record_ID + ", Type=" + type);
                return null;
            }
            if ((type == 0 || type == 1) && (what = ReportEngine.getDocumentWhat(type, Record_ID)) != null) {
                type = what[0];
                Record_ID = what[1];
            }
            AD_PrintFormat_ID = 0;
            C_BPartner_ID = 0;
            DocumentNo = null;
            copies = 1;
            MClient client = MClient.get(ctx);
            language = client.getLanguage();
            String sql = null;
            sql = type == 6 ? "SELECT bad.Check_PrintFormat_ID,\tc.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo FROM C_PaySelectionCheck d INNER JOIN C_PaySelection ps ON (d.C_PaySelection_ID=ps.C_PaySelection_ID) INNER JOIN C_BankAccountDoc bad ON (ps.C_BankAccount_ID=bad.C_BankAccount_ID AND d.PaymentRule=bad.PaymentRule) INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) WHERE d.C_PaySelectionCheck_ID=?" : (type == 10 ? "SELECT bad.Check_PrintFormat_ID,\tc.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo FROM HR_PaySelectionCheck d INNER JOIN HR_PaySelection ps ON (d.HR_PaySelection_ID=ps.HR_PaySelection_ID) INNER JOIN C_BankAccountDoc bad ON (ps.C_BankAccount_ID=bad.C_BankAccount_ID AND d.PaymentRule=bad.PaymentRule) INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) WHERE d.HR_PaySelectionCheck_ID=?" : (type == 7 ? "SELECT dl.Dunning_PrintFormat_ID, c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,dr.DunningDate FROM C_DunningRunEntry d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_DunningRun dr ON (d.C_DunningRun_ID=dr.C_DunningRun_ID) INNER JOIN C_DunningLevel dl ON (dl.C_DunningLevel_ID=d.C_DunningLevel_ID) WHERE d.C_DunningRunEntry_ID=?" : (type == 5 ? "SELECT pf.Remittance_PrintFormat_ID, c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo FROM C_PaySelectionCheck d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID) INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) WHERE d.C_PaySelectionCheck_ID=? AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC" : (type == 11 ? "SELECT pf.Remittance_PrintFormat_ID, c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo FROM HR_PaySelectionCheck d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID) INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) WHERE d.HR_PaySelectionCheck_ID=? AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC" : (type == 3 ? "SELECT pf.Project_PrintFormat_ID, c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.Value FROM C_Project d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID) LEFT OUTER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) WHERE d.C_Project_ID=? AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC" : (type == 8 ? "SELECT pf.Manuf_Order_PrintFormat_ID, c.IsMultiLingualDocument,bp.AD_Language, 0 , d.DocumentNo FROM PP_Order d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) LEFT OUTER JOIN AD_User u ON (u.AD_User_ID=d.Planner_ID) LEFT OUTER JOIN C_BPartner bp ON (u.C_BPartner_ID=bp.C_BPartner_ID)  INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)WHERE d.PP_Order_ID=? AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC" : (type == 9 ? "SELECT pf.Distrib_Order_PrintFormat_ID, c.IsMultiLingualDocument,bp.AD_Language, bp.C_BPartner_ID , d.DocumentNo FROM DD_Order d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID) LEFT OUTER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) WHERE d.DD_Order_ID=? AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC" : (type == 4 ? "SELECT COALESCE(t.AD_PrintFormat_ID, pf.AD_PrintFormat_ID), c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,rr.Name FROM C_RfQResponse rr INNER JOIN C_RfQ r ON (rr.C_RfQ_ID=r.C_RfQ_ID) INNER JOIN C_RfQ_Topic t ON (r.C_RfQ_Topic_ID=t.C_RfQ_Topic_ID) INNER JOIN AD_Client c ON (rr.AD_Client_ID=c.AD_Client_ID) INNER JOIN C_BPartner bp ON (rr.C_BPartner_ID=bp.C_BPartner_ID), AD_PrintFormat pf WHERE pf.AD_Client_ID IN (0,rr.AD_Client_ID) AND pf.AD_Table_ID=725 AND pf.IsTableBased='N' AND rr.C_RfQResponse_ID=? ORDER BY t.AD_PrintFormat_ID, pf.AD_Client_ID DESC, pf.AD_Org_ID DESC" : (type == 0 || type == 2 ? "SELECT pf.Order_PrintFormat_ID,pf.Shipment_PrintFormat_ID, COALESCE (bp.Invoice_PrintFormat_ID,dt.AD_PrintFormat_ID,pf.Invoice_PrintFormat_ID), pf.Project_PrintFormat_ID, pf.Remittance_PrintFormat_ID, c.IsMultiLingualDocument, bp.AD_Language, COALESCE(dt.DocumentCopies,0)+COALESCE(bp.DocumentCopies,1),  dt.AD_PrintFormat_ID,bp.C_BPartner_ID,d.DocumentNo FROM " + DOC_BASETABLES[type] + " d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID) INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN C_DocType dt ON ((d.C_DocType_ID>0 AND d.C_DocType_ID=dt.C_DocType_ID) OR (d.C_DocType_ID=0 AND d.C_DocTypeTarget_ID=dt.C_DocType_ID)) WHERE d." + DOC_IDS[type] + "=? AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC" : "SELECT pf.Order_PrintFormat_ID,pf.Shipment_PrintFormat_ID, COALESCE (bp.Invoice_PrintFormat_ID,dt.AD_PrintFormat_ID,pf.Invoice_PrintFormat_ID), pf.Project_PrintFormat_ID, pf.Remittance_PrintFormat_ID, c.IsMultiLingualDocument, bp.AD_Language, COALESCE(dt.DocumentCopies,0)+COALESCE(bp.DocumentCopies,1),  dt.AD_PrintFormat_ID,bp.C_BPartner_ID,d.DocumentNo,  pf.Manuf_Order_PrintFormat_ID, pf.Distrib_Order_PrintFormat_ID FROM " + DOC_BASETABLES[type] + " d INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID) INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN C_DocType dt ON (d.C_DocType_ID=dt.C_DocType_ID) WHERE d." + DOC_IDS[type] + "=? AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC")))))))));
            pstmt = null;
            rs = null;
            try {
                String AD_Language;
                pstmt = DB.prepareStatement(sql, trxName);
                pstmt.setInt(1, Record_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block14;
                if (type == 6 || type == 10 || type == 7 || type == 5 || type == 11 || type == 3 || type == 4 || type == 8 || type == 9) {
                    AD_PrintFormat_ID = rs.getInt(1);
                    copies = 1;
                    AD_Language = rs.getString(3);
                    if (AD_Language != null) {
                        language = Language.getLanguage(AD_Language);
                    }
                    C_BPartner_ID = rs.getInt(4);
                    if (type == 7) {
                        Timestamp ts = rs.getTimestamp(5);
                        DocumentNo = ts.toString();
                    } else {
                        DocumentNo = rs.getString(5);
                    }
                    break block14;
                }
                AD_PrintFormat_ID = rs.getInt(type + 1);
                if (type != 2 && rs.getInt(9) != 0) {
                    AD_PrintFormat_ID = rs.getInt(9);
                }
                copies = rs.getInt(8);
                AD_Language = rs.getString(7);
                if (AD_Language != null) {
                    language = Language.getLanguage(AD_Language);
                }
                C_BPartner_ID = rs.getInt(10);
                DocumentNo = rs.getString(11);
            }
            catch (Exception e) {
                try {
                    log.log(Level.SEVERE, "Record_ID=" + Record_ID + ", SQL=" + sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (AD_PrintFormat_ID == 0) {
            log.log(Level.SEVERE, "No PrintFormat found for Type=" + type + ", Record_ID=" + Record_ID);
            return null;
        }
        MPrintFormat format = MPrintFormat.get(ctx, AD_PrintFormat_ID, false);
        format.setLanguage(language);
        format.setTranslationLanguage(language);
        MQuery query = new MQuery(format.getAD_Table_ID());
        query.addRestriction(DOC_IDS[type], "=", Record_ID);
        if (DocumentNo == null || DocumentNo.length() == 0) {
            DocumentNo = "DocPrint";
        }
        PrintInfo info = new PrintInfo(DocumentNo, DOC_TABLE_ID[type], Record_ID, C_BPartner_ID);
        info.setCopies(copies);
        info.setDocumentCopy(false);
        info.setPrinterName(format.getPrinterName());
        ReportEngine re = new ReportEngine(ctx, format, query, info, trxName);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getDocumentWhat(int type, int Record_ID) {
        int[] what = new int[2];
        if (type == 0) {
            ResultSet rs;
            CPreparedStatement pstmt;
            String printDocument;
            String DocSubTypeSO;
            String sql;
            block44: {
                what[0] = 0;
                what[1] = Record_ID;
                sql = "SELECT dt.DocSubTypeSO, dt.PrintDocument FROM C_DocType dt, C_Order o WHERE o.C_DocType_ID=dt.C_DocType_ID AND o.C_Order_ID=?";
                DocSubTypeSO = null;
                printDocument = null;
                pstmt = null;
                rs = null;
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, Record_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        DocSubTypeSO = rs.getString(1);
                        printDocument = rs.getString(2);
                    }
                    if (DocSubTypeSO != null && !"".equals(DocSubTypeSO)) break block44;
                    sql = "SELECT dt.DocSubTypeSO, dt.PrintDocument FROM C_DocType dt, C_Order o WHERE o.C_DocTypeTarget_ID=dt.C_DocType_ID AND o.C_Order_ID=?";
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, Record_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        DocSubTypeSO = rs.getString(1);
                        printDocument = rs.getString(2);
                    }
                }
                catch (SQLException e1) {
                    int[] nArray;
                    try {
                        log.log(Level.SEVERE, "(1) - " + sql, e1);
                        nArray = null;
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return nArray;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (DocSubTypeSO == null) {
                DocSubTypeSO = "";
            }
            if ("0".equals(printDocument)) {
                what[0] = 0;
            } else if ("1".equals(printDocument)) {
                what[0] = 1;
            } else if ("2".equals(printDocument)) {
                what[0] = 2;
            } else if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("WI")) {
                what[0] = 2;
            } else if (DocSubTypeSO.equals("WP")) {
                what[0] = 1;
            } else {
                return what;
            }
            sql = what[0] == 2 ? "SELECT C_Invoice_ID REC FROM C_Invoice WHERE C_Order_ID=? ORDER BY C_Invoice_ID DESC" : "SELECT M_InOut_ID REC FROM M_InOut WHERE C_Order_ID=? ORDER BY M_InOut_ID DESC";
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, Record_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    what[1] = rs.getInt(1);
                } else {
                    what[0] = 0;
                }
            }
            catch (SQLException e2) {
                log.log(Level.SEVERE, "(2) - " + sql, e2);
                int[] nArray = null;
                return nArray;
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            log.fine("Order => " + what[0] + " ID=" + what[1]);
        } else if (type == 1) {
            what[0] = 1;
            what[1] = Record_ID;
            String sql = "SELECT dt.PrintDocument FROM C_DocType dt, M_InOut io WHERE io.C_DocType_ID=dt.C_DocType_ID AND io.M_InOut_ID=?";
            String DocSubTypeSO = null;
            String printDocument = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, Record_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    printDocument = rs.getString(1);
                }
            }
            catch (SQLException e1) {
                int[] nArray;
                try {
                    log.log(Level.SEVERE, "(1) - " + sql, e1);
                    nArray = null;
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return nArray;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (DocSubTypeSO == null) {
                DocSubTypeSO = "";
            }
            if ("0".equals(printDocument)) {
                what[0] = 0;
            } else if ("2".equals(printDocument)) {
                what[0] = 2;
            } else {
                return what;
            }
            sql = what[0] == 0 ? "SELECT C_Order_ID REC FROM M_InOut WHERE M_InOut_ID=? ORDER BY C_Order_ID DESC" : "SELECT C_Invoice_ID REC FROM M_InOut WHERE M_InOut_ID=? ORDER BY M_InOut_ID DESC";
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, Record_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    what[1] = rs.getInt(1);
                    if (rs.wasNull()) {
                        what[0] = 1;
                        what[1] = Record_ID;
                    }
                }
            }
            catch (SQLException e2) {
                log.log(Level.SEVERE, "(2) - " + sql, e2);
                int[] nArray = null;
                return nArray;
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            log.fine("InOut => " + what[0] + " ID=" + what[1]);
        }
        return what;
    }

    public static void printConfirm(int type, int Record_ID, String trxName) {
        int no;
        StringBuffer sql = new StringBuffer();
        if (type == 0 || type == 1 || type == 2) {
            sql.append("UPDATE ").append(DOC_BASETABLES[type]).append(" SET DatePrinted=SysDate, IsPrinted='Y' WHERE ").append(DOC_IDS[type]).append("=").append(Record_ID);
        }
        if (sql.length() > 0 && (no = DB.executeUpdate(sql.toString(), trxName)) != 1) {
            log.log(Level.SEVERE, "Updated records=" + no + " - should be just one");
        }
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        int AD_Table_ID = 100;
        MQuery q = new MQuery("AD_Table");
        q.addRestriction("AD_Table_ID", "<", 108);
        MPrintFormat f = MPrintFormat.createFromTable(Env.getCtx(), AD_Table_ID);
        PrintInfo i2 = new PrintInfo("test", AD_Table_ID, 108, 0);
        i2.setAD_Table_ID(AD_Table_ID);
        ReportEngine re = new ReportEngine(Env.getCtx(), f, q, i2);
        re.layout();
        re.print();
        System.exit(0);
    }

    public void setWhereExtended(String whereExtended) {
        this.m_whereExtended = whereExtended;
    }

    public String getWhereExtended() {
        return this.m_whereExtended;
    }

    public void setWindowNo(int windowNo) {
        this.m_windowNo = windowNo;
        if (this.m_layout != null) {
            this.m_layout.setWindowNo(windowNo);
        }
    }

    public int getWindowNo() {
        return this.m_windowNo;
    }

    public void setSummary(boolean summary) {
        this.m_summary = summary;
    }

    public void setReportType(String type) {
        this.reportType = type;
    }

    public String getReportType() {
        return this.reportType;
    }

    private File rename(File f) throws IOException {
        String timeStamp;
        File d = File.createTempFile("tempdir", "");
        String path = d.getAbsolutePath();
        d.delete();
        d.mkdir();
        String filename = timeStamp = new SimpleDateFormat("yyyy-MM-dd_HH:mm").format(Calendar.getInstance().getTime());
        if (this.m_printFormat != null) {
            filename = filename + "_" + this.m_printFormat.getName();
        }
        File doc = new File(path + File.separator + filename + ".pdf");
        f.renameTo(doc);
        return doc;
    }

    public void setProcessInfo(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }
}

