/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class ServerReportCtl {
    public static final String PARAM_PRINTER_NAME = "PRINTER_NAME";
    public static final String PARAM_PRINT_FORMAT = "PRINT_FORMAT";
    public static final String PARAM_PRINT_INFO = "PRINT_INFO";
    private static CLogger s_log = CLogger.getCLogger(ServerReportCtl.class);

    public static boolean startDocumentPrint(int type, MPrintFormat customPrintFormat, int recordId, String printerName, ProcessInfo processInfo) {
        String trxName = processInfo != null ? processInfo.getTransactionName() : null;
        ReportEngine reportEngine = ReportEngine.get(Env.getCtx(), type, recordId, trxName);
        if (reportEngine == null) {
            CLogger log = CLogger.getCLogger(ServerReportCtl.class);
            log.warning("NoDocPrintFormat");
            return false;
        }
        if (customPrintFormat != null) {
            reportEngine.setPrintFormat(customPrintFormat);
        }
        if (reportEngine.getPrintFormat() != null) {
            MPrintFormat format = reportEngine.getPrintFormat();
            if (format.getJasperProcess_ID() > 0) {
                boolean result = ServerReportCtl.runJasperProcess(recordId, reportEngine, true, printerName, processInfo);
                return result;
            }
            if (processInfo != null) {
                processInfo.setPDFReport(reportEngine.getPDF());
            }
            ServerReportCtl.createOutput(reportEngine, printerName);
            ReportEngine.printConfirm(type, recordId, trxName);
        }
        return true;
    }

    public static boolean runJasperProcess(int recordId, ReportEngine reportEngine, boolean isDirectPrint, String printerName, ProcessInfo processInfo) {
        ProcessInfoParameter pip;
        Trx trx = processInfo != null ? Trx.get(processInfo.getTransactionName(), false) : null;
        MPrintFormat format = reportEngine.getPrintFormat();
        ProcessInfo jasperProcessInfo = new ProcessInfo("", format.getJasperProcess_ID());
        jasperProcessInfo.setPrintPreview(!isDirectPrint);
        MQuery query = reportEngine.getQuery();
        if (query != null) {
            recordId = (Integer)query.getCode(0);
        }
        jasperProcessInfo.setRecord_ID(recordId);
        Vector<ProcessInfoParameter> jasperPrintParams = new Vector<ProcessInfoParameter>();
        if (printerName != null && printerName.trim().length() > 0) {
            pip = new ProcessInfoParameter(PARAM_PRINTER_NAME, printerName, null, null, null);
            jasperPrintParams.add(pip);
        }
        pip = new ProcessInfoParameter(PARAM_PRINT_FORMAT, format, null, null, null);
        jasperPrintParams.add(pip);
        pip = new ProcessInfoParameter(PARAM_PRINT_INFO, reportEngine.getPrintInfo(), null, null, null);
        jasperPrintParams.add(pip);
        jasperProcessInfo.setParameter(jasperPrintParams.toArray(new ProcessInfoParameter[0]));
        ServerProcessCtl.process(null, jasperProcessInfo, trx);
        if (processInfo != null) {
            processInfo.setPDFReport(jasperProcessInfo.getPDFReport());
        }
        boolean result = true;
        return result;
    }

    private static void createOutput(ReportEngine reportEngine, String printerName) {
        if (printerName != null) {
            reportEngine.getPrintInfo().setPrinterName(printerName);
        }
        reportEngine.print();
    }

    public static boolean start(ASyncProcess parent, ProcessInfo processInfo) {
        if (processInfo.getAD_Process_ID() == 110) {
            return ServerReportCtl.startDocumentPrint(0, null, processInfo.getRecord_ID(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == MProcess.getProcess_ID("Rpt PP_Order", null)) {
            return ServerReportCtl.startDocumentPrint(8, null, processInfo.getRecord_ID(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == MProcess.getProcess_ID("Rpt DD_Order", null)) {
            return ServerReportCtl.startDocumentPrint(9, null, processInfo.getRecord_ID(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 116) {
            return ServerReportCtl.startDocumentPrint(2, null, processInfo.getRecord_ID(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 117) {
            return ServerReportCtl.startDocumentPrint(1, null, processInfo.getRecord_ID(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 217) {
            return ServerReportCtl.startDocumentPrint(3, null, processInfo.getRecord_ID(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 276) {
            return ServerReportCtl.startDocumentPrint(4, null, processInfo.getRecord_ID(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 159) {
            return ServerReportCtl.startDocumentPrint(7, null, processInfo.getRecord_ID(), null, processInfo);
        }
        if (processInfo.getAD_Process_ID() == 202 || processInfo.getAD_Process_ID() == 204) {
            return ServerReportCtl.startFinReport(processInfo);
        }
        return ServerReportCtl.startStandardReport(processInfo);
    }

    public static boolean startStandardReport(ProcessInfo processInfo, boolean isDirectPrint) {
        processInfo.setPrintPreview(!isDirectPrint);
        return ServerReportCtl.startStandardReport(processInfo);
    }

    public static boolean startStandardReport(ProcessInfo processInfo) {
        ReportEngine re = null;
        Object o = processInfo.getTransientObject();
        if (o == null) {
            o = processInfo.getSerializableObject();
        }
        if (o != null && o instanceof MPrintFormat) {
            Properties ctx = Env.getCtx();
            MPrintFormat format = (MPrintFormat)o;
            String TableName = MTable.getTableName(ctx, format.getAD_Table_ID());
            MQuery query = MQuery.get(ctx, processInfo.getAD_PInstance_ID(), TableName);
            PrintInfo info = new PrintInfo(processInfo);
            re = new ReportEngine(ctx, format, query, info);
            ServerReportCtl.createOutput(re, null);
            return true;
        }
        re = ReportEngine.get(Env.getCtx(), processInfo);
        if (re == null) {
            processInfo.setSummary("No ReportEngine");
            return false;
        }
        ServerReportCtl.createOutput(re, null);
        return true;
    }

    public static boolean startFinReport(ProcessInfo pi) {
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        String TableName = pi.getAD_Process_ID() == 202 ? "T_Report" : "T_ReportStatement";
        MQuery query = MQuery.get(Env.getCtx(), pi.getAD_PInstance_ID(), TableName);
        MPrintFormat format = (MPrintFormat)pi.getTransientObject();
        if (format == null) {
            format = (MPrintFormat)pi.getSerializableObject();
        }
        if (format == null) {
            s_log.log(Level.SEVERE, "startFinReport - No PrintFormat");
            return false;
        }
        PrintInfo printInfo = new PrintInfo(pi);
        ReportEngine reportEngine = new ReportEngine(Env.getCtx(), format, query, printInfo);
        ServerReportCtl.createOutput(reportEngine, null);
        return true;
    }
}

