/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.net.URI;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetDelivery;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MProductDownload;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.EMail;

public class AssetDelivery
extends SvrProcess {
    private MClient m_client = null;
    private int m_A_Asset_Group_ID = 0;
    private int m_M_Product_ID = 0;
    private int m_C_BPartner_ID = 0;
    private int m_A_Asset_ID = 0;
    private Timestamp m_GuaranteeDate = null;
    private int m_NoGuarantee_MailText_ID = 0;
    private boolean m_AttachAsset = false;
    private MMailText m_MailText = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            if (string.equals("A_Asset_Group_ID")) {
                this.m_A_Asset_Group_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("M_Product_ID")) {
                this.m_M_Product_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("C_BPartner_ID")) {
                this.m_C_BPartner_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("A_Asset_ID")) {
                this.m_A_Asset_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("GuaranteeDate")) {
                this.m_GuaranteeDate = (Timestamp)processInfoParameterArray[i].getParameter();
                continue;
            }
            if (string.equals("NoGuarantee_MailText_ID")) {
                this.m_NoGuarantee_MailText_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("AttachAsset")) {
                this.m_AttachAsset = "Y".equals(processInfoParameterArray[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
        if (this.m_GuaranteeDate == null) {
            this.m_GuaranteeDate = new Timestamp(System.currentTimeMillis());
        }
        this.m_client = MClient.get(this.getCtx());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        String string;
        this.log.info("");
        long l = System.currentTimeMillis();
        if (this.m_client.getSMTPHost() == null || this.m_client.getSMTPHost().length() == 0) {
            throw new Exception("No Client SMTP Info");
        }
        if (this.m_client.getRequestEMail() == null) {
            throw new Exception("No Client Request User");
        }
        if (this.m_A_Asset_ID != 0) {
            String string2 = this.deliverIt(this.m_A_Asset_ID);
            this.addLog(this.m_A_Asset_ID, null, null, string2);
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT A_Asset_ID, GuaranteeDate FROM A_Asset a INNER JOIN M_Product p ON (a.M_Product_ID=p.M_Product_ID) WHERE ");
        if (this.m_A_Asset_Group_ID != 0) {
            stringBuffer.append("a.A_Asset_Group_ID=").append(this.m_A_Asset_Group_ID).append(" AND ");
        }
        if (this.m_M_Product_ID != 0) {
            stringBuffer.append("p.M_Product_ID=").append(this.m_M_Product_ID).append(" AND ");
        }
        if (this.m_C_BPartner_ID != 0) {
            stringBuffer.append("a.C_BPartner_ID=").append(this.m_C_BPartner_ID).append(" AND ");
        }
        if ((string = stringBuffer.toString()).endsWith(" WHERE ")) {
            throw new Exception("@RestrictSelection@");
        }
        if (this.m_NoGuarantee_MailText_ID == 0) {
            stringBuffer.append("TRUNC(GuaranteeDate, 'DD') >= ").append(DB.TO_DATE(this.m_GuaranteeDate, true));
            string = stringBuffer.toString();
        }
        if (string.endsWith(" AND ")) {
            string = stringBuffer.substring(0, stringBuffer.length() - 5);
        }
        Statement statement = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ResultSet resultSet = null;
        try {
            statement = DB.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                int n4 = resultSet.getInt(1);
                Timestamp timestamp = resultSet.getTimestamp(2);
                if (timestamp != null && timestamp.before(this.m_GuaranteeDate)) {
                    if (this.m_NoGuarantee_MailText_ID == 0) continue;
                    this.sendNoGuaranteeMail(n4, this.m_NoGuarantee_MailText_ID, this.get_TrxName());
                    ++n3;
                    continue;
                }
                String string3 = this.deliverIt(n4);
                this.addLog(n4, null, null, string3);
                if (string3.startsWith("** ")) {
                    ++n2;
                    continue;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            try {
                this.log.log(Level.SEVERE, string, exception);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, statement);
                resultSet = null;
                statement = null;
                throw throwable;
            }
            DB.close(resultSet, statement);
            resultSet = null;
            statement = null;
        }
        DB.close(resultSet, statement);
        resultSet = null;
        statement = null;
        this.log.info("Count=" + n + ", Errors=" + n2 + ", Reminder=" + n3 + " - " + (System.currentTimeMillis() - l) + "ms");
        return "@Sent@=" + n + " - @Errors@=" + n2;
    }

    private String sendNoGuaranteeMail(int n, int n2, String string) {
        MAsset mAsset = new MAsset(this.getCtx(), n, string);
        if (mAsset.getAD_User_ID() == 0) {
            return "** No Asset User";
        }
        MUser mUser = new MUser(this.getCtx(), mAsset.getAD_User_ID(), this.get_TrxName());
        if (mUser.getEMail() == null || mUser.getEMail().length() == 0) {
            return "** No Asset User Email";
        }
        if (this.m_MailText == null || this.m_MailText.getR_MailText_ID() != n2) {
            this.m_MailText = new MMailText(this.getCtx(), n2, this.get_TrxName());
        }
        if (this.m_MailText.getMailHeader() == null || this.m_MailText.getMailHeader().length() == 0) {
            return "** No Subject";
        }
        EMail eMail = this.m_client.createEMail(mUser.getEMail(), null, null);
        this.m_MailText.setPO(mUser);
        this.m_MailText.setPO(mAsset);
        String string2 = this.m_MailText.getMailText(true);
        if (this.m_MailText.isHtml()) {
            eMail.setMessageHTML(this.m_MailText.getMailHeader(), string2);
        } else {
            eMail.setSubject(this.m_MailText.getMailHeader());
            eMail.setMessageText(string2);
        }
        String string3 = eMail.send();
        new MUserMail(this.m_MailText, mAsset.getAD_User_ID(), eMail).saveEx();
        if (!"OK".equals(string3)) {
            return "** Not delivered: " + mUser.getEMail() + " - " + string3;
        }
        return mUser.getEMail();
    }

    private String deliverIt(int n) {
        Object object;
        this.log.fine("A_Asset_ID=" + n);
        long l = System.currentTimeMillis();
        MAsset mAsset = new MAsset(this.getCtx(), n, this.get_TrxName());
        if (mAsset.getAD_User_ID() == 0) {
            return "** No Asset User";
        }
        MUser mUser = new MUser(this.getCtx(), mAsset.getAD_User_ID(), this.get_TrxName());
        if (mUser.getEMail() == null || mUser.getEMail().length() == 0) {
            return "** No Asset User Email";
        }
        if (mAsset.getProductR_MailText_ID() == 0) {
            return "** Product Mail Text";
        }
        if (this.m_MailText == null || this.m_MailText.getR_MailText_ID() != mAsset.getProductR_MailText_ID()) {
            this.m_MailText = new MMailText(this.getCtx(), mAsset.getProductR_MailText_ID(), this.get_TrxName());
        }
        if (this.m_MailText.getMailHeader() == null || this.m_MailText.getMailHeader().length() == 0) {
            return "** No Subject";
        }
        EMail eMail = this.m_client.createEMail(mUser.getEMail(), null, null);
        if (!eMail.isValid()) {
            mAsset.setHelp(mAsset.getHelp() + " - Invalid EMail");
            mAsset.setIsActive(false);
            return "** Invalid EMail: " + mUser.getEMail();
        }
        if (this.m_client.isSmtpAuthorization()) {
            eMail.createAuthenticator(this.m_client.getRequestUser(), this.m_client.getRequestUserPW());
        }
        this.m_MailText.setUser(mUser);
        this.m_MailText.setPO(mAsset);
        String string = this.m_MailText.getMailText(true);
        if (this.m_MailText.isHtml() || this.m_AttachAsset) {
            eMail.setMessageHTML(this.m_MailText.getMailHeader(), string);
        } else {
            eMail.setSubject(this.m_MailText.getMailHeader());
            eMail.setMessageText(string);
        }
        if (this.m_AttachAsset) {
            object = mAsset.getProductDownloads();
            if (object != null) {
                for (int i = 0; i < ((MProductDownload[])object).length; ++i) {
                    URI uRI = object[i].getDownloadURL(this.m_client.getDocumentDir());
                    if (uRI == null) continue;
                    eMail.addAttachment(uRI);
                }
            } else {
                this.log.warning("No DowloadURL for A_Asset_ID=" + n);
            }
        }
        object = eMail.send();
        new MUserMail(this.m_MailText, mAsset.getAD_User_ID(), eMail).saveEx();
        if (!"OK".equals(object)) {
            return "** Not delivered: " + mUser.getEMail() + " - " + (String)object;
        }
        MAssetDelivery mAssetDelivery = this.confirmDelivery(mAsset, eMail, mUser.getAD_User_ID());
        mAssetDelivery.saveEx();
        mAsset.saveEx();
        this.log.fine(System.currentTimeMillis() - l + " ms");
        return mUser.getEMail() + " - " + mAsset.getProductVersionNo();
    }

    public MAssetDelivery confirmDelivery(MAsset mAsset, EMail eMail, int n) {
        mAsset.setVersionNo(mAsset.getProductVersionNo());
        MAssetDelivery mAssetDelivery = new MAssetDelivery(mAsset, eMail, n);
        return mAssetDelivery;
    }
}

