/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.Doc;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MBankStatement;
import org.compiere.model.MCash;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MInOut;
import org.compiere.model.MInventory;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionBatch;
import org.compiere.model.MRequisition;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.I_DD_Order;
import org.eevolution.model.I_PP_Cost_Collector;
import org.eevolution.model.I_PP_Order;

public class DocumentEngine
implements DocAction {
    private DocAction m_document;
    private String m_status = "DR";
    private String m_message = null;
    private String m_action = null;
    private static CLogger log = CLogger.getCLogger(DocumentEngine.class);
    private static String EXCEPTION_MSG = "Document Engine is no Document";

    public DocumentEngine(DocAction po) {
        this(po, "DR");
    }

    public DocumentEngine(DocAction po, String docStatus) {
        this.m_document = po;
        if (docStatus != null) {
            this.m_status = docStatus;
        }
    }

    @Override
    public String getDocStatus() {
        return this.m_status;
    }

    @Override
    public void setDocStatus(String ignored) {
    }

    public boolean isDrafted() {
        return "DR".equals(this.m_status);
    }

    public boolean isInvalid() {
        return "IN".equals(this.m_status);
    }

    public boolean isInProgress() {
        return "IP".equals(this.m_status);
    }

    public boolean isApproved() {
        return "AP".equals(this.m_status);
    }

    public boolean isNotApproved() {
        return "NA".equals(this.m_status);
    }

    public boolean isWaiting() {
        return "WP".equals(this.m_status) || "WC".equals(this.m_status);
    }

    public boolean isCompleted() {
        return "CO".equals(this.m_status);
    }

    public boolean isReversed() {
        return "RE".equals(this.m_status);
    }

    public boolean isClosed() {
        return "CL".equals(this.m_status);
    }

    public boolean isVoided() {
        return "VO".equals(this.m_status);
    }

    public boolean isUnknown() {
        return "??".equals(this.m_status) || !this.isDrafted() && !this.isInvalid() && !this.isInProgress() && !this.isNotApproved() && !this.isApproved() && !this.isWaiting() && !this.isCompleted() && !this.isReversed() && !this.isClosed() && !this.isVoided();
    }

    public boolean processIt(String processAction, String docAction) {
        this.m_message = null;
        this.m_action = null;
        if (this.isValidAction(processAction)) {
            this.m_action = processAction;
        } else if (this.isValidAction(docAction)) {
            this.m_action = docAction;
        } else {
            if (processAction.equals("--") || docAction.equals("--")) {
                if (this.m_document != null) {
                    this.m_document.get_Logger().info("**** No Action (Prc=" + processAction + "/Doc=" + docAction + ") " + this.m_document);
                }
                return true;
            }
            throw new IllegalStateException("Status=" + this.getDocStatus() + " - Invalid Actions: Process=" + processAction + ", Doc=" + docAction);
        }
        if (this.m_document != null) {
            this.m_document.get_Logger().info("**** Action=" + this.m_action + " (Prc=" + processAction + "/Doc=" + docAction + ") " + this.m_document);
        }
        boolean success = this.processIt(this.m_action);
        if (this.m_document != null) {
            this.m_document.get_Logger().fine("**** Action=" + this.m_action + " - Success=" + success);
        }
        return success;
    }

    @Override
    public boolean processIt(String action) {
        this.m_message = null;
        this.m_action = action;
        if ("XL".equals(this.m_action)) {
            return this.unlockIt();
        }
        if ("IN".equals(this.m_action)) {
            return this.invalidateIt();
        }
        if ("PR".equals(this.m_action)) {
            return "IP".equals(this.prepareIt());
        }
        if ("AP".equals(this.m_action)) {
            return this.approveIt();
        }
        if ("RJ".equals(this.m_action)) {
            return this.rejectIt();
        }
        if ("CO".equals(this.m_action) || "WC".equals(this.m_action)) {
            boolean ok;
            String status = null;
            if ((this.isDrafted() || this.isInvalid()) && !"IP".equals(status = this.prepareIt())) {
                return false;
            }
            status = this.completeIt();
            boolean bl = ok = "CO".equals(status) || "IP".equals(status) || "WP".equals(status) || "WC".equals(status);
            if (this.m_document != null && ok) {
                ArrayList<Object> docsPostProcess = new ArrayList();
                if (this.m_document instanceof MInvoice || this.m_document instanceof MInOut) {
                    if (this.m_document instanceof MInvoice) {
                        docsPostProcess = ((MInvoice)this.m_document).getDocsPostProcess();
                    }
                    if (this.m_document instanceof MInOut) {
                        docsPostProcess = ((MInOut)this.m_document).getDocsPostProcess();
                    }
                }
                if (this.m_document instanceof PO && docsPostProcess.size() > 0) {
                    for (PO pO : docsPostProcess) {
                        pO.setProcessedOn("Processed", true, false);
                        pO.saveEx();
                    }
                }
                if ("CO".equals(status) && MClient.isClientAccountingImmediate()) {
                    this.m_document.saveEx();
                    this.postIt();
                    if (this.m_document instanceof PO && docsPostProcess.size() > 0) {
                        for (PO pO : docsPostProcess) {
                            String string = DocumentEngine.postImmediate(pO.getCtx(), pO.getAD_Client_ID(), pO.get_Table_ID(), pO.get_ID(), true, pO.get_TrxName());
                        }
                    }
                }
            }
            return ok;
        }
        if ("RE".equals(this.m_action)) {
            return this.reActivateIt();
        }
        if ("RA".equals(this.m_action)) {
            return this.reverseAccrualIt();
        }
        if ("RC".equals(this.m_action)) {
            return this.reverseCorrectIt();
        }
        if ("CL".equals(this.m_action)) {
            return this.closeIt();
        }
        if ("VO".equals(this.m_action)) {
            return this.voidIt();
        }
        if ("PO".equals(this.m_action)) {
            return this.postIt();
        }
        return false;
    }

    @Override
    public boolean unlockIt() {
        if (!this.isValidAction("XL")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.unlockIt()) {
                this.m_status = "DR";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "DR";
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (!this.isValidAction("IN")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.invalidateIt()) {
                this.m_status = "IN";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "IN";
        return true;
    }

    @Override
    public String prepareIt() {
        if (!this.isValidAction("PR")) {
            return this.m_status;
        }
        if (this.m_document != null) {
            this.m_status = this.m_document.prepareIt();
            this.m_document.setDocStatus(this.m_status);
        }
        return this.m_status;
    }

    @Override
    public boolean approveIt() {
        if (!this.isValidAction("AP")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.approveIt()) {
                this.m_status = "AP";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "AP";
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (!this.isValidAction("RJ")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.rejectIt()) {
                this.m_status = "NA";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "NA";
        return true;
    }

    @Override
    public String completeIt() {
        if (!this.isValidAction("CO")) {
            return this.m_status;
        }
        if (this.m_document != null) {
            this.m_status = this.m_document.completeIt();
            this.m_document.setDocStatus(this.m_status);
        }
        return this.m_status;
    }

    public boolean postIt() {
        if (!this.isValidAction("PO") || this.m_document == null) {
            return false;
        }
        String error = DocumentEngine.postImmediate(Env.getCtx(), this.m_document.getAD_Client_ID(), this.m_document.get_Table_ID(), this.m_document.get_ID(), true, this.m_document.get_TrxName());
        return error == null;
    }

    @Override
    public boolean voidIt() {
        if (!this.isValidAction("VO")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.voidIt()) {
                this.m_status = "VO";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "VO";
        return true;
    }

    @Override
    public boolean closeIt() {
        if (!(this.m_document != null && this.m_document.get_Table_ID() == MOrder.Table_ID || this.isValidAction("CL"))) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.closeIt()) {
                this.m_status = "CL";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "CL";
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (!this.isValidAction("RC")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.reverseCorrectIt()) {
                this.m_status = "RE";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "RE";
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (!this.isValidAction("RA")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.reverseAccrualIt()) {
                this.m_status = "RE";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "RE";
        return true;
    }

    @Override
    public boolean reActivateIt() {
        if (!this.isValidAction("RE")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.reActivateIt()) {
                this.m_status = "IP";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "IP";
        return true;
    }

    void setStatus(String newStatus) {
        this.m_status = newStatus;
    }

    public String[] getActionOptions() {
        if (this.isInvalid()) {
            return new String[]{"PR", "IN", "XL", "VO"};
        }
        if (this.isDrafted()) {
            return new String[]{"PR", "IN", "CO", "XL", "VO"};
        }
        if (this.isInProgress() || this.isApproved()) {
            return new String[]{"CO", "WC", "AP", "RJ", "XL", "VO", "PR"};
        }
        if (this.isNotApproved()) {
            return new String[]{"RJ", "PR", "XL", "VO"};
        }
        if (this.isWaiting()) {
            return new String[]{"CO", "WC", "RE", "VO", "CL"};
        }
        if (this.isCompleted()) {
            return new String[]{"CL", "RE", "RA", "RC", "PO", "VO"};
        }
        if (this.isClosed()) {
            return new String[]{"PO", "OP"};
        }
        if (this.isReversed() || this.isVoided()) {
            return new String[]{"PO"};
        }
        return new String[0];
    }

    public boolean isValidAction(String action) {
        String[] options = this.getActionOptions();
        for (int i2 = 0; i2 < options.length; ++i2) {
            if (!options[i2].equals(action)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProcessMsg() {
        return this.m_message;
    }

    public void setProcessMsg(String msg) {
        this.m_message = msg;
    }

    @Override
    public String getSummary() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String getDocumentNo() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String getDocumentInfo() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getDoc_User_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getC_Currency_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public BigDecimal getApprovalAmt() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getAD_Client_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getAD_Org_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String getDocAction() {
        return this.m_action;
    }

    @Override
    public boolean save() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public void saveEx() throws AdempiereException {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public Properties getCtx() {
        if (this.m_document != null) {
            return this.m_document.getCtx();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int get_ID() {
        if (this.m_document != null) {
            return this.m_document.get_ID();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int get_Table_ID() {
        if (this.m_document != null) {
            return this.m_document.get_Table_ID();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public CLogger get_Logger() {
        if (this.m_document != null) {
            return this.m_document.get_Logger();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String get_TrxName() {
        return null;
    }

    @Override
    public File createPDF() {
        return null;
    }

    public static int getValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options) {
        if (options == null) {
            throw new IllegalArgumentException("Option array parameter is null");
        }
        if (docAction == null) {
            throw new IllegalArgumentException("Doc action array parameter is null");
        }
        int index = 0;
        if (processing != null) {
            boolean locked = "Y".equals(processing);
            if (!locked && processing instanceof Boolean) {
                locked = (Boolean)processing;
            }
            if (locked) {
                options[index++] = "XL";
            }
        }
        if (docStatus.equals("NA")) {
            options[index++] = "PR";
            options[index++] = "VO";
        } else if (docStatus.equals("DR") || docStatus.equals("IN")) {
            options[index++] = "CO";
            options[index++] = "PR";
            options[index++] = "VO";
        } else if (docStatus.equals("IP") || docStatus.equals("AP")) {
            options[index++] = "CO";
            options[index++] = "VO";
        } else if (docStatus.equals("CO")) {
            options[index++] = "CL";
        } else if (docStatus.equals("WP") || docStatus.equals("WC")) {
            options[index++] = "VO";
            options[index++] = "PR";
        } else if (docStatus.equals("CL") || docStatus.equals("VO") || docStatus.equals("RE")) {
            return 0;
        }
        if (AD_Table_ID == MOrder.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
                if ("Y".equals(isSOTrx) && ("OB".equals(orderType) || "ON".equals(orderType))) {
                    docAction[0] = "PR";
                }
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            } else if (docStatus.equals("WP")) {
                options[index++] = "RE";
                options[index++] = "CL";
            }
        } else if (AD_Table_ID == MRequisition.Table_ID) {
            options[index++] = "PR";
        } else if (AD_Table_ID == MInOut.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == MInvoice.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == MPayment.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == MJournal.Table_ID || AD_Table_ID == MJournalBatch.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "RC";
                options[index++] = "RA";
                options[index++] = "RE";
            }
        } else if (AD_Table_ID == MAllocationHdr.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == MCash.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
            }
        } else if (AD_Table_ID == MBankStatement.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
            }
        } else if (AD_Table_ID == MMovement.Table_ID || AD_Table_ID == MInventory.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == MProduction.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == MProductionBatch.Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
            }
        } else if (AD_Table_ID == I_PP_Order.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            }
        } else if (AD_Table_ID == I_PP_Cost_Collector.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
            }
        } else if (AD_Table_ID == I_DD_Order.Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            }
        } else if (AD_Table_ID == MTable.getTable_ID("HR_Process")) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
                options[index++] = "RC";
                options[index++] = "RA";
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readReferenceList(ArrayList<String> v_value, ArrayList<String> v_name, ArrayList<String> v_description) {
        if (v_value == null) {
            throw new IllegalArgumentException("v_value parameter is null");
        }
        if (v_name == null) {
            throw new IllegalArgumentException("v_name parameter is null");
        }
        if (v_description == null) {
            throw new IllegalArgumentException("v_description parameter is null");
        }
        String sql = Env.isBaseLanguage(Env.getCtx(), "AD_Ref_List") ? "SELECT Value, Name, Description FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Name" : "SELECT l.Value, t.Name, t.Description FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "' AND l.AD_Reference_ID=? ORDER BY t.Name";
        CPreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = DB.prepareStatement(sql, null);
            preparedStatement.setInt(1, 135);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String value = resultSet.getString(1);
                String name = resultSet.getString(2);
                String description = resultSet.getString(3);
                if (description == null) {
                    description = "";
                }
                v_value.add(value);
                v_name.add(name);
                v_description.add(description);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, preparedStatement);
                resultSet = null;
                preparedStatement = null;
                throw throwable;
            }
            DB.close(resultSet, preparedStatement);
            resultSet = null;
            preparedStatement = null;
        }
        DB.close(resultSet, preparedStatement);
        resultSet = null;
        preparedStatement = null;
    }

    public static int checkActionAccess(int clientId, int roleId, int docTypeId, String[] options, int maxIndex) {
        return MRole.get(Env.getCtx(), roleId).checkActionAccess(clientId, docTypeId, options, maxIndex);
    }

    public static String postImmediate(Properties ctx, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force, String trxName) {
        if (MColumn.getColumn_ID(MTable.getTableName(ctx, AD_Table_ID), "Posted") <= 0) {
            return null;
        }
        String error = null;
        if (MClient.isClientAccounting()) {
            log.info("Table=" + AD_Table_ID + ", Record=" + Record_ID);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(ctx, AD_Client_ID);
            error = Doc.postImmediate(ass, AD_Table_ID, Record_ID, force, trxName);
            return error;
        }
        if (CConnection.get().isAppsServerOK(true)) {
            log.config("trying server");
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    Properties p2 = Env.getRemoteCallCtx(Env.getCtx());
                    error = server.postImmediate(p2, AD_Client_ID, AD_Table_ID, Record_ID, force, null);
                    log.config("from Server: " + error == null ? "OK" : error);
                } else {
                    error = "NoAppsServer";
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "(RE)", e);
                error = e.getMessage();
            }
        }
        return error;
    }

    public static boolean processIt(DocAction doc, String processAction) {
        boolean success = false;
        DocumentEngine engine = new DocumentEngine(doc, doc.getDocStatus());
        success = engine.processIt(processAction, doc.getDocAction());
        return success;
    }
}

