/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.util.List;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDunningLevel;
import org.compiere.model.MDunningRun;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MMailText;
import org.compiere.model.MQuery;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.DunningPrintAbstract;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.EMail;

public class DunningPrint
extends DunningPrintAbstract {
    private int count = 0;
    private int errors = 0;

    @Override
    protected String doIt() throws AdempiereUserError {
        this.log.info("C_DunningRun_ID=" + this.getDunningRunId() + ",R_MailText_ID=" + this.getMailTextId() + ", EmailPDF=" + this.isEMailPDF() + ",IsOnlyIfBPBalance=" + this.isOnlyIfBPBalance() + ",PrintUnprocessedOnly=" + this.isPrintUnprocessedOnly());
        if (this.isEMailPDF() && this.getMailTextId() == 0) {
            throw new AdempiereUserError("@NotFound@: @R_MailText_ID@");
        }
        MMailText text = null;
        if (this.isEMailPDF()) {
            text = new MMailText(this.getCtx(), this.getMailTextId(), this.get_TrxName());
            if (this.isEMailPDF() && text.get_ID() == 0) {
                throw new AdempiereUserError("@NotFound@: @R_MailText_ID@ - " + this.getMailTextId());
            }
        }
        if (this.getDunningRunId() != 0) {
            MDunningRun dunningRun = new MDunningRun(this.getCtx(), this.getDunningRunId(), this.get_TrxName());
            if (dunningRun.get_ID() == 0) {
                throw new AdempiereUserError("@NotFound@: @C_DunningRun_ID@ - " + this.getDunningRunId());
            }
            this.processDunning(dunningRun, text);
        } else {
            List<MDunningRun> dunningList = MDunningRun.getDunningRunList(this.getCtx(), this.isPrintUnprocessedOnly());
            if (dunningList != null) {
                for (MDunningRun dunningRun : dunningList) {
                    this.processDunning(dunningRun, text);
                }
            }
        }
        if (this.isEMailPDF()) {
            return "@Sent@=" + this.count + " - @Errors@=" + this.errors;
        }
        return "@Printed@=" + this.count;
    }

    private void processDunning(MDunningRun dunningRun, MMailText text) {
        int internalError = 0;
        MClient client = MClient.get(this.getCtx());
        for (MDunningRunEntry entry : dunningRun.getEntries(false)) {
            MDunningLevel level = new MDunningLevel(this.getCtx(), entry.getC_DunningLevel_ID(), this.get_TrxName());
            MPrintFormat format = null;
            if (level.getDunning_PrintFormat_ID() > 0) {
                format = MPrintFormat.get(this.getCtx(), level.getDunning_PrintFormat_ID(), false);
            }
            if (this.isOnlyIfBPBalance() && entry.getAmt().signum() <= 0 || this.isPrintUnprocessedOnly() && entry.isProcessed()) continue;
            MBPartner bp = new MBPartner(this.getCtx(), entry.getC_BPartner_ID(), this.get_TrxName());
            if (bp.get_ID() == 0) {
                this.addLog(entry.get_ID(), null, null, "@NotFound@: @C_BPartner_ID@ " + entry.getC_BPartner_ID());
                ++this.errors;
                continue;
            }
            MUser to = new MUser(this.getCtx(), entry.getAD_User_ID(), this.get_TrxName());
            if (this.isEMailPDF()) {
                if (to.get_ID() == 0) {
                    this.addLog(entry.get_ID(), null, null, "@NotFound@: @AD_User_ID@ - " + bp.getName());
                    ++this.errors;
                    continue;
                }
                if (to.getEMail() == null || to.getEMail().length() == 0) {
                    this.addLog(entry.get_ID(), null, null, "@NotFound@: @EMail@ - " + to.getName());
                    ++this.errors;
                    continue;
                }
            }
            MQuery query = new MQuery("C_Dunning_Header_v");
            query.addRestriction("C_DunningRunEntry_ID", "=", new Integer(entry.getC_DunningRunEntry_ID()));
            PrintInfo info = new PrintInfo(bp.getName(), MDunningRunEntry.Table_ID, entry.getC_DunningRunEntry_ID(), entry.getC_BPartner_ID());
            info.setDescription(bp.getName() + ", Amt=" + entry.getAmt());
            ReportEngine re = null;
            if (format != null) {
                re = new ReportEngine(this.getCtx(), format, query, info);
            }
            boolean printed = false;
            if (this.isEMailPDF()) {
                EMail email = client.createEMail(to.getEMail(), null, null);
                if (!email.isValid()) {
                    this.addLog(entry.get_ID(), null, null, "@RequestActionEMailError@ Invalid EMail: " + to);
                    ++internalError;
                    continue;
                }
                if (text == null) continue;
                text.setUser(to);
                text.setBPartner(bp);
                text.setPO(entry);
                String message = text.getMailText(true);
                if (text.isHtml()) {
                    email.setMessageHTML(text.getMailHeader(), message);
                } else {
                    email.setSubject(text.getMailHeader());
                    email.setMessageText(message);
                }
                if (re != null) {
                    File attachment = re.getPDF();
                    this.log.fine(to + " - " + attachment);
                    email.addAttachment(attachment);
                }
                String msg = email.send();
                MUserMail um = new MUserMail(text, entry.getAD_User_ID(), email);
                um.saveEx();
                if (msg.equals("OK")) {
                    this.addLog(entry.get_ID(), null, null, bp.getName() + " @RequestActionEMailOK@");
                    ++this.count;
                    printed = true;
                } else {
                    this.addLog(entry.get_ID(), null, null, bp.getName() + " @RequestActionEMailError@ " + msg);
                    ++internalError;
                }
            } else if (re != null) {
                re.print();
                ++this.count;
                printed = true;
            }
            if (!printed) continue;
            entry.setProcessed(true);
            entry.save();
        }
        this.errors += internalError;
        if (internalError == 0) {
            dunningRun.setProcessed(true);
            dunningRun.saveEx();
        }
    }
}

