/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.Query;
import org.compiere.model.X_I_BankStatement;
import org.compiere.process.ImportBankStatementAbstract;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ImportBankStatement
extends ImportBankStatementAbstract {
    private MBankStatement statement = null;
    private AtomicInteger lineNo = new AtomicInteger(10);
    private AtomicInteger noInsert = new AtomicInteger();
    private AtomicInteger noInsertLine = new AtomicInteger();

    @Override
    protected String doIt() throws Exception {
        this.log.info("AD_Org_ID=" + this.getOrgId() + ", C_BankAccount_ID" + this.getBankAccountId());
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.getClientId();
        if (this.isDeleteOldImported()) {
            sql = new StringBuffer("DELETE I_BankStatement WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_BankStatement SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.getClientId()).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.getOrgId()).append("),");
        sql.append(" IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL OR AD_Client_ID IS NULL OR AD_Org_ID IS NULL OR AD_Client_ID=0 OR AD_Org_ID=0");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("Reset=" + no);
        sql = new StringBuffer("UPDATE I_BankStatement o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0 OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement i SET C_BankAccount_ID=(  SELECT C_BankAccount_ID  FROM C_BankAccount a, C_Bank b  WHERE b.IsOwnBank='Y'  AND a.AD_Client_ID=i.AD_Client_ID  AND a.C_Bank_ID=b.C_Bank_ID  AND a.AccountNo=i.BankAccountNo  AND b.RoutingNo=i.RoutingNo  OR b.SwiftCode=i.RoutingNo ) WHERE i.C_BankAccount_ID IS NULL AND i.I_IsImported<>'Y' OR i.I_IsImported IS NULL").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Bank Account (With Routing No)=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement i SET C_BankAccount_ID=(  SELECT C_BankAccount_ID  FROM C_BankAccount a, C_Bank b  WHERE b.IsOwnBank='Y'  AND a.C_Bank_ID=b.C_Bank_ID  AND a.AccountNo=i.BankAccountNo  AND a.AD_Client_ID=i.AD_Client_ID ) WHERE i.C_BankAccount_ID IS NULL AND i.I_isImported<>'Y' OR i.I_isImported IS NULL").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Bank Account (Without Routing No)=" + no);
        }
        sql = new StringBuffer("UPDATE I_BankStatement i SET C_BankAccount_ID=(SELECT C_BankAccount_ID FROM C_BankAccount a WHERE a.C_BankAccount_ID=").append(this.getBankAccountId());
        sql.append(" and a.AD_Client_ID=i.AD_Client_ID) WHERE i.C_BankAccount_ID IS NULL AND i.BankAccountNo IS NULL AND i.I_isImported<>'Y' OR i.I_isImported IS NULL").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.info("Bank Account=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement SET I_isImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Bank Account, ' WHERE C_BankAccount_ID IS NULL AND I_isImported<>'Y' OR I_isImported IS NULL").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Invalid Bank Account=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement i SET C_Currency_ID=(SELECT C_Currency_ID FROM C_Currency c WHERE i.ISO_Code=c.ISO_Code AND c.AD_Client_ID IN (0,i.AD_Client_ID)) WHERE C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Set Currency=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement i SET C_Currency_ID=(SELECT C_Currency_ID FROM C_BankAccount WHERE C_BankAccount_ID=i.C_BankAccount_ID) WHERE i.C_Currency_ID IS NULL AND i.ISO_Code IS NULL").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Set Currency=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Currency,' WHERE C_Currency_ID IS NULL AND I_IsImported<>'E'  AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Invalid Currency=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement SET ChargeAmt=0 WHERE ChargeAmt IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Charge Amount=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement SET InterestAmt=0 WHERE InterestAmt IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Interest Amount=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement SET TrxAmt=StmtAmt - InterestAmt - ChargeAmt WHERE TrxAmt IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Transaction Amount=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement SET I_isImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Amount, ' WHERE TrxAmt + ChargeAmt + InterestAmt <> StmtAmt AND I_isImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Invaid Amount=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement SET ValutaDate=StatementLineDate WHERE ValutaDate IS NULL AND I_isImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Valuta Date=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Payment<->Invoice, ' WHERE I_BankStatement_ID IN (SELECT I_BankStatement_ID FROM I_BankStatement i INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) WHERE i.C_Invoice_ID IS NOT NULL  AND p.C_Invoice_ID IS NOT NULL  AND p.C_Invoice_ID<>i.C_Invoice_ID) ").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Payment<->Invoice Mismatch=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Payment<->BPartner, ' WHERE I_BankStatement_ID IN (SELECT I_BankStatement_ID FROM I_BankStatement i INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) WHERE i.C_BPartner_ID IS NOT NULL  AND p.C_BPartner_ID IS NOT NULL  AND p.C_BPartner_ID<>i.C_BPartner_ID) ").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Payment<->BPartner Mismatch=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Invoice<->BPartner, ' WHERE I_BankStatement_ID IN (SELECT I_BankStatement_ID FROM I_BankStatement i INNER JOIN C_Invoice v ON (i.C_Invoice_ID=v.C_Invoice_ID) WHERE i.C_BPartner_ID IS NOT NULL  AND v.C_BPartner_ID IS NOT NULL  AND v.C_BPartner_ID<>i.C_BPartner_ID) ").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Invoice<->BPartner Mismatch=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_BankStatement SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Invoice.BPartner<->Payment.BPartner, ' WHERE I_BankStatement_ID IN (SELECT I_BankStatement_ID FROM I_BankStatement i INNER JOIN C_Invoice v ON (i.C_Invoice_ID=v.C_Invoice_ID) INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) WHERE p.C_Invoice_ID<>v.C_Invoice_ID AND v.C_BPartner_ID<>p.C_BPartner_ID) ").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Invoice.BPartner<->Payment.BPartner Mismatch=" + no);
        }
        sql = new StringBuffer("SELECT i.I_BankStatement_ID, l.C_BankStatementLine_ID, i.EftTrxID FROM I_BankStatement i, C_BankStatement s, C_BankStatementLine l WHERE i.I_isImported='N' AND s.C_BankStatement_ID=l.C_BankStatement_ID AND i.EftTrxID IS NOT NULL AND (l.EftTrxID||l.EftAmt||l.EftStatementLineDate||l.EftValutaDate||l.EftTrxType||l.EftCurrency||l.EftReference||s.EftStatementReference ||l.EftCheckNo||l.EftMemo||l.EftPayee||l.EftPayeeAccount) = (i.EftTrxID||i.EftAmt||i.EftStatementLineDate||i.EftValutaDate||i.EftTrxType||i.EftCurrency||i.EftReference||i.EftStatementReference ||i.EftCheckNo||i.EftMemo||i.EftPayee||i.EftPayeeAccount) ");
        StringBuffer updateSql = new StringBuffer("UPDATE I_Bankstatement SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Duplicate['||?||']' WHERE I_BankStatement_ID=?").append(clientCheck);
        CPreparedStatement pupdt = DB.prepareStatement(updateSql.toString(), this.get_TrxName());
        CPreparedStatement pstmtDuplicates = null;
        no = 0;
        try {
            pstmtDuplicates = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmtDuplicates.executeQuery();
            while (rs.next()) {
                String info = "Line_ID=" + rs.getInt(2) + ",EDTTrxID=" + rs.getString(3);
                pupdt.setString(1, info);
                pupdt.setInt(2, rs.getInt(1));
                pupdt.executeUpdate();
                ++no;
            }
            rs.close();
            pstmtDuplicates.close();
            pupdt.close();
            rs = null;
            pstmtDuplicates = null;
            pupdt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "DetectDuplicates " + e.getMessage());
        }
        if (no != 0) {
            this.log.info("Duplicates=" + no);
        }
        this.commitEx();
        new Query(this.getCtx(), "I_BankStatement", "I_IsImported='N'" + clientCheck, this.get_TrxName()).setOrderBy("C_BankAccount_ID, Name, EftStatementDate, EftStatementReference").list().forEach(toImport -> this.addToStatement((X_I_BankStatement)toImport));
        sql = new StringBuffer("UPDATE I_BankStatement SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(this.noInsert.get()), "@C_BankStatement_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(this.noInsertLine.get()), "@C_BankStatementLine_ID@: @Inserted@");
        return "";
    }

    private boolean isToCreate(X_I_BankStatement toImport) {
        boolean isToCreate = false;
        if (this.statement == null) {
            isToCreate = true;
        } else if (this.statement.getC_BankAccount_ID() != toImport.getC_BankAccount_ID()) {
            isToCreate = true;
        } else if (!(Util.isEmpty(this.statement.getName()) || Util.isEmpty(toImport.getName()) || this.statement.getName().equals(toImport.getName()))) {
            isToCreate = true;
        } else if (!(Util.isEmpty(this.statement.getEftStatementReference()) || Util.isEmpty(toImport.getEftStatementReference()) || this.statement.getEftStatementReference().equals(toImport.getEftStatementReference()))) {
            isToCreate = true;
        } else if (this.statement.getStatementDate() != null && toImport.getStatementDate() != null && !this.statement.getStatementDate().equals(toImport.getStatementDate())) {
            isToCreate = true;
        }
        return isToCreate;
    }

    private void addToStatement(X_I_BankStatement toImport) {
        if (this.isToCreate(toImport)) {
            try {
                this.createStatement(toImport);
                this.noInsert.updateAndGet(count -> count + 1);
            }
            catch (Exception e) {
                this.statement = null;
            }
            this.lineNo.updateAndGet(count -> count + 10);
        }
        if (this.statement != null) {
            try {
                MBankStatementLine line = new MBankStatementLine(this.statement, toImport, this.lineNo.get());
                line.saveEx();
                toImport.setC_BankStatement_ID(this.statement.getC_BankStatement_ID());
                toImport.setC_BankStatementLine_ID(line.getC_BankStatementLine_ID());
                toImport.setI_IsImported(true);
                toImport.setProcessed(true);
                toImport.saveEx();
                this.noInsertLine.updateAndGet(count -> count + 1);
                this.lineNo.updateAndGet(count -> count + 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createStatement(X_I_BankStatement toImport) {
        MBankAccount account = MBankAccount.get(this.getCtx(), toImport.getC_BankAccount_ID());
        this.statement = new MBankStatement(account);
        this.statement.setEndingBalance(Env.ZERO);
        if (toImport.getName() != null) {
            this.statement.setName(toImport.getName());
        }
        if (toImport.getStatementDate() != null) {
            this.statement.setStatementDate(toImport.getStatementDate());
        }
        this.statement.setDescription(toImport.getDescription());
        this.statement.setEftStatementReference(toImport.getEftStatementReference());
        this.statement.setEftStatementDate(toImport.getEftStatementDate());
        this.statement.saveEx(this.get_TrxName());
        this.log.info("New Statement, Account=" + account.getAccountNo());
    }
}

