/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MMailText;
import org.compiere.model.MQuery;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_C_Invoice;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.ServerReportCtl;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;

public class InvoicePrint
extends SvrProcess {
    private boolean p_EMailPDF = false;
    private int p_R_MailText_ID = 0;
    private Timestamp m_dateInvoiced_From = null;
    private Timestamp m_dateInvoiced_To = null;
    private int m_C_BPartner_ID = 0;
    private int m_C_Invoice_ID = 0;
    private String m_DocumentNo_From = null;
    private String m_DocumentNo_To = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("DateInvoiced")) {
                this.m_dateInvoiced_From = (Timestamp)para[i2].getParameter();
                this.m_dateInvoiced_To = (Timestamp)para[i2].getParameter_To();
                continue;
            }
            if (name.equals("EMailPDF")) {
                this.p_EMailPDF = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("R_MailText_ID")) {
                this.p_R_MailText_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.m_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Invoice_ID")) {
                this.m_C_Invoice_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("DocumentNo")) {
                this.m_DocumentNo_From = (String)para[i2].getParameter();
                this.m_DocumentNo_To = (String)para[i2].getParameter_To();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        if (this.m_DocumentNo_From != null && this.m_DocumentNo_From.length() == 0) {
            this.m_DocumentNo_From = null;
        }
        if (this.m_DocumentNo_To != null && this.m_DocumentNo_To.length() == 0) {
            this.m_DocumentNo_To = null;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_EMailPDF && this.p_R_MailText_ID == 0) {
            throw new AdempiereUserError("@NotFound@: @R_MailText_ID@");
        }
        this.log.info("C_BPartner_ID=" + this.m_C_BPartner_ID + ", C_Invoice_ID=" + this.m_C_Invoice_ID + ", EmailPDF=" + this.p_EMailPDF + ",R_MailText_ID=" + this.p_R_MailText_ID + ", DateInvoiced=" + this.m_dateInvoiced_From + "-" + this.m_dateInvoiced_To + ", DocumentNo=" + this.m_DocumentNo_From + "-" + this.m_DocumentNo_To);
        MMailText mText = null;
        if (this.p_R_MailText_ID != 0 && (mText = new MMailText(this.getCtx(), this.p_R_MailText_ID, this.get_TrxName())).get_ID() != this.p_R_MailText_ID) {
            throw new AdempiereUserError("@NotFound@: @R_MailText_ID@ - " + this.p_R_MailText_ID);
        }
        if (this.m_C_BPartner_ID == 0 && this.m_C_Invoice_ID == 0 && this.m_dateInvoiced_From == null && this.m_dateInvoiced_To == null && this.m_DocumentNo_From == null && this.m_DocumentNo_To == null) {
            throw new AdempiereUserError("@RestrictSelection@");
        }
        MClient client = MClient.get(this.getCtx());
        StringBuffer sql = new StringBuffer("SELECT i.C_Invoice_ID,bp.AD_Language,c.IsMultiLingualDocument, COALESCE(bp.Invoice_PrintFormat_ID, dt.AD_PrintFormat_ID, pf.Invoice_PrintFormat_ID), dt.DocumentCopies+bp.DocumentCopies, bpc.AD_User_ID, i.DocumentNo, bp.C_BPartner_ID FROM C_Invoice i INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN AD_User bpc ON (i.AD_User_ID=bpc.AD_User_ID) INNER JOIN AD_Client c ON (i.AD_Client_ID=c.AD_Client_ID) INNER JOIN AD_PrintForm pf ON (i.AD_Client_ID=pf.AD_Client_ID) INNER JOIN C_DocType dt ON (i.C_DocType_ID=dt.C_DocType_ID) WHERE i.AD_Client_ID=? AND i.AD_Org_ID=? AND i.isSOTrx='Y' AND        pf.AD_Org_ID IN (0,i.AD_Org_ID) AND ");
        boolean needAnd = false;
        if (this.m_C_Invoice_ID != 0) {
            sql.append("i.C_Invoice_ID=").append(this.m_C_Invoice_ID);
        } else {
            if (this.m_C_BPartner_ID != 0) {
                sql.append("i.C_BPartner_ID=").append(this.m_C_BPartner_ID);
                needAnd = true;
            }
            if (this.m_dateInvoiced_From != null && this.m_dateInvoiced_To != null) {
                if (needAnd) {
                    sql.append(" AND ");
                }
                sql.append("TRUNC(i.DateInvoiced, 'DD') BETWEEN ").append(DB.TO_DATE(this.m_dateInvoiced_From, true)).append(" AND ").append(DB.TO_DATE(this.m_dateInvoiced_To, true));
                needAnd = true;
            } else if (this.m_dateInvoiced_From != null) {
                if (needAnd) {
                    sql.append(" AND ");
                }
                sql.append("TRUNC(i.DateInvoiced, 'DD') >= ").append(DB.TO_DATE(this.m_dateInvoiced_From, true));
                needAnd = true;
            } else if (this.m_dateInvoiced_To != null) {
                if (needAnd) {
                    sql.append(" AND ");
                }
                sql.append("TRUNC(i.DateInvoiced, 'DD') <= ").append(DB.TO_DATE(this.m_dateInvoiced_To, true));
                needAnd = true;
            } else if (this.m_DocumentNo_From != null && this.m_DocumentNo_To != null) {
                if (needAnd) {
                    sql.append(" AND ");
                }
                sql.append("i.DocumentNo BETWEEN ").append(DB.TO_STRING(this.m_DocumentNo_From)).append(" AND ").append(DB.TO_STRING(this.m_DocumentNo_To));
            } else if (this.m_DocumentNo_From != null) {
                if (needAnd) {
                    sql.append(" AND ");
                }
                if (this.m_DocumentNo_From.indexOf(37) == -1) {
                    sql.append("i.DocumentNo >= ").append(DB.TO_STRING(this.m_DocumentNo_From));
                } else {
                    sql.append("i.DocumentNo LIKE ").append(DB.TO_STRING(this.m_DocumentNo_From));
                }
            }
            if (this.p_EMailPDF) {
                if (needAnd) {
                    sql.append(" AND ");
                }
                sql.append("i.DocStatus IN ('CO','CL') ");
            }
        }
        sql.append(" ORDER BY i.C_Invoice_ID, pf.AD_Org_ID DESC");
        this.log.fine(sql.toString());
        MPrintFormat format = null;
        int old_AD_PrintFormat_ID = -1;
        int old_C_Invoice_ID = -1;
        int C_BPartner_ID = 0;
        int count = 0;
        int errors = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            pstmt.setInt(1, Env.getAD_Client_ID(Env.getCtx()));
            pstmt.setInt(2, Env.getAD_Org_ID(Env.getCtx()));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_Invoice_ID = rs.getInt(1);
                if (C_Invoice_ID == old_C_Invoice_ID) continue;
                old_C_Invoice_ID = C_Invoice_ID;
                Language language = Language.getLoginLanguage();
                String AD_Language = rs.getString(2);
                if (AD_Language != null && "Y".equals(rs.getString(3))) {
                    language = Language.getLanguage(AD_Language);
                }
                int AD_PrintFormat_ID = rs.getInt(4);
                int copies = rs.getInt(5);
                if (copies == 0) {
                    copies = 1;
                }
                int AD_User_ID = rs.getInt(6);
                MUser to = new MUser(this.getCtx(), AD_User_ID, this.get_TrxName());
                String DocumentNo = rs.getString(7);
                C_BPartner_ID = rs.getInt(8);
                String documentDir = client.getDocumentDir();
                if (documentDir == null || documentDir.length() == 0) {
                    documentDir = ".";
                }
                if (this.p_EMailPDF && (to.get_ID() == 0 || to.getEMail() == null || to.getEMail().length() == 0)) {
                    this.addLog(C_Invoice_ID, null, null, DocumentNo + " @RequestActionEMailNoTo@");
                    ++errors;
                    continue;
                }
                if (AD_PrintFormat_ID == 0) {
                    this.addLog(C_Invoice_ID, null, null, DocumentNo + " No Print Format");
                    ++errors;
                    continue;
                }
                if (AD_PrintFormat_ID != old_AD_PrintFormat_ID) {
                    format = MPrintFormat.get(this.getCtx(), AD_PrintFormat_ID, false);
                    old_AD_PrintFormat_ID = AD_PrintFormat_ID;
                }
                format.setLanguage(language);
                format.setTranslationLanguage(language);
                MQuery query = new MQuery("C_Invoice_Header_v");
                query.addRestriction("C_Invoice_ID", "=", new Integer(C_Invoice_ID));
                PrintInfo info = new PrintInfo(DocumentNo, X_C_Invoice.Table_ID, C_Invoice_ID, C_BPartner_ID);
                info.setCopies(copies);
                ReportEngine re = new ReportEngine(this.getCtx(), format, query, info);
                boolean printed = false;
                if (this.p_EMailPDF) {
                    String subject = mText.getMailHeader() + " - " + DocumentNo;
                    EMail email = client.createEMail(to.getEMail(), subject, null);
                    if (!email.isValid()) {
                        this.addLog(C_Invoice_ID, null, null, DocumentNo + " @RequestActionEMailError@ Invalid EMail: " + to);
                        ++errors;
                        continue;
                    }
                    mText.setUser(to);
                    mText.setBPartner(C_BPartner_ID);
                    mText.setPO(new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName()));
                    String message = mText.getMailText(true);
                    if (mText.isHtml()) {
                        email.setMessageHTML(subject, message);
                    } else {
                        email.setSubject(subject);
                        email.setMessageText(message);
                    }
                    File invoice = null;
                    if (!Ini.isClient()) {
                        invoice = new File(MInvoice.getPDFFileName(documentDir, C_Invoice_ID));
                    }
                    File attachment = re.getPDF(invoice);
                    this.log.fine(to + " - " + attachment);
                    email.addAttachment(attachment);
                    String msg = email.send();
                    MUserMail um = new MUserMail(mText, this.getAD_User_ID(), email);
                    um.saveEx();
                    if (msg.equals("OK")) {
                        this.addLog(C_Invoice_ID, null, null, DocumentNo + " @RequestActionEMailOK@ - " + to.getEMail());
                        ++count;
                        printed = true;
                    } else {
                        this.addLog(C_Invoice_ID, null, null, DocumentNo + " @RequestActionEMailError@ " + msg + " - " + to.getEMail());
                        ++errors;
                    }
                } else {
                    ServerReportCtl.startDocumentPrint(2, null, C_Invoice_ID, null, null);
                    ++count;
                    printed = true;
                }
                if (!printed) continue;
                StringBuffer sb = new StringBuffer("UPDATE C_Invoice SET DatePrinted=SysDate, IsPrinted='Y' WHERE C_Invoice_ID=").append(C_Invoice_ID);
                int n = DB.executeUpdate(sb.toString(), this.get_TrxName());
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, "doIt - " + sql, e);
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        if (this.p_EMailPDF) {
            return "@Sent@=" + count + " - @Errors@=" + errors;
        }
        return "@Printed@=" + count;
    }
}

