/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MProductionBatch;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;

public class ProductionBatchCreate
extends SvrProcess {
    private int p_M_Production_Batch_ID = 0;
    private MProductionBatch pBatch = null;
    private boolean m_CreateMovement = true;
    private boolean m_CreateProductionLine = true;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_M_Production_Batch_ID = this.getRecord_ID();
        this.pBatch = new MProductionBatch(this.getCtx(), this.p_M_Production_Batch_ID, this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        if (this.pBatch.get_ID() == 0) {
            throw new AdempiereUserError("Could not load production batch");
        }
        if (this.pBatch.isProcessed()) {
            if (this.pBatch.getDocStatus().equals("CL")) {
                return "Can not process, Production Batch is closed";
            }
            if (this.pBatch.getDocStatus().equals("VO")) {
                return "Can not process, Production Batch is voided";
            }
            if (this.pBatch.getDocStatus().equals("CO")) {
                if (this.pBatch.getQtyCompleted().compareTo(this.pBatch.getTargetQty()) >= 0) {
                    return "Already processed target qty of production batch";
                }
                return this.createProduction();
            }
        } else {
            return "Please first confirm/complete the batch";
        }
        return null;
    }

    protected String createProduction() throws Exception {
        String result = this.pBatch.createAutomaticProduction();
        return result;
    }
}

