/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.process.ProjectGenOrder;
import org.compiere.process.ProjectPhaseGenOrderAbstract;
import org.compiere.util.Env;

public class ProjectPhaseGenOrder
extends ProjectPhaseGenOrderAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - C_ProjectPhase_ID=" + this.getRecord_ID());
        if (this.getRecord_ID() == 0) {
            throw new IllegalArgumentException("C_ProjectPhase_ID == 0");
        }
        MProjectPhase fromPhase = new MProjectPhase(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        MProject fromProject = ProjectGenOrder.getProject(this.getCtx(), fromPhase.getC_Project_ID(), this.get_TrxName());
        if (fromProject.getC_PaymentTerm_ID() <= 0) {
            throw new AdempiereException("@C_PaymentTerm_ID@ @NotFound@");
        }
        MOrder order = new MOrder(fromProject, true, "WI");
        order.setDescription(order.getDescription() + " - " + fromPhase.getName());
        order.saveEx();
        if (fromPhase.getM_Product_ID() != 0) {
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(fromPhase.getSeqNo());
            StringBuilder stringBuilder = new StringBuilder(fromPhase.getName());
            if (fromPhase.getDescription() != null && fromPhase.getDescription().length() > 0) {
                stringBuilder.append(" - ").append(fromPhase.getDescription());
            }
            orderLine.setDescription(stringBuilder.toString());
            orderLine.setM_Product_ID(fromPhase.getM_Product_ID(), true);
            orderLine.setQty(fromPhase.getQty());
            orderLine.setC_Project_ID(fromProject.getC_Project_ID());
            orderLine.setC_ProjectPhase_ID(fromPhase.getC_ProjectPhase_ID());
            orderLine.setPrice();
            if (fromPhase.getPriceActual() != null && fromPhase.getPriceActual().compareTo(Env.ZERO) != 0) {
                orderLine.setPrice(fromPhase.getPriceActual());
            }
            orderLine.setTax();
            if (!orderLine.save()) {
                this.log.log(Level.SEVERE, "doIt - Lines not generated");
            }
            return "@C_Order_ID@ " + order.getDocumentNo() + " (1)";
        }
        AtomicInteger count = new AtomicInteger(0);
        List<MProjectLine> projectLines = fromPhase.getLines();
        projectLines.stream().forEach(projectLine -> {
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(projectLine.getLine());
            orderLine.setDescription(projectLine.getDescription());
            orderLine.setM_Product_ID(projectLine.getM_Product_ID(), true);
            orderLine.setQty(projectLine.getPlannedQty().subtract(projectLine.getInvoicedQty()));
            orderLine.setPrice();
            if (projectLine.getPlannedPrice() != null && projectLine.getPlannedPrice().compareTo(Env.ZERO) != 0) {
                orderLine.setPrice(projectLine.getPlannedPrice());
            }
            orderLine.setDiscount();
            orderLine.setTax();
            orderLine.setC_Project_ID(fromProject.getC_Project_ID());
            orderLine.setC_ProjectPhase_ID(projectLine.getC_ProjectPhase_ID());
            orderLine.saveEx();
            count.getAndUpdate(no -> no + 1);
        });
        if (projectLines.size() != count.get()) {
            this.log.log(Level.SEVERE, "Lines difference - ProjectLines=" + projectLines.size() + " <> Saved=" + count.get());
        }
        List<MProjectTask> tasks = fromPhase.getTasks();
        tasks.stream().filter(task -> task.getM_Product_ID() != 0).forEach(fromTask -> {
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(fromTask.getSeqNo());
            StringBuilder stringBuilder = new StringBuilder(fromTask.getName());
            if (fromTask.getDescription() != null && fromTask.getDescription().length() > 0) {
                stringBuilder.append(" - ").append(fromTask.getDescription());
            }
            orderLine.setDescription(stringBuilder.toString());
            orderLine.setM_Product_ID(fromTask.getM_Product_ID(), true);
            orderLine.setQty(fromTask.getQty());
            orderLine.setPrice();
            orderLine.setC_Project_ID(fromProject.getC_Project_ID());
            orderLine.setC_ProjectPhase_ID(fromTask.getC_ProjectPhase_ID());
            orderLine.setC_ProjectTask_ID(fromTask.getC_ProjectTask_ID());
            orderLine.setTax();
            orderLine.saveEx();
            count.getAndUpdate(no -> no + 1);
        });
        if (tasks.size() != count.get() - projectLines.size()) {
            this.log.log(Level.SEVERE, "doIt - Lines difference - ProjectTasks=" + tasks.size() + " <> Saved=" + count.get());
        }
        return "@C_Order_ID@ " + order.getDocumentNo() + " (" + count + ")";
    }
}

