/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.Query;
import org.compiere.process.RequestInvoiceAbstract;
import org.compiere.util.AdempiereSystemError;

public class RequestInvoice
extends RequestInvoiceAbstract {
    private HashMap<Integer, MInvoice> invoicesByPartner = new HashMap();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("R_RequestType_ID=" + this.getRequestTypeId() + ", R_Group_ID=" + this.getGroupId() + ", R_Category_ID=" + this.getCategoryId() + ", C_BPartner_ID=" + this.getBPartnerId() + ", p_M_Product_ID=" + this.getProductId());
        this.validate();
        this.getRequestsToInvoice().stream().forEach(request -> {
            MInvoice invoice = Optional.ofNullable(this.invoicesByPartner.get(request.getC_BPartner_ID())).orElse(this.invoiceNew((MRequest)request));
            this.invoiceLine((MRequest)request, invoice);
        });
        this.invoicesByPartner.entrySet().stream().forEach(entry -> {
            MInvoice invoice = (MInvoice)entry.getValue();
            invoice.processIt("PR");
            invoice.saveEx();
            this.addLog(invoice.getDocumentInfo());
        });
        return "@Ok@";
    }

    private boolean validate() throws AdempiereSystemError {
        MRequestType requestType = MRequestType.get(this.getCtx(), this.getRequestTypeId());
        if (requestType.get_ID() == 0) {
            throw new AdempiereSystemError("@R_RequestType_ID@ @NotFound@ " + this.getRequestTypeId());
        }
        if (!requestType.isInvoiced()) {
            throw new AdempiereSystemError("@R_RequestType_ID@ <> @IsInvoiced@");
        }
        return true;
    }

    private List<MRequest> getRequestsToInvoice() {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("R_RequestType_ID").append("=? AND ");
        parameters.add(this.getRequestTypeId());
        whereClause.append("IsInvoiced").append("=? AND ");
        parameters.add("Y");
        whereClause.append(" EXISTS (SELECT 1 FROM ").append("R_Status").append(" WHERE ").append("R_Request").append(".").append("R_Status_ID").append("=").append("R_Status").append(".").append("R_Status_ID").append(" AND ").append("R_Status").append(".").append("IsClosed").append("=?)  AND ");
        parameters.add("Y");
        if (this.getGroupId() > 0) {
            whereClause.append("R_Request").append(".").append("R_Group_ID").append("=? AND ");
            parameters.add(this.getGroupId());
        }
        if (this.getCategoryId() > 0) {
            whereClause.append("R_Request").append(".").append("R_Category_ID").append("=? AND ");
            parameters.add(this.getCategoryId());
        }
        if (this.getBPartnerId() > 0) {
            whereClause.append("R_Request").append(".").append("C_BPartner_ID").append("=? AND ");
            parameters.add(this.getBPartnerId());
        }
        whereClause.append(" EXISTS (SELECT 1 FROM ").append("R_RequestUpdate").append(" WHERE ").append("R_RequestUpdate").append(".").append("R_Request_ID").append("=").append("R_Request").append(".").append("R_Request_ID").append(" AND ").append("R_RequestUpdate").append(".").append("C_InvoiceLine_ID").append(" IS NULL )");
        return new Query(this.getCtx(), "R_Request", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).setOrderBy("C_BPartner_ID").list();
    }

    private MInvoice invoiceNew(MRequest request) {
        MInvoice invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        invoice.setIsSOTrx(true);
        MBPartner partner = new MBPartner(this.getCtx(), request.getC_BPartner_ID(), this.get_TrxName());
        invoice.setBPartner(partner);
        if (request.getAD_User_ID() > 0) {
            invoice.setAD_User_ID(request.getAD_User_ID());
        }
        invoice.saveEx();
        this.invoicesByPartner.put(partner.get_ID(), invoice);
        return invoice;
    }

    private void invoiceLine(MRequest request, MInvoice invoice) {
        AtomicInteger lineNo = new AtomicInteger(invoice.getLines().length);
        Arrays.stream(request.getUpdates(null)).forEach(requestUpdate -> {
            Optional<BigDecimal> maybeQuantityInvoiced = Optional.ofNullable(requestUpdate.getQtyInvoiced());
            maybeQuantityInvoiced.ifPresent(quantityInvoiced -> {
                MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
                lineNo.updateAndGet(no -> no + 10);
                invoiceLine.setLine(lineNo.get());
                invoiceLine.setQty((BigDecimal)quantityInvoiced);
                if (requestUpdate.getM_ProductSpent_ID() > 0) {
                    invoiceLine.setM_Product_ID(requestUpdate.getM_ProductSpent_ID());
                } else if (this.getProductId() > 0) {
                    invoiceLine.setM_Product_ID(this.getProductId());
                }
                invoiceLine.setPrice();
                invoiceLine.saveEx();
                requestUpdate.setC_InvoiceLine_ID(invoiceLine.get_ID());
                requestUpdate.saveEx();
            });
        });
    }
}

