/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQTopic;
import org.compiere.model.MRfQTopicSubscriber;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class RfQCreate
extends SvrProcess {
    private boolean p_IsSendRfQ = false;
    private int p_C_RfQ_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("IsSendRfQ")) {
                this.p_IsSendRfQ = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_RfQ_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MRfQ rfq = new MRfQ(this.getCtx(), this.p_C_RfQ_ID, this.get_TrxName());
        this.log.info("doIt - " + rfq + ", Send=" + this.p_IsSendRfQ);
        String error = rfq.checkQuoteTotalAmtOnly();
        if (error != null && error.length() > 0) {
            throw new Exception(error);
        }
        int counter = 0;
        int sent = 0;
        int notSent = 0;
        MRfQResponse[] responses = rfq.getResponses(false, false);
        MRfQTopic topic = new MRfQTopic(this.getCtx(), rfq.getC_RfQ_Topic_ID(), this.get_TrxName());
        MRfQTopicSubscriber[] subscribers = topic.getSubscribers();
        for (int i2 = 0; i2 < subscribers.length; ++i2) {
            MRfQResponse response;
            MRfQTopicSubscriber subscriber = subscribers[i2];
            boolean skip = false;
            for (int r = 0; r < responses.length; ++r) {
                if (subscriber.getC_BPartner_ID() != responses[r].getC_BPartner_ID() || subscriber.getC_BPartner_Location_ID() != responses[r].getC_BPartner_Location_ID()) continue;
                skip = true;
                break;
            }
            if (skip || (response = new MRfQResponse(rfq, subscriber)).get_ID() == 0) continue;
            ++counter;
            if (!this.p_IsSendRfQ) continue;
            this.commitEx();
            if (response.sendRfQ()) {
                ++sent;
                continue;
            }
            ++notSent;
        }
        String retValue = "@Created@ " + counter;
        if (this.p_IsSendRfQ) {
            retValue = retValue + " - @IsSendRfQ@=" + sent + " - @Error@=" + notSent;
        }
        return retValue;
    }
}

