/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.RoleAccessUpdateAbstract;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class RoleAccessUpdate
extends RoleAccessUpdateAbstract {
    private static CLogger s_log = CLogger.getCLogger(RoleAccessUpdate.class);

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("AD_Client_ID=" + this.getClientId() + ", AD_Role_ID=" + this.getRoleId());
        if (this.getRoleId() > 0) {
            this.updateRole(new MRole(this.getCtx(), this.getRoleId(), this.get_TrxName()));
        } else {
            ArrayList<Object> params = new ArrayList<Object>();
            String whereClause = "1=1";
            if (this.getClientId() > 0) {
                whereClause = whereClause + " AND AD_Client_ID=? ";
                params.add(this.getClientId());
            }
            if (this.getRoleId() == 0) {
                whereClause = whereClause + " AND AD_Role_ID=?";
                params.add(this.getRoleId());
            }
            new Query(this.getCtx(), "AD_Role", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(params).setOrderBy("AD_Client_ID, Name").list().stream().forEach(role -> this.updateRole((MRole)role));
        }
        return "";
    }

    private void updateRole(MRole role) {
        this.addLog(0, null, null, role.getName() + ": " + role.updateAccessRecords());
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(false);
        CLogMgt.setLevel(Level.FINE);
        s_log.info("Role Access Update");
        s_log.info("------------------");
        ProcessInfo pi = new ProcessInfo("Role Access Update", 295);
        pi.setAD_Client_ID(0);
        pi.setAD_User_ID(100);
        RoleAccessUpdate rau = new RoleAccessUpdate();
        rau.startProcess(Env.getCtx(), pi, null);
        System.out.println("Process=" + pi.getTitle() + " Error=" + pi.isError() + " Summary=" + pi.getSummary());
    }
}

