/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.InvalidClassException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.util.ProcessUtil;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MPInstance;
import org.compiere.print.ServerReportCtl;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.wf.MWFProcess;

public class ServerProcessCtl
implements Runnable {
    private static CLogger log = CLogger.getCLogger(ServerProcessCtl.class);
    ASyncProcess m_parent;
    ProcessInfo processInfo;
    private Trx trx;
    private boolean isServerProcess = false;

    public ServerProcessCtl(ASyncProcess parent, ProcessInfo pi, Trx trx) {
        this.m_parent = parent;
        this.processInfo = pi;
        this.trx = trx;
    }

    public static ServerProcessCtl process(ASyncProcess parent, ProcessInfo pi, Trx trx) {
        log.fine("ServerProcess - " + pi);
        MPInstance instance = null;
        try {
            instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
        }
        catch (Exception e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        catch (Error e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        if (!instance.save()) {
            pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            pi.setError(true);
            return null;
        }
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ServerProcessCtl worker = new ServerProcessCtl(parent, pi, trx);
        if (parent != null) {
            worker.start();
        } else {
            worker.run();
        }
        return worker;
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.processInfo != null) {
            thread.setName(this.processInfo.getTitle() + "-" + this.processInfo.getAD_PInstance_ID());
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResultSet rs;
        CPreparedStatement pstmt;
        boolean IsReport;
        int AD_Workflow_ID;
        int AD_ReportView_ID;
        String JasperReport;
        String ProcedureName;
        block23: {
            log.fine("AD_PInstance_ID=" + this.processInfo.getAD_PInstance_ID() + ", Record_ID=" + this.processInfo.getRecord_ID());
            ProcedureName = "";
            JasperReport = "";
            AD_ReportView_ID = 0;
            AD_Workflow_ID = 0;
            IsReport = false;
            boolean isPrintPreview = this.processInfo.isPrintPreview();
            String sql = "SELECT p.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport,p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess, p.JasperReport FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID) WHERE p.IsActive='Y' AND i.AD_PInstance_ID=?";
            if (!Env.isBaseLanguage(Env.getCtx(), "AD_Process")) {
                sql = "SELECT t.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport, p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess, p.JasperReport FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID)  INNER JOIN AD_Process_Trl t ON (p.AD_Process_ID=t.AD_Process_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "') WHERE p.IsActive='Y' AND i.AD_PInstance_ID=?";
            }
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, 1003, 1007, null);
                pstmt.setInt(1, this.processInfo.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.processInfo.setTitle(rs.getString(1));
                    ProcedureName = rs.getString(2);
                    this.processInfo.setClassName(rs.getString(3));
                    this.processInfo.setAD_Process_ID(rs.getInt(4));
                    if ("Y".equals(rs.getString(5))) {
                        IsReport = true;
                    }
                    AD_ReportView_ID = rs.getInt(7);
                    AD_Workflow_ID = rs.getInt(8);
                    int estimate = rs.getInt(9);
                    if (estimate != 0) {
                        this.processInfo.setEstSeconds(estimate + 1);
                    }
                    this.isServerProcess = "Y".equals(rs.getString(10));
                    JasperReport = rs.getString(11);
                    break block23;
                }
                log.log(Level.SEVERE, "No AD_PInstance_ID=" + this.processInfo.getAD_PInstance_ID());
            }
            catch (Throwable e) {
                try {
                    this.processInfo.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoProcedure") + " " + e.getLocalizedMessage(), true);
                    log.log(Level.SEVERE, "run", e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (ProcedureName == null) {
            ProcedureName = "";
        }
        if (AD_Workflow_ID > 0) {
            this.startWorkflow(AD_Workflow_ID);
            return;
        }
        boolean isJasper = false;
        if (JasperReport != null && JasperReport.trim().length() > 0) {
            isJasper = true;
            if ("org.compiere.report.ReportStarter".equals(this.processInfo.getClassName())) {
                this.processInfo.setClassName(null);
            }
        }
        if (this.processInfo.getClassName() != null) {
            if (isJasper) {
                this.processInfo.setReportingProcess(true);
            }
            if (!this.startProcess()) {
                return;
            }
            if (!IsReport && ProcedureName.length() == 0) {
                return;
            }
            if (IsReport && AD_ReportView_ID == 0 && !isJasper) {
                return;
            }
        }
        if (IsReport && ProcedureName.length() > 0) {
            this.processInfo.setReportingProcess(true);
            if (!this.startDBProcess(ProcedureName)) {
                return;
            }
        }
        if (isJasper) {
            this.processInfo.setReportingProcess(true);
            this.processInfo.setClassName("org.compiere.report.ReportStarter");
            this.startProcess();
            return;
        }
        if (IsReport) {
            this.processInfo.setReportingProcess(true);
            boolean ok = ServerReportCtl.start(this.m_parent, this.processInfo);
            this.processInfo.setSummary("Report", !ok);
        } else {
            if (!this.startDBProcess(ProcedureName)) {
                return;
            }
            ProcessInfoUtil.setSummaryFromDB(this.processInfo);
        }
    }

    protected boolean startWorkflow(int AD_Workflow_ID) {
        log.fine(AD_Workflow_ID + " - " + this.processInfo);
        boolean started = false;
        if (this.isServerProcess) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    this.processInfo = server.workflow(Env.getRemoteCallCtx(Env.getCtx()), this.processInfo, AD_Workflow_ID);
                    log.finest("server => " + this.processInfo);
                    started = true;
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "AppsServer error", ex);
                started = false;
            }
        }
        if (!started && !this.isServerProcess) {
            MWFProcess wfProcess;
            if (this.trx != null) {
                this.processInfo.setTransactionName(this.trx.getTrxName());
            }
            started = (wfProcess = ProcessUtil.startWorkFlow(Env.getCtx(), this.processInfo, AD_Workflow_ID)) != null;
        }
        return started;
    }

    protected boolean startProcess() {
        log.fine(this.processInfo.toString());
        boolean started = false;
        boolean clientOnly = false;
        if (!this.processInfo.getClassName().toLowerCase().startsWith("@script:")) {
            try {
                Class<?> processClass = Class.forName(this.processInfo.getClassName());
                if (ClientProcess.class.isAssignableFrom(processClass)) {
                    clientOnly = true;
                }
            }
            catch (Exception processClass) {
                // empty catch block
            }
        }
        if (this.isServerProcess && !clientOnly) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    this.processInfo = server.process(Env.getRemoteCallCtx(Env.getCtx()), this.processInfo);
                    log.finest("server => " + this.processInfo);
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.processInfo, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.processInfo, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.processInfo, ex);
                }
                started = false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.processInfo, cause);
                started = false;
            }
        }
        if (!(started || this.isServerProcess && !clientOnly)) {
            if (this.processInfo.getClassName().toLowerCase().startsWith("@script:")) {
                return ProcessUtil.startScriptProcess(Env.getCtx(), this.processInfo, this.trx);
            }
            if (this.processInfo.isManagedTransaction()) {
                return ProcessUtil.startJavaProcess(Env.getCtx(), this.processInfo, this.trx);
            }
            return ProcessUtil.startJavaProcess(Env.getCtx(), this.processInfo, this.trx, this.processInfo.isManagedTransaction());
        }
        return !this.processInfo.isError();
    }

    protected boolean startDBProcess(String ProcedureName) {
        String trxName;
        log.fine(ProcedureName + "(" + this.processInfo.getAD_PInstance_ID() + ")");
        boolean started = false;
        String string = trxName = this.trx != null ? this.trx.getTrxName() : null;
        if (this.isServerProcess) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    this.processInfo = server.dbProcess(this.processInfo, ProcedureName);
                    log.finest("server => " + this.processInfo);
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.processInfo, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.processInfo, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.processInfo, ex);
                    cause = ex;
                }
                this.processInfo.setSummary(Msg.getMsg(Env.getCtx(), "ProcessRunError") + " " + cause.getLocalizedMessage());
                this.processInfo.setError(true);
                return false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.processInfo, cause);
                this.processInfo.setSummary(Msg.getMsg(Env.getCtx(), "ProcessRunError") + " " + cause.getLocalizedMessage());
                this.processInfo.setError(true);
                return false;
            }
        }
        if (!started) {
            if (this.processInfo.isManagedTransaction()) {
                return ProcessUtil.startDatabaseProcedure(this.processInfo, ProcedureName, this.trx);
            }
            return ProcessUtil.startDatabaseProcedure(this.processInfo, ProcedureName, this.trx, this.processInfo.isManagedTransaction());
        }
        return true;
    }
}

