/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.process.StatementCreateFromAbstract;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class StatementCreateFrom
extends StatementCreateFromAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@C_BankStatement_ID@ @NotFound@");
        }
        MBankStatement bankStatement = new MBankStatement(Env.getCtx(), this.getRecord_ID(), this.get_TrxName());
        MBankAccount bankAccount = bankStatement.getBankAccount();
        AtomicInteger created = new AtomicInteger(0);
        AtomicReference<BigDecimal> totalAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        this.log.config(bankStatement.toString());
        this.getSelectionKeys().stream().forEach(key -> {
            Timestamp dateTransaction = this.getSelectionAsTimestamp((int)key, "P_DateTrx");
            int paymentId = this.getSelectionAsInt((int)key, "P_C_Payment_ID");
            int currencyId = this.getSelectionAsInt((int)key, "P_C_Currency_ID");
            BigDecimal transactionAmount = this.getSelectionAsBigDecimal((int)key, "P_ConvertedAmount");
            this.log.fine("Line Date=" + dateTransaction + ", Payment=" + paymentId + ", Currency=" + currencyId + ", Amt=" + transactionAmount);
            MBankStatementLine bankStatementLine = new MBankStatementLine(bankStatement);
            bankStatementLine.setDateAcct(bankStatement.getStatementDate());
            bankStatementLine.setStatementLineDate(bankStatement.getStatementDate());
            bankStatementLine.setValutaDate(dateTransaction);
            MPayment payment = new MPayment(Env.getCtx(), paymentId, this.get_TrxName());
            bankStatementLine.setPayment(payment);
            bankStatementLine.setTrxAmt(transactionAmount);
            bankStatementLine.setStmtAmt(transactionAmount);
            bankStatementLine.setC_Currency_ID(bankAccount.getC_Currency_ID());
            bankStatementLine.saveEx();
            created.updateAndGet(createNo -> createNo + 1);
            totalAmt.updateAndGet(amt -> amt.add(payment.isReceipt() ? payment.getPayAmt() : payment.getPayAmt().negate()));
        });
        return "@Created@ = " + created.get() + " - @PayAmt@ = " + DisplayType.getNumberFormat(12).format(totalAmt.get());
    }
}

