/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.ValueNamePair;

public class T_InventoryValue_Create
extends SvrProcess {
    private int p_M_PriceList_Version_ID;
    private Timestamp p_DateValue;
    private int p_M_Warehouse_ID;
    private int p_C_Currency_ID;
    private int p_Record_ID = 0;
    private int p_PInstance_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_PriceList_Version_ID")) {
                this.p_M_PriceList_Version_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("DateValue")) {
                this.p_DateValue = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_Record_ID = this.getRecord_ID();
        this.p_PInstance_ID = this.getAD_PInstance_ID();
    }

    @Override
    protected String doIt() throws Exception {
        int cntu = 0;
        int cnti = 0;
        this.log.info("Inventory Valuation Temporary Table");
        String sqlins = "INSERT INTO T_InventoryValue (AD_Client_ID,AD_Org_ID, AD_PInstance_ID, M_Warehouse_ID,M_Product_ID) SELECT AD_Client_ID,AD_Org_ID," + this.p_PInstance_ID + "," + this.p_M_Warehouse_ID + ",M_Product_ID FROM M_Product WHERE IsStocked='Y'";
        cnti = DB.executeUpdate(sqlins, this.get_TrxName());
        if (cnti == 0) {
            return "@Created@ = 0";
        }
        if (cnti < 0) {
            this.raiseError("InsertStockedProducts:ERROR", sqlins);
        }
        this.p_DateValue.setHours(23);
        this.p_DateValue.setMinutes(59);
        this.p_DateValue.setSeconds(0);
        String sqlupd = "UPDATE T_InventoryValue SET DateValue = ?, M_PriceList_Version_ID = ? , C_Currency_ID = ? WHERE M_Warehouse_ID = ?";
        CPreparedStatement pstmt = DB.prepareStatement(sqlupd, 1004, 1008, this.get_TrxName());
        pstmt.setTimestamp(1, this.p_DateValue);
        pstmt.setInt(2, this.p_M_PriceList_Version_ID);
        pstmt.setInt(3, this.p_C_Currency_ID);
        pstmt.setInt(4, this.p_M_Warehouse_ID);
        cntu = pstmt.executeUpdate();
        if (cntu < 0) {
            this.raiseError("UpdateConstants:ERROR", sqlupd);
        }
        if ((cntu = DB.executeUpdate(sqlupd = "UPDATE T_InventoryValue SET QtyOnHand = (SELECT SUM(QtyOnHand) FROM M_Storage s, M_Locator l WHERE T_InventoryValue.M_Product_ID=s.M_Product_ID AND l.M_Locator_ID=s.M_Locator_ID AND l.M_Warehouse_ID=T_InventoryValue.M_Warehouse_ID) WHERE T_InventoryValue.M_Warehouse_ID = " + this.p_M_Warehouse_ID, this.get_TrxName())) < 0) {
            this.raiseError("GetQtyOnHand:ERROR", sqlupd);
        }
        if ((cntu = DB.executeUpdate(sqlupd = "UPDATE T_InventoryValue SET QtyOnHand = (SELECT T_InventoryValue.QtyOnHand - NVL(SUM(t.MovementQty), 0) FROM M_Transaction t, M_Locator l WHERE t.M_Product_ID=T_InventoryValue.M_Product_ID AND t.MovementDate > T_InventoryValue.DateValue AND t.M_Locator_ID=l.M_Locator_ID AND l.M_Warehouse_ID=T_InventoryValue.M_Warehouse_ID) WHERE\tT_InventoryValue.M_Warehouse_ID = " + this.p_M_Warehouse_ID, this.get_TrxName())) < 0) {
            this.raiseError("AdjustQtyOnHand:ERROR", sqlupd);
        }
        if ((cntu = DB.executeUpdate(sqlupd = "DELETE T_InventoryValue WHERE QtyOnHand=0 OR QtyOnHand IS NULL", this.get_TrxName())) < 0) {
            this.raiseError("DeleteZeroQtyOnHand:ERROR", sqlupd);
        }
        if ((cntu = DB.executeUpdate(sqlupd = "UPDATE T_InventoryValue SET PricePO = (SELECT currencyConvert (po.PriceList,po.C_Currency_ID,T_InventoryValue.C_Currency_ID,T_InventoryValue.DateValue, null, T_InventoryValue.AD_Client_ID, T_InventoryValue.AD_Org_ID) FROM M_Product_PO po WHERE po.M_Product_ID=T_InventoryValue.M_Product_ID AND po.IsCurrentVendor='Y' AND po.C_BPartner_ID = (SELECT MIN(po1.C_BPartner_ID) FROM M_Product_PO po1 WHERE po1.M_Product_ID=T_InventoryValue.M_Product_ID AND po1.IsCurrentVendor='Y')), PriceList = (SELECT currencyConvert(pp.PriceList,pl.C_Currency_ID,T_InventoryValue.C_Currency_ID,T_InventoryValue.DateValue, null, T_InventoryValue.AD_Client_ID, T_InventoryValue.AD_Org_ID) FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pp.M_Product_ID=T_InventoryValue.M_Product_ID AND pp.M_PriceList_Version_ID=T_InventoryValue.M_PriceList_Version_ID AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID AND plv.M_PriceList_ID=pl.M_PriceList_ID), PriceStd = (SELECT currencyConvert(pp.PriceStd,pl.C_Currency_ID,T_InventoryValue.C_Currency_ID,T_InventoryValue.DateValue, null, T_InventoryValue.AD_Client_ID, T_InventoryValue.AD_Org_ID) FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pp.M_Product_ID=T_InventoryValue.M_Product_ID AND pp.M_PriceList_Version_ID=T_InventoryValue.M_PriceList_Version_ID AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID AND plv.M_PriceList_ID=pl.M_PriceList_ID), PriceLimit = (SELECT currencyConvert(pp.PriceLimit,pl.C_Currency_ID,T_InventoryValue.C_Currency_ID,T_InventoryValue.DateValue, null, T_InventoryValue.AD_Client_ID, T_InventoryValue.AD_Org_ID) FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pp.M_Product_ID=T_InventoryValue.M_Product_ID AND pp.M_PriceList_Version_ID=T_InventoryValue.M_PriceList_Version_ID AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID AND plv.M_PriceList_ID=pl.M_PriceList_ID), CostStandard = (SELECT currencyConvert(pc.CurrentCostPrice,acs.C_Currency_ID,T_InventoryValue.C_Currency_ID,T_InventoryValue.DateValue, null, T_InventoryValue.AD_Client_ID, T_InventoryValue.AD_Org_ID) FROM AD_ClientInfo ci, C_AcctSchema acs, M_Product_Costing pc WHERE T_InventoryValue.AD_Client_ID=ci.AD_Client_ID AND ci.C_AcctSchema1_ID=acs.C_AcctSchema_ID AND acs.C_AcctSchema_ID=pc.C_AcctSchema_ID AND T_InventoryValue.M_Product_ID=pc.M_Product_ID) WHERE\tT_InventoryValue.M_Warehouse_ID = " + this.p_M_Warehouse_ID, this.get_TrxName())) < 0) {
            this.raiseError("GetPrices:ERROR", sqlupd);
        }
        if ((cntu = DB.executeUpdate(sqlupd = "UPDATE T_InventoryValue SET PricePOAmt = QtyOnHand * PricePO, PriceListAmt = QtyOnHand * PriceList, PriceStdAmt = QtyOnHand * PriceStd, PriceLimitAmt = QtyOnHand * PriceLimit, CostStandardAmt = QtyOnHand * CostStandard WHERE\tM_Warehouse_ID = " + this.p_M_Warehouse_ID, this.get_TrxName())) < 0) {
            this.raiseError("UpdateValue:ERROR", sqlupd);
        }
        DB.commit(true, this.get_TrxName());
        return "@Created@ = " + cntu;
    }

    private void raiseError(String string, String sql) throws Exception {
        DB.rollback(false, this.get_TrxName());
        String msg = string;
        ValueNamePair pp = CLogger.retrieveError();
        if (pp != null) {
            msg = pp.getName() + " - ";
        }
        msg = msg + sql;
        throw new AdempiereUserError(msg);
    }
}

